/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class OverhaulSchemeUniqueValidator
extends AbstractValidator {
    private static final String FMM_OVERHAULSCHEME = "fmm_overhaulscheme";
    private static final String CREATORG = "createorg";
    private static final String MATERIAL = "materiel";
    private static final String CUSTOMERS = "customers";
    private static final String MRTYPE = "mrtype";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<String> batchUniqueKey = new HashSet<String>(2);
        for (int i = 0; i < dataEntities.length; ++i) {
            long dataPK;
            DynamicObjectCollection checkUniqueDate;
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            DynamicObject createOrg = dataEntity.getDynamicObject(CREATORG);
            DynamicObject materielDO = dataEntity.getDynamicObject(MATERIAL);
            DynamicObject mrtype = dataEntity.getDynamicObject(MRTYPE);
            DynamicObjectCollection customerDOC = dataEntity.getDynamicObjectCollection(CUSTOMERS);
            if (createOrg == null) {
                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"OverhaulSchemeUniqueValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder uniqueBuilder = new StringBuilder();
            long createOrgPK = createOrg.getLong("id");
            uniqueBuilder.append(createOrgPK).append(":");
            long materailPK = 0L;
            if (materielDO != null) {
                materailPK = materielDO.getLong("id");
            }
            uniqueBuilder.append(materailPK).append(":");
            long mrtypePK = 0L;
            if (mrtype != null) {
                mrtypePK = mrtype.getLong("id");
            }
            uniqueBuilder.append(mrtypePK).append(":");
            ArrayList<Long> customerList = new ArrayList<Long>(2);
            boolean batchUniqueFlag = false;
            if (customerDOC != null && customerDOC.size() > 0) {
                Collections.sort(customerDOC, Comparator.comparingLong(o -> o.getDynamicObject("fbasedataid").getLong("id")));
                for (DynamicObject baseDataCustomer : customerDOC) {
                    DynamicObject customerDO = baseDataCustomer.getDynamicObject("fbasedataid");
                    if (customerDO == null) continue;
                    long customerPK = customerDO.getLong("id");
                    uniqueBuilder.append(customerPK);
                    customerList.add(customerPK);
                    if (batchUniqueKey.contains(uniqueBuilder.toString())) {
                        batchUniqueFlag = true;
                        this.addErrorMessage(dataEntities[i], this.getErrorMessage(dataEntity));
                        break;
                    }
                    batchUniqueKey.add(uniqueBuilder.toString());
                }
            } else {
                if (batchUniqueKey.contains(uniqueBuilder.toString())) {
                    batchUniqueFlag = true;
                    this.addErrorMessage(dataEntities[i], this.getErrorMessage(dataEntity));
                    continue;
                }
                batchUniqueKey.add(uniqueBuilder.toString());
            }
            if (batchUniqueFlag || (checkUniqueDate = this.checkUnique(createOrgPK, materailPK, mrtypePK, dataPK = dataEntity.getLong("id"), customerList)) == null || checkUniqueDate.size() <= 0) continue;
            this.addErrorMessage(dataEntities[i], this.getErrorMessage(dataEntity));
        }
    }

    private String getErrorMessage(DynamicObject dataEntity) {
        DynamicObject materielDO = dataEntity.getDynamicObject(MATERIAL);
        String materielname = null == materielDO ? "" : materielDO.getString("name");
        DynamicObject mrtype = dataEntity.getDynamicObject(MRTYPE);
        String modelone = null == mrtype ? "" : mrtype.getString("name");
        String customers = "";
        DynamicObjectCollection customerDOC = dataEntity.getDynamicObjectCollection(CUSTOMERS);
        if (customerDOC != null && customerDOC.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject baseDataCustomer : customerDOC) {
                DynamicObject customerDO = baseDataCustomer.getDynamicObject("fbasedataid");
                if (customerDO == null) continue;
                sb.append(customerDO.getString("name")).append(",");
            }
            customers = sb.substring(0, sb.length() - 1);
        }
        return String.format(ResManager.loadKDString((String)"\u5b58\u5728\u201c\u4ea7\u54c1\u7f16\u7801\u201d%1$s\u3001\u201c\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b\u201d%2$s\u3001\u201c\u5ba2\u6237\u201d%3$s\u4e00\u81f4\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8", (String)"OverhaulSchemeUniqueValidator_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), materielname, modelone, customers);
    }

    public DynamicObjectCollection checkUnique(long createOrgPK, long materailPK, long mrtypePK, long dataPK, List<Long> customerList) {
        ArrayList<QFilter> qFiltersList = new ArrayList<QFilter>(8);
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)FMM_OVERHAULSCHEME, (Long)createOrgPK);
        qFiltersList.add(orgQfiter);
        QFilter materialQfiter = new QFilter(MATERIAL, "=", (Object)materailPK);
        qFiltersList.add(materialQfiter);
        QFilter productModelQfiter = new QFilter(MRTYPE, "=", (Object)mrtypePK);
        qFiltersList.add(productModelQfiter);
        if (customerList != null && customerList.size() > 0) {
            QFilter customerListFilter = new QFilter("customers.fbasedataid", "in", customerList);
            qFiltersList.add(customerListFilter);
        }
        QFilter enableQfiter = new QFilter("enable", "=", (Object)"1");
        qFiltersList.add(enableQfiter);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        qFiltersList.add(statusFilter);
        if (dataPK > 0L) {
            QFilter pkQFilter = new QFilter("id", "not in", (Object)dataPK);
            qFiltersList.add(pkQFilter);
        }
        QFilter[] qFilters = qFiltersList.toArray(new QFilter[qFiltersList.size()]);
        DynamicObjectCollection isExistsDate = QueryServiceHelper.query((String)FMM_OVERHAULSCHEME, (String)"number,customers.fbasedataid.id,customers.fbasedataid.name", (QFilter[])qFilters);
        return isExistsDate;
    }
}

