/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.util.DateCommonUtils;
import kd.mmc.fmm.common.util.MMCUtils;

public class ProcessRouteSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ProcessRouteSaveValidator.class);
    private static final String MAIN_PROSEQ = "1";

    public void validate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<Long> routeIDSet = new HashSet<Long>(16);
        HashSet<Long> processEntryIdSet = new HashSet<Long>(16);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            Long routeId;
            DynamicObject entity = this.dataEntities[i].getDataEntity();
            boolean isEcoRoute = this.isEcoRoute(entity);
            DynamicObjectCollection entryCol = entity.getDynamicObjectCollection("processentry");
            String routeNumber = MMCUtils.getDynamicObjectStringData((DynamicObject)entity, (String)"number");
            DynamicObject unitDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entity, (String)"unit");
            long unitPKValue = MMCUtils.getDynamicObjectPK((DynamicObject)unitDO);
            String processType = MMCUtils.getDynamicObjectStringData((DynamicObject)entity, (String)"processtype", (String)"");
            if ("A".equals(processType)) {
                DynamicObject materialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entity, (String)"material");
                DynamicObject materialUnitDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)materialDO, (String)"baseunit");
                if (unitDO != null && materialUnitDO != null) {
                    long materiaPKValue = MMCUtils.getDynamicObjectPK((DynamicObject)materialUnitDO);
                    if ((unitPKValue > 0L || materiaPKValue > 0L) && unitPKValue != materiaPKValue) {
                        this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e0e\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_10", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            ArrayList<DynamicObject> alist = new ArrayList<DynamicObject>(16);
            HashMap<String, Map<String, List<DynamicObject>>> parentMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
            HashMap<String, Set<String>> processOperationNoMap = new HashMap<String, Set<String>>(4);
            logger.info("\u5f00\u59cb\u8bb0\u5f55\u6570\u636e");
            Iterator iterator = entryCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject sup = (DynamicObject)iterator.next();
                if (sup.getBoolean("storagepoint")) {
                    alist.add(sup);
                }
                this.handleOptionInfo(sup);
                this.checkOptionInfo(this.dataEntities[i], sup, unitPKValue, parentMap, processOperationNoMap);
                if (sup.getPkValue() == null) continue;
                processEntryIdSet.add((Long)sup.getPkValue());
            }
            if (!isEcoRoute) {
                this.checkRepeatOptionNo(this.dataEntities[i], routeNumber, parentMap);
            }
            this.checkManyProcess(this.dataEntities[i], i, processOperationNoMap);
            int size = alist.size();
            if (size > 1 && !isEcoRoute) {
                for (int j = 0; j < size; ++j) {
                    DynamicObject sup = (DynamicObject)alist.get(j);
                    Date entryvaliddate = sup.getDate("entryvaliddate");
                    Date entryinvaliddate = sup.getDate("entryinvaliddate");
                    if (j == size - 1) break;
                    for (int k = j + 1; k < size; ++k) {
                        Date entryinvaliddate2;
                        DynamicObject sup2 = (DynamicObject)alist.get(k);
                        Date entryvaliddate2 = sup2.getDate("entryvaliddate");
                        if (!DateCommonUtils.DateIsUnion((Date)entryvaliddate, (Date)entryinvaliddate, (Date)entryvaliddate2, (Date)(entryinvaliddate2 = sup2.getDate("entryinvaliddate")))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf%1$s\uff0c\u5728\u751f\u6548\u65f6\u95f4\u548c\u5931\u6548\u65f6\u95f4\u533a\u95f4\u91cd\u53e0\u5185\u5165\u5e93\u70b9\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), routeNumber));
                    }
                }
            }
            if ((routeId = Long.valueOf(entity.getLong("id"))) == null || routeId.equals(0L) || isEcoRoute) continue;
            routeIDSet.add(routeId);
        }
        if (!routeIDSet.isEmpty()) {
            HashSet<Long> existsRouteIDSet = new HashSet<Long>(16);
            String selectProperties = "id,processentry.entryecnid entryecnid";
            QFilter qfilter = new QFilter("id", "in", routeIDSet);
            qfilter.and(new QFilter("processentry.id", "not in", processEntryIdSet));
            DynamicObjectCollection routes = QueryServiceHelper.query((String)"pdm_route", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
            if (routes != null && !routes.isEmpty()) {
                for (DynamicObject route : routes) {
                    Long routeId = route.getLong("id");
                    Long ecnId = route.getLong("entryecnid");
                    if (ecnId == null || ecnId.equals(0L)) continue;
                    existsRouteIDSet.add(routeId);
                }
            }
            if (!existsRouteIDSet.isEmpty()) {
                int n2 = this.dataEntities.length;
                for (int i = 0; i < n2; ++i) {
                    DynamicObject route = this.dataEntities[i].getDataEntity();
                    Long routeId = route.getLong("id");
                    if (!existsRouteIDSet.contains(routeId)) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\u7684\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u5df2\u7ecf\u5b58\u5728\u5de5\u7a0b\u53d8\u66f4\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5206\u5f55\u5220\u9664\u64cd\u4f5c\u3002", (String)"ProcessRouteSaveValidator_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), route.getString("number")));
                }
            }
        }
    }

    public List<String> checkOpFormula(DynamicObject sup) {
        ArrayList<String> resultStrList = new ArrayList<String>(4);
        if (sup == null) {
            return resultStrList;
        }
        String entryParent = sup.getString("parent");
        String entryOperationno = sup.getString("operationno");
        DynamicObjectCollection actentryEntityDOC = sup.getDynamicObjectCollection("actentryentity");
        for (DynamicObject actentryEntityDO : actentryEntityDOC) {
            DynamicObject activityDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)actentryEntityDO, (String)"activity");
            String activeStageStr = "";
            if (activityDO != null) {
                activeStageStr = MMCUtils.getDynamicObjectStringData((DynamicObject)activityDO, (String)"processstage");
            }
            DynamicObject standardFormulaDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)actentryEntityDO, (String)"standardformula");
            String standardFormulaStageStr = "";
            if (standardFormulaDO != null) {
                standardFormulaStageStr = MMCUtils.getDynamicObjectStringData((DynamicObject)standardFormulaDO, (String)"processstage");
            }
            DynamicObject reportFormulaDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)actentryEntityDO, (String)"standardformula1");
            String reportFormulaStageStr = "";
            if (standardFormulaDO != null) {
                reportFormulaStageStr = MMCUtils.getDynamicObjectStringData((DynamicObject)reportFormulaDO, (String)"processstage");
            }
            if (activeStageStr.equals(standardFormulaStageStr) && activeStageStr.equals(reportFormulaStageStr)) continue;
            String resultStr = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\uff0c\u5de5\u5e8f\u6d3b\u52a8\u4e0e\u6807\u51c6\u516c\u5f0f\u7684\u5de5\u5e8f\u9636\u6bb5\u4e0d\u4e00\u81f4\u3002", (String)"ProcessRouteSaveValidator_11", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), entryParent, entryOperationno, actentryEntityDO.get("seq"));
            resultStrList.add(resultStr);
        }
        return resultStrList;
    }

    public void checkOptionInfo(ExtendedDataEntity dataEntity, DynamicObject sup, long unitPKValue, Map<String, Map<String, List<DynamicObject>>> parentMap, Map<String, Set<String>> processOperationNoMap) {
        List<DynamicObject> supList;
        if (dataEntity == null || sup == null || parentMap == null) {
            return;
        }
        DynamicObject headunitDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)sup, (String)"headunit");
        long headUnitPkValue = MMCUtils.getDynamicObjectPK((DynamicObject)headunitDO);
        if ((unitPKValue > 0L || headUnitPkValue > 0L) && unitPKValue != headUnitPkValue) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u9875\u7b7e\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0e\u5de5\u5e8f\u660e\u7ec6\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_12", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
        String machTypeStr = MMCUtils.getDynamicObjectStringData((DynamicObject)sup, (String)"machiningtype");
        DynamicObject opCtrlStrateDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)sup, (String)"oprctrlstrategy");
        String promodeStr = MMCUtils.getDynamicObjectStringData((DynamicObject)opCtrlStrateDO, (String)"promode");
        if (StringUtils.isNotEmpty((CharSequence)machTypeStr) && StringUtils.isNotEmpty((CharSequence)promodeStr) && !StringUtils.equals((CharSequence)machTypeStr, (CharSequence)promodeStr)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e0e\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u5bf9\u5e94\u7684\u52a0\u5de5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_13", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
        String parentStr = MMCUtils.getDynamicObjectStringData((DynamicObject)sup, (String)"parent");
        String opNoStr = MMCUtils.getDynamicObjectStringData((DynamicObject)sup, (String)"operationno");
        Map<String, List<DynamicObject>> opNoMap = parentMap.get(parentStr);
        if (opNoMap == null) {
            opNoMap = new HashMap<String, List<DynamicObject>>(16);
        }
        if ((supList = opNoMap.get(opNoStr)) == null) {
            supList = new ArrayList<DynamicObject>(16);
        }
        supList.add(sup);
        opNoMap.put(opNoStr, supList);
        parentMap.put(parentStr, opNoMap);
        List<String> checStrList = this.checkOpFormula(sup);
        if (checStrList != null && !checStrList.isEmpty()) {
            for (String str : checStrList) {
                this.addErrorMessage(dataEntity, str);
            }
        }
        if (processOperationNoMap == null) {
            return;
        }
        Set<String> optionNoSet = processOperationNoMap.get(parentStr);
        if (optionNoSet == null) {
            optionNoSet = new HashSet<String>(2);
            optionNoSet.add(opNoStr);
        } else {
            optionNoSet.add(opNoStr);
        }
        processOperationNoMap.put(parentStr, optionNoSet);
    }

    public void checkRepeatOptionNo(ExtendedDataEntity dataEntity, String routeNumber, Map<String, Map<String, List<DynamicObject>>> parentMap) {
        if (dataEntity == null || parentMap == null) {
            return;
        }
        Set<Map.Entry<String, Map<String, List<DynamicObject>>>> entries = parentMap.entrySet();
        for (Map.Entry<String, Map<String, List<DynamicObject>>> parentMapEntry : entries) {
            String parentStr = parentMapEntry.getKey();
            Map<String, List<DynamicObject>> opNoMap = parentMapEntry.getValue();
            Set<Map.Entry<String, List<DynamicObject>>> opNoEntries = opNoMap.entrySet();
            block1: for (Map.Entry<String, List<DynamicObject>> opNoMapEntry : opNoEntries) {
                List<DynamicObject> supList = opNoMapEntry.getValue();
                int size = supList.size();
                if (size <= 1) continue;
                for (int i = 0; i < size; ++i) {
                    DynamicObject sup = supList.get(i);
                    Date entryvaliddate = sup.getDate("entryvaliddate");
                    Date entryinvaliddate = sup.getDate("entryinvaliddate");
                    if (i == size - 1) continue block1;
                    for (int j = i + 1; j < size; ++j) {
                        Date entryinvaliddate2;
                        DynamicObject sup2 = supList.get(j);
                        Date entryvaliddate2 = sup2.getDate("entryvaliddate");
                        if (!DateCommonUtils.DateIsUnion((Date)entryvaliddate, (Date)entryinvaliddate, (Date)entryvaliddate2, (Date)(entryinvaliddate2 = sup2.getDate("entryinvaliddate")))) continue;
                        String opNoStr = opNoMapEntry.getKey();
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\uff0c\u5b58\u5728\u76f8\u540c\u7684\u5de5\u5e8f\u53f7\u201c%3$s\u201d\uff0c\u751f\u6548\u65f6\u95f4\u548c\u5931\u6548\u65f6\u95f4\u533a\u95f4\u91cd\u53e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_14", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), routeNumber, parentStr, opNoStr));
                    }
                }
            }
        }
    }

    public void checkManyProcess(ExtendedDataEntity dataEntity, int row, Map<String, Set<String>> processOperationNoMap) {
        if (dataEntity == null) {
            return;
        }
        DynamicObject routeDO = dataEntity.getDataEntity();
        String routeNumber = routeDO.getString("number");
        DynamicObjectCollection proListDOC = routeDO.getDynamicObjectCollection("entryentity");
        if (proListDOC == null) {
            return;
        }
        HashMap proSeqMap = new HashMap(4);
        AtomicBoolean mainProFlag = new AtomicBoolean(false);
        HashMap<String, String> proTypeMap = new HashMap<String, String>(2);
        for (DynamicObject rowDo : proListDOC) {
            String processSeq = rowDo.getString("processseq");
            String proType = rowDo.getString("processseqtype");
            if (!StringUtils.isNotEmpty((CharSequence)processSeq)) continue;
            proTypeMap.put(processSeq, proType);
        }
        proListDOC.stream().forEach(rowDO -> {
            String processTypeValue;
            int seq = rowDO.getInt("seq");
            String processSeq = rowDO.getString("processseq");
            String proType = rowDO.getString("processseqtype");
            if (StringUtils.equals((CharSequence)MAIN_PROSEQ, (CharSequence)processSeq) && StringUtils.equals((CharSequence)"A", (CharSequence)proType)) {
                mainProFlag.set(true);
            }
            if (StringUtils.equals((CharSequence)"A", (CharSequence)proType) && !StringUtils.equals((CharSequence)MAIN_PROSEQ, (CharSequence)processSeq)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217\u5e8f\u5217\u53f7\u56fa\u5b9a\u4e3a\u201c1\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_7", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)proType) && StringUtils.equals((CharSequence)MAIN_PROSEQ, (CharSequence)processSeq)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217\u5e8f\u5217\u53f7\u56fa\u5b9a\u4e3a\u201c1\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_7", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
            if (proSeqMap.containsKey(processSeq)) {
                int pre = (Integer)proSeqMap.get(processSeq);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u5e8f\u5217\u53f7\u91cd\u590d\u3002", (String)"ProcessRouteSaveValidator_18", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), pre, seq));
            } else {
                proSeqMap.put(processSeq, seq);
            }
            String reference = rowDO.getString("reference");
            if (!(StringUtils.equals((CharSequence)MAIN_PROSEQ, (CharSequence)processSeq) || StringUtils.equals((CharSequence)"A", (CharSequence)proType) || proTypeMap.containsKey(reference))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u201c%1$s\u201d\u7684\u53c2\u7167\u5e8f\u5217\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ProcessRouteSaveValidator_20", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), processSeq, reference));
            }
            if (StringUtils.equals((CharSequence)"B", (CharSequence)(processTypeValue = (String)proTypeMap.get(reference)))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u5217%s\u4e3a\u5e76\u884c\u5e8f\u5217\uff0c\u4e0d\u53ef\u4f5c\u4e3a\u53c2\u7167\u5e8f\u5217\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_21", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), reference));
            }
            if (!this.isEcoRoute(routeDO) && processOperationNoMap != null) {
                Set optionNoSet = (Set)processOperationNoMap.get(reference);
                String output = rowDO.getString("output");
                if (optionNoSet != null && !optionNoSet.contains(output)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u7684\u53c2\u7167\u5e8f\u5217\u201c%3$s\u201d\u4e2d\u5de5\u5e8f\u201c%4$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u51fa\u5de5\u5e8f\u3002", (String)"ProcessRouteSaveValidator_16", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), routeNumber, processSeq, reference, output));
                }
                String input = rowDO.getString("input");
                if (optionNoSet != null && !optionNoSet.contains(input)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u7684\u53c2\u7167\u5e8f\u5217\u201c%3$s\u201d\u4e2d\u5de5\u5e8f\u201c%4$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u5165\u5de5\u5e8f\u3002", (String)"ProcessRouteSaveValidator_17", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), routeNumber, processSeq, reference, input));
                }
            }
        });
        if (!mainProFlag.get()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%s\u201d\uff0c\u5fc5\u987b\u5f55\u5165\u4e3b\u5e8f\u5217\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteSaveValidator_9", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), routeNumber));
        }
    }

    public void handleOptionInfo(DynamicObject sup) {
        DynamicObject workshop;
        if (sup == null) {
            return;
        }
        DynamicObject workCenterDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)sup, (String)"workcenter");
        DynamicObject productWorkshopDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)sup, (String)"productionworkshop");
        if (productWorkshopDO == null && (workshop = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)workCenterDO, (String)"workshop")) != null) {
            sup.set("productionworkshop", (Object)workshop);
        }
    }

    public boolean isEcoRoute(DynamicObject route) {
        return "pdm_ecoroute".equals(route.getDataEntityType().getName());
    }
}

