/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.croindustrycotype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CroinDustrycoTypeEnableOp
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_NAME = "fmm_croindustrycotype";
    private static final String ORG_FIELD = "createorg";
    private static final String CROSSINDUSTRY_FIELD = "crossindustrycoordtype";
    private static final String ENABLE_FIELD = "enable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(ORG_FIELD);
        e.getFieldKeys().add(CROSSINDUSTRY_FIELD);
        e.getFieldKeys().add(ENABLE_FIELD);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        HashMap<String, ExtendedDataEntity> key_validExtDataEntity = new HashMap<String, ExtendedDataEntity>(16);
        HashMap key_numbers = new HashMap(16);
        HashSet<String> errorKey = new HashSet<String>(16);
        HashSet<Object> orgPks = new HashSet<Object>(16);
        HashSet<Object> typePks = new HashSet<Object>(16);
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = validExtDataEntity.getDataEntity();
            String number = dataEntity.getString("number");
            DynamicObject orgName = dataEntity.getDynamicObject(ORG_FIELD);
            DynamicObject crossIndustryType = dataEntity.getDynamicObject(CROSSINDUSTRY_FIELD);
            String enableStatus = (String)dataEntity.get(ENABLE_FIELD);
            String orgId = orgName.getString("id");
            String typeId = crossIndustryType.getString("id");
            String key = orgId + "_" + typeId + "_" + enableStatus;
            key_validExtDataEntity.put(key, validExtDataEntity);
            ArrayList<String> numbers = (ArrayList<String>)key_numbers.get(key);
            if (numbers == null) {
                numbers = new ArrayList<String>(16);
                orgPks.add(orgName.getPkValue());
                typePks.add(crossIndustryType.getPkValue());
            } else {
                errorKey.add(key);
            }
            numbers.add(number);
            key_numbers.put(key, numbers);
        }
        if (!orgPks.isEmpty()) {
            QFilter orgQf = new QFilter("createorg.id", "in", orgPks);
            QFilter typeQf = new QFilter("crossindustrycoordtype.id", "in", typePks);
            QFilter enableQf = new QFilter(ENABLE_FIELD, "=", (Object)"1");
            QFilter[] qf = new QFilter[]{orgQf, typeQf, enableQf};
            DynamicObjectCollection colls = QueryServiceHelper.query((String)ENTITY_NAME, (String)"number,createorg,crossindustrycoordtype,enable", (QFilter[])qf);
            if (!colls.isEmpty()) {
                for (DynamicObject dataEntity : colls) {
                    String enableStatus = dataEntity.getString(ENABLE_FIELD);
                    String orgId = dataEntity.getString(ORG_FIELD);
                    String typeId = dataEntity.getString(CROSSINDUSTRY_FIELD);
                    String key = orgId + "_" + typeId + "_" + enableStatus;
                    List numbers = (List)key_numbers.get(key);
                    if (numbers != null) continue;
                    enableStatus = "0";
                    key = orgId + "_" + typeId + "_" + enableStatus;
                    errorKey.add(key);
                }
            }
        }
        StringBuilder errMsg = new StringBuilder();
        for (String key : errorKey) {
            List numbers = (List)key_numbers.get(key);
            if (!numbers.isEmpty()) {
                for (String number : numbers) {
                    errMsg.append(String.format(ResManager.loadKDString((String)"%s:\u4e0d\u6ee1\u8db3\u521b\u5efa\u7ec4\u7ec7+\u8de8\u884c\u4e1a\u534f\u8c03\u7c7b\u578b\u4e14\u6570\u636e\u72b6\u6001\u4e3a\u542f\u7528\u7684\u552f\u4e00\u6027\u6821\u9a8c", (String)"CroinDustrycoTypeEnableOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number)).append("\n");
                }
            }
            key_validExtDataEntity.remove(key);
        }
        if (key_validExtDataEntity.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage(errMsg.toString());
        } else {
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(key_validExtDataEntity.values());
            e.setCancelMessage(errMsg.toString());
        }
    }
}

