/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.mftbom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.bomcache.BomUtils;
import kd.bd.mpdm.common.utils.PdmParamSetHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MFTBOMEcnDataValidator
extends AbstractValidator {
    private static final String OP_UNAUDIT = "unaudit";
    private static final String OP_DELETE = "delete";

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "delete": {
                this.checkDeleteData();
                break;
            }
            case "unaudit": {
                this.checkUnAuditData();
                break;
            }
        }
    }

    private void checkDeleteData() {
        Set<Long> bomIDSet = this.getBomIdSet();
        String opKey = OP_DELETE;
        if (!bomIDSet.isEmpty()) {
            Set<Long> existsRouteIDSet = this.getExistsECNBomIdSet(bomIDSet, opKey);
            this.checkExistsECN(existsRouteIDSet, opKey);
        }
    }

    private void checkUnAuditData() {
        Set<Long> bomIDSet = this.getBomIdSet();
        String opKey = OP_UNAUDIT;
        if (!bomIDSet.isEmpty()) {
            Set<Long> existsRouteIDSet = this.getExistsECNBomIdSet(bomIDSet, opKey);
            if (!this.checkExistsECN(existsRouteIDSet, opKey)) {
                return;
            }
            if (PdmParamSetHelper.getBooleanParamValue((String)"BomUnAuditCheckMutex")) {
                return;
            }
            List ids = bomIDSet.stream().map(x -> x.toString()).collect(Collectors.toList());
            Set lockIds = BomUtils.checkEntityIsLock(ids, (String)"pdm_mftbom", (String)"modify");
            if (!lockIds.isEmpty()) {
                int n = this.dataEntities.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject bom = this.dataEntities[i].getDataEntity();
                    Long bomId = bom.getLong("id");
                    if (!this.isMftBom(bom) || !lockIds.contains(String.valueOf(bomId))) continue;
                    String checkMsg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u6b63\u5728\u8fdb\u884c\u7f16\u8f91\u64cd\u4f5c\uff0c\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"MFTBOMEcnDataValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), bom.getString("number"));
                    this.addErrorMessage(this.dataEntities[i], checkMsg);
                }
            }
        }
    }

    private Set<Long> getBomIdSet() {
        HashSet<Long> bomIDSet = new HashSet<Long>(16);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject bom = this.dataEntities[i].getDataEntity();
            Long bomId = bom.getLong("id");
            if (!this.isMftBom(bom) || bomId == null || bomId.equals(0L)) continue;
            bomIDSet.add(bomId);
        }
        return bomIDSet;
    }

    private Set<String> getUnAuditStatus() {
        HashSet<String> unAuditStatusSet = new HashSet<String>(16);
        unAuditStatusSet.add("A");
        unAuditStatusSet.add("B");
        return unAuditStatusSet;
    }

    private boolean isUnAuditOpKey(String opKey) {
        return OP_UNAUDIT.equals(opKey);
    }

    private Set<Long> getExistsECNBomIdSet(Set<Long> bomIDSet, String opKey) {
        DynamicObjectCollection ecoBills;
        HashSet<Long> existsBomIDSet = new HashSet<Long>(16);
        String selectProperties = "pentry.pentrybom as bomid";
        QFilter qfilter = new QFilter("pentry.pentrybom", "in", bomIDSet);
        if (this.isUnAuditOpKey(opKey)) {
            qfilter = qfilter.and(new QFilter("billstatus", "in", this.getUnAuditStatus()));
        }
        if ((ecoBills = QueryServiceHelper.query((String)"pdm_bom_eco", (String)selectProperties, (QFilter[])new QFilter[]{qfilter})) != null && !ecoBills.isEmpty()) {
            for (DynamicObject ecnBill : ecoBills) {
                Long bomId = ecnBill.getLong("bomid");
                existsBomIDSet.add(bomId);
            }
        }
        return existsBomIDSet;
    }

    private boolean isMftBom(DynamicObject bom) {
        return "pdm_mftbom".equalsIgnoreCase(bom.getDynamicObjectType().getName());
    }

    private boolean checkExistsECN(Set<Long> existsBomIDSet, String opKey) {
        boolean isCheck = Boolean.TRUE;
        if (!existsBomIDSet.isEmpty()) {
            int n = this.dataEntities.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject bom = this.dataEntities[i].getDataEntity();
                Long bomId = bom.getLong("id");
                if (!this.isMftBom(bom) || !existsBomIDSet.contains(bomId)) continue;
                String checkMsg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u5de5\u7a0b\u53d8\u66f4\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u3002", (String)"MFTBOMEcnDataValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), bom.getString("number"));
                if (this.isUnAuditOpKey(opKey)) {
                    checkMsg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u7a0b\u53d8\u66f4\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MFTBOMEcnDataValidator_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), bom.getString("number"));
                }
                this.addErrorMessage(this.dataEntities[i], checkMsg);
                isCheck = Boolean.FALSE;
            }
        }
        return isCheck;
    }
}

