/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.mftbom;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.fmm.common.constants.MFTBOMConst;
import kd.mmc.fmm.common.enums.MaterialAttrEnum;
import kd.mmc.fmm.common.util.MMCUtils;

public class MFTBOMImportOp
extends BatchImportPlugin
implements IImportDataPlugin {
    public static boolean isTrue(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        String literal = String.valueOf(val);
        return "true".equalsIgnoreCase(literal) || "1".equals(literal);
    }

    protected void resolveExcel() {
        MFTBOMConst.matMap.clear();
        MFTBOMConst.bomVerMap.clear();
        MFTBOMConst.bomMap.clear();
        MFTBOMConst.bomTypeMap.clear();
        MFTBOMConst.matInfoNumMap.clear();
        super.resolveExcel();
    }

    public MainEntityType getExportMainEntityType(String s, DynamicObject dynamicObject) {
        return EntityMetadataCache.getDataEntityType((String)s);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (result != null && result.getData() != null) {
            List dataList;
            List<DynamicObject> retData;
            Object data = result.getData();
            ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(128);
            if (data instanceof List && (retData = this.dealOtherFields(dataList = (List)data)) != null && !retData.isEmpty()) {
                saveDatas.addAll(retData);
            }
            SaveServiceHelper.update((DynamicObject[])saveDatas.toArray(new DynamicObject[saveDatas.size()]));
        }
        return result;
    }

    private Set<Long> getBomIdSet(List<Object> dataList) {
        HashSet<Long> idSet = new HashSet<Long>(dataList.size());
        for (Object o : dataList) {
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            String id = String.valueOf(map.get("id"));
            if (!MFTBOMImportOp.isTrue(map.get("success")) || !StringUtils.isNotBlank((CharSequence)id)) continue;
            idSet.add(Long.parseLong(id));
        }
        return idSet;
    }

    private String getBomSelectProperties() {
        String selectFields = "createorg,material,version,auxproperty,type,type.purpose,materialid,qtybaseunit,entry.id,entry.entrytype,entry.entrymaterial,entry.entrymaterialid,entry.featuretype,entry.configproperties,entry.entrymaterialattr,entry.entryunit,entry.entryisjumplevel,entry.entryversion,entry.entryqtytype,entry.entryownertype,entry.entryowner,entry.entrysupplyorg,entry.entryisstockalloc,entry.entrywarehouse,entry.entrylocation,entry.entryoutorg,entry.entryoutwarehouse,entry.entryoutlocation,entry.opt,entry.qtyopt,entry.preferopt,entry.minqtyopt,entry.maxqtyopt,copentry.copentrymaterial,copentry.copentryunit,copentry.copentrymaterialid,copentry.copentryversion,copentry.copentryauxproperty";
        return selectFields;
    }

    private Map<Long, DynamicObject> convertBomMap(DynamicObject[] boms) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(boms.length);
        for (DynamicObject bom : boms) {
            map.put((Long)bom.getPkValue(), bom);
        }
        return map;
    }

    private List<DynamicObject> dealOtherFields(List<Object> dataList) {
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
        Set<Long> bomIdSet = this.getBomIdSet(dataList);
        DynamicObject[] boms = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)this.getBomSelectProperties(), (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
        Map<Long, DynamicObject> bomMap = this.convertBomMap(boms);
        Map<Object, DynamicObject> materialMasterMap = this.getMaterialMaster(boms);
        Map<Object, DynamicObject> featureTypeMap = this.getFeatureTypeMap(boms);
        Map<String, DynamicObject> materialMftMap = this.getMaterialMftInfo(boms);
        Map<Object, DynamicObject> bomVersionMap = this.getVersionMap(boms);
        Set<String> orgWarehouseIdSet = this.getWarehouseMap(boms);
        Set<String> warehouseLocationIdSet = this.getLocationMap(boms);
        for (Object o : dataList) {
            DynamicObject version;
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            Object success = map.get("success");
            String id = String.valueOf(map.get("id"));
            if (!MFTBOMImportOp.isTrue(success) || !StringUtils.isNotBlank((CharSequence)id)) continue;
            DynamicObject bom = bomMap.get(Long.parseLong(id));
            DynamicObject matObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"materialid");
            DynamicObject orgObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"createorg");
            Long orgId = orgObj == null ? 0L : orgObj.getLong("id");
            if (matObj != null) {
                matObj = materialMasterMap.get(matObj.getPkValue());
                String keyString = this.getMaterialOrgKey(orgId, matObj.getPkValue());
                DynamicObject mft = materialMftMap.get(keyString);
                bom.set("material", (Object)mft);
                DynamicObject baseunit = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)matObj, (String)"baseunit");
                Long baseunitId = baseunit == null ? 0L : Long.parseLong(baseunit.getPkValue().toString());
                bom.set("qtybaseunit", (Object)baseunitId);
                bom.set("qtybaseunit_id", (Object)baseunitId);
            }
            if ((version = bom.getDynamicObject("version")) != null && matObj != null) {
                DynamicObject verMaterial;
                DynamicObject dynamicObject = verMaterial = (version = this.getNewDataFromMap(version, bomVersionMap)) == null ? null : version.getDynamicObject("material");
                if (verMaterial == null || !verMaterial.getPkValue().equals(matObj.getPkValue())) {
                    bom.set("version", null);
                }
            }
            this.dealEntryFields(bom, materialMftMap, materialMasterMap, featureTypeMap, bomVersionMap, orgWarehouseIdSet, warehouseLocationIdSet);
            this.dealCopEntryField(bom, materialMftMap, bomVersionMap, materialMasterMap);
            saveDatas.add(bom);
        }
        return saveDatas;
    }

    private DynamicObject getNewDataFromMap(DynamicObject oldData, Map<Object, DynamicObject> cacheMap) {
        DynamicObject newData;
        if (oldData != null && (newData = cacheMap.get(oldData.getPkValue())) != null) {
            oldData = newData;
        }
        return oldData;
    }

    private void dealEntryFields(DynamicObject bom, Map<String, DynamicObject> materialMftMap, Map<Object, DynamicObject> materialMasterMap, Map<Object, DynamicObject> featureTypeMap, Map<Object, DynamicObject> bomVersionMap, Set<String> orgWarehouseIdSet, Set<String> warehouseLocationIdSet) {
        DynamicObject orgObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"createorg");
        DynamicObjectCollection entrys = bom.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            boolean qtyopt;
            boolean entryisstockalloc;
            String entryownertype;
            DynamicObject entrymatObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterialid");
            entrymatObj = this.getNewDataFromMap(entrymatObj, materialMasterMap);
            String entryType = entry.getString("entrytype");
            DynamicObject featureTypeObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"featuretype");
            DynamicObject entrybaseunit = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entrymatObj, (String)"baseunit");
            if ("B".equals(entryType)) {
                featureTypeObj = this.getNewDataFromMap(featureTypeObj, featureTypeMap);
                entrybaseunit = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)featureTypeObj, (String)"basicunit");
                entry.set("entrymaterial", (Object)0L);
                entry.set("entrymaterial_id", (Object)0L);
                entry.set("entrymaterialid", (Object)0L);
                entry.set("entrymaterialid_id", (Object)0L);
                entry.set("entrymaterialattr", (Object)" ");
                entry.set("configproperties", (Object)" ");
            } else {
                entry.set("featuretype", (Object)0L);
                if (entrymatObj != null) {
                    String keyString = this.getMaterialOrgKey(orgObj.getPkValue(), entrymatObj.getPkValue());
                    DynamicObject mft = materialMftMap.get(keyString);
                    String entrymaterialAttr = "";
                    if (mft != null) {
                        entrymaterialAttr = MMCUtils.getDynamicObjectStringData((DynamicObject)mft, (String)"materialattr");
                    }
                    entry.set("entrymaterial", (Object)mft);
                    entry.set("entrymaterialattr", (Object)entrymaterialAttr);
                    String isJumpLevel = entry.getString("entryisjumplevel");
                    if (StringUtils.equalsIgnoreCase((CharSequence)entrymaterialAttr, (CharSequence)MaterialAttrEnum.PHANTOMPART.getValue())) {
                        entry.set("entryisjumplevel", (Object)true);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)entrymaterialAttr, (CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue())) {
                        entry.set("entryisjumplevel", (Object)false);
                    }
                    if ((StringUtils.equalsIgnoreCase((CharSequence)entrymaterialAttr, (CharSequence)MaterialAttrEnum.FABRICATEDPART.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)entrymaterialAttr, (CharSequence)MaterialAttrEnum.EXTERNALPROCESSINPART.getValue())) && (isJumpLevel == null || "".equals(isJumpLevel))) {
                        entry.set("entryisjumplevel", (Object)false);
                    }
                }
            }
            if (entrymatObj != null) {
                String configproperties = MMCUtils.getDynamicObjectStringData((DynamicObject)entrymatObj, (String)"configproperties");
                entry.set("configproperties", (Object)configproperties);
            }
            Long entrybaseunitId = 0L;
            if (entrybaseunit != null) {
                entrybaseunitId = MMCUtils.getDynamicObjectPK((DynamicObject)entrybaseunit);
            }
            entry.set("entryunit", (Object)entrybaseunit);
            entry.set("entryunit_id", (Object)entrybaseunitId);
            DynamicObject entryversion = entry.getDynamicObject("entryversion");
            if (entryversion != null && entrymatObj != null) {
                DynamicObject verMaterial;
                DynamicObject dynamicObject = verMaterial = (entryversion = this.getNewDataFromMap(entryversion, bomVersionMap)) == null ? null : entryversion.getDynamicObject("material");
                if (verMaterial == null || !verMaterial.getPkValue().equals(entrymatObj.getPkValue())) {
                    entry.set("entryversion", null);
                }
            }
            if ("bos_org".equals(entryownertype = entry.getString("entryownertype"))) {
                entry.set("entryowner", null);
            }
            if (!(entryisstockalloc = entry.getBoolean("entryisstockalloc"))) {
                entry.set("entryoutorg", null);
                entry.set("entryoutwarehouse", null);
                entry.set("entryoutlocation", null);
            }
            this.dealWarehouseAndLocation(entry, "entrysupplyorg", "entrywarehouse", "entrylocation", orgWarehouseIdSet, warehouseLocationIdSet);
            this.dealWarehouseAndLocation(entry, "entryoutorg", "entryoutwarehouse", "entryoutlocation", orgWarehouseIdSet, warehouseLocationIdSet);
            boolean opt = entry.getBoolean("opt");
            if (!opt) {
                entry.set("preferopt", (Object)false);
            }
            if (qtyopt = entry.getBoolean("qtyopt")) continue;
            entry.set("minqtyopt", (Object)BigDecimal.ZERO);
            entry.set("maxqtyopt", (Object)BigDecimal.ZERO);
        }
    }

    private void dealWarehouseAndLocation(DynamicObject entry, String orgFieldNumber, String warehouseFieldNumber, String locationFieldNumber, Set<String> orgWarehouseIdSet, Set<String> warehouseLocationIdSet) {
        String keyString;
        String keyString2;
        DynamicObject entrywarehouse;
        DynamicObject entrysupplyorg = entry.getDynamicObject(orgFieldNumber);
        if (entrysupplyorg != null & (entrywarehouse = entry.getDynamicObject(warehouseFieldNumber)) != null && !orgWarehouseIdSet.contains(keyString2 = entrysupplyorg.getPkValue() + "_" + entrywarehouse.getPkValue())) {
            entry.set(warehouseFieldNumber, null);
            entrywarehouse = null;
        }
        if (entrysupplyorg == null) {
            entry.set(warehouseFieldNumber, null);
            entrywarehouse = null;
        }
        DynamicObject entrylocation = entry.getDynamicObject(locationFieldNumber);
        if (entrywarehouse == null) {
            entry.set(locationFieldNumber, null);
            entrylocation = null;
        } else if (entrylocation != null && !warehouseLocationIdSet.contains(keyString = entrywarehouse.getPkValue() + "_" + entrylocation.getPkValue())) {
            entry.set(locationFieldNumber, null);
            entrylocation = null;
        }
    }

    private void dealCopEntryField(DynamicObject bom, Map<String, DynamicObject> materialMftMap, Map<Object, DynamicObject> bomVersionMap, Map<Object, DynamicObject> materialMasterMap) {
        DynamicObject orgObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"createorg");
        DynamicObjectCollection copentrys = bom.getDynamicObjectCollection("copentry");
        for (DynamicObject copentry : copentrys) {
            DynamicObject verMaterial;
            DynamicObject copEntryMatObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentrymaterialid");
            if ((copEntryMatObj = this.getNewDataFromMap(copEntryMatObj, materialMasterMap)) != null) {
                String keyString = this.getMaterialOrgKey(orgObj.getPkValue(), copEntryMatObj.getPkValue());
                DynamicObject mft = materialMftMap.get(keyString);
                copentry.set("copentrymaterial", (Object)mft);
            }
            DynamicObject copEntryBaseUnit = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)copEntryMatObj, (String)"baseunit");
            Long entrybaseunitId = 0L;
            if (copEntryBaseUnit != null) {
                entrybaseunitId = MMCUtils.getDynamicObjectPK((DynamicObject)copEntryBaseUnit);
            }
            copentry.set("copentryunit", (Object)copEntryBaseUnit);
            copentry.set("copentryunit_id", (Object)entrybaseunitId);
            DynamicObject copentryversion = copentry.getDynamicObject("copentryversion");
            if (copentryversion == null || copEntryMatObj == null) continue;
            DynamicObject dynamicObject = verMaterial = (copentryversion = this.getNewDataFromMap(copentryversion, bomVersionMap)) == null ? null : copentryversion.getDynamicObject("material");
            if (verMaterial != null && verMaterial.getPkValue().equals(copEntryMatObj.getPkValue())) continue;
            copentry.set("copentryversion", null);
        }
    }

    private String getMaterialOrgKey(Object orgId, Object materialMasterId) {
        return String.valueOf(orgId) + "_" + String.valueOf(materialMasterId);
    }

    private Map<String, DynamicObject> getMaterialMftInfo(DynamicObject[] boms) {
        Map<Long, Set<Long>> orgMaterialMap = this.getMaterialIdSet(boms);
        HashMap<String, DynamicObject> mftMap = new HashMap<String, DynamicObject>(16);
        if (orgMaterialMap == null || orgMaterialMap.isEmpty()) {
            return mftMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : orgMaterialMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> materialMasterId = entrys.getValue();
            QFilter qFilter = new QFilter("masterid", "in", materialMasterId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map mftCacheMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"id,masterid,mftunit,materialattr", (QFilter[])new QFilter[]{qFilter});
            if (mftCacheMap == null || mftCacheMap.isEmpty()) continue;
            for (Map.Entry mfts : mftCacheMap.entrySet()) {
                DynamicObject mft = (DynamicObject)mfts.getValue();
                String keyString = this.getMaterialOrgKey(orgId, mft.getDynamicObject("masterid").getPkValue());
                mftMap.put(keyString, mft);
            }
        }
        return mftMap;
    }

    private void addToLongMap(Long keyString, Long value, Map<Long, Set<Long>> map) {
        Set<Long> idSet = map.get(keyString);
        if (idSet == null) {
            idSet = new HashSet<Long>(16);
        }
        idSet.add(value);
        map.put(keyString, idSet);
    }

    private Map<Long, Set<Long>> getMaterialIdSet(DynamicObject[] boms) {
        HashMap<Long, Set<Long>> orgMaterialMap = new HashMap<Long, Set<Long>>(16);
        if (boms == null || boms.length < 1) {
            return orgMaterialMap;
        }
        for (DynamicObject bom : boms) {
            DynamicObject orgObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"createorg");
            Long orgId = orgObj == null ? 0L : orgObj.getLong("id");
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject entrymarerialid = entryData.getDynamicObject("entrymaterialid");
                if (entrymarerialid == null) continue;
                this.addToLongMap(orgId, entrymarerialid.getLong("id"), orgMaterialMap);
            }
            DynamicObject materialid = bom.getDynamicObject("materialid");
            if (materialid != null) {
                this.addToLongMap(orgId, materialid.getLong("id"), orgMaterialMap);
            }
            DynamicObjectCollection copentry = bom.getDynamicObjectCollection("copentry");
            for (DynamicObject copentryData : copentry) {
                DynamicObject copentrymarerialidObj = copentryData.getDynamicObject("copentrymaterialid");
                if (copentrymarerialidObj == null) continue;
                this.addToLongMap(orgId, copentrymarerialidObj.getLong("id"), orgMaterialMap);
            }
        }
        return orgMaterialMap;
    }

    private Map<Object, DynamicObject> getMaterialMaster(DynamicObject[] boms) {
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(16);
        if (boms == null || boms.length < 1) {
            return dataMap;
        }
        HashSet<Long> matSet = new HashSet<Long>(64);
        for (DynamicObject bom : boms) {
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject entrymarerialid;
                String entrytype = entryData.getString("entrytype");
                if (!"A".equals(entrytype) || (entrymarerialid = entryData.getDynamicObject("entrymaterialid")) == null) continue;
                matSet.add(entrymarerialid.getLong("id"));
            }
            DynamicObject materialid = bom.getDynamicObject("materialid");
            if (materialid != null) {
                matSet.add(materialid.getLong("id"));
            }
            DynamicObjectCollection copentry = bom.getDynamicObjectCollection("copentry");
            for (DynamicObject copentryData : copentry) {
                DynamicObject copentrymarerialidObj = copentryData.getDynamicObject("copentrymaterialid");
                if (copentrymarerialidObj == null) continue;
                matSet.add(copentrymarerialidObj.getLong("id"));
            }
        }
        if (matSet.isEmpty()) {
            return dataMap;
        }
        QFilter Filter = new QFilter("id", "in", matSet);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,configproperties,baseunit", (QFilter[])new QFilter[]{Filter});
    }

    private Map<Object, DynamicObject> getFeatureTypeMap(DynamicObject[] boms) {
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(16);
        if (boms == null || boms.length < 1) {
            return dataMap;
        }
        HashSet<Long> idSet = new HashSet<Long>(64);
        for (DynamicObject bom : boms) {
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject featuretype = entryData.getDynamicObject("featuretype");
                if (featuretype == null) continue;
                idSet.add(featuretype.getLong("id"));
            }
        }
        if (idSet.isEmpty()) {
            return dataMap;
        }
        QFilter Filter = new QFilter("id", "in", idSet);
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_featuretype", (String)"id,basicunit", (QFilter[])new QFilter[]{Filter});
    }

    private Map<Object, DynamicObject> getVersionMap(DynamicObject[] boms) {
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(16);
        if (boms == null || boms.length < 1) {
            return dataMap;
        }
        HashSet<Long> idSet = new HashSet<Long>(64);
        for (DynamicObject bom : boms) {
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject entryversion = entryData.getDynamicObject("entryversion");
                if (entryversion == null) continue;
                idSet.add(entryversion.getLong("id"));
            }
            DynamicObject version = bom.getDynamicObject("version");
            if (version != null) {
                idSet.add(version.getLong("id"));
            }
            DynamicObjectCollection copentry = bom.getDynamicObjectCollection("copentry");
            for (DynamicObject copentryData : copentry) {
                DynamicObject copentryversion = copentryData.getDynamicObject("copentryversion");
                if (copentryversion == null) continue;
                idSet.add(copentryversion.getLong("id"));
            }
        }
        if (idSet.isEmpty()) {
            return dataMap;
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        return BusinessDataServiceHelper.loadFromCache((String)"bd_bomversion_new", (String)"id,material,type", (QFilter[])new QFilter[]{qFilter});
    }

    private Set<String> getWarehouseMap(DynamicObject[] boms) {
        HashSet<String> matchIdSet = new HashSet<String>(64);
        if (boms == null || boms.length < 1) {
            return matchIdSet;
        }
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (DynamicObject bom : boms) {
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject entryoutwarehouse;
                DynamicObject entryoutorg;
                DynamicObject entrywarehouse;
                DynamicObject entrysupplyorg = entryData.getDynamicObject("entrysupplyorg");
                if (entrysupplyorg != null & (entrywarehouse = entryData.getDynamicObject("entrywarehouse")) != null) {
                    orgIdSet.add(entrysupplyorg.getLong("id"));
                    warehouseIdSet.add(entrywarehouse.getLong("id"));
                }
                if (!((entryoutorg = entryData.getDynamicObject("entryoutorg")) != null & (entryoutwarehouse = entryData.getDynamicObject("entryoutwarehouse")) != null)) continue;
                orgIdSet.add(entryoutorg.getLong("id"));
                warehouseIdSet.add(entryoutwarehouse.getLong("id"));
            }
        }
        if (!orgIdSet.isEmpty() && !warehouseIdSet.isEmpty()) {
            QFilter qfilter = new QFilter("org", "in", orgIdSet);
            qfilter.and(new QFilter("warehouse", "in", warehouseIdSet));
            qfilter.and(new QFilter("initstatus", "=", (Object)"B"));
            qfilter.and(new QFilter("startstatus", "=", (Object)"B"));
            DynamicObjectCollection warehouseColl = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse,org", (QFilter[])new QFilter[]{qfilter});
            for (DynamicObject warehouse : warehouseColl) {
                matchIdSet.add(warehouse.getLong("org") + "_" + warehouse.getLong("warehouse"));
            }
        }
        return matchIdSet;
    }

    private Set<String> getLocationMap(DynamicObject[] boms) {
        HashSet<String> matchIdSet = new HashSet<String>(64);
        if (boms == null || boms.length < 1) {
            return matchIdSet;
        }
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        HashSet<Long> locationIdSet = new HashSet<Long>(16);
        for (DynamicObject bom : boms) {
            DynamicObjectCollection entry = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entryData : entry) {
                DynamicObject entryoutwarehouse;
                DynamicObject entryoutlocation;
                DynamicObject entrywarehouse;
                DynamicObject entrylocation = entryData.getDynamicObject("entrylocation");
                if (entrylocation != null & (entrywarehouse = entryData.getDynamicObject("entrywarehouse")) != null) {
                    locationIdSet.add(entrylocation.getLong("id"));
                    warehouseIdSet.add(entrywarehouse.getLong("id"));
                }
                if (!((entryoutlocation = entryData.getDynamicObject("entryoutlocation")) != null & (entryoutwarehouse = entryData.getDynamicObject("entryoutwarehouse")) != null)) continue;
                locationIdSet.add(entryoutlocation.getLong("id"));
                warehouseIdSet.add(entryoutwarehouse.getLong("id"));
            }
        }
        if (!locationIdSet.isEmpty() && !warehouseIdSet.isEmpty()) {
            QFilter qfilter = new QFilter("id", "in", warehouseIdSet);
            qfilter.and(new QFilter("entryentity.location", "in", locationIdSet));
            qfilter.and(new QFilter("isopenlocation", "=", (Object)true));
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            qfilter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection locationColl = QueryServiceHelper.query((String)"bd_warehouse", (String)"id,entryentity.location location", (QFilter[])new QFilter[]{qfilter});
            for (DynamicObject location : locationColl) {
                matchIdSet.add(location.getLong("id") + "_" + location.getLong("location"));
            }
        }
        return matchIdSet;
    }
}

