/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.program;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.fmm.business.programe.ProcessNoBusiness;
import kd.mmc.fmm.business.programe.ProgramBusiness;

public class ProgramProNoRepeatValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        for (ExtendedDataEntity obj : objs) {
            DynamicObject programeObj = obj.getDataEntity();
            DynamicObjectCollection proEntryCol = programeObj.getDynamicObjectCollection("entryentity");
            this.proEntryVal(obj, proEntryCol);
            String number = programeObj.getString("number");
            DynamicObjectCollection groupEntryCol = programeObj.getDynamicObjectCollection("groupentity");
            this.groupEntryVal(obj, number, groupEntryCol);
        }
    }

    private void proEntryVal(ExtendedDataEntity obj, DynamicObjectCollection proEntryCol) {
        if (proEntryCol == null || proEntryCol.isEmpty()) {
            return;
        }
        ProcessNoBusiness proNoBusiness = new ProcessNoBusiness();
        String errorMsg = proNoBusiness.proNoRepeatVal(proEntryCol);
        if (errorMsg != null && !"".equals(errorMsg)) {
            this.addErrorMessage(obj, errorMsg);
        }
        ProgramBusiness proBusiness = new ProgramBusiness();
        ArrayList<Map<String, Date>> pointList = new ArrayList<Map<String, Date>>(proEntryCol.size());
        for (int i = 0; i < proEntryCol.size(); ++i) {
            Date invalidate;
            DynamicObject entryObj = (DynamicObject)proEntryCol.get(i);
            Date validate = entryObj.getDate("validate");
            boolean isBetween = proBusiness.validateVal(validate, invalidate = entryObj.getDate("invalidate"));
            if (!isBetween) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7b2c\"%1$s\"\u884c\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"ProgramProNoRepeatValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), i + 1));
            }
            boolean isStorePoint = entryObj.getBoolean("storepoint");
            HashMap<String, Date> pointMap = new HashMap<String, Date>(64);
            if (!isStorePoint) continue;
            pointMap.put("starTime", validate);
            pointMap.put("endTime", invalidate);
            pointList.add(pointMap);
        }
        if (!this.isPointRepeat(pointList)) {
            this.addErrorMessage(obj, ResManager.loadKDString((String)"\u540c\u4e00\u751f\u6548\u65f6\u95f4\u5185\uff0c\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5165\u5e93\u70b9\u5de5\u5e8f\u3002", (String)"ProgramProNoRepeatValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isPointRepeat(List<Map<String, Date>> pointList) {
        boolean retFlag = true;
        if (pointList == null || pointList.isEmpty()) {
            return true;
        }
        block0: for (int i = 0; i < pointList.size() - 1; ++i) {
            Map<String, Date> pointMap = pointList.get(i);
            Date starTime = pointMap.get("starTime");
            Date endTime = pointMap.get("endTime");
            for (int k = i + 1; k < pointList.size(); ++k) {
                Map<String, Date> pointMap1 = pointList.get(k);
                Date starTime1 = pointMap1.get("starTime");
                Date endTime1 = pointMap1.get("endTime");
                if (starTime.after(starTime1) && starTime.before(endTime1) || endTime.after(starTime1) && endTime.before(endTime1) || starTime1.after(starTime) && starTime1.before(endTime) || endTime1.after(starTime) && endTime1.before(endTime)) {
                    retFlag = false;
                    continue block0;
                }
                if (!retFlag) continue block0;
            }
        }
        return retFlag;
    }

    private void groupEntryVal(ExtendedDataEntity obj, String number, DynamicObjectCollection groupEntryCol) {
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u914d\u65b9\u201c%1$s\u201d\u7269\u6599\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProgramProNoRepeatValidator_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number));
            return;
        }
        ProgramBusiness proBusiness = new ProgramBusiness();
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            Date invalidate;
            DynamicObject entryObj = (DynamicObject)groupEntryCol.get(i);
            Date validate = entryObj.getDate("entryvaliddate");
            boolean isBetween = proBusiness.validateVal(validate, invalidate = entryObj.getDate("entryinvaliddate"));
            if (!isBetween) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7b2c\"%1$s\"\u884c\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"ProgramProNoRepeatValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            String msg = proBusiness.stageEntryVal(entryObj);
            if (msg != null && !"".equals(msg)) {
                this.addErrorMessage(obj, msg);
                continue;
            }
            String prodType = entryObj.getString("prodtype");
            DynamicObject matObj = entryObj.getDynamicObject("entrymaterial");
            if (!"C".equals(prodType) && matObj == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u914d\u65b9\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c\u7ec4\u4ef6\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProgramProNoRepeatValidator_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number, i + 1));
                continue;
            }
            if (entryObj.getBigDecimal("entryqtynumerator") != null && entryObj.getBigDecimal("entryqtynumerator").compareTo(BigDecimal.ZERO) > 0) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u914d\u65b9\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c\u7ec4\u4ef6\u7269\u6599\u201c%3$s\u201d\u7684\u6807\u51c6\u7528\u91cf\u5206\u5b50\u9700\u5927\u4e8e0\u3002", (String)"ProgramProNoRepeatValidator_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number, i + 1, matObj.getString("number")));
        }
    }
}

