/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.program;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.common.util.ProgrameVersionUtils;

public class ProgramSetVersionValueValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(ProgramSetVersionValueValidator.class);

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            HashMap<Long, String> orgParamMap = new HashMap<Long, String>(16);
            HashSet<Long> unVersionIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity obj : objs) {
                try {
                    this.createProgrameVersion(obj.getDataEntity(), orgParamMap, unVersionIdSet);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.addErrorMessage(obj, e.getMessage());
                }
            }
        }
    }

    public void initRouteId(DynamicObject obj) {
        Object pk = obj.getPkValue();
        if (pk == null || ((Long)pk).equals(0L)) {
            obj.set("id", (Object)ORM.create().genLongId(obj.getDynamicObjectType().getName()));
        }
    }

    public void createProgrameVersion(DynamicObject obj, Map<Long, String> orgParamMap, Set<Long> unVersionIdSet) {
        DynamicObject material = obj.getDynamicObject("material");
        DynamicObject createOrg = obj.getDynamicObject("createorg");
        DynamicObject version = obj.getDynamicObject("version");
        if (material == null || createOrg == null) {
            return;
        }
        if (version != null) {
            return;
        }
        boolean isMaterialVersion = ProgrameVersionUtils.isMaterialVsersion((DynamicObject)material);
        Long orgId = (Long)createOrg.getPkValue();
        String isOpenVersionS = orgParamMap.get(orgId);
        if (StringUtils.isEmpty((String)isOpenVersionS)) {
            boolean isOpenVersion = ProgrameVersionUtils.isProgrameVsersion((Long)orgId);
            isOpenVersionS = isOpenVersion ? "true" : "false";
            orgParamMap.put(orgId, isOpenVersionS);
        }
        if (!isMaterialVersion && !"true".equalsIgnoreCase(isOpenVersionS)) {
            return;
        }
        this.initRouteId(obj);
        DynamicObject newProgrameVersion = ProgrameVersionUtils.createAndGetProgrameVersion((DynamicObject)obj, (boolean)true, unVersionIdSet);
        obj.set("version", (Object)newProgrameVersion);
        if (newProgrameVersion != null) {
            unVersionIdSet.add((Long)newProgrameVersion.getPkValue());
        }
    }
}

