/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.resourceready;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ResourceReadyPlanVal
extends AbstractValidator {
    private static final String READY_PLAN = "fmm_readyplan";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if (dataEntities != null) {
            for (int i = 0; i < dataEntities.length; ++i) {
                ExtendedDataEntity dataEntity = dataEntities[i];
                if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey)) {
                    this.checkUnSubmit(dataEntity);
                    continue;
                }
                this.checkUnique(dataEntity);
            }
        }
    }

    private boolean checkUnSubmit(ExtendedDataEntity dataEntity) {
        DynamicObject dataEntityCreateOrgDO = dataEntity.getDataEntity().getDynamicObject("createorg");
        String useorg = this.getOption().getVariableValue("createorg", "0");
        String createOrg = "";
        if (dataEntityCreateOrgDO != null) {
            createOrg = dataEntityCreateOrgDO.getPkValue().toString();
        }
        if (!"0".equals(useorg) && !createOrg.equals(useorg)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u64a4\u9500\u5931\u8d25\u3002", (String)"ResourceReadyPlanVal_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        return true;
    }

    private void checkUnique(ExtendedDataEntity dataEntity) {
        DynamicObject resouceReadyLevelDO = dataEntity.getDataEntity();
        String planNumber = resouceReadyLevelDO.getString("number");
        QFilter numberFilter = new QFilter("number", "=", (Object)planNumber);
        QFilter statueFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject createOrg = resouceReadyLevelDO.getDynamicObject("createorg");
        long createOrgPK = 0L;
        String orgNumber = "";
        if (createOrg != null && createOrg.getPkValue() instanceof Long) {
            createOrgPK = Long.parseLong(String.valueOf(createOrg.getPkValue()));
            orgNumber = createOrg.getString("name");
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)READY_PLAN, (Long)createOrgPK);
        QFilter[] existsFilter = null;
        existsFilter = resouceReadyLevelDO.getPkValue() != null ? new QFilter[]{new QFilter("id", "!=", resouceReadyLevelDO.getPkValue()), numberFilter, baseDataFilter, statueFilter} : new QFilter[]{numberFilter, baseDataFilter, statueFilter};
        DynamicObjectCollection planDOC = QueryServiceHelper.query((String)READY_PLAN, (String)"id,number,createorg.name orgname", (QFilter[])existsFilter);
        if (planDOC != null && planDOC.size() > 0) {
            String info = String.format("%s(%s)", planNumber, ((DynamicObject)planDOC.get(0)).getString("orgname"));
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5728\u4f7f\u7528\u7ec4\u7ec7%1$s\u4e0b\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u65b9\u6848%2$s\u3002", (String)"ResourceReadyPlanVal_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), orgNumber, info));
        }
    }
}

