/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.resourceready;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.common.enums.ResReadyRuleTypeEnum;

public class ResourceReadyRuleVal
extends AbstractValidator {
    private static final String READY_RULE = "fmm_readyrule";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if (dataEntities != null) {
            for (int i = 0; i < dataEntities.length; ++i) {
                ExtendedDataEntity dataEntity = dataEntities[i];
                if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey)) {
                    this.checkUnSubmit(dataEntity);
                    return;
                }
                this.checkUnique(dataEntity);
                this.checkEntryEntity(dataEntity);
            }
        }
    }

    private boolean checkUnSubmit(ExtendedDataEntity dataEntity) {
        DynamicObject dataEntityCreateOrgDO = dataEntity.getDataEntity().getDynamicObject("createorg");
        String useorg = this.getOption().getVariableValue("createorg", "0");
        String createOrg = "";
        if (dataEntityCreateOrgDO != null) {
            createOrg = dataEntityCreateOrgDO.getPkValue().toString();
        }
        if (!"0".equals(useorg) && !createOrg.equals(useorg)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u64a4\u9500\u5931\u8d25\u3002", (String)"ResourceReadyRuleVal_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        return true;
    }

    private void checkUnique(ExtendedDataEntity dataEntity) {
        DynamicObject resouceReadyLevelDO = dataEntity.getDataEntity();
        String ruleNumber = resouceReadyLevelDO.getString("number");
        QFilter numberFilter = new QFilter("number", "=", (Object)ruleNumber);
        QFilter statueFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject createOrg = resouceReadyLevelDO.getDynamicObject("createorg");
        long createOrgPK = 0L;
        String orgNumber = "";
        if (createOrg != null && createOrg.getPkValue() instanceof Long) {
            createOrgPK = Long.parseLong(String.valueOf(createOrg.getPkValue()));
            orgNumber = createOrg.getString("name");
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)READY_RULE, (Long)createOrgPK);
        QFilter[] existsFilter = null;
        existsFilter = resouceReadyLevelDO.getPkValue() != null ? new QFilter[]{new QFilter("id", "!=", resouceReadyLevelDO.getPkValue()), numberFilter, baseDataFilter, statueFilter} : new QFilter[]{numberFilter, baseDataFilter, statueFilter};
        DynamicObjectCollection ruleDOC = QueryServiceHelper.query((String)READY_RULE, (String)"id,number,createorg.name orgname", (QFilter[])existsFilter);
        if (ruleDOC != null && ruleDOC.size() > 0) {
            String info = String.format("%s(%s)", ruleNumber, ((DynamicObject)ruleDOC.get(0)).getString("orgname"));
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5728\u4f7f\u7528\u7ec4\u7ec7%1$s\u4e0b\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219%2$s\u3002", (String)"ResourceReadyRuleVal_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), orgNumber, info));
        }
    }

    private void checkEntryEntity(ExtendedDataEntity dataEntity) {
        DynamicObject resouceReadyRuleDO = dataEntity.getDataEntity();
        DynamicObjectCollection entryentityDOC = null;
        String ClacOrderNumber = "";
        if (resouceReadyRuleDO != null) {
            entryentityDOC = resouceReadyRuleDO.getDynamicObjectCollection("entryentity");
            ClacOrderNumber = resouceReadyRuleDO.getString("number");
        }
        if (entryentityDOC == null || entryentityDOC.isEmpty()) {
            return;
        }
        HashSet<Integer> clacOrderSet = new HashSet<Integer>(4);
        for (int i = 0; i < entryentityDOC.size(); ++i) {
            DynamicObject entryEntityDO = (DynamicObject)entryentityDOC.get(i);
            int seq = entryEntityDO.getInt("seq");
            int entryClacOrder = entryEntityDO.getInt("entrycalcorder");
            if (clacOrderSet.contains(entryClacOrder)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219%1$s\uff1a\u7b2c%2$s\u884c\u201c\u8ba1\u7b97\u987a\u5e8f\u201d%3$s\u91cd\u590d\u3002", (String)"ResourceReadyRuleVal_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), ClacOrderNumber, seq, entryClacOrder));
            } else {
                clacOrderSet.add(entryClacOrder);
            }
            String entryRuleType = entryEntityDO.getString("entryruletype");
            DynamicObject algoRegisterDO = entryEntityDO.getDynamicObject("entryalgoregister");
            String calculateText = entryEntityDO.getString("entrycalculatetext");
            if (StringUtils.equals((CharSequence)ResReadyRuleTypeEnum.CALCEXE.getValue(), (CharSequence)entryRuleType) && StringUtils.isEmpty((CharSequence)calculateText)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219%1$s\uff1a\u7b2c%2$s\u884c\u201c\u89c4\u5219\u7c7b\u578b\u201d\u4e3a%3$s\uff0c\u8bf7\u586b\u5199\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u3002", (String)"ResourceReadyRuleVal_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), ClacOrderNumber, seq, ResReadyRuleTypeEnum.CALCEXE.getName()));
                continue;
            }
            if (!StringUtils.equals((CharSequence)ResReadyRuleTypeEnum.REGIESTER.getValue(), (CharSequence)entryRuleType) || algoRegisterDO != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219%1$s\uff1a\u7b2c%2$s\u884c\u201c\u89c4\u5219\u7c7b\u578b\u201d\u4e3a%3$s\uff0c\u8bf7\u586b\u5199\u201c\u81ea\u5b9a\u4e49\u63d2\u4ef6\u201d\u3002", (String)"ResourceReadyRuleVal_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), ClacOrderNumber, seq, ResReadyRuleTypeEnum.REGIESTER.getName()));
        }
    }
}

