/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.opplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmbd.common.util.CommonUtils;
import kd.pmc.pmbd.common.util.TimeUtils;
import kd.pmc.pmbd.enums.WorkDateSetTypeEnum;
import kd.pmc.pmbd.enums.WorkDateTypeEnum;
import kd.pmc.pmbd.opplugin.ProjectCalendarOp;
import kd.pmc.pmbd.validator.ProjectCalendarSaveValidator;

public class ProjectCalendarSaveOp
extends ProjectCalendarOp {
    private static final String[] radioStrings = new String[]{"mondayradio", "tuesdayradio", "wednesdayradio", "thursdayradio", "fridayradio", "saturdayradio", "sundayradio"};

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentitytime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ProjectCalendarSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ArrayList<DynamicObject> exprObjs = new ArrayList<DynamicObject>(16);
        DynamicObject calendarObj = e.getDataEntities()[0];
        Map<Integer, String> dayTypes = this.getDayTypes(calendarObj, radioStrings);
        String strFormat = "yyyy-MM-dd";
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(TimeUtils.getDate((Date)new Date(), (String)strFormat));
        Date expirstartdate = calendarObj.getDate("expirstartdate");
        Calendar fromDate = Calendar.getInstance();
        fromDate.setTime(TimeUtils.getDate((Date)expirstartdate, (String)strFormat));
        Date expirendate = calendarObj.getDate("expirendate");
        Calendar toDate = Calendar.getInstance();
        toDate.setTime(TimeUtils.getDate((Date)expirendate, (String)strFormat));
        int days = TimeUtils.daysBetween((Calendar)fromDate, (Calendar)toDate);
        QFilter calendarexprFilter = new QFilter("pjcalendar", "=", calendarObj.getPkValue());
        DynamicObject[] calendarexprObjs = CommonUtils.getLoadData((String)"pmbd_calendarexpr", (QFilter[])calendarexprFilter.toArray());
        Map mapExprObj = CommonUtils.getMapDync((DynamicObject[])calendarexprObjs, (String[])new String[]{"workdate"});
        RequestContext rc = RequestContext.get();
        String creator = rc.getUserId();
        Date creatorDate = new Date();
        for (int i = 0; i < days; ++i) {
            Boolean submitFromList;
            DynamicObject exprObj = BusinessDataServiceHelper.newDynamicObject((String)"pmbd_calendarexpr");
            exprObj.set("pjcalendar", calendarObj.getPkValue());
            exprObj.set("workdate", (Object)fromDate.getTime());
            String mapkey = CommonUtils.getMapDyncKey((DynamicObject)exprObj, (String[])new String[]{"workdate"});
            DynamicObject exprObjLoad = (DynamicObject)mapExprObj.get(mapkey);
            String setType = WorkDateSetTypeEnum.SYS.getValue();
            if (StringUtils.isNotBlank((Object)exprObjLoad)) {
                setType = exprObjLoad.getString("settype");
            }
            String week = TimeUtils.dateToWeek((Date)fromDate.getTime());
            String dateType = WorkDateTypeEnum.WORK_DAY.getValue();
            if (dayTypes.get(3).contains(week)) {
                dateType = WorkDateTypeEnum.REST_DAY.getValue();
            } else if (dayTypes.get(1).contains(week)) {
                dateType = WorkDateTypeEnum.HALF_REST_DAY.getValue();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)setType, (CharSequence)WorkDateSetTypeEnum.HAND.getValue())) {
                dateType = exprObjLoad.getString("datetype");
            }
            if ((submitFromList = this.isSubmitFromList(calendarObj, dateType, e.getOperationKey())).booleanValue()) {
                return;
            }
            this.saveWorkTimeInfo(calendarObj, exprObj, dateType);
            exprObj.set("datetype", (Object)dateType);
            exprObj.set("settype", (Object)setType);
            exprObj.set("billstatus", (Object)"A");
            exprObj.set("creator", (Object)creator);
            exprObj.set("createtime", (Object)creatorDate);
            fromDate.add(5, 1);
            exprObjs.add(exprObj);
        }
        this.setDefCale(calendarObj);
        if (exprObjs.size() > 0) {
            DeleteServiceHelper.delete((String)"pmbd_calendarexpr", (QFilter[])calendarexprFilter.toArray());
            SaveServiceHelper.save((DynamicObject[])exprObjs.toArray(new DynamicObject[exprObjs.size()]));
        }
    }

    private Boolean isSubmitFromList(DynamicObject calendarObj, String dateType, String opr) {
        block3: {
            block2: {
                if (!StringUtils.equals((CharSequence)opr, (CharSequence)"submit") || !StringUtils.equals((CharSequence)dateType, (CharSequence)"1")) break block2;
                DynamicObjectCollection entryentity = calendarObj.getDynamicObjectCollection("entryentitytime");
                for (DynamicObject dynamicObject : entryentity) {
                    if (dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"workstarttime")) continue;
                    return true;
                }
                break block3;
            }
            if (!StringUtils.equals((CharSequence)opr, (CharSequence)"submit") || !StringUtils.equals((CharSequence)dateType, (CharSequence)"2")) break block3;
            DynamicObjectCollection halfentryentity = calendarObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : halfentryentity) {
                if (dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"halfworkstarttime")) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Integer, String> getDayTypes(DynamicObject obj, String[] dayStrings) {
        StringBuilder workallday = new StringBuilder();
        StringBuilder workhalfday = new StringBuilder();
        StringBuilder fixedrestday = new StringBuilder();
        for (int index = 0; index < dayStrings.length; ++index) {
            String flag = dayStrings[index];
            if (1 == obj.getInt(flag)) {
                workhalfday.append(flag);
                workhalfday.append(',');
                continue;
            }
            if (2 == obj.getInt(flag)) {
                workallday.append(flag);
                workhalfday.append(',');
                continue;
            }
            if (3 != obj.getInt(flag)) continue;
            fixedrestday.append(flag);
            workhalfday.append(',');
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, workhalfday.toString());
        map.put(2, workallday.toString());
        map.put(3, fixedrestday.toString());
        return map;
    }

    private void saveWorkTimeInfo(DynamicObject calendarObj, DynamicObject exprObj, String dateType) {
        DynamicObjectCollection worktimeentry = exprObj.getDynamicObjectCollection("worktimeentry");
        switch (dateType) {
            case "1": {
                DynamicObjectCollection entryentity = calendarObj.getDynamicObjectCollection("entryentitytime");
                for (DynamicObject dynamicObject : entryentity) {
                    DynamicObject addNew = worktimeentry.addNew();
                    addNew.set("workstarttime", dynamicObject.get("workstarttime"));
                    addNew.set("workfinshtime", dynamicObject.get("workfinshtime"));
                    addNew.set("halfworkstarttime", (Object)0);
                    addNew.set("halfworkfinshtime", (Object)0);
                }
                break;
            }
            case "2": {
                DynamicObjectCollection halfentryentity = calendarObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : halfentryentity) {
                    DynamicObject addNew = worktimeentry.addNew();
                    addNew.set("halfworkstarttime", dynamicObject.get("halfworkstarttime"));
                    addNew.set("halfworkfinshtime", dynamicObject.get("halfworkfinshtime"));
                    addNew.set("workstarttime", (Object)0);
                    addNew.set("workfinshtime", (Object)0);
                }
                break;
            }
        }
        exprObj.set("worktimeentry", (Object)worktimeentry);
    }
}

