/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.validator;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ProjectCalendarSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject dyncObj = extend.getDataEntity();
            boolean validateStartDateAndEndDate = this.validateStartDateAndEndDate(extend, dyncObj);
            if (!validateStartDateAndEndDate) {
                return;
            }
            DynamicObjectCollection worktimes = dyncObj.getDynamicObjectCollection("entryentitytime");
            DynamicObjectCollection halfworktimes = dyncObj.getDynamicObjectCollection("entryentity");
            if (worktimes.size() > 1 && worktimes.getDynamicObjectType().getProperties().containsKey((Object)"workstarttime") && worktimes.getDynamicObjectType().getProperties().containsKey((Object)"workfinshtime")) {
                String errWorkTimeStr = ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u6bb5\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"ProjectCalendarSaveValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]);
                this.validateTime(extend, errWorkTimeStr, worktimes, "workstarttime", "workfinshtime");
            }
            if (halfworktimes.size() <= 1 || !halfworktimes.getDynamicObjectType().getProperties().containsKey((Object)"halfworkstarttime") || !halfworktimes.getDynamicObjectType().getProperties().containsKey((Object)"halfworkfinshtime")) continue;
            String errHalfWorkTimeStr = ResManager.loadKDString((String)"\u534a\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u6bb5\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u534a\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"ProjectCalendarSaveValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]);
            this.validateTime(extend, errHalfWorkTimeStr, halfworktimes, "halfworkstarttime", "halfworkfinshtime");
        }
    }

    private Boolean isSubmitFromList(DynamicObjectCollection worktimes, DynamicObjectCollection halfworktimes) {
        if (worktimes.size() <= 1 || halfworktimes.size() <= 1) {
            return true;
        }
        DynamicObject worktime = (DynamicObject)worktimes.get(0);
        DynamicObject halfworktime = (DynamicObject)halfworktimes.get(0);
        if (!(worktime.getDynamicObjectType().getProperties().containsKey((Object)"workstarttime") && worktime.getDynamicObjectType().getProperties().containsKey((Object)"workfinshtime") && halfworktime.getDynamicObjectType().getProperties().containsKey((Object)"halfworkstarttime") && halfworktime.getDynamicObjectType().getProperties().containsKey((Object)"workfinshtime"))) {
            return true;
        }
        return false;
    }

    private boolean validateStartDateAndEndDate(ExtendedDataEntity extend, DynamicObject dyncObj) {
        Date expirendate;
        Date expirstartdate = dyncObj.getDate("expirstartdate");
        if (expirstartdate.compareTo(expirendate = dyncObj.getDate("expirendate")) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6709\u6548\u671f\uff0c\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u3002", (String)"ProjectCalendarSaveValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extend, errorMsg);
            return false;
        }
        return true;
    }

    private void validateTime(ExtendedDataEntity extend, String errStr, DynamicObjectCollection worktimes, String startTimeName, String endTimeName) {
        if (worktimes.size() <= 1) {
            return;
        }
        for (int index = 0; index < worktimes.size(); ++index) {
            DynamicObject worktime = (DynamicObject)worktimes.get(index);
            Integer halfworkstarttime = worktime.getInt(startTimeName);
            Integer halfworkfinshtime = worktime.getInt(endTimeName);
            for (int indexTwo = index + 1; indexTwo < worktimes.size(); ++indexTwo) {
                boolean fourth;
                DynamicObject worktimeTwo = (DynamicObject)worktimes.get(indexTwo);
                Integer halfworkstarttimeTwo = worktimeTwo.getInt(startTimeName);
                Integer halfworkfinshtimeTwo = worktimeTwo.getInt(endTimeName);
                boolean first = halfworkstarttime.compareTo(halfworkstarttimeTwo) > 0 && halfworkstarttime.compareTo(halfworkfinshtimeTwo) < 0;
                boolean sencond = halfworkfinshtime.compareTo(halfworkstarttimeTwo) > 0 && halfworkfinshtime.compareTo(halfworkfinshtimeTwo) < 0;
                boolean third = halfworkfinshtimeTwo.compareTo(halfworkstarttime) > 0 && halfworkfinshtimeTwo.compareTo(halfworkfinshtime) < 0;
                boolean bl = fourth = halfworkstarttimeTwo.compareTo(halfworkstarttime) > 0 && halfworkstarttimeTwo.compareTo(halfworkfinshtime) < 0;
                if (!first && !sencond && !third && !fourth && halfworkstarttime.compareTo(halfworkstarttimeTwo) != 0 && halfworkstarttime.compareTo(halfworkfinshtimeTwo) != 0 && halfworkfinshtime.compareTo(halfworkstarttimeTwo) != 0 && halfworkfinshtime.compareTo(halfworkfinshtimeTwo) != 0) continue;
                this.addErrorMessage(extend, errStr);
            }
        }
    }
}

