/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.project;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.form.MessageType;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.pmc.query.wbs.ProjectParamQueryHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectAutoPushAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog((String)ProjectAutoPushAuditOp.class.getName());
    public static final String BD_PROJECTPARAM = "bd_projectparam";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("pjtype");
        e.getFieldKeys().add("status");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        Map prjParamMap = ProjectParamQueryHelper.batchQueryByProjectDyn((DynamicObject[])entities, (String)"id,projectkind,autogenwbs");
        HashMap<Long, String> needAutoPushProjects = new HashMap<Long, String>(2);
        for (DynamicObject entity : entities) {
            DynamicObject projectParam;
            long projId = entity.getLong("id");
            if (!prjParamMap.containsKey(projId) || !(projectParam = (DynamicObject)prjParamMap.get(projId)).getBoolean("autogenwbs")) continue;
            String projectNumber = entity.getString("number");
            needAutoPushProjects.put(projId, projectNumber);
        }
        if (!needAutoPushProjects.isEmpty()) {
            this.filterPushedProjects(needAutoPushProjects);
            this.autoGenWbs(needAutoPushProjects);
        }
    }

    private void filterPushedProjects(Map<Long, String> needAutoPushProjects) {
        Map targetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"pmpd_project", (Long[])needAutoPushProjects.keySet().toArray(new Long[0]));
        needAutoPushProjects.entrySet().removeIf(t -> targetBills.containsKey(t.getKey()) && CollectionUtils.isNotEmpty((Collection)((Collection)targetBills.get(t.getKey()))));
    }

    private void autoGenWbs(Map<Long, String> needAutoPushProjects) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(needAutoPushProjects.size());
        for (Long pk : needAutoPushProjects.keySet()) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("pmpd_project");
        args.setTargetEntityNumber("pmts_wbs");
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)args);
        if (!result.isSuccess()) {
            StringBuilder error = new StringBuilder();
            String message = result.getMessage();
            if (StringUtils.isNotEmpty((String)message)) {
                error.append(message);
            }
            for (SourceBillReport billReport : result.getBillReports()) {
                if (billReport.isFullSuccess()) continue;
                error.append("\r\n");
                error.append(needAutoPushProjects.getOrDefault((Long)billReport.getBillId(), ""));
                error.append(":");
                error.append(billReport.getFailMessage());
            }
            OperationResult operationResult = this.getOperationResult();
            JSONObject params = new JSONObject();
            params.put("autopush_result", (Object)error.toString());
            operationResult.setMessage(params.toJSONString());
            operationResult.setMessageType(MessageType.Notice.getValue());
            operationResult.setShowMessage(Boolean.FALSE.booleanValue());
            logger.info((Object)String.format("ProjectAutoPushAuditOp-pushError:%s", error.toString()));
        }
    }
}

