/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.project;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.validator.project.ProjectChangeSaveValidator;

public class ProjectChangeSaveOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_PCLOG = "pmpd_pchangelog";
    private static final String PROJECT = "pmpd_project";
    private static final String STATUS_A = "A";
    private static final String STATUS_C = "C";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PDUNIT = "pdunit";
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String PJMANAGER = "pjmanager";
    private static final String PJSTAGE = "pjstage";
    private static final String PJMGLEVEL = "pjmglevel";
    private static final String RESBALLEVEL = "resballevel";
    private static final String EXPSTARTDATE = "expstartdate";
    private static final String EXPFINSHDATE = "expfinshdate";
    private static final String ESTPERIOD = "estperiod";
    private static final String PLANSTARTDATE = "planstartdate";
    private static final String PLANFINSHDATE = "planfinshdate";
    private static final String PLANPERIOD = "planperiod";
    private static final String REALSTARTDATE = "realstartdate";
    private static final String ACCOUNTORG = "accountorg";
    private static final String PJCALE = "pjcale";
    private static final String PURCHASEORG = "purchaseorg";
    private static final String SALEORG = "saleorg";
    private static final String PRODUCTORG = "productorg";
    private static final String QUALITYORG = "qualityorg";
    private static final String ASSETSORG = "assetsorg";
    private static final String CAPITALORG = "capitalorg";
    private static final String SHARECENTER = "sharecenter";
    private static final String HRORG = "hrorg";
    private static final String TAXORG = "taxorg";
    private static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String CHANGE_FIELDS = "pjstage,resballevel,pdunit,estperiod,planperiod,";
    private static final String CHANGE_DATES = "expstartdate,expfinshdate,planstartdate,planfinshdate,";
    private static final String SELECT_CHANGE_FIELDS = "name,pjmglevel,pjstage,resballevel,pdunit,expstartdate,expfinshdate,estperiod,planstartdate,planfinshdate,planperiod,group,pjmanager,pjcale,accountorg,purchaseorg,saleorg,productorg,qualityorg,assetsorg,capitalorg,sharecenter,hrorg,taxorg";
    private static final String SELECT_CHANGE_FIELDF7S = "group,pjmanager,pjcale,accountorg,purchaseorg,saleorg,productorg,qualityorg,assetsorg,capitalorg,sharecenter,hrorg,taxorg,";
    private static final Map<String, String> PJMGLEVELMAP = new HashMap<String, String>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add(NAME);
        e.getFieldKeys().add(PDUNIT);
        e.getFieldKeys().add(GROUP);
        e.getFieldKeys().add(PJMANAGER);
        e.getFieldKeys().add(PJSTAGE);
        e.getFieldKeys().add(PJMGLEVEL);
        e.getFieldKeys().add(RESBALLEVEL);
        e.getFieldKeys().add(EXPSTARTDATE);
        e.getFieldKeys().add(EXPFINSHDATE);
        e.getFieldKeys().add(ESTPERIOD);
        e.getFieldKeys().add(PLANPERIOD);
        e.getFieldKeys().add(PLANFINSHDATE);
        e.getFieldKeys().add(REALSTARTDATE);
        e.getFieldKeys().add(PLANSTARTDATE);
        e.getFieldKeys().add(ACCOUNTORG);
        e.getFieldKeys().add(PJCALE);
        e.getFieldKeys().add(HRORG);
        e.getFieldKeys().add(TAXORG);
        e.getFieldKeys().add(SHARECENTER);
        e.getFieldKeys().add(CAPITALORG);
        e.getFieldKeys().add(PURCHASEORG);
        e.getFieldKeys().add(SALEORG);
        e.getFieldKeys().add(PRODUCTORG);
        e.getFieldKeys().add(QUALITYORG);
        e.getFieldKeys().add(ASSETSORG);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProjectChangeSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            ArrayList<Long> projectChangeIds = new ArrayList<Long>(16);
            DynamicObject[] projectChangeBills = e.getDataEntities();
            ArrayList<DynamicObject> projectChangeLogList = new ArrayList<DynamicObject>(projectChangeBills.length);
            for (int i = 0; i < projectChangeBills.length; ++i) {
                DynamicObject projectChangeBill = projectChangeBills[i];
                String pcNumber = (String)projectChangeBill.get("number");
                DynamicObject projectChangeLogInfo = this.getProjectChangeLogInfo(projectChangeBill);
                projectChangeLogList.add(projectChangeLogInfo);
                DynamicObject projectChangeLInfo = QueryServiceHelper.queryOne((String)KEY_PCLOG, (String)"id", (QFilter[])new QFilter("pcnumber", "=", (Object)pcNumber).toArray());
                if (null == projectChangeLInfo) continue;
                long pchangelogid = projectChangeLInfo.getLong("id");
                projectChangeIds.add(pchangelogid);
            }
            if (projectChangeIds.size() > 0) {
                this.deleteProjectChangeLogByIds(projectChangeIds);
            }
            this.insertProjectChangeLogInfo(projectChangeLogList);
        }
    }

    private void insertProjectChangeLogInfo(List<DynamicObject> projectChangeLogList) {
        int size = projectChangeLogList.size();
        if (size > 0) {
            DynamicObject[] param = new DynamicObject[size];
            for (int i = 0; i < param.length; ++i) {
                param[i] = projectChangeLogList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])param);
        }
    }

    private DynamicObject getProjectChangeLogInfo(DynamicObject projectChangeBill) {
        DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_PCLOG);
        RequestContext rc = RequestContext.get();
        logObject.set("pnumber", (Object)projectChangeBill.getString("pnumber"));
        logObject.set("pname", (Object)projectChangeBill.getString(NAME));
        logObject.set("creator", (Object)rc.getCurrUserId());
        logObject.set("createtime", (Object)projectChangeBill.getDate("createtime"));
        logObject.set("pcnumber", (Object)projectChangeBill.getString("number"));
        logObject.set("reason", (Object)projectChangeBill.getString("reason"));
        logObject.set("status", (Object)STATUS_A);
        DynamicObjectCollection entrys = logObject.getDynamicObjectCollection(ENTRYENTITY);
        QFilter qFilter = new QFilter("number", "=", (Object)projectChangeBill.getString("pnumber"));
        qFilter.and("status", "=", (Object)STATUS_C);
        DynamicObject projectObjects = BusinessDataServiceHelper.loadSingle((String)PROJECT, (String)SELECT_CHANGE_FIELDS, (QFilter[])qFilter.toArray());
        if (null != projectObjects) {
            IDataEntityType dataEntityType = projectObjects.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                Object projectPropertyValue = null;
                Object changePropertyValue = null;
                if (property == null || property.getName() == null) continue;
                String propertyName = property.getName().toLowerCase();
                String name = property.getDisplayName() == null ? "" : property.getDisplayName().toString();
                boolean flag = false;
                if (NAME.equalsIgnoreCase(property.getName())) {
                    projectPropertyValue = ((OrmLocaleValue)projectObjects.get(propertyName)).getLocaleValue();
                    changePropertyValue = ((OrmLocaleValue)projectChangeBill.get(propertyName)).getLocaleValue();
                    flag = true;
                } else if (PJMGLEVEL.equalsIgnoreCase(property.getName())) {
                    projectPropertyValue = projectObjects.get(propertyName) == null ? null : PJMGLEVELMAP.get(projectObjects.get(propertyName));
                    changePropertyValue = projectChangeBill.get(propertyName) == null ? null : PJMGLEVELMAP.get(projectChangeBill.get(propertyName));
                    flag = true;
                } else if (CHANGE_FIELDS.contains(property.getName().toLowerCase() + ",")) {
                    projectPropertyValue = projectObjects.get(propertyName);
                    changePropertyValue = projectChangeBill.get(propertyName);
                    flag = true;
                } else if (SELECT_CHANGE_FIELDF7S.contains(property.getName().toLowerCase() + ",")) {
                    projectPropertyValue = projectObjects.get(propertyName);
                    changePropertyValue = projectChangeBill.get(propertyName);
                    projectPropertyValue = projectPropertyValue == null ? null : ((DynamicObject)projectPropertyValue).get(NAME);
                    changePropertyValue = changePropertyValue == null ? null : ((DynamicObject)changePropertyValue).get(NAME);
                    flag = true;
                } else if (CHANGE_DATES.contains(property.getName().toLowerCase() + ",")) {
                    projectPropertyValue = projectObjects.get(propertyName);
                    changePropertyValue = projectChangeBill.get(propertyName);
                    projectPropertyValue = this.formatDate((Date)projectPropertyValue);
                    changePropertyValue = this.formatDate((Date)changePropertyValue);
                    flag = true;
                }
                projectPropertyValue = projectPropertyValue == null ? " " : projectPropertyValue;
                Object object = changePropertyValue = changePropertyValue == null ? " " : changePropertyValue;
                if (!flag || changePropertyValue.equals(projectPropertyValue)) continue;
                DynamicObject entry = entrys.addNew();
                entry.set("pfield", (Object)name);
                entry.set("changebefore", projectPropertyValue);
                entry.set("changeafter", changePropertyValue);
            }
        }
        logObject.set(ENTRYENTITY, (Object)entrys);
        return logObject;
    }

    private void deleteProjectChangeLogByIds(List<Long> projectChangeIds) {
        QFilter mftOrderLogFilter = new QFilter("id", "in", projectChangeIds);
        DeleteServiceHelper.delete((String)KEY_PCLOG, (QFilter[])mftOrderLogFilter.toArray());
    }

    private String formatDate(Date date) {
        if (date == null) {
            return " ";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        String dateStr = sdf.format(date);
        return dateStr;
    }

    static {
        PJMGLEVELMAP.put("100", STATUS_A);
        PJMGLEVELMAP.put("99", "B");
        PJMGLEVELMAP.put("98", STATUS_C);
        PJMGLEVELMAP.put("97", "D");
        PJMGLEVELMAP.put("96", "E");
    }
}

