/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.project;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmbd.common.util.CommonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog((String)"name");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("isbdproject");
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("pjmanager");
        e.getFieldKeys().add("jobcodepreincre");
        e.getFieldKeys().add("jobcodeprefix");
        e.getFieldKeys().add("pjcale");
        e.getFieldKeys().add("pjcale.expirstartdate");
        e.getFieldKeys().add("pjcale.expirendate");
        e.getFieldKeys().add("isbdproject");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        block12: for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "save": {
                    this.beforeExecuteOperationSave(e, obj);
                    continue block12;
                }
                case "submit": {
                    this.beforeExecuteOperationSubmit(e, obj);
                    continue block12;
                }
                case "unaudit": {
                    this.beforeExecuteOperationUnAudit(e, obj);
                    continue block12;
                }
                case "delete": {
                    this.beforeExecuteOperationDelete(e, obj);
                    continue block12;
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    protected void setProjectManagerQty(String oprKey, DynamicObject[] entitiys) {
        List<Long> pjmanagerIDs = this.getProjectManagerID(oprKey, entitiys);
        if (pjmanagerIDs.size() <= 0) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_asspjmginfo");
        DynamicObject[] pjmanagers = BusinessDataServiceHelper.load((Object[])pjmanagerIDs.toArray(), (DynamicObjectType)entityType);
        for (DynamicObject entitiy : entitiys) {
            DynamicObject pjmgUser = entitiy.getDynamicObject("pjmanager");
            Long pjmanagerID = StringUtils.isBlank((Object)pjmgUser) ? Long.valueOf(0L) : Long.valueOf(String.valueOf(pjmgUser.getPkValue()));
            DynamicObject pjmanager = CommonUtils.getDyncObj((DynamicObject[])pjmanagers, (Long)pjmanagerID);
            if (StringUtils.isBlank((Object)pjmanager)) continue;
            BigDecimal pjqty = pjmanager.getBigDecimal("pjqty");
            if (pjqty == null) {
                pjqty = BigDecimal.ZERO;
            }
            switch (oprKey) {
                case "audit": {
                    pjqty = pjqty.add(BigDecimal.ONE);
                    break;
                }
                case "unaudit": {
                    pjqty = pjqty.subtract(BigDecimal.ONE);
                    break;
                }
            }
            if (pjqty.compareTo(BigDecimal.ZERO) < 0) {
                pjqty = BigDecimal.ZERO;
            }
            pjmanager.set("pjqty", (Object)pjqty);
        }
        SaveServiceHelper.update((DynamicObject[])pjmanagers);
    }

    private List<Long> getProjectManagerID(String oprKey, DynamicObject[] entitiys) {
        ArrayList<Long> pjmanagerIDs = new ArrayList<Long>();
        for (DynamicObject entitiy : entitiys) {
            DynamicObject pjmgUser = entitiy.getDynamicObject("pjmanager");
            Long pjmanagerID = StringUtils.isBlank((Object)pjmgUser) ? Long.valueOf(0L) : Long.valueOf(String.valueOf(pjmgUser.getPkValue()));
            String billstatus = entitiy.getString("status");
            if (StringUtils.isBlank((Object)pjmanagerID) && pjmanagerID <= 0L || (!oprKey.equals("audit") || !billstatus.equals("C")) && (!oprKey.equals("unaudit") || !billstatus.equals("A"))) continue;
            pjmanagerIDs.add(pjmanagerID);
        }
        return pjmanagerIDs;
    }

    private void beforeExecuteOperationSubmit(BeforeOperationArgs e, DynamicObject obj) {
        this.updateParentPro(obj);
    }

    private void beforeExecuteOperationSave(BeforeOperationArgs e, DynamicObject obj) {
        this.updateParentPro(obj);
    }

    private void beforeExecuteOperationUnAudit(BeforeOperationArgs e, DynamicObject obj) {
        this.validateBeforeUnAudit(e, obj);
    }

    private boolean validateBeforeUnAudit(BeforeOperationArgs e, DynamicObject obj) {
        boolean validateBeforeUnAudit = true;
        QFilter qFilter = new QFilter("parent", "=", obj.getPkValue());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (load.length > 0) {
            String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\u3002\u5b50\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectOp_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), obj.getString("name"));
            e.setCancelMessage(formatText);
            e.cancel = true;
            validateBeforeUnAudit = false;
        }
        return validateBeforeUnAudit;
    }

    private void beforeExecuteOperationDelete(BeforeOperationArgs e, DynamicObject obj) {
        Boolean valide = this.validateBeforeDelete(e, obj);
        if (!valide.booleanValue()) {
            return;
        }
        DynamicObject parent = (DynamicObject)obj.get("parent");
        if (parent != null) {
            QFilter qFilter = new QFilter("parent", "=", parent.getPkValue());
            qFilter.and(new QFilter("id", "!=", obj.getPkValue()));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id,parent", (QFilter[])new QFilter[]{qFilter});
            if (load.length <= 0) {
                DynamicObject parentPro = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmpd_project");
                parentPro.set("isleaf", (Object)1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentPro});
            }
        }
    }

    private boolean validateBeforeDelete(BeforeOperationArgs e, DynamicObject obj) {
        boolean f = true;
        QFilter qFilter = new QFilter("parent", "=", obj.getPkValue());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (load.length > 0) {
            String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\u3002\u5b50\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ProjectOp_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), obj.getString("name"));
            e.setCancelMessage(formatText);
            e.cancel = true;
            f = false;
        }
        return f;
    }

    protected Boolean isSync() {
        String issyncStr = this.getOption().getVariableValue("issync", "false");
        Boolean issync = Boolean.valueOf(issyncStr);
        return issync;
    }

    private void syncProjectBill(BeginOperationTransactionArgs e) {
    }

    private void updateParentPro(DynamicObject obj) {
        DynamicObject parent = (DynamicObject)obj.get("parent");
        if (parent == null) {
            boolean isleaf = obj.getBoolean("isleaf");
            if (!isleaf) {
                obj.set("isleaf", (Object)1);
            }
            return;
        }
        Object pkValue = parent.getPkValue();
        boolean exists = QueryServiceHelper.exists((String)"pmpd_project", (Object)Long.parseLong(pkValue.toString()));
        if (exists) {
            boolean aBoolean;
            DynamicObject parentPro = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmpd_project");
            if (parentPro != null && (aBoolean = parentPro.getBoolean("isleaf"))) {
                parentPro.set("isleaf", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentPro});
            }
        } else {
            boolean isleaf = obj.getBoolean("isleaf");
            if (!isleaf) {
                obj.set("isleaf", (Object)1);
            }
        }
    }
}

