/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.project;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProjectUpdateTimeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ProjectUpdateTimeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity_hour.basichour");
        e.getFieldKeys().add("entryentity_hour.nrchour");
        e.getFieldKeys().add("entryentity_hour.skillhour");
        e.getFieldKeys().add("entryentity_hour.noskillhour");
        e.getFieldKeys().add("entryentity_hour.totalhour");
        e.getFieldKeys().add("entryentity_hour.hourtype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] projects = e.getDataEntities();
        ArrayList<Long> projectIds = new ArrayList<Long>(projects.length);
        for (DynamicObject project : projects) {
            projectIds.add((Long)project.getPkValue());
        }
        Map<Long, Map<String, BigDecimal>> result = this.handleResult(projectIds);
        logger.info("--ProjectUpdateTimeOp--" + result);
        for (DynamicObject project : projects) {
            long projectId = (Long)project.getPkValue();
            Map<String, BigDecimal> hourMap = result.get(projectId);
            DynamicObjectCollection entryentity_hour = project.getDynamicObjectCollection("entryentity_hour");
            if (entryentity_hour.size() == 0) continue;
            DynamicObject predictEntry = (DynamicObject)entryentity_hour.get(0);
            predictEntry.set("basichour", (Object)hourMap.get("otherPredict"));
            predictEntry.set("nrchour", (Object)hourMap.get("nrcPredict"));
            predictEntry.set("skillhour", (Object)hourMap.get("skillPredict"));
            predictEntry.set("noskillhour", (Object)hourMap.get("noSkillPredict"));
            predictEntry.set("totalhour", (Object)hourMap.get("otherPredict").add(hourMap.get("nrcPredict")));
            DynamicObject actualEntry = (DynamicObject)entryentity_hour.get(1);
            actualEntry.set("basichour", (Object)hourMap.get("otherActual"));
            actualEntry.set("nrchour", (Object)hourMap.get("nrcActual"));
            actualEntry.set("skillhour", (Object)hourMap.get("skillActual"));
            actualEntry.set("noskillhour", (Object)hourMap.get("noSkillActual"));
            actualEntry.set("totalhour", (Object)hourMap.get("otherActual").add(hourMap.get("nrcActual")));
            DynamicObject effectiveEntry = (DynamicObject)entryentity_hour.get(2);
            effectiveEntry.set("basichour", (Object)hourMap.get("otherEffect"));
            effectiveEntry.set("nrchour", (Object)hourMap.get("nrcEffect"));
            effectiveEntry.set("skillhour", (Object)hourMap.get("skillEffect"));
            effectiveEntry.set("noskillhour", (Object)hourMap.get("noSkillEffect"));
            effectiveEntry.set("totalhour", (Object)hourMap.get("nrcEffect").add(hourMap.get("otherEffect")));
        }
        SaveServiceHelper.save((DynamicObject[])projects);
    }

    private Map<Long, Map<String, BigDecimal>> handleResult(List<Long> projectIds) {
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>(projectIds.size());
        Map<Long, BigDecimal> nrcActual = this.invokeService(projectIds, true, "1");
        Map<Long, BigDecimal> otherActual = this.invokeService(projectIds, false, "1");
        Map<Long, BigDecimal> skillActual = this.invokeSkillService(projectIds, true, "1");
        Map<Long, BigDecimal> noSkillActual = this.invokeSkillService(projectIds, false, "1");
        Map<Long, BigDecimal> nrcEffect = this.invokeService(projectIds, true, "2");
        Map<Long, BigDecimal> otherEffect = this.invokeService(projectIds, false, "2");
        Map<Long, BigDecimal> skillEffect = this.invokeSkillService(projectIds, true, "2");
        Map<Long, BigDecimal> noSkillEffect = this.invokeSkillService(projectIds, false, "2");
        Map<Long, BigDecimal> nrcPredict = this.invokeService(projectIds, true, "3");
        Map<Long, BigDecimal> otherPredict = this.invokeService(projectIds, false, "3");
        Map<Long, BigDecimal> skillPredict = this.invokeSkillService(projectIds, true, "3");
        Map<Long, BigDecimal> noSkillPredict = this.invokeSkillService(projectIds, false, "3");
        for (long projectId : projectIds) {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(12);
            map.put("nrcActual", nrcActual.get(projectId) == null ? BigDecimal.ZERO : nrcActual.get(projectId));
            map.put("otherActual", otherActual.get(projectId) == null ? BigDecimal.ZERO : otherActual.get(projectId));
            map.put("skillActual", skillActual.get(projectId) == null ? BigDecimal.ZERO : skillActual.get(projectId));
            map.put("noSkillActual", noSkillActual.get(projectId) == null ? BigDecimal.ZERO : noSkillActual.get(projectId));
            map.put("nrcEffect", nrcEffect.get(projectId) == null ? BigDecimal.ZERO : nrcEffect.get(projectId));
            map.put("otherEffect", otherEffect.get(projectId) == null ? BigDecimal.ZERO : otherEffect.get(projectId));
            map.put("skillEffect", skillEffect.get(projectId) == null ? BigDecimal.ZERO : skillEffect.get(projectId));
            map.put("noSkillEffect", noSkillEffect.get(projectId) == null ? BigDecimal.ZERO : noSkillEffect.get(projectId));
            map.put("nrcPredict", nrcPredict.get(projectId) == null ? BigDecimal.ZERO : nrcPredict.get(projectId));
            map.put("otherPredict", otherPredict.get(projectId) == null ? BigDecimal.ZERO : otherPredict.get(projectId));
            map.put("skillPredict", skillPredict.get(projectId) == null ? BigDecimal.ZERO : skillPredict.get(projectId));
            map.put("noSkillPredict", noSkillPredict.get(projectId) == null ? BigDecimal.ZERO : noSkillPredict.get(projectId));
            result.put(projectId, map);
        }
        return result;
    }

    private Map<Long, BigDecimal> invokeService(List<Long> projectIds, boolean isNrcJob, String hourType) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MroReportProjectHourCountService", (String)"queryMroProjectHourData", (Object[])new Object[]{projectIds, isNrcJob, hourType});
            logger.info("--MroReportProjectHourCountService->queryMroProjectHourData--" + result);
            for (Map.Entry entry : result.entrySet()) {
                Map value = (Map)entry.getValue();
                BigDecimal total = BigDecimal.ZERO;
                for (BigDecimal e : value.values()) {
                    if (e == null) continue;
                    total = total.add(e);
                }
                map.put((Long)entry.getKey(), total);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(new ErrorCode("ProjectUpdateTimeOp", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7edf\u8ba1\u5de5\u65f6\u63a5\u53e3[MroReportProjectHourCountService->queryMroProjectHourData]\u5931\u8d25:%1$s", (String)"ProjectUpdateTimeOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), e.getMessage() != null ? e.getMessage() : e.toString())), new Object[]{e});
        }
        return map;
    }

    private Map<Long, BigDecimal> invokeSkillService(List<Long> projectIds, boolean isSkill, String hourType) {
        HashMap<Long, BigDecimal> map = new HashMap();
        try {
            map = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MroReportProjectHourCountService", (String)"queryMroProjectSkillHourData", (Object[])new Object[]{projectIds, isSkill, hourType});
            logger.info("--MroReportProjectHourCountService->queryMroProjectSkillHourData--" + map);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(new ErrorCode("ProjectUpdateTimeOp", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7edf\u8ba1\u5de5\u65f6\u63a5\u53e3[MroReportProjectHourCountService->queryMroProjectHourData]\u5931\u8d25:%1$s", (String)"ProjectUpdateTimeOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), e.getMessage() != null ? e.getMessage() : e.toString())), new Object[]{e});
        }
        return map;
    }
}

