/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.validator.project;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmbd.common.util.TimeUtils;
import kd.pmc.pmpd.validator.project.ProjectValidator;

public class ProjectSaveValidator
extends ProjectValidator {
    @Override
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            this.validateBill(extend);
        }
    }

    private void validateBill(ExtendedDataEntity extend) {
        DynamicObject dyncObj = extend.getDataEntity();
        this.validNumber(extend, dyncObj);
        this.validDate(extend, dyncObj);
        this.validProjectCalendar(extend);
    }

    private void validProjectCalendar(ExtendedDataEntity extend) {
        DynamicObject dyncObj = extend.getDataEntity();
        String number = dyncObj.getString("number");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Date planstartdate = dyncObj.getDate("planstartdate");
        if (planstartdate == null) {
            return;
        }
        Date planenddate = dyncObj.getDate("planfinshdate");
        if (planenddate == null) {
            return;
        }
        DynamicObject pjcale = dyncObj.getDynamicObject("pjcale");
        if (pjcale == null) {
            return;
        }
        Date expirstartdate = pjcale.getDate("expirstartdate");
        if (expirstartdate == null) {
            return;
        }
        Date expirenddata = pjcale.getDate("expirendate");
        if (expirenddata == null) {
            return;
        }
        try {
            planstartdate = sdf1.parse(sdf1.format(planstartdate));
            planenddate = sdf1.parse(sdf1.format(planenddate));
            expirstartdate = sdf1.parse(sdf1.format(expirstartdate));
            expirenddata = sdf1.parse(sdf1.format(expirenddata));
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5931\u8d25", (String)"ProjectSaveValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
        if (planstartdate == null || planenddate == null || planstartdate.compareTo(expirstartdate) < 0 || planenddate.compareTo(expirenddata) > 0) {
            this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\u201c%s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u548c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u4e0d\u7b26\u5408\u9879\u76ee\u65e5\u5386\u8303\u56f4\u3002", (String)"ProjectSaveValidator_10", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number));
        }
    }

    private void validNumber(ExtendedDataEntity extend, DynamicObject dyncObj) {
        QFilter dbQfilter;
        DynamicObjectCollection sysProjects;
        Long pkVal = StringUtils.isBlank((Object)dyncObj.getPkValue()) ? Long.valueOf(0L) : Long.valueOf(String.valueOf(dyncObj.getPkValue()));
        String number = dyncObj.getString("number");
        String sysNumber = "";
        DynamicObject project = null;
        if (StringUtils.isBlank((CharSequence)number)) {
            this.addErrorMessage(extend, ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectSaveValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            return;
        }
        if (pkVal > 0L) {
            project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)pkVal).toArray());
        }
        if (project != null) {
            sysNumber = project.getString("number");
        }
        if ((pkVal == 0L || project == null || pkVal > 0L && !StringUtils.equalsIgnoreCase((CharSequence)number, (CharSequence)sysNumber)) && (sysProjects = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])(dbQfilter = new QFilter("number", "=", (Object)number)).toArray())).size() > 0) {
            this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"ProjectSaveValidator_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), number));
        }
    }

    private void validDate(ExtendedDataEntity extend, DynamicObject dyncObj) {
        Date expfinshdate;
        Date expstartdate = dyncObj.getDate("expstartdate");
        String errStr = TimeUtils.getDateError((Date)expstartdate, (Date)(expfinshdate = dyncObj.getDate("expfinshdate")), (String)ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u671f", (String)"ProjectSaveValidator_11", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f", (String)"ProjectSaveValidator_12", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        if (errStr.length() > 0) {
            this.addErrorMessage(extend, errStr);
        }
    }
}

