/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmc.pmts.business.helper.TaskInvokeOperationHelper;

public class TaskAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("responsorg");
        e.getFieldKeys().add("taskstatus");
        e.getFieldKeys().add("plantime");
        e.getFieldKeys().add("tasktype");
        e.getFieldKeys().add("percenttype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskAuditValidator());
    }

    static class TaskAuditValidator
    extends AbstractValidator {
        TaskAuditValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject dyncObj = extend.getDataEntity();
                if (!StringUtils.isNotBlank((Object)dyncObj.get("taskstatus"))) {
                    this.addErrorMessage(extend, TaskInvokeOperationHelper.propIsNull((DynamicObject)dyncObj, (String)"taskstatus"));
                }
                if (dyncObj.getBigDecimal("plantime").compareTo(BigDecimal.ZERO) == 0) {
                    // empty if block
                }
                if (StringUtils.isNotBlank((Object)dyncObj.get("percenttype"))) continue;
                this.addErrorMessage(extend, TaskInvokeOperationHelper.propIsNull((DynamicObject)dyncObj, (String)"percenttype"));
            }
        }
    }
}

