/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;
import kd.pmc.pmts.common.util.BindOrderUtils;
import org.apache.commons.lang.StringUtils;

public class TaskDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("prepositiontaskentry.prepositiontask");
        e.getFieldKeys().add("postpositiontaskentry.postpositiontask");
        e.getFieldKeys().add("prepositiontaskentry.taskrelation");
        e.getFieldKeys().add("postpositiontaskentry.taskrelationtwo");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] tasks = e.getDataEntities();
        ArrayList<String> targetIds = new ArrayList<String>(8);
        for (DynamicObject task : tasks) {
            targetIds.add(task.getPkValue().toString());
            DynamicObjectCollection prepositiontaskentry = task.getDynamicObjectCollection("prepositiontaskentry");
            this.deleteTaskRalation(prepositiontaskentry, task.getPkValue().toString(), "prepositiontask");
            DynamicObjectCollection postpositiontaskentry = task.getDynamicObjectCollection("postpositiontaskentry");
            this.deleteTaskRalation(postpositiontaskentry, task.getPkValue().toString(), "postpositiontask");
        }
        BindOrderUtils.deleteTargetBillRelations(targetIds, null);
        List ids = Stream.of(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ProjectPlanTypeHelper.projectPlanTypeTaskDelete(ids);
    }

    private void deleteTaskRalation(DynamicObjectCollection taskentrys, String id, String positiontaskname) {
        for (DynamicObject object : taskentrys) {
            DynamicObject prepositiontask = object.getDynamicObject(positiontaskname);
            this.deleteEntryData(prepositiontask.getDynamicObjectCollection("prepositiontaskentry"), "prepositiontask", id, "t_pmts_pre_task");
            this.deleteEntryData(prepositiontask.getDynamicObjectCollection("postpositiontaskentry"), "postpositiontask", id, "t_pmts_post_task");
        }
    }

    private void deleteEntryData(DynamicObjectCollection taskentrys, String positiontaskname, String id, String tableName) {
        for (DynamicObject object : taskentrys) {
            boolean idEqual;
            DynamicObject positiontask = object.getDynamicObject(positiontaskname);
            if (positiontask == null || !(idEqual = StringUtils.equals((String)positiontask.getString("id"), (String)id))) continue;
            this.executeDelete(object, tableName);
            break;
        }
    }

    private void executeDelete(DynamicObject object, String tableName) {
        DBRoute dbRoute = DBRoute.of((String)object.getDataEntityType().getDBRouteKey());
        String sql = String.format("delete from %s  where fentryid=?", tableName);
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{object.get(0)});
    }
}

