/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.util.Calendar;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TaskReStartOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("executestatus");
        e.getFieldKeys().add("actualenddate");
        e.getFieldKeys().add("stoptask_entry");
        e.getFieldKeys().add("stoptask_entry.restarttime");
        e.getFieldKeys().add("stoptask_entry.stoptime");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject task = objs[i];
            task.set("executestatus", (Object)"2");
            task.set("actualenddate", null);
            DynamicObjectCollection stopentrys = task.getDynamicObjectCollection("stoptask_entry");
            stopentrys.removeIf(entry -> Objects.isNull(entry.get("stoptime")));
            if (stopentrys.size() > 1) {
                stopentrys.sort((o1, o2) -> o2.getDate("stoptime").compareTo(o1.getDate("stoptime")));
            }
            DynamicObject stopentry = (DynamicObject)stopentrys.get(0);
            Calendar calendar = Calendar.getInstance();
            stopentry.set("restarttime", (Object)calendar.getTime());
        }
        SaveServiceHelper.update((DynamicObject[])objs);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskReStartOpValidator());
    }

    static class TaskReStartOpValidator
    extends AbstractValidator {
        TaskReStartOpValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject dyncObj = extend.getDataEntity();
                if (!StringUtils.equals((CharSequence)dyncObj.getString("executestatus"), (CharSequence)"3")) {
                    this.addErrorMessage(extend, ResManager.loadKDString((String)"\u6267\u884c\u72b6\u6001\u4e0d\u4e3a\u5df2\u505c\u5de5\uff0c\u65e0\u6cd5\u590d\u5de5\u3002", (String)"TaskReStartOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!dyncObj.getDynamicObjectCollection("stoptask_entry").isEmpty()) continue;
                this.addErrorMessage(extend, ResManager.loadKDString((String)"\u5386\u53f2\u505c\u5de5\u65e0\u8bb0\u5f55\uff0c\u65e0\u6cd5\u6267\u884c\u590d\u5de5\u64cd\u4f5c\u3002", (String)"TaskReStartOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

