/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.business.helper.TaskSaveStageServiceHelper;

public class TaskSaveAndSubmitValidateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("projectstage");
        e.getFieldKeys().add("scheduletype");
        e.getFieldKeys().add("projectnum");
        e.getFieldKeys().add("planstartdate");
        e.getFieldKeys().add("planenddate");
        e.getFieldKeys().add("abnormal");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskSaveAndSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        boolean hasAbnormal = this.getOption().tryGetVariableValue("hasAbnormal", new RefObject());
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity.set("abnormal", (Object)hasAbnormal);
        }
    }

    private String projectStageCompareDate(DynamicObject dynObj, String operateKey) {
        DynamicObjectCollection projectStages = dynObj.getDynamicObjectCollection("projectstage");
        String scheduleType = dynObj.getString("scheduletype");
        if (!(projectStages.isEmpty() || "3".equals(scheduleType) || "4".equals(scheduleType))) {
            HashSet<Long> projectStageId = new HashSet<Long>(projectStages.size());
            for (DynamicObject projectStage : projectStages) {
                projectStageId.add(projectStage.getLong("fbasedataid.masterid"));
            }
            DynamicObject project = dynObj.getDynamicObject("projectnum");
            Date startDate = dynObj.getDate("planstartdate");
            Date endDate = dynObj.getDate("planenddate");
            ArrayList taskList = new ArrayList(1);
            HashMap<String, Object> task = new HashMap<String, Object>(3);
            task.put("id", 1L);
            task.put("projectstage", projectStageId);
            task.put("planstartdate", startDate);
            task.put("planenddate", endDate);
            task.put("op", operateKey);
            taskList.add(task);
            Map errorSb = TaskSaveStageServiceHelper.getTaskProjectStageMsg((Long)project.getLong("id"), taskList);
            if (!errorSb.isEmpty()) {
                return (String)errorSb.entrySet().iterator().next().getValue();
            }
        }
        return null;
    }

    class TaskSaveAndSubmitValidator
    extends AbstractValidator {
        TaskSaveAndSubmitValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extend : this.getDataEntities()) {
                String vaildateMsg;
                String releaseStatus;
                DynamicObject dynObj = extend.getDataEntity();
                DynamicObject task = QueryServiceHelper.queryOne((String)"pmts_task", (String)"releasestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", dynObj.getPkValue())});
                if (task != null && StringUtils.equals((CharSequence)(releaseStatus = task.getString("releasestatus")), (CharSequence)"1")) {
                    this.addWarningMessage(extend, ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u4efb\u52a1\u4e0d\u80fd%s\u3002", (String)"TaskSaveAndSubmitValidateOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[]{this.getOperationName()}));
                }
                if (!StringUtils.isNotBlank((CharSequence)(vaildateMsg = TaskSaveAndSubmitValidateOp.this.projectStageCompareDate(dynObj, this.getOperateKey())))) continue;
                this.addWarningMessage(extend, vaildateMsg);
                this.getOption().setVariableValue("hasAbnormal", "true");
            }
        }
    }
}

