/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.DateUtil;

public class TaskStartOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("executestatus");
        e.getFieldKeys().add("actualstartdate");
        e.getFieldKeys().add("plantime");
        e.getFieldKeys().add("finishpercent");
        e.getFieldKeys().add("actualdate");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Calendar c = Calendar.getInstance();
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject task = objs[i];
            if (Objects.isNull(task.get("actualstartdate"))) {
                task.set("actualstartdate", (Object)System.currentTimeMillis());
            }
            task.set("executestatus", (Object)"2");
            Date starttime = c.getTime();
            task.set("actualstartdate", (Object)starttime);
            BigDecimal plantime = task.getBigDecimal("plantime");
            BigDecimal finishpercent = task.getBigDecimal("finishpercent");
            finishpercent = finishpercent.divide(new BigDecimal(100));
            if (!Objects.nonNull(plantime) || !Objects.nonNull(finishpercent) || finishpercent.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal actualtime = plantime.multiply(finishpercent);
            Double seconds = actualtime.doubleValue() * 24.0 * 60.0 * 60.0;
            Date actualEndDate = DateUtil.addSecond((Date)starttime, (long)seconds.longValue());
            task.set("actualdate", (Object)actualEndDate);
        }
        SaveServiceHelper.update((DynamicObject[])objs);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskStartOpValidator());
    }

    static class TaskStartOpValidator
    extends AbstractValidator {
        TaskStartOpValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject dyncObj = extend.getDataEntity();
                if (StringUtils.equals((CharSequence)dyncObj.getString("executestatus"), (CharSequence)"5")) continue;
                this.addErrorMessage(extend, ResManager.loadKDString((String)"\u6267\u884c\u72b6\u6001\u4e0d\u4e3a\u5df2\u4e0b\u8fbe\uff0c\u65e0\u6cd5\u5f00\u59cb\u3002", (String)"TaskStartOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

