/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;

public class TaskSubsectionOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskSubsectionValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dynamicObject = e.getDataEntities()[0];
        DynamicObject taskObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getLong("id"), (String)"pmts_task");
        PmtsTaskValueHelper.startCalTaskDateDalayed((DynamicObject)taskObject, (String)this.operateOption.getVariableValue("pageId"));
        DynamicObjectCollection prepositiontaskentry = taskObject.getDynamicObjectCollection("prepositiontaskentry");
        if (!CollectionUtils.isEmpty((Collection)prepositiontaskentry)) {
            PmtsTaskValueHelper.setTaskCollection((DynamicObjectCollection)prepositiontaskentry, (DynamicObject)taskObject);
            SaveServiceHelper.update((DynamicObject)taskObject);
        }
    }

    static class TaskSubsectionValidator
    extends AbstractValidator {
        TaskSubsectionValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                BigDecimal plantime = dataEntity.getBigDecimal("plantime");
                if (plantime.compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u65e0\u5de5\u671f\u4efb\u52a1\u65e0\u9700\u62c6\u5206\u3002", (String)"TaskSubsectionOp_7", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (dataEntity.getDate("planstartdate") == null || dataEntity.getDate("planenddate") == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u6216\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62c6\u5206\u3002", (String)"TaskSubsectionOp_8", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal finishpercent = dataEntity.getBigDecimal("finishpercent");
                if (finishpercent.compareTo(new BigDecimal(100)) == 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u5b9e\u9645\u5b8c\u6210\u8fdb\u5ea6\u5df2\u8fbe100%\uff0c\u65e0\u9700\u62c6\u5206\u3002", (String)"TaskSubsectionOp_9", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("subsectionentry");
                if (collection == null) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                BigDecimal timeLong = BigDecimal.ZERO;
                if (collection != null && collection.size() == 1) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u81f3\u5c11\u8f93\u5165\u4e24\u6761\u5206\u6bb5\u3002", (String)"TaskSubsectionOp_6", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                int collectionSize = collection.size();
                for (int i = 0; i < collectionSize; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                    int seq = i + 1;
                    Date startTime = dynamicObject.getDate("subplanstartdate");
                    Date endTime = dynamicObject.getDate("subsubplanenddate");
                    timeLong = timeLong.add(dynamicObject.getBigDecimal("subplantime"));
                    if (startTime == null || endTime == null) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u6216\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u4e3a\u7a7a\u3002", (String)"TaskSubsectionOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), seq));
                        continue;
                    }
                    if (startTime.compareTo(endTime) >= 0) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"TaskSubsectionOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), seq));
                    }
                    String prefix = String.format(ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u7b2c%d\u884c, \u5b58\u5728\u91cd\u53e0\u7684\u8ba1\u5212\u65f6\u95f4\uff1a", (String)"TaskSubsectionOp_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), seq);
                    sb.append(prefix);
                    for (int j = 0; j < collectionSize; ++j) {
                        boolean isOverlap;
                        if (i == j) continue;
                        DynamicObject comparedDynamicObject = (DynamicObject)collection.get(j);
                        Date sectionStartTime = comparedDynamicObject.getDate("subplanstartdate");
                        Date sectionEndTime = comparedDynamicObject.getDate("subsubplanenddate");
                        if (sectionStartTime == null || sectionEndTime == null) continue;
                        boolean bl = isOverlap = startTime.compareTo(sectionStartTime) >= 0 && startTime.compareTo(sectionEndTime) <= 0 || endTime.compareTo(sectionStartTime) >= 0 && endTime.compareTo(sectionEndTime) <= 0;
                        if (!isOverlap) continue;
                        sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"TaskSubsectionOp_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), j + 1)).append('\uff0c');
                    }
                    int strLength = sb.length();
                    if (strLength > prefix.length()) {
                        sb.setCharAt(strLength - 1, '\u3002');
                        this.addErrorMessage(extendedDataEntity, sb.toString());
                    }
                    sb.setLength(0);
                }
                BigDecimal repaircycle = dataEntity.getBigDecimal("plantime");
                if (collection.size() <= 0 || repaircycle.compareTo(timeLong) == 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u8ba1\u5212\u5de5\u671f\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u8ba1\u5212\u5de5\u671f\u201d\u3002", (String)"TaskSubsectionOp_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

