/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.validator.wbs;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WbsSaveAndSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            boolean hasInvoice;
            DynamicObject wbsDyn = dataEntity.getDataEntity();
            String number = wbsDyn.getString("number");
            QFilter qFilter = new QFilter("id", "!=", wbsDyn.getPkValue());
            qFilter.and(new QFilter("number", "=", (Object)number));
            boolean exists = QueryServiceHelper.exists((String)"bd_wbs", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u3010%s\u3011\u7f16\u7801\u4e0e\u57fa\u7840\u670d\u52a1\u7684WBS\u91cd\u590d\u3002", (String)"WbsSaveAndSubmitValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[]{number}));
            }
            if (!wbsDyn.getBoolean("isinvoice")) continue;
            long parentId = wbsDyn.getLong("parent.id");
            if (parentId != 0L && this.queryParent(parentId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5df2\u5f00\u7968\uff0c\u5f53\u524dWBS\u4e0d\u53ef\u5f00\u7968\u3002", (String)"WbsSaveAndSubmitValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[]{number}));
            }
            if (!(hasInvoice = this.queryChild((Long)wbsDyn.getPkValue(), false))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7ea7\u5df2\u5f00\u7968\uff0c\u5f53\u524dWBS\u4e0d\u53ef\u5f00\u7968\u3002", (String)"WbsSaveAndSubmitValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[]{number}));
        }
    }

    private boolean queryParent(Long parentId) {
        QFilter preFilter = new QFilter("id", "=", (Object)parentId);
        DynamicObject query = QueryServiceHelper.queryOne((String)"pmts_wbs", (String)"isinvoice, parent", (QFilter[])new QFilter[]{preFilter});
        if (query == null) {
            return false;
        }
        if (query.getBoolean("isinvoice")) {
            return true;
        }
        if (query.getLong("parent") == 0L) {
            return false;
        }
        return this.queryParent(query.getLong("parent"));
    }

    private boolean queryChild(Long id, boolean isInvoice) {
        if (id == 0L) {
            return isInvoice;
        }
        QFilter preFilter = new QFilter("parent", "=", (Object)id);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmts_wbs", (String)"isinvoice, id", (QFilter[])new QFilter[]{preFilter});
        for (DynamicObject dynamicObject : query) {
            if (dynamicObject.getBoolean("isinvoice")) {
                isInvoice = true;
                return isInvoice;
            }
            isInvoice = this.queryChild(dynamicObject.getLong("id"), isInvoice);
        }
        return isInvoice;
    }
}

