/*
 * Decompiled with CFR 0.152.
 */
package kd.industry.model;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ProcessPlanNodeSelectPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String SEARCHAP = "searchap";
    private static final String BILLLISTAP = "billlistap";
    private static final String LISTGRIDVIEWAP = "listgridviewap";
    private static final String BTN_DELETE = "btn_delete";
    private static final String OP_DELETE = "btndelete";
    private static final String BTN_ADD = "btn_add";
    private static final String BTNOK = "btnok";
    private static final String PASSDELETECACHE = "passdeletecache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DELETE, BTN_ADD, BTNOK});
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        this.setListOrderby(billlist);
    }

    public void search(SearchEnterEvent e) {
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        List searchFields = e.getSearchFields();
        if (searchFields == null || searchFields.size() < 1) {
            billlist.getFilterParameter().getQFilters().clear();
            this.setListOrderby(billlist);
            return;
        }
        QFilter qf = null;
        for (Map searchField : searchFields) {
            qf = this.getQFilter(qf, searchField);
        }
        if (qf != null) {
            billlist.setFilter(qf);
            this.setListOrderby(billlist);
        }
    }

    private QFilter getQFilter(QFilter qf, Map<String, Object> searchField) {
        List fieldnames = (List)searchField.get("fieldName");
        List values = (List)searchField.get("value");
        for (String fieldname : fieldnames) {
            for (String value : values) {
                if (qf == null) {
                    qf = new QFilter(fieldname, "ftlike", (Object)value);
                    continue;
                }
                qf.or(new QFilter(fieldname, "ftlike", (Object)value));
            }
        }
        return qf;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        FormOperate source = (FormOperate)e.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OP_DELETE)) {
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            if (selectedRows == null || selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"ProcessPlanNodeSelectPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String ispass = this.getPageCache().get(PASSDELETECACHE);
            if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)ispass)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(OP_DELETE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ProcessPlanNodeSelectPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OP_DELETE)) {
            this.getPageCache().put(PASSDELETECACHE, "false");
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            if (selectedRows == null || selectedRows.size() < 1) {
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            try (TXHandle tx = TX.required((String)"delete processPlanNode");){
                try {
                    DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fmm_processplannode"), (Object[])primaryKeyValues);
                }
                catch (Exception e1) {
                    tx.markRollback();
                    throw e1;
                }
            }
            this.setListOrderby(billlist);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        Object source = e.getSource();
        Button button = (Button)source;
        switch (button.getKey()) {
            case "btn_delete": {
                break;
            }
            case "btn_add": {
                this.showBillForm(BTN_ADD, 0L);
                break;
            }
            case "btnok": {
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                if (selectedRows == null || selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"ProcessPlanNodeSelectPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().returnDataToParent((Object)billlist.getSelectedRows());
                this.getView().close();
                break;
            }
        }
    }

    private void showBillForm(String opkey, Object pkId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("fmm_processplannode");
        if (StringUtils.equals((CharSequence)BTN_ADD, (CharSequence)opkey)) {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setPkId(pkId);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opkey));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null || returnData.equals(0L)) {
            return;
        }
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        String actionId = e.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)BTN_ADD)) {
            this.setListOrderby(billlist);
            billlist.selectRows(0);
        }
    }

    private void setListOrderby(BillList billlist) {
        billlist.setOrderBy("createdate desc");
        this.getView().updateView(BILLLISTAP);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equals((CharSequence)OP_DELETE, (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                this.getPageCache().put(PASSDELETECACHE, "true");
                this.getView().invokeOperation(OP_DELETE);
            } else {
                this.getPageCache().put(PASSDELETECACHE, "false");
            }
        }
    }
}

