/*
 * Decompiled with CFR 0.152.
 */
package kd.industry.model;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ProcessPlanlibEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String BTN_ADD = "btn_add";
    public static final String BTN_DELETE = "btn_delete";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_CLEAN = "btn_clean";
    public static final String DESIGNER = "cc_mgdesigner";
    public static final String SELECTNODE = "selectNode";
    public static final String ACTION = "Action";
    public static final String SAVEMXGRAPH = "saveMxgraph";
    public static final String ADDXML = "addxml";
    public static final String NODE_ID = "nodeId";
    public static final String ADD_NODE = "addPHMNode";
    public static final String AFTER_ADD_NODE = "afterAddPHMNode";
    public static final String DELETE_CELLS = "deleteCells";
    public static final String CLEAN_GRAPH = "cleanGraph";
    public static final String SET_MXVALUE = "setMxValue";
    public static final String VALUE = "value";
    public static final String XML_DATA = "xmlData";
    public static final String SELECT_CELL = "selectCell";
    public static final String INIT_XML_DATA = "initxmlData";
    public static final String CLEAR_CONTROL_DATA = "ClearControlData";
    public static final String CLEAN_FLEX_DATA = "cleanFlexData";
    public static final String CHECKDATACHANGE = "checkDataChange";
    public static final String VIEWPROCESSNODEDETIAL = "viewprocessnodedetial";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD, BTN_DELETE, BTN_SAVE, BTN_CLEAN});
        BasedataEdit processNode = (BasedataEdit)this.getControl("processnode");
        if (processNode != null) {
            processNode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            processNode.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        }
    }

    public void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        event.setCancel(true);
        DynamicObject processNode = (DynamicObject)this.getModel().getValue("processnode");
        if (processNode != null) {
            this.showBaseForm(VIEWPROCESSNODEDETIAL, "fmm_processplannode", processNode.getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"processnode")) {
            String selectId = (String)this.getModel().getValue("selectid");
            if (StringUtils.isBlank((CharSequence)selectId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"ProcessPlanlibEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.showForm(SELECTNODE, "fmm_processplannode_f7");
            e.setCancel(true);
        }
    }

    private void showForm(String opkey, String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opkey));
        this.getView().showForm(formShowParameter);
    }

    private void showBaseForm(String opkey, String formId, Object pkId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        if (pkId != null && !pkId.equals(0L)) {
            showParameter.setPkId(pkId);
        }
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opkey));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        if (event == null) {
            return;
        }
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            DynamicObject propertyValueCDDE = changeData.getDataEntity();
            if (StringUtils.equalsIgnoreCase((CharSequence)"processnode", (CharSequence)propertyName)) {
                this.alogoModelChanged(oldObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"selectname", (CharSequence)propertyName)) {
                this.selectNameChanged(oldObject, newObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"selectid", (CharSequence)propertyName)) {
                this.selectIdChanged(newObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"scenegroup", (CharSequence)propertyName)) {
                this.scenGroupChanged(oldObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"xml_tag", (CharSequence)propertyName)) continue;
            this.getPageCache().put(CHECKDATACHANGE, "true");
        }
    }

    private void alogoModelChanged(Object oldObject, DynamicObject propertyValueCDDE) {
        boolean isSuccess = this.saveCellData();
        if (!isSuccess) {
            this.getModel().beginInit();
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set("processnode", oldObject);
            propertyValueCDDE.endInit();
            this.getModel().endInit();
            this.getView().updateView("processnode");
        }
    }

    private void scenGroupChanged(Object oldObject, DynamicObject propertyValueCDDE) {
        boolean isSuccess = this.saveCellData();
        if (!isSuccess) {
            this.getModel().beginInit();
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set("scenegroup", oldObject);
            propertyValueCDDE.endInit();
            this.getModel().endInit();
            this.getView().updateView("scenegroup");
        }
    }

    private boolean saveCellData() {
        Object nodedataObj = this.getModel().getValue("nodedata_tag");
        Object upSelectid = this.getModel().getValue("selectid");
        if (upSelectid != null && StringUtils.isNotBlank((Object)upSelectid)) {
            Map<String, Map> cellsDataMap;
            String upSelectidstr = (String)upSelectid;
            String selectname = (String)this.getModel().getValue("selectname");
            if (nodedataObj != null && StringUtils.isNotBlank((Object)nodedataObj)) {
                String cellsdata = (String)nodedataObj;
                cellsDataMap = (Map)JSON.parse((String)cellsdata);
            } else {
                cellsDataMap = new HashMap(1);
            }
            Map cellData = cellsDataMap.getOrDefault(upSelectidstr, new HashMap(1));
            DynamicObject processNode = (DynamicObject)this.getModel().getValue("processnode");
            if (processNode != null && StringUtils.isBlank((CharSequence)selectname)) {
                selectname = processNode.getString("name");
            }
            ArrayList<String> scenGroupIDs = new ArrayList<String>(10);
            DynamicObjectCollection scenGroups = (DynamicObjectCollection)this.getModel().getValue("scenegroup");
            for (DynamicObject scenGroup : scenGroups) {
                scenGroupIDs.add(scenGroup.getString("fbasedataid_id"));
            }
            cellData.put("scenegroup", SerializationUtils.toJsonString(scenGroupIDs));
            cellData.put("processnode", processNode == null ? "" : processNode.getPkValue().toString());
            cellData.put("selectname", selectname);
            cellsDataMap.put(upSelectidstr, cellData);
            String jsonString = JSON.toJSONString(cellsDataMap);
            this.getModel().setValue("nodedata_tag", (Object)jsonString);
            this.getModel().setValue("selectname", (Object)selectname);
            this.getView().updateView("nodedata");
            this.getView().updateView("nodedata_tag");
            this.getView().updateView("selectname");
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"ProcessPlanlibEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        return false;
    }

    private void selectNameChanged(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        String value = newObject instanceof String ? (String)newObject : "";
        this.setCellValue(value);
        boolean isSuccess = this.saveCellData();
        if (!isSuccess) {
            this.getModel().beginInit();
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set("selectname", oldObject);
            propertyValueCDDE.endInit();
            this.getModel().endInit();
            this.getView().updateView("selectname");
        }
    }

    private void setCellValue(String value) {
        Object nodeId = this.getModel().getValue("selectid");
        if (StringUtils.isBlank((Object)nodeId)) {
            return;
        }
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        HashMap<String, String> paramsMap = new HashMap<String, String>(3);
        paramsMap.put(ACTION, SET_MXVALUE);
        paramsMap.put(VALUE, value);
        paramsMap.put(NODE_ID, nodeId.toString());
        control.setData(paramsMap);
    }

    private void selectIdChanged(Object newObject, DynamicObject propertyValueCDDE) {
        if (newObject == null) {
            this.getModel().beginInit();
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set("processnode", null);
            propertyValueCDDE.set("selectname", null);
            propertyValueCDDE.endInit();
            this.getModel().endInit();
            this.getView().updateView("processnode");
            this.getView().updateView("selectname");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            Document document;
            String rootXml = (String)this.getModel().getValue("xml_tag");
            if (StringUtils.isBlank((CharSequence)rootXml)) {
                return;
            }
            try {
                document = DocumentHelper.parseText((String)rootXml);
            }
            catch (DocumentException e1) {
                throw new KDBizException(e1.getMessage());
            }
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            this.removeRepeatCellData(mxCellElements);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"new")) {
            this.cleanGraph();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cleanGraph();
    }

    private void removeRepeatCellData(List<Element> mxCellElements) {
        if (mxCellElements == null) {
            return;
        }
        if (mxCellElements.isEmpty()) {
            this.getModel().setValue("nodedata", null);
            this.getModel().setValue("nodedata_tag", null);
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Object cellsdataObj = this.getModel().getValue("nodedata_tag");
        if (cellsdataObj == null || StringUtils.isEmpty((CharSequence)cellsdataObj.toString())) {
            return;
        }
        String cellData = cellsdataObj.toString();
        Map cellsDataMap = (Map)JSON.parse((String)cellData);
        HashMap<String, Map> newCellsDataMap = new HashMap<String, Map>(cellsDataMap.size());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection scenGroups = (DynamicObjectCollection)model.getValue("scenegroup");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("processnodeid", new Object[0]);
        vs.addField("sceneparam", new Object[0]);
        vs.addField("nodeid", new Object[0]);
        int seq = 1;
        for (Map.Entry entry : cellsDataMap.entrySet()) {
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            boolean isExist = false;
            for (Element cell : mxCellElements) {
                String id = cell.attributeValue("id");
                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)id)) continue;
                isExist = true;
                break;
            }
            if (!isExist) continue;
            newCellsDataMap.put(key, value);
            if (value == null) continue;
            String algoModel = (String)value.get("processnode");
            DynamicObjectCollection entryscenGroups = new DynamicObjectCollection();
            String s1 = (String)value.get("scenegroup");
            if (StringUtils.isNotBlank((CharSequence)s1)) {
                List scenGroupIds = (List)SerializationUtils.fromJsonString((String)s1, List.class);
                for (String scenGroupId : scenGroupIds) {
                    DynamicObject obj = new DynamicObject(scenGroups.getDynamicObjectType());
                    DynamicObject obj1 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fmm_sceneparam"));
                    obj1.set("id", (Object)Long.parseLong(scenGroupId));
                    obj.set("fbasedataid", (Object)obj1);
                    entryscenGroups.add((Object)obj);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)algoModel)) continue;
            vs.addRow(new Object[]{seq++, algoModel, entryscenGroups, key});
        }
        model.beginInit();
        this.getModel().deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        String jsonString = JSON.toJSONString(newCellsDataMap);
        this.getModel().setValue("nodedata_tag", (Object)jsonString);
        this.getView().updateView("entryentity");
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (StringUtils.equalsIgnoreCase((CharSequence)XML_DATA, (CharSequence)eventName)) {
            this.setXmlData(eventArgs);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SELECT_CELL, (CharSequence)eventName) || StringUtils.equalsIgnoreCase((CharSequence)AFTER_ADD_NODE, (CharSequence)eventName)) {
            this.selectCell(eventArgs);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)INIT_XML_DATA, (CharSequence)eventName)) {
            this.initXmlData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CLEAR_CONTROL_DATA, (CharSequence)eventName)) {
            this.clearControlData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CLEAN_FLEX_DATA, (CharSequence)eventName)) {
            this.cleanFlexData();
        }
    }

    private void cleanFlexData() {
        this.getModel().setValue("selectid", null);
        this.getModel().setValue("xml", null);
        this.getModel().setValue("xml_tag", null);
        this.getModel().setValue("nodedata_tag", null);
    }

    private void clearControlData() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        control.setData(null);
    }

    private void initXmlData() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        String xml = (String)this.getModel().getValue("xml_tag");
        if (StringUtils.isNotBlank((CharSequence)xml)) {
            HashMap<String, String> paramsMap = new HashMap<String, String>(2);
            paramsMap.put(ACTION, ADDXML);
            paramsMap.put("xml", xml);
            control.setData(paramsMap);
        }
    }

    private void setXmlData(String eventArgs) {
        try {
            int indexOf = eventArgs.indexOf("<root>");
            int lastIndexOf = eventArgs.lastIndexOf("</root>");
            String rootXml = eventArgs.substring(indexOf, lastIndexOf + 7);
            Document document = DocumentHelper.parseText((String)rootXml);
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            Iterator iterator = mxCellElements.iterator();
            while (iterator.hasNext()) {
                Element mxCell = (Element)iterator.next();
                String vertex = mxCell.attributeValue("vertex");
                String edge = mxCell.attributeValue("edge");
                if ("1".equals(vertex) || "1".equals(edge)) continue;
                iterator.remove();
            }
            this.getModel().beginInit();
            this.getModel().setValue("xml", (Object)"root xml");
            this.getModel().setValue("xml_tag", (Object)document.asXML());
            this.getModel().endInit();
            this.getView().updateView("xml");
        }
        catch (DocumentException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void selectCell(String cellId) {
        Object cellsdataObj = this.getModel().getValue("nodedata_tag");
        this.getModel().setValue("selectid", (Object)cellId);
        if (cellsdataObj != null && StringUtils.isNotBlank((Object)cellsdataObj)) {
            String cellsdata = (String)cellsdataObj;
            Map cellsDataMap = (Map)JSON.parse((String)cellsdata);
            Map cellData = (Map)cellsDataMap.get(cellId);
            if (cellData != null) {
                if (StringUtils.isNotBlank((CharSequence)"processnode")) {
                    this.getModel().setValue("processnode", cellData.get("processnode"));
                } else {
                    this.getModel().setValue("processnode", null);
                }
                String s1 = (String)cellData.get("scenegroup");
                if (StringUtils.isNotBlank((CharSequence)s1)) {
                    DynamicObjectCollection scenGroups = (DynamicObjectCollection)this.getModel().getValue("scenegroup");
                    scenGroups.clear();
                    List scenGroupIds = (List)SerializationUtils.fromJsonString((String)s1, List.class);
                    if (scenGroupIds == null || scenGroupIds.size() < 1) {
                        this.getModel().setValue("scenegroup", (Object)scenGroups);
                    } else {
                        for (String scenGroupId : scenGroupIds) {
                            DynamicObject obj = new DynamicObject(scenGroups.getDynamicObjectType());
                            obj.set("fbasedataid_id", (Object)Long.parseLong(scenGroupId));
                            DynamicObject obj1 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fmm_sceneparam"));
                            obj1.set("id", (Object)Long.parseLong(scenGroupId));
                            obj.set("fbasedataid", (Object)obj1);
                            scenGroups.add((Object)obj);
                        }
                        this.getModel().setValue("scenegroup", (Object)scenGroups);
                    }
                } else {
                    this.getModel().setValue("scenegroup", null);
                }
                this.getModel().setValue("selectname", cellData.get("selectname"));
            } else {
                this.getModel().setValue("processnode", null);
                this.getModel().setValue("selectname", null);
                this.getModel().setValue("scenegroup", null);
            }
        } else {
            this.getModel().setValue("processnode", null);
            this.getModel().setValue("selectname", null);
            this.getModel().setValue("scenegroup", null);
        }
        this.getView().updateView("scenegroup");
    }

    public void click(EventObject evt) {
        Control srcCtrl;
        super.click(evt);
        Object srcCtrlObj = evt.getSource();
        Control control = srcCtrl = srcCtrlObj instanceof Control ? (Control)srcCtrlObj : null;
        if (srcCtrl == null) {
            return;
        }
        String srcCtrlKey = srcCtrl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)BTN_SAVE, (CharSequence)srcCtrlKey)) {
            this.saveMxgraph();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BTN_ADD, (CharSequence)srcCtrlKey)) {
            this.addNewNode();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BTN_DELETE, (CharSequence)srcCtrlKey)) {
            this.deleteNode();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BTN_CLEAN, (CharSequence)srcCtrlKey)) {
            this.cleanGraph();
        }
    }

    private void saveMxgraph() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(1);
        paramsMap.put(ACTION, SAVEMXGRAPH);
        control.setData(paramsMap);
    }

    private void addNewNode() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(3);
        paramsMap.put(ACTION, ADD_NODE);
        paramsMap.put(NODE_ID, this.getUUID());
        paramsMap.put("name", "");
        control.setData(paramsMap);
    }

    private void deleteNode() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(1);
        paramsMap.put(ACTION, DELETE_CELLS);
        control.setData(paramsMap);
    }

    private void cleanGraph() {
        CustomControl control = (CustomControl)this.getControl(DESIGNER);
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(1);
        paramsMap.put(ACTION, CLEAN_GRAPH);
        control.setData(paramsMap);
    }

    private String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)SELECTNODE, (CharSequence)actionId) && (selectedRows = (ListSelectedRowCollection)returnData).size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            this.getModel().setValue("processnode", listSelectedRow.getPrimaryKeyValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String checkDataChange = this.getPageCache().get(CHECKDATACHANGE);
        String status = (String)this.getModel().getValue("status");
        if ("A".equalsIgnoreCase(status) && "true".equalsIgnoreCase(checkDataChange)) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }
}

