/*
 * Decompiled with CFR 0.152.
 */
package kd.industry.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.param.groupcontrol.SelectParam;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.util.TreeNodeFilter;

public class SysParamSelectPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener {
    public static final String APPTREEVIEW = "apptreeview";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTN_OK = "btnok";
    private static final String CACHE_TREE_NODES = "CACHE_TREE_NODES";
    private static final String CACHE_VIEW_TYPE = "CACHE_VIEW_TYPE";
    private static final String FOCUS_NODE_ID = "FOCUS_NODE_ID";
    private static IParameterReaderService readerService = null;

    public SysParamSelectPlugin() {
        readerService = new ParameterReaderServiceImpl();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        TreeView treeView = (TreeView)this.getControl(APPTREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTN_OK)) {
            EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = control.getSelectRows();
            if (selectRows == null || selectRows.length < 1) {
                return;
            }
            int currentRowIndex = selectRows[0];
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, currentRowIndex);
            HashMap<String, String> map = new HashMap<String, String>(4);
            TreeNode rootNode = this.getRootNodeFromCache();
            TreeNode treeNode = rootNode.getTreeNode(this.getTreeFocusNodeId());
            map.put("appid", treeNode.getId());
            map.put("appname", treeNode.getText());
            map.put("param", entryRowEntity.getString("param"));
            map.put("paramname", entryRowEntity.getString("paramname"));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.focusAppNode();
    }

    private void focusAppNode() {
        TreeNode root = this.getRootNodeFromCache();
        List cloudNodes = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            this.clickNode(root);
            return;
        }
        Object appId = this.getView().getFormShowParameter().getCustomParam("appid");
        if (ObjectUtils.isEmpty((Object)appId)) {
            TreeNode firstNode = this.getFirstNode(cloudNodes);
            this.clickNode(firstNode);
            return;
        }
        String nodeId = String.valueOf(appId);
        TreeNode appNode = root.getTreeNode(nodeId);
        this.clickNode(appNode);
    }

    private void clickNode(TreeNode node) {
        if (node == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(APPTREEVIEW);
        TreeNode root = this.getRootNodeFromCache();
        treeView.focusNode(node);
        List childPathNodes = root.getChildPathNodes(node.getId());
        for (TreeNode pathNode : childPathNodes) {
            treeView.expand(pathNode.getParentid());
        }
        this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)node.getParentid(), (Object)node.getId()));
    }

    private TreeNode getFirstNode(List<TreeNode> cloudNodes) {
        TreeNode cloudNode = cloudNodes.get(0);
        List appNodes = cloudNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)appNodes)) {
            return null;
        }
        return (TreeNode)appNodes.get(0);
    }

    private TreeNode getRootNodeFromCache() {
        String treeNodesJson = this.getPageCache().get(CACHE_TREE_NODES);
        if (StringUtils.isNotBlank((CharSequence)treeNodesJson)) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodesJson, TreeNode.class);
            return root;
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)false);
        this.filterCloudAndAppNodes(root);
        List<String> clouds = this.getEnableCloudOrAppIdList(true);
        Map<String, String> appViewTypeMap = this.getAppViewTypeMapFromCache();
        Set<String> appIds = appViewTypeMap.keySet();
        List children = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return root;
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode cloud = (TreeNode)iterator.next();
            cloud.getChildren().removeIf(app -> !appIds.contains(app.getId()));
            if (!cloud.getChildren().isEmpty() || clouds.contains(cloud.getId())) continue;
            iterator.remove();
        }
        TreeView treeView = (TreeView)this.getView().getControl(APPTREEVIEW);
        treeView.addNode(root);
        this.getPageCache().put(CACHE_TREE_NODES, SerializationUtils.toJsonString((Object)root));
        return root;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
    }

    private String getTreeFocusNodeId() {
        TreeView tree = (TreeView)this.getControl(APPTREEVIEW);
        return tree.getTreeState().getFocusNodeId();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        ParamPublishObject parameterObject;
        String formId;
        Map<String, SelectParam> metaDataParam;
        String nodeId = String.valueOf(evt.getNodeId());
        if (this.checkRepeatedClickTreeNode(nodeId)) {
            return;
        }
        TreeNode root = this.getRootNodeFromCache();
        TreeNode node = root.getTreeNode(nodeId);
        Object nodeType = node.getData();
        if (!"app".equals(nodeType)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(ENTRYENTITY));
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(ENTRYENTITY));
        }
        if (CollectionUtils.isEmpty(metaDataParam = this.getMetaDataParamFromCache(formId = (parameterObject = readerService.getParameterObject(null, nodeId)).getFormId()))) {
            return;
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("param", new Object[0]);
        tableValueSetter.addField("paramname", new Object[0]);
        for (Map.Entry<String, SelectParam> selectParamEntry : metaDataParam.entrySet()) {
            SelectParam value = selectParamEntry.getValue();
            tableValueSetter.addRow(new Object[]{value.getFieldKey(), value.getName()});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRYENTITY, tableValueSetter);
        this.getModel().updateCache();
        this.getView().updateView(ENTRYENTITY);
    }

    private Map<String, SelectParam> getMetaDataParamFromCache(String entityId) {
        String cacheKey = this.getCacheKey(entityId, "getMetaDataParam");
        String getMetaDataParamJson = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)getMetaDataParamJson)) {
            Map metaDataParam = (Map)SerializationUtils.fromJsonString((String)getMetaDataParamJson, Map.class);
            HashMap<String, SelectParam> res = new HashMap<String, SelectParam>(metaDataParam.size());
            for (Map.Entry entry : metaDataParam.entrySet()) {
                res.put((String)entry.getKey(), new SelectParam((Map)entry.getValue()));
            }
            return res;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        HashMap<String, SelectParam> cacheParam = new HashMap<String, SelectParam>(16);
        int index = 0;
        for (ControlAp ap : controlAps) {
            boolean hidden;
            ContainerAp cp;
            String fieldKey = ap.getKey();
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (field instanceof RadioField || field instanceof BasedataPropField || ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            String id = ap.getId();
            String name = ap.getName().getLocaleValue();
            if (ap instanceof FormAp || !(ap instanceof FieldAp)) continue;
            boolean bl = hidden = ap.isInvisible() || ap.isHidden() || StringUtils.isBlank((CharSequence)ap.getVisible());
            if (hidden) continue;
            SelectParam selectParam = new SelectParam();
            selectParam.setId(id);
            selectParam.setName(name);
            selectParam.setFieldKey(fieldKey);
            selectParam.setIndex(index);
            ++index;
            if (field.isGroupControl()) {
                selectParam.setDesignGcControl(true);
            }
            cacheParam.put(selectParam.getId(), selectParam);
        }
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(cacheParam));
        return cacheParam;
    }

    private String getCacheKey(String ... keys) {
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key).append("_");
        }
        return builder.toString();
    }

    private boolean checkRepeatedClickTreeNode(String nodeId) {
        IPageCache pageCache = this.getPageCache();
        String preNodeId = pageCache.get(FOCUS_NODE_ID);
        if (StringUtils.isBlank((CharSequence)preNodeId)) {
            preNodeId = "";
        }
        if (nodeId.equals(preNodeId)) {
            return true;
        }
        pageCache.put(FOCUS_NODE_ID, nodeId);
        return false;
    }

    private List<String> getEnableCloudOrAppIdList(boolean isCloud) {
        String sql;
        DynamicObjectCollection systems;
        String field = "FCLOUDID";
        if (!isCloud) {
            field = "FAPPID";
        }
        if (CollectionUtils.isEmpty((Collection)(systems = SingleORM.query(null, (String)(sql = "select distinct " + field + " from t_bas_sysparaconsole where FENABLED ='1'"), null)))) {
            return new ArrayList<String>(0);
        }
        List<String> ids = systems.stream().map(dynamicObject -> dynamicObject.getString(0)).collect(Collectors.toList());
        return ids;
    }

    private Map<String, String> getAppViewTypeMapFromCache() {
        String viewTypeMapJson = this.getPageCache().get(CACHE_VIEW_TYPE);
        if (StringUtils.isNotBlank((CharSequence)viewTypeMapJson)) {
            Map appViewTypeMap = (Map)SerializationUtils.fromJsonString((String)viewTypeMapJson, Map.class);
            return appViewTypeMap;
        }
        List<String> apps = this.getEnableCloudOrAppIdList(false);
        Map bizApps = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("id", "in", apps).and(new QFilter("deploystatus", "=", (Object)"2"))});
        HashMap<String, String> appViewTypeMap = new HashMap<String, String>(bizApps.size());
        for (Map.Entry entry : bizApps.entrySet()) {
            String appId = String.valueOf(entry.getKey());
            DynamicObject appObj = (DynamicObject)entry.getValue();
            String viewType = appObj.getString("orgfunc");
            if (StringUtils.isBlank((CharSequence)viewType)) {
                viewType = "15";
            }
            appViewTypeMap.put(appId, viewType);
        }
        this.getPageCache().put(CACHE_VIEW_TYPE, SerializationUtils.toJsonString(appViewTypeMap));
        return appViewTypeMap;
    }
}

