/*
 * Decompiled with CFR 0.152.
 */
package kd.industry.model.cust;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.industry.model.bean.BaseDataConfig;
import kd.industry.model.bean.EntitySetingParam;

public class ConfigCustPlugin
extends AbstractBillPlugIn {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List items = e.getItems();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSetStyle();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("settingparam");
        if (customParam == null) {
            throw new KDBizException(new ErrorCode("baseconfig_param null error", "baseconfig_param is null"), new Object[0]);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        String entityTypeName = dataEntityType.getName();
        List<ControlAp<?>> allControlAp = this.getControlApByEntityId(entityTypeName);
        this.setAllContrlVisbleFalse(entityTypeName, allControlAp);
        EntitySetingParam setingParam = (EntitySetingParam)SerializationUtils.fromJsonString((String)customParam.toString(), EntitySetingParam.class);
        List baseDataConfigs = setingParam.getBaseDataConfigs();
        HashSet<String> allShowContrl = new HashSet<String>(baseDataConfigs.size() * 3);
        for (BaseDataConfig baseDataConfig : baseDataConfigs) {
            String fieldtag = baseDataConfig.getFieldtag();
            if (fieldtag.indexOf(".") > 0) {
                String[] split = StringUtils.split((String)fieldtag, (String)".");
                fieldtag = split[split.length - 1];
                this.getView().setEnable(Boolean.valueOf(baseDataConfig.getIslock() == false), 0, new String[]{fieldtag});
            } else {
                this.getView().setEnable(Boolean.valueOf(baseDataConfig.getIslock() == false), new String[]{fieldtag});
            }
            ControlAp<?> contrl = this.findContrl(allControlAp, fieldtag);
            if (contrl == null) continue;
            FieldEdit fieldEdit = (FieldEdit)this.getControl(fieldtag);
            fieldEdit.setMustInput(baseDataConfig.getMustinputble().booleanValue());
            MulBasedataEdit basedataEdit = new MulBasedataEdit();
            basedataEdit.setF7MultipleSelect(true);
            this.findParentContrl(allControlAp, contrl, allShowContrl);
        }
        if (allShowContrl.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), allShowContrl.toArray(new String[0]));
        }
    }

    private ControlAp<?> findContrl(List<ControlAp<?>> allControlAp, String contrlKey) {
        for (ControlAp<?> controlAp : allControlAp) {
            String key = controlAp.getKey();
            if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)contrlKey)) continue;
            return controlAp;
        }
        return null;
    }

    private void findParentContrl(List<ControlAp<?>> allControlAp, ControlAp<?> contrl, Set<String> allShowContrl) {
        if (contrl == null) {
            return;
        }
        String contrlKey = contrl.getKey();
        allShowContrl.add(contrlKey);
        String parentId = contrl.getParentId();
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return;
        }
        for (ControlAp<?> controlAp : allControlAp) {
            String id = controlAp.getId();
            if (!StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)id)) continue;
            this.findParentContrl(allControlAp, controlAp, allShowContrl);
            return;
        }
    }

    private void setAllContrlVisbleFalse(String entityTypeName, List<ControlAp<?>> controlApByEntityId) {
        HashSet<String> initVisibleFalseKeys = new HashSet<String>(controlApByEntityId.size());
        for (ControlAp<?> controlAp : controlApByEntityId) {
            String controlKey = controlAp.getKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)entityTypeName, (CharSequence)controlKey)) continue;
            initVisibleFalseKeys.add(controlKey);
        }
        this.getView().setVisible(Boolean.valueOf(false), initVisibleFalseKeys.toArray(new String[0]));
    }

    private void initSetStyle() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"titleapanel"});
        HashMap<String, String> ctrl = new HashMap<String, String>(4);
        ctrl.put("r", "0px solid #ffffff");
        ctrl.put("b", "0px solid #ffffff");
        ctrl.put("t", "0px solid #ffffff");
        ctrl.put("l", "0px solid #ffffff");
        HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>(1);
        data.put("b", ctrl);
        HashMap<String, HashMap<String, HashMap<String, String>>> dataa = new HashMap<String, HashMap<String, HashMap<String, String>>>(1);
        dataa.put("s", data);
        this.getView().updateControlMetadata("conentpanel", dataa);
    }

    private List<ControlAp<?>> getControlApByEntityId(String formId) {
        String idByNumber = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entitymeta);
        List items = formMeta.getItems();
        return items;
    }
}

