/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.business.BusiSyschFieldUtil;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.fmm.formplugin.FixEntryModel;

public class ProjectAndWbsFixSysFieldUtilEdit
extends AbstractFormPlugin {
    List<FixEntryModel> preSetModels = new ArrayList<FixEntryModel>(){
        {
            this.add(new FixEntryModel("pmpd_project", false, null, "id", "sysproject"));
            this.add(new FixEntryModel("pmts_wbs", false, null, "projectnum", "sysproject"));
            this.add(new FixEntryModel("pmts_wbs", false, null, "releasewbs", "sysreleasewbs"));
            this.add(new FixEntryModel("pmts_demand_list", false, null, "project", "sysproject"));
            this.add(new FixEntryModel("pmts_demand_list", false, null, "wbs", "syswbs"));
        }
    };

    public void afterCreateNewData(EventObject e) {
        this.getModel().batchCreateNewEntryRow("entryentity", this.preSetModels.size());
        for (int i = 0; i < this.preSetModels.size(); ++i) {
            this.getModel().setValue("entitynumber", (Object)this.preSetModels.get(i).getEntityNumber(), i);
            this.getModel().setValue("isentry", (Object)this.preSetModels.get(i).getIsEntry(), i);
            this.getModel().setValue("entryname", (Object)this.preSetModels.get(i).getEntryName(), i);
            this.getModel().setValue("mmcfield", (Object)this.preSetModels.get(i).getMmcField(), i);
            this.getModel().setValue("sysfield", (Object)this.preSetModels.get(i).getSysField(), i);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("fixdata".equals(operateKey)) {
            HashMap<String, List<FixEntryModel>> fixEntryModels = new HashMap<String, List<FixEntryModel>>(8);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                int i = 1;
                for (DynamicObject entryObj : entryentity) {
                    String entitynumber = entryObj.getString("entitynumber");
                    boolean isentry = entryObj.getBoolean("isentry");
                    String entryname = entryObj.getString("entryname");
                    String mmcfield = entryObj.getString("mmcfield");
                    String sysfield = entryObj.getString("sysfield");
                    if (StringUtils.isEmpty((Object)entitynumber) || isentry && StringUtils.isEmpty((Object)entryname) || StringUtils.isEmpty((Object)mmcfield) || StringUtils.isEmpty((Object)sysfield)) continue;
                    fixEntryModels.computeIfAbsent(entitynumber, t -> new ArrayList(8)).add(new FixEntryModel(entitynumber, isentry, entryname, mmcfield, sysfield));
                    ++i;
                }
                this.fixData(fixEntryModels);
            }
        }
    }

    private void fixData(Map<String, List<FixEntryModel>> fixEntryModels) {
        for (Map.Entry<String, List<FixEntryModel>> fixEntry : fixEntryModels.entrySet()) {
            String entityNumber = fixEntry.getKey();
            List<FixEntryModel> needFixFields = fixEntry.getValue();
            StringBuilder selectFields = new StringBuilder();
            HashMap<String, List> syschEntryFieldMap = new HashMap<String, List>(8);
            HashMap<String, String> syschFieldMap = new HashMap<String, String>(8);
            for (FixEntryModel needFixField : needFixFields) {
                if (needFixField.isEntry.booleanValue()) {
                    String entryName = needFixField.entryName;
                    syschEntryFieldMap.computeIfAbsent(entryName, t -> new ArrayList(8)).add(new Tuple((Object)needFixField.mmcField, (Object)needFixField.sysField));
                    if (selectFields.indexOf(entryName) == -1) {
                        if (selectFields.length() > 0) {
                            selectFields.append(",");
                        }
                        selectFields.append(entryName);
                    }
                    if (selectFields.length() > 0) {
                        selectFields.append(",");
                    }
                    selectFields.append(entryName);
                    selectFields.append(".");
                    selectFields.append(needFixField.mmcField);
                    selectFields.append(",");
                    selectFields.append(entryName);
                    selectFields.append(".");
                    selectFields.append(needFixField.sysField);
                    continue;
                }
                syschFieldMap.put(needFixField.mmcField, needFixField.sysField);
                if (selectFields.length() > 0) {
                    selectFields.append(",");
                }
                selectFields.append(needFixField.mmcField);
                selectFields.append(",");
                selectFields.append(needFixField.sysField);
            }
            DynamicObject[] needUpdateObjs = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields.toString(), null);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            for (DynamicObject needUpdateObj : needUpdateObjs) {
                if (syschFieldMap.size() > 0) {
                    for (Map.Entry field : syschFieldMap.entrySet()) {
                        String srcField = (String)field.getKey();
                        String targetField = (String)field.getValue();
                        IDataEntityProperty srcProperty = mainType.findProperty(srcField);
                        IDataEntityProperty targetProperty = mainType.findProperty(targetField);
                        Object srcValue = needUpdateObj.get(srcField);
                        if (srcProperty instanceof BasedataProp) {
                            if ("id".equals(srcField)) {
                                needUpdateObj.set(targetField, (Object)BusiSyschFieldUtil.getSysField((String)entityNumber, (Long)((Long)srcValue)));
                                continue;
                            }
                            needUpdateObj.set(targetField, (Object)BusiSyschFieldUtil.getSysField((String)((BasedataProp)targetProperty).getBaseEntityId(), (DynamicObject)((DynamicObject)srcValue)));
                            continue;
                        }
                        if (srcProperty instanceof MulBasedataProp) {
                            needUpdateObj.set(targetField, (Object)BusiSyschFieldUtil.getExistentPksFromSrcDObjColl((String)((BasedataProp)targetProperty).getBaseEntityId(), (DynamicObjectCollection)((DynamicObjectCollection)srcValue)));
                            continue;
                        }
                        needUpdateObj.set(targetField, srcValue);
                    }
                }
                if (syschEntryFieldMap.size() <= 0) continue;
                for (Map.Entry entryField : syschEntryFieldMap.entrySet()) {
                    String entryName = (String)entryField.getKey();
                    List entryMappings = (List)entryField.getValue();
                    DynamicObjectCollection entryColl = needUpdateObj.getDynamicObjectCollection(entryName);
                    for (DynamicObject entryObj : entryColl) {
                        for (Tuple entryMapping : entryMappings) {
                            String srcField = (String)entryMapping.item1;
                            String targetField = (String)entryMapping.item2;
                            IDataEntityProperty srcProperty = mainType.findProperty(srcField);
                            IDataEntityProperty targetProperty = mainType.findProperty(targetField);
                            Object srcValue = entryObj.get(srcField);
                            if (srcProperty instanceof BasedataProp) {
                                entryObj.set(targetField, (Object)BusiSyschFieldUtil.getSysField((String)((BasedataProp)targetProperty).getBaseEntityId(), (DynamicObject)((DynamicObject)srcValue)));
                                continue;
                            }
                            if (srcProperty instanceof MulBasedataProp) {
                                entryObj.set(targetField, (Object)BusiSyschFieldUtil.getExistentPksFromSrcDObjColl((String)((BasedataProp)targetProperty).getBaseEntityId(), (DynamicObjectCollection)((DynamicObjectCollection)srcValue)));
                                continue;
                            }
                            entryObj.set(targetField, srcValue);
                        }
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])needUpdateObjs);
        }
    }
}

