/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;

public class DispatchWorkTypeListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (data.isEmpty()) {
                return data;
            }
            DataEntityPropertyCollection properties = ((DynamicObject)data.get(0)).getDataEntityType().getProperties();
            boolean bgcFlag = properties.containsKey((Object)"bgcolor");
            boolean ftcFlag = properties.containsKey((Object)"fontcolor");
            if (bgcFlag || ftcFlag) {
                int index = start;
                ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
                for (DynamicObject obj : data) {
                    if (bgcFlag) {
                        String bgcolor = obj.getString("bgcolor");
                        styles.add(this.getStyle("bgcolor", bgcolor, index));
                        obj.set("bgcolor", (Object)"");
                    }
                    if (ftcFlag) {
                        String fontcolor = obj.getString("fontcolor");
                        styles.add(this.getStyle("fontcolor", fontcolor, index));
                        obj.set("fontcolor", (Object)"");
                    }
                    ++index;
                }
                if (styles.size() > 0) {
                    BillList billlist = (BillList)DispatchWorkTypeListPlugin.this.getControl("billlistap");
                    billlist.setCellStyle(styles);
                }
            }
            return data;
        }

        private CellStyle getStyle(String key, String color, int index) {
            CellStyle c = new CellStyle();
            c.setRow(index);
            c.setFieldKey(key);
            c.setBackColor(color);
            return c;
        }
    }
}

