/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class IndustryTimeRelEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(IndustryTimeRelEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("workstarttime".equals(propertyName)) {
            this.calculateWorkTime();
            this.calculateWorkShiftTime();
        }
        if ("workendtime".equals(propertyName)) {
            this.calculateWorkTime();
            this.calculateWorkShiftTime();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private int getSelectEntryRowIndex(String entryName) {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        boolean isExistsDaily;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)op.getOperateKey()) || StringUtils.equals((CharSequence)"deleteentry", (CharSequence)op.getOperateKey())) {
            int schemeentry = this.getSelectEntryRowIndex("schemeentry");
            if (schemeentry == -1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u6bb5\u65b9\u6848", (String)"IndustryTimeRelEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            boolean isExistsDaily2 = this.isExistsDailyPlan();
            if (isExistsDaily2) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u6bb5\u65b9\u6848\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u65f6\u95f4\u6bb5\u4fe1\u606f\u3002", (String)"IndustryTimeRelEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"deletescheme", (CharSequence)op.getOperateKey()) && (isExistsDaily = this.isExistsDailyPlan())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u6bb5\u65b9\u6848\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"IndustryTimeRelEditPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private boolean isExistsDailyPlan() {
        int schemeentryIndex = this.getSelectEntryRowIndex("schemeentry");
        IBillModel model = (IBillModel)this.getModel();
        DynamicObjectCollection entryEntitys = model.getEntryEntity("schemeentry");
        DynamicObject schemeentry = (DynamicObject)entryEntitys.get(schemeentryIndex);
        Object pkValue = schemeentry.getPkValue();
        if (pkValue == null || pkValue.equals(0L)) {
            return false;
        }
        QFilter filter = new QFilter("planentryentity.timeslotproid", "=", pkValue);
        boolean isExistsDaily = QueryServiceHelper.exists((String)"sfc_dailyplan_user", (QFilter[])filter.toArray());
        return isExistsDaily;
    }

    private void calculateWorkTime() {
        IDataModel model = this.getModel();
        model.beginInit();
        int rowIndex = model.getEntryCurrentRowIndex("subentry");
        String workStartTime = model.getValue("workstarttime").toString();
        String workEndTime = model.getValue("workendtime").toString();
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)workStartTime)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)workEndTime)) {
            return;
        }
        BigDecimal startTime = new BigDecimal(workStartTime);
        BigDecimal endTime = new BigDecimal(workEndTime);
        BigDecimal help = new BigDecimal(3600);
        BigDecimal workTime = startTime.compareTo(endTime) < 0 ? endTime.subtract(startTime).divide(help, 2, 1) : endTime.add(new BigDecimal(86400)).subtract(startTime).divide(help, 2, 1);
        model.setValue("worktime", (Object)workTime, rowIndex);
        model.endInit();
        this.getView().updateView("worktime", rowIndex);
    }

    private void calculateWorkShiftTime() {
        int rowCounts = this.getModel().getEntryRowCount("subentry");
        BigDecimal workShiftTime = BigDecimal.ZERO;
        for (int i = 0; i < rowCounts; ++i) {
            String workTimeStr = this.getModel().getValue("worktime", i).toString();
            BigDecimal workTime = new BigDecimal(workTimeStr);
            workShiftTime = workShiftTime.add(workTime);
        }
    }
}

