/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class ManuSupplyNewFieldPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ware = (BasedataEdit)this.getControl("supwarehouseid");
        ware.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit locate = (BasedataEdit)this.getControl("suplocationid");
        locate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("supstockorgid");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        Object value = changeSet[0].getNewValue();
        String field = e.getProperty().getName();
        Object num = this.getModel().getValue("number");
        String status = this.getModel().getValue("status").toString();
        if ("".equals(num.toString()) && "A".equals(status) && "useorg".equals(field)) {
            Long orgId = (Long)value;
            this.setSupOrgValue(orgId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        if ("supwarehouseid".equals(field)) {
            this.getModel().setItemValueByID("suplocationid", (Object)0L);
        }
        if ("supstockorgid".equals(field)) {
            this.getModel().setItemValueByID("suplocationid", (Object)0L);
            this.getModel().setItemValueByID("supwarehouseid", (Object)0L);
        }
        Object num = this.getModel().getValue("number");
        String status = this.getModel().getValue("status").toString();
        if ("".equals(num.toString()) && "A".equals(status) && "useorg".equals(field)) {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            this.setSupOrgValue(createOrg);
        }
    }

    private void setSupOrgValue(Object orgId) {
        OrgRelationParam param;
        Long id;
        int i = 0;
        try {
            DynamicObject oid = (DynamicObject)orgId;
            id = oid.getLong("id");
            param = this.getOrgParam(id);
        }
        catch (ClassCastException exp) {
            id = (Long)orgId;
            param = this.getOrgParam(id);
            i = 1;
        }
        Map relationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        if (this.checkOrgIsProduce(id)) {
            if (i == 1) {
                this.getModel().setItemValueByID("supstockorgid", (Object)id);
            } else {
                this.getModel().setValue("supstockorgid", orgId);
            }
        } else if (relationMap != null && !relationMap.isEmpty() && relationMap.get("data") != null && ((ArrayList)relationMap.get("data")).size() != 0) {
            List ids = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            QFilter fil = new QFilter("id", "in", (Object)ids);
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{fil});
            long defOrgId = OrgUnitServiceHelper.getDefaultOrgRelation((OrgRelationParam)param);
            if (ids.size() != 0) {
                if (defOrgId != 0L) {
                    for (DynamicObject obj : objects) {
                        if (obj.getLong("id") != defOrgId) continue;
                        this.getModel().setValue("supstockorgid", (Object)obj);
                    }
                } else {
                    this.getModel().setValue("supstockorgid", (Object)objects[0]);
                }
            } else {
                i = 2;
            }
        } else {
            i = 2;
        }
        if (i == 2) {
            this.getModel().setValue("supstockorgid", (Object)0L);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if ("supwarehouseid".equals(event.getProperty().getName())) {
            ArrayList<QFilter> filList = new ArrayList<QFilter>(16);
            QFilter fil1 = new QFilter("status", "=", (Object)"C");
            filList.add(fil1);
            QFilter fil2 = new QFilter("enable", "=", (Object)"1");
            filList.add(fil2);
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("createorg");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a", (String)"ManuSupplyNewFieldPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject supOrg = (DynamicObject)this.getModel().getValue("supstockorgid");
            if (supOrg == null) {
                return;
            }
            Long prodOrg = supOrg.getLong("id");
            QFilter fil3 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)prodOrg);
            filList.add(fil3);
            Long[] wareSet = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)prodOrg);
            QFilter fil4 = new QFilter("id", "in", (Object)wareSet);
            filList.add(fil4);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(filList);
        }
        if ("suplocationid".equals(event.getProperty().getName())) {
            DynamicObject wareObj = (DynamicObject)this.getModel().getValue("supwarehouseid");
            if (wareObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u5e93\u4ed3\u5e93\u4e3a\u7a7a", (String)"ManuSupplyNewFieldPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long wareId = wareObj.getLong("id");
            QFilter fil = new QFilter("id", "=", (Object)wareId);
            DynamicObjectCollection wareData = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location", (QFilter[])new QFilter[]{fil});
            ArrayList<Long> nos = new ArrayList<Long>(16);
            for (int i = 0; i < wareData.size(); ++i) {
                nos.add(((DynamicObject)wareData.get(i)).getLong("entryentity.location"));
            }
            QFilter filLoc = new QFilter("id", "in", nos);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filLoc);
        }
        if ("supstockorgid".equals(event.getProperty().getName())) {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("createorg");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a", (String)"ManuSupplyNewFieldPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long orgId = orgObj.getLong("id");
            List<Long> ids = this.getSupOrgFilter(orgId);
            QFilter filOrg = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filOrg);
        }
        if ("configurecodeid".equals(event.getProperty().getName())) {
            QFilter filMatStatus = new QFilter("enable", "=", (Object)"1");
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filMatStatus);
        }
    }

    private List<Long> getSupOrgFilter(Long orgId) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        OrgRelationParam param = this.getOrgParam(orgId);
        Map relationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        if (relationMap != null && !relationMap.isEmpty() && relationMap.get("data") != null && ((ArrayList)relationMap.get("data")).size() != 0) {
            List ids = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            filterList.addAll(ids);
        }
        if (this.checkOrgIsProduce(orgId)) {
            filterList.add(orgId);
        }
        return filterList;
    }

    private boolean checkOrgIsProduce(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org", (String)"fisinventory");
        return dyOrg.getBoolean("fisinventory");
    }

    private OrgRelationParam getOrgParam(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("04");
        param.setToViewType("05");
        param.setDirectViewType("toorg");
        return param;
    }
}

