/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.common.errorcode.FMMErrorCode;

public class ManuVersionEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BASEUNIT_ID = "mftunit";
    private static final Log logger = LogFactory.getLog(ManuVersionEditPlugin.class);
    private boolean isIgnoreChangeListener = false;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        UnitEdit unitEdit = (UnitEdit)this.getView().getControl("unit");
        unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit processrouteEdit = (BasedataEdit)this.getView().getControl("processroute");
        processrouteEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultValue() {
        String enddate = "2999-12-31";
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            try {
                Date date = this.sdf.parse(enddate);
                this.getModel().setValue("enddate", (Object)date);
            }
            catch (ParseException e) {
                logger.info(e.toString());
                throw new KDBizException((Throwable)e, FMMErrorCode.DEFAULT_VALUE_ERROR, new Object[]{e.getMessage()});
            }
            this.getModel().setValue("begindate", (Object)new Date());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"unit", (CharSequence)fieldKey)) {
            if (this.checkFieldValueNull("material")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599", (String)"ManuVersionEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (this.checkFieldValueNull("unit")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u662f\u5426\u6b63\u786e\u3002", (String)"ManuVersionEditPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"processroute", (CharSequence)fieldKey)) {
            DynamicObject OrgDO;
            if (this.checkFieldValueNull("material")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599", (String)"ManuVersionEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject matDO = (DynamicObject)this.getModel().getValue("material");
            QFilter qfilter1 = this.getProcessRouteFilter(matDO, OrgDO = (DynamicObject)this.getModel().getValue("createorg"));
            if (qfilter1 != null) {
                showParameter.getListFilterParameter().getQFilters().add(qfilter1);
            }
        }
    }

    private QFilter getProcessRouteFilter(DynamicObject mftmaterial, DynamicObject org) {
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_route", (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)mftmaterial.getPkValue());
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObjectCollection materialgroup = mftmaterial.getDynamicObjectCollection("mftcontrolentry");
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (DynamicObject group : materialgroup) {
            grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
        }
        QFilter result = orgqFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter statusFilter = typeA.and(materialFilter);
        if (grouplist.size() > 0) {
            statusFilter.or(typeB.and(new QFilter("materialgroup", "in", grouplist)));
        }
        statusFilter.or(typeC);
        result.and(statusFilter);
        return result;
    }

    private boolean checkFieldValueNull(String fieldname) {
        Object value = this.getModel().getValue(fieldname);
        if (value != null) {
            String valuestr;
            if (value instanceof DynamicObject) {
                DynamicObject doValue = (DynamicObject)value;
                return doValue.getLong("id") <= 0L;
            }
            return value instanceof String && (StringUtils.isEmpty((CharSequence)(valuestr = (String)value)) || StringUtils.equalsIgnoreCase((CharSequence)valuestr, (CharSequence)"none"));
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.isIgnoreChangeListener) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        if ("beginqty".equalsIgnoreCase(propName) || "endqty".equalsIgnoreCase(propName)) {
            this.change4QtyRange(propName, newObj);
        } else if ("material".equalsIgnoreCase(propName) || "createorg".equalsIgnoreCase(propName)) {
            this.change4MateAndOrg(propName, newObj);
        }
    }

    private void change4MateAndOrg(String key, Object newObj) {
        this.getModel().setValue("bom", null);
        this.getModel().setValue("processroute", null);
        if (StringUtils.equals((CharSequence)key, (CharSequence)"material")) {
            if (newObj == null) {
                this.getModel().setValue("unit", null);
            } else {
                DynamicObject mate = (DynamicObject)newObj;
                DynamicObject baseunit = mate.getDynamicObject(BASEUNIT_ID);
                if (baseunit != null) {
                    this.getModel().setValue("unit", baseunit.getPkValue());
                }
            }
        }
    }

    private void change4QtyRange(String key, Object newObj) {
        if (newObj == null) {
            return;
        }
        if (newObj instanceof BigDecimal) {
            BigDecimal beginqty;
            this.isIgnoreChangeListener = true;
            BigDecimal qty = (BigDecimal)newObj;
            if (StringUtils.equals((CharSequence)"beginqty", (CharSequence)key)) {
                BigDecimal endqty = (BigDecimal)this.getModel().getValue("endqty");
                if (endqty != null && qty.compareTo(endqty) >= 0) {
                    this.getModel().setValue("endqty", null);
                }
            } else if (StringUtils.equals((CharSequence)"endqty", (CharSequence)key) && (beginqty = (BigDecimal)this.getModel().getValue("beginqty")) != null && qty.compareTo(beginqty) <= 0) {
                this.getModel().setValue("beginqty", null);
            }
            this.isIgnoreChangeListener = false;
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        int ordinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty("begindate").getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
    }
}

