/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OutSourceQuotaCategoryListPlugin
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("setdefault".equals(itemKey)) {
            this.setDefaultTpl();
            this.refreshList();
        }
    }

    private void setDefaultTpl() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (!selectedRows.isEmpty()) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OutSourceQuotaCategoryListPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            } else {
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                Long categoryId = (Long)listSelectedRow.getPrimaryKeyValue();
                DynamicObject categoryObj = BusinessDataServiceHelper.loadSingle((Object)categoryId, (String)"pm_quotacategory");
                if (categoryObj != null && categoryObj.getBoolean("isdefault")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5df2\u8bbe\u4e3a\u9ed8\u8ba4\u914d\u989d\u7c7b\u578b\u3002", (String)"OutSourceQuotaCategoryListPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                } else {
                    OutSourceQuotaCategoryListPlugin.setDefaultQuotaCategory(categoryId);
                }
            }
        }
    }

    public static void setDefaultQuotaCategory(Long billTypeId) {
        String defaultSql = "UPDATE t_fmm_quotacategory SET fisdefault = 1 WHERE fid = ? ";
        String otherSql = "UPDATE t_fmm_quotacategory SET fisdefault = 0 WHERE fid <> ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)billTypeId)};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)defaultSql, (Object[])params);
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)otherSql, (Object[])params);
        }
        catch (Throwable var19) {
            if (var19 instanceof KDException) {
                throw (KDException)var19;
            }
            if (var19 instanceof OrmException) {
                throw (OrmException)var19;
            }
            throw new KDException(var19, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", var19.getMessage())});
        }
    }

    private void refreshList() {
        ListView view = (ListView)this.getView();
        view.refresh();
    }
}

