/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class OutSourceQuotaImportPlugin
extends AbstractBasePlugIn {
    private Map<String, Object> importTempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        HashSet<String> orgNumberSet = new HashSet<String>();
        HashSet<String> quotTypeNumberSet = new HashSet<String>();
        for (Map bill : sourceDataList) {
            String quotaTypeImportProp;
            Map quotaCategoryMap;
            Map orgMap = (Map)bill.get("org");
            String orgImportProp = (String)orgMap.get("importprop");
            if ("number".equals(orgImportProp)) {
                orgNumberSet.add((String)orgMap.get("number"));
            }
            if ((quotaCategoryMap = (Map)bill.get("quotacategory")) == null || !"number".equals(quotaTypeImportProp = (String)quotaCategoryMap.get("importprop"))) continue;
            quotTypeNumberSet.add((String)quotaCategoryMap.get("number"));
        }
        Map orgMapFromDb = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "in", orgNumberSet).toArray());
        HashMap<String, Set<String>> orgProcedureMap = new HashMap<String, Set<String>>(orgMapFromDb.size());
        for (DynamicObject org : orgMapFromDb.values()) {
            Object pkValue = org.getPkValue();
            Set<String> procedureNumberSet = this.getProcedureNumberByOrg((Long)pkValue);
            orgProcedureMap.put(org.getString("number"), procedureNumberSet);
        }
        this.importTempCache.put("procedure", orgProcedureMap);
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject defaultQuotaCategory = BusinessDataServiceHelper.loadSingle((String)"fmm_quotacategory", (String)"number,condimensionjson", (QFilter[])new QFilter[]{isDefault, enable});
        if (defaultQuotaCategory != null) {
            this.importTempCache.put("defaultquotacategory", defaultQuotaCategory.getString("number"));
        }
        Map quotaCategoryMapFromDb = BusinessDataServiceHelper.loadFromCache((String)"fmm_quotacategory", (String)"id,number,condimensionjson", (QFilter[])new QFilter("number", "in", quotTypeNumberSet).and(new QFilter("enable", "=", (Object)"1")).toArray());
        HashMap<String, Set> quotaCategoryMap = new HashMap<String, Set>(16);
        for (DynamicObject category : quotaCategoryMapFromDb.values()) {
            String conDimensionJson = category.getString("condimensionjson");
            Set quotaCategoryNumberSet = (Set)JSON.parseObject((String)conDimensionJson, Set.class);
            quotaCategoryMap.put(category.getString("number"), quotaCategoryNumberSet);
        }
        if (defaultQuotaCategory != null) {
            String conDimensionJson = defaultQuotaCategory.getString("condimensionjson");
            Set quotaCategoryNumberSet = (Set)JSON.parseObject((String)conDimensionJson, Set.class);
            quotaCategoryMap.put(defaultQuotaCategory.getString("number"), quotaCategoryNumberSet);
        }
        this.importTempCache.put("dimension", quotaCategoryMap);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String procedureImportProp;
        String categoryNumber;
        boolean cancel = false;
        Map sourceData = e.getSourceData();
        Map orgMap = (Map)sourceData.get("org");
        HashMap<String, String> quotaCategory = (HashMap<String, String>)sourceData.get("quotacategory");
        if (quotaCategory == null && StringUtils.isNotEmpty((String)(categoryNumber = (String)this.importTempCache.get("defaultquotacategory")))) {
            quotaCategory = new HashMap<String, String>();
            quotaCategory.put("importprop", "number");
            quotaCategory.put("number", categoryNumber);
            sourceData.put("quotacategory", quotaCategory);
        }
        if (quotaCategory != null) {
            String quotaCategoryNumber = (String)quotaCategory.get("number");
            Map dimension = (Map)this.importTempCache.get("dimension");
            if (dimension != null && StringUtils.isNotEmpty((String)quotaCategoryNumber)) {
                Set fields = (Set)dimension.get(quotaCategoryNumber);
                if (fields == null) {
                    cancel = true;
                    String msg = ResManager.loadKDString((String)"\u914d\u989d\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"OutSourceQuotaImportPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), msg);
                } else {
                    List entryentity = (List)sourceData.get("entryentity");
                    if (entryentity != null) {
                        for (int i = 0; i < entryentity.size(); ++i) {
                            Map entry = (Map)entryentity.get(i);
                            Map procedure = (Map)entry.get("procedure");
                            String procedureNumber = null;
                            if (procedure != null && "number".equals(procedureImportProp = (String)procedure.get("importprop"))) {
                                procedureNumber = (String)procedure.get("number");
                            }
                            if ("GXWWPE-002".equals(quotaCategoryNumber)) {
                                if (!StringUtils.isEmpty(procedureNumber)) continue;
                                cancel = true;
                                String msg = ResManager.loadKDString((String)"\u914d\u989d\u7c7b\u578b\u4e3a\u5de5\u5e8f\u59d4\u5916\u914d\u989d\u65f6\uff0c\u5de5\u5e8f\u5fc5\u987b\u5f55\u5165\u3002", (String)"OutSourceQuotaImportPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), msg);
                                continue;
                            }
                            entry.put("procedure", null);
                        }
                    }
                }
            }
        }
        if (orgMap != null) {
            String orgImportProp = (String)orgMap.get("importprop");
            Map orgProcedureMap = (Map)this.importTempCache.get("procedure");
            if ("number".equals(orgImportProp)) {
                String orgNumber = (String)orgMap.get("number");
                Set procedureNumberSet = (Set)orgProcedureMap.get(orgNumber);
                List entryentity = (List)sourceData.get("entryentity");
                if (entryentity != null) {
                    for (int i = 0; i < entryentity.size(); ++i) {
                        String procedureNumber;
                        Map entry = (Map)entryentity.get(i);
                        Map procedure = (Map)entry.get("procedure");
                        if (procedure == null || !"number".equals(procedureImportProp = (String)procedure.get("importprop")) || !StringUtils.isNotEmpty((String)(procedureNumber = (String)procedure.get("number"))) || procedureNumberSet.contains(procedureNumber)) continue;
                        cancel = true;
                        String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u5de5\u5e8f", (String)"OutSourceQuotaImportPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), procedureNumber);
                        e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), msg);
                    }
                }
            }
        }
        if (cancel) {
            e.setCancel(true);
            e.setFireAfterImportData(false);
        }
    }

    private Set<String> getProcedureNumberByOrg(Long pkValue) {
        QFilter filter;
        HashSet<String> procedureNumberSet = new HashSet<String>(16);
        OrgRelationParam orgRelationParam = new OrgRelationParam();
        orgRelationParam.setFromViewType(null);
        orgRelationParam.setToViewType("02");
        orgRelationParam.setOrgId(pkValue.longValue());
        orgRelationParam.setDirectViewType("fromorg");
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)orgRelationParam);
        if (bizRelationOrgIds != null && bizRelationOrgIds.size() > 0 && (filter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workprocedure", (List)bizRelationOrgIds, (boolean)true)) != null) {
            filter.and(new QFilter("enable", "=", (Object)"1"));
            Map procedureMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workprocedure", (String)"number", (QFilter[])filter.toArray());
            if (procedureMap != null && procedureMap.size() > 0) {
                for (DynamicObject procedure : procedureMap.values()) {
                    String number = procedure.getString("number");
                    procedureNumberSet.add(number);
                }
            }
        }
        return procedureNumberSet;
    }
}

