/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkTypeTreeSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        EntryGrid worktptree = (EntryGrid)this.getControl("worktptree");
        worktptree.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter filter1 = new QFilter("status", "=", (Object)"C");
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        String fileds = "id,number,name,mainwktp,parent.id,parent.name";
        DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)"fmm_dispatchwktp", (String)fileds, (QFilter[])new QFilter[]{filter1, filter2});
        if (dataCollection != null && dataCollection.size() > 0) {
            Map<Long, List<DynamicObject>> tdata = this.getTreeData(dataCollection);
            this.setTree(tdata);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formParameter = this.getView().getFormShowParameter();
        String selectedData = (String)formParameter.getCustomParam("selectedData");
        Set data = null;
        if (selectedData != null) {
            data = (Set)SerializationUtils.fromJsonString((String)selectedData, Set.class);
        }
        this.setMiantypeChoosed(data);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            String str = this.getReturnStr();
            this.getView().returnDataToParent((Object)str);
            this.getView().close();
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryControl = (EntryGrid)this.getControl("worktptree");
        int[] currSelectRows = entryControl.getSelectRows();
        Set<Integer> selectEntry = this.getSelectEntry();
        int count = Integer.parseInt(this.getPageCache().get("count"));
        if (currSelectRows.length == 0) {
            selectEntry.clear();
            this.putSelectEntry(selectEntry);
            return;
        }
        if (currSelectRows.length == count) {
            for (int x : currSelectRows) {
                selectEntry.add(x);
            }
            entryControl.selectRows(currSelectRows, 0);
            this.putSelectEntry(selectEntry);
            return;
        }
        if (Math.abs(currSelectRows.length - selectEntry.size()) == 1) {
            int row = this.getRow(selectEntry, currSelectRows);
            int prow = (Integer)this.getModel().getValue("fparentnumber", row);
            DynamicObject dyobj = (DynamicObject)this.getModel().getValue("fworkingtype", row);
            long id = dyobj.getLong("id");
            if (prow == -1 && currSelectRows.length < selectEntry.size()) {
                this.canCelChildRow(id, row, prow, selectEntry);
            } else if (prow != -1 && currSelectRows.length > selectEntry.size()) {
                this.chooseParentRow(prow, row, selectEntry);
            }
        } else {
            HashSet<Integer> set = new HashSet<Integer>(currSelectRows.length);
            for (int x : currSelectRows) {
                set.add(x);
            }
            this.putSelectEntry(set);
        }
    }

    protected int getRow(Set<Integer> selectEntry, int[] currSelectRows) {
        int row = -1;
        if (selectEntry.size() > currSelectRows.length) {
            for (int x : selectEntry) {
                boolean flag = false;
                for (int y : currSelectRows) {
                    if (x != y) continue;
                    flag = true;
                }
                if (flag) continue;
                row = x;
                break;
            }
        } else {
            for (int x : currSelectRows) {
                if (selectEntry.contains(x)) continue;
                row = x;
                break;
            }
        }
        return row;
    }

    protected void canCelChildRow(long id, int r, int pr, Set<Integer> selectEntry) {
        String str = String.valueOf(id);
        Map<Object, List<Integer>> relationMap = this.getRelationMap();
        List<Integer> child = relationMap.get(str);
        if (child != null && child.size() > 0) {
            HashSet<Integer> rows = new HashSet<Integer>();
            for (int x : selectEntry) {
                if (child.contains(x) || x == r) continue;
                rows.add(x);
            }
            int[] newSelectRow = new int[rows.size()];
            int i = 0;
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                int y = (Integer)iterator.next();
                newSelectRow[i++] = y;
            }
            EntryGrid entry = (EntryGrid)this.getControl("worktptree");
            entry.selectRows(newSelectRow, r);
            this.putSelectEntry(rows);
        }
    }

    protected void chooseParentRow(int prow, int row, Set<Integer> selectEntry) {
        selectEntry.add(row);
        if (prow != -1) {
            selectEntry.add(prow);
        }
        int[] rows = new int[selectEntry.size()];
        int i = 0;
        for (int r : selectEntry) {
            rows[i++] = r;
        }
        EntryGrid entryCol = (EntryGrid)this.getControl("worktptree");
        entryCol.selectRows(rows, row);
        this.putSelectEntry(selectEntry);
    }

    protected void setTree(Map<Long, List<DynamicObject>> tdata) {
        List<DynamicObject> parent = tdata.get(-1L);
        int row = 0;
        HashMap<Long, List<Integer>> relation = new HashMap<Long, List<Integer>>();
        for (DynamicObject pobj : parent) {
            this.getModel().createNewEntryRow("worktptree");
            long pid = pobj.getLong("id");
            boolean mainwktp = pobj.getBoolean("mainwktp");
            this.getModel().setValue("fworkingtype", (Object)pid, row);
            this.getModel().setValue("fparentnumber", (Object)-1, row);
            if (mainwktp) {
                this.getModel().setValue("fmainworktp", (Object)true, row);
            }
            ++row;
            List<DynamicObject> child = tdata.get(pid);
            if (child == null || child.size() <= 0) continue;
            ArrayList<Integer> clist = new ArrayList<Integer>();
            relation.put(pid, clist);
            row = this.setTreeNode(row, child, clist);
        }
        this.getPageCache().put("count", String.valueOf(row));
        this.putRelationMap(relation);
    }

    protected int setTreeNode(int row, List<DynamicObject> child, List<Integer> clist) {
        int crow = row;
        for (DynamicObject cobj : child) {
            this.getModel().insertEntryRow("worktptree", row - 1);
            long cid = cobj.getLong("id");
            this.getModel().setValue("fworkingtype", (Object)cid, crow);
            this.getModel().setValue("fparentnumber", (Object)(row - 1), crow);
            clist.add(crow);
            ++crow;
        }
        return crow;
    }

    protected Map<Long, List<DynamicObject>> getTreeData(DynamicObjectCollection dataCollection) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        result.put(-1L, new ArrayList());
        for (DynamicObject dyobj : dataCollection) {
            long pid = dyobj.getLong("parent.id");
            if (pid > 0L) {
                if (result.containsKey(pid)) {
                    ((List)result.get(pid)).add(dyobj);
                    continue;
                }
                ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>();
                temp.add(dyobj);
                result.put(pid, temp);
                continue;
            }
            ((List)result.get(-1L)).add(dyobj);
        }
        return result;
    }

    protected void putSelectEntry(Set<Integer> selectSet) {
        this.getPageCache().put("selectEntry", SerializationUtils.toJsonString(selectSet));
    }

    protected Set<Integer> getSelectEntry() {
        Set<Integer> selectSet = new HashSet<Integer>(16);
        String selectEntry = this.getPageCache().get("selectEntry");
        if (StringUtils.isNotEmpty((CharSequence)selectEntry)) {
            selectSet = (Set)SerializationUtils.fromJsonString((String)selectEntry, Set.class);
        }
        return selectSet;
    }

    protected Map<Object, List<Integer>> getRelationMap() {
        Map<Object, List<Integer>> relationMap = new HashMap<Object, List<Integer>>(16);
        String rMap = this.getPageCache().get("relatonMap");
        if (StringUtils.isNotEmpty((CharSequence)rMap)) {
            relationMap = (Map)SerializationUtils.fromJsonString((String)rMap, Map.class);
        }
        return relationMap;
    }

    protected void putRelationMap(Map<Long, List<Integer>> relationMap) {
        this.getPageCache().put("relatonMap", SerializationUtils.toJsonString(relationMap));
    }

    protected String getReturnStr() {
        EntryGrid entryControl = (EntryGrid)this.getControl("worktptree");
        int[] selectRows = entryControl.getSelectRows();
        StringBuilder sb = new StringBuilder();
        if (selectRows.length > 0) {
            DynamicObject dyobj = (DynamicObject)this.getModel().getValue("fworkingtype", selectRows[0]);
            sb.append(dyobj.getLong("id"));
            for (int i = 1; i < selectRows.length; ++i) {
                dyobj = (DynamicObject)this.getModel().getValue("fworkingtype", selectRows[i]);
                sb.append("-").append(dyobj.getLong("id"));
            }
        }
        return sb.toString();
    }

    protected void setMiantypeChoosed(Set<Long> data) {
        boolean flag = data != null && data.size() > 0;
        int rowCount = this.getModel().getEntryRowCount("worktptree");
        HashSet<Integer> selectRows = new HashSet<Integer>(16);
        for (int i = 0; i < rowCount; ++i) {
            long id;
            boolean fmainworktp = (Boolean)this.getModel().getValue("fmainworktp", i);
            if (fmainworktp) {
                selectRows.add(i);
                if (!flag) break;
            }
            if (!flag || !data.contains(id = ((DynamicObject)this.getModel().getValue("fworkingtype", i)).getLong("id"))) continue;
            selectRows.add(i);
        }
        if (selectRows.size() > 0) {
            int[] selected = new int[selectRows.size()];
            int i = 0;
            Iterator id = selectRows.iterator();
            while (id.hasNext()) {
                int x = (Integer)id.next();
                selected[i++] = x;
            }
            EntryGrid entry = (EntryGrid)this.getControl("worktptree");
            entry.selectRows(selected, 0);
            this.putSelectEntry(selectRows);
        }
    }
}

