/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkingGroupPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit bgc = (TextEdit)this.getControl("bgcolor");
        bgc.addButtonClickListener((ClickListener)this);
        TextEdit fc = (TextEdit)this.getControl("fontcolor");
        fc.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"tabap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        boolean flag = false;
        flag = "bgcolor".equals(key);
        if (flag || "fontcolor".equals(key)) {
            String currTagStr = flag ? "bgcolor_save" : "fontcolor_save";
            this.openColorChoose(key, currTagStr);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("importmsg".equals(operationKey)) {
            this.openWorkTypeChoose();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount("worktpentry");
        DynamicObject[] entryEntity = this.getModel().getEntryEntity("worktpentry", 0, rowCount);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(16);
        for (int i = 0; i < entryEntity.length; ++i) {
            String colorStr;
            boolean mainworktp = entryEntity[i].getBoolean("mainworktp");
            if (mainworktp) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryenable"});
            }
            colorStr = (colorStr = entryEntity[i].getString("bgcolor_save")) == null ? "#ffffff" : colorStr;
            styles.add(this.getBackGroundColorCell("bgcolor", colorStr, i));
            colorStr = entryEntity[i].getString("fontcolor_save");
            colorStr = colorStr == null ? "#ffffff" : colorStr;
            styles.add(this.getBackGroundColorCell("fontcolor", colorStr, i));
        }
        EntryGrid control = (EntryGrid)this.getControl("worktpentry");
        control.setCellStyle(styles);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        boolean flag = false;
        if ("grouptype".equals(name)) {
            this.setIsRequre(newValue);
        } else if ("worktype".equals(name)) {
            this.setWorkTpRowData(changeSet.getRowIndex(), newValue);
        } else {
            flag = "fontcolor_save".equals(name);
            if (flag || "bgcolor_save".equals(name)) {
                String currColor = flag ? "fontcolor" : "bgcolor";
                CellStyle c = this.getBackGroundColorCell(currColor, newValue, changeSet.getRowIndex());
                EntryGrid control = (EntryGrid)this.getControl("worktpentry");
                ArrayList<CellStyle> list = new ArrayList<CellStyle>();
                list.add(c);
                control.setCellStyle(list);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent cevt) {
        super.closedCallBack(cevt);
        String actionId = cevt.getActionId();
        Object returnData = cevt.getReturnData();
        if ("bgcolor".equals(actionId) || "fontcolor".equals(actionId)) {
            boolean flag = false;
            if (returnData != null && ((flag = "bgcolor".equals(actionId)) || "fontcolor".equals(actionId))) {
                String currStr = flag ? "bgcolor_save" : "fontcolor_save";
                this.getModel().setValue(currStr, (Object)((String)returnData));
            }
        } else if ("importmsg".equals(actionId)) {
            this.workTypeCloseSet(returnData);
        }
    }

    protected void workTypeCloseSet(Object returnData) {
        if (returnData != null) {
            this.getModel().deleteEntryData("worktpentry");
            String[] idStr = ((String)returnData).split("-");
            long[] ids = new long[idStr.length];
            int i = 0;
            for (String s : idStr) {
                if (s == null || s.length() <= 0) continue;
                ids[i++] = Long.parseLong(s);
            }
            String fileds = "id,name,number,parent.name,fontcolor,bgcolor,mainwktp";
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection data = QueryServiceHelper.query((String)"fmm_dispatchwktp", (String)fileds, (QFilter[])new QFilter[]{filter});
            this.setEntryData(data);
        }
    }

    protected void setEntryData(DynamicObjectCollection data) {
        if (data != null && data.size() > 0) {
            int[] indexs = this.getModel().batchCreateNewEntryRow("worktpentry", data.size());
            int i = 0;
            for (DynamicObject dyobj : data) {
                this.getModel().setValue("worktype", (Object)dyobj.getLong("id"), indexs[i]);
                boolean mainworktp = dyobj.getBoolean("mainwktp");
                if (mainworktp) {
                    this.getView().setEnable(Boolean.valueOf(false), indexs[i], new String[]{"entryenable"});
                }
                this.getModel().setValue("mainworktp", (Object)mainworktp, indexs[i]);
                this.getModel().setValue("bgcolor_save", (Object)dyobj.getString("bgcolor"), indexs[i]);
                this.getModel().setValue("fontcolor_save", (Object)dyobj.getString("fontcolor"), indexs[i]);
                ++i;
            }
        }
    }

    protected void openWorkTypeChoose() {
        FormShowParameter formShowParameter = new FormShowParameter();
        Set<Long> selectData = this.getAllDataId();
        formShowParameter.setCustomParam("selectedData", (Object)SerializationUtils.toJsonString(selectData));
        formShowParameter.setFormId("fmm_dispatchwktp_select");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importmsg"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    protected void openColorChoose(String key, String currTagStr) {
        Object value = this.getModel().getValue(currTagStr);
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("color", value);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mpdm_color_selector");
        formShowParameter.setHasRight(true);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(false);
        formShowParameter.setShowClose(false);
        this.getView().showForm(formShowParameter);
    }

    protected CellStyle getBackGroundColorCell(String currColor, Object newValue, int rowIndex) {
        CellStyle c = new CellStyle();
        c.setBackColor((String)newValue);
        c.setFieldKey(currColor);
        c.setRow(rowIndex);
        return c;
    }

    protected void setWorkTpRowData(int rowIndex, Object newValue) {
        if (newValue != null) {
            DynamicObject dyNew = (DynamicObject)newValue;
            boolean mainwktp = dyNew.getBoolean("mainwktp");
            String bgcolor = dyNew.getString("bgcolor");
            String fontcolor = dyNew.getString("fontcolor");
            this.getModel().setValue("mainworktp", (Object)mainwktp, rowIndex);
            this.getModel().setValue("bgcolor_save", (Object)bgcolor, rowIndex);
            this.getModel().setValue("fontcolor_save", (Object)fontcolor, rowIndex);
        }
    }

    protected void setIsRequre(Object newValue) {
        BasedataEdit bde = (BasedataEdit)this.getView().getControl("industry");
        BasedataProp bdp = (BasedataProp)bde.getProperty();
        if (newValue != null) {
            DynamicObject dyNew = (DynamicObject)newValue;
            String number = dyNew.getString("number");
            if (!StringUtils.isEmpty((CharSequence)number) && "PRODUCTION_GP_S".equals(number)) {
                bde.setMustInput(true);
                bdp.setMustInput(true);
            } else {
                bde.setMustInput(false);
                bdp.setMustInput(false);
            }
        } else {
            bde.setMustInput(false);
            bdp.setMustInput(false);
        }
    }

    protected Set<Long> getAllDataId() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("worktpentry");
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject dyobj : entryEntity) {
            DynamicObject temp = (DynamicObject)dyobj.get("worktype");
            set.add(temp.getLong("id"));
        }
        return set;
    }
}

