/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.factorymodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class DefaultOrgPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object obj = this.getModel().getValue("callinorg");
        FieldEdit callinwarehouse = (FieldEdit)this.getView().getControl("callinwarehouse");
        if (obj != null) {
            callinwarehouse.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"callinwarehouse", (CharSequence)propertyName)) {
            this.getModel().setValue("callinlocation", null);
        }
        if (StringUtils.equals((CharSequence)"callinorg", (CharSequence)propertyName)) {
            Object obj = this.getModel().getValue("callinorg");
            FieldEdit callinwarehouse = (FieldEdit)this.getView().getControl("callinwarehouse");
            this.getModel().setValue("callinwarehouse", null);
            if (obj != null) {
                callinwarehouse.setMustInput(true);
            } else {
                callinwarehouse.setMustInput(false);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit callInOrg = (BasedataEdit)this.getView().getControl("callinorg");
        BasedataEdit callInWarehouse = (BasedataEdit)this.getView().getControl("callinwarehouse");
        BasedataEdit callInLocation = (BasedataEdit)this.getView().getControl("callinlocation");
        callInOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        callInWarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        callInLocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "callinorg": {
                this.beforeCallInOrgF7(e, showParameter);
                break;
            }
            case "callinwarehouse": {
                this.beforeCallInWarehouseF7(e, showParameter);
                break;
            }
            case "callinlocation": {
                this.beforeCallInLocationF7(e);
            }
        }
    }

    private void beforeCallInOrgF7(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        if (this.getModel().getValue("createorg") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"DefaultOrgPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject callInOrg = (DynamicObject)this.getModel().getValue("createorg");
        List idList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)callInOrg.getPkValue()));
        if (idList.isEmpty() || idList.size() == 1 && idList.contains(callInOrg.getPkValue())) {
            return;
        }
        if (callInOrg.getBoolean("fisinventory")) {
            idList.add((Long)callInOrg.getPkValue());
        }
        showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
    }

    private void beforeCallInWarehouseF7(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject callInOrg = (DynamicObject)this.getModel().getValue("callinorg");
        if (callInOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u8c03\u5165\u5e93\u5b58\u7ec4\u7ec7\u201d\u3002", (String)"DefaultOrgPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter orgFilter = new QFilter("org.id", "=", callInOrg.getPkValue());
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"B");
        QFilter qfilter = new QFilter("startstatus", "=", (Object)"B");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection col = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgFilter, initstatusFilter, qfilter, enableFilter});
        ArrayList<Object> obj = new ArrayList<Object>();
        for (int i = 0; i < col.size(); ++i) {
            obj.add(((DynamicObject)col.get(i)).get("warehouse.id"));
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", obj));
    }

    private void beforeCallInLocationF7(BeforeF7SelectEvent e) {
        DynamicObject callInWarehouse = (DynamicObject)this.getModel().getValue("callinwarehouse");
        if (callInWarehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8c03\u5165\u4ed3\u5e93\uff0c\u518d\u5f55\u5165\u8c03\u51fa\u4ed3\u5e93\u3002", (String)"DefaultOrgPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.setLocationFilter(callInWarehouse.getLong("id"), e);
    }

    private void setLocationFilter(Long warehouseId, BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseId, (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : col) {
            DynamicObject location = dynamicObject.getDynamicObject("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        if (!locationList.isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", locationList);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }
}

