/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.formula;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ProductLineOperationFormPlugin
extends AbstractFormPlugin
implements IDataModelListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit product;
        super.registerListener(e);
        this.addClickListeners(new String[]{"parent_sequence_new"});
        this.addItemClickListeners(new String[]{"bar_save"});
        BasedataEdit sequence = (BasedataEdit)this.getControl("step_sequence_num");
        if (sequence != null) {
            sequence.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((product = (BasedataEdit)this.getControl("product_line")) != null) {
            product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.numOnlyCheck(args);
            this.productLineOnlyCheck(args);
        } else if ("deleteentry".equals(operateKey)) {
            this.deleteEntryCheck(args);
        }
    }

    private void deleteEntryCheck(BeforeDoOperationEventArgs args) {
        int[] selectRows;
        DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
        ArrayList parentSequences = new ArrayList();
        proseqEntryentity.forEach(entryRow -> parentSequences.add(entryRow.getString("parent_sequence_new")));
        EntryGrid proseqEntryentityControl = (EntryGrid)this.getControl("proseq_entryentity");
        for (int selectRow : selectRows = proseqEntryentityControl.getSelectRows()) {
            DynamicObject selectEntryRow = (DynamicObject)proseqEntryentity.get(selectRow);
            String stepSequenceSeq = String.valueOf(selectEntryRow.getInt("step_sequence_seq"));
            if (!parentSequences.contains(stepSequenceSeq)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f/\u9636\u6bb5\u5e8f\u53f7\u201c%s\u201d\u5df2\u7ecf\u88ab\u201c\u4e0a\u4e00\u7ea7\u5de5\u5e8f\u53f7\u201d\u5f15\u7528\u7684\u5de5\u5e8f /\u9636\u6bb5\u4e0d\u5141\u8bb8\u5220\u884c\u3002", (String)"ProductLineOperationFormPlugin_03", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), stepSequenceSeq));
            args.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("step_sequence_seq".equals(name)) {
            this.chenkEntitySeqOnlyOne(e);
            this.changeSeqCheck(changeSet);
        } else if ("step_sequence_num".equals(name)) {
            this.setMilestoneFromStepNum(changeSet);
        }
    }

    private void changeSeqCheck(ChangeData[] changeSet) {
        String oldValue = String.valueOf(changeSet[0].getOldValue());
        DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
        ArrayList parentSequences = new ArrayList();
        proseqEntryentity.forEach(entryRow -> parentSequences.add(entryRow.getString("parent_sequence_new")));
        EntryGrid proseqEntryentityControl = (EntryGrid)this.getControl("proseq_entryentity");
        int[] selectRows = proseqEntryentityControl.getSelectRows();
        if (parentSequences.contains(oldValue)) {
            this.getModel().setValue("step_sequence_seq", (Object)oldValue, selectRows[0]);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f/\u9636\u6bb5\u5e8f\u53f7\u201c%s\u201d\u5df2\u7ecf\u88ab\u201c\u4e0a\u4e00\u7ea7\u5de5\u5e8f\u53f7\u201d\u5f15\u7528\u7684\u5de5\u5e8f /\u9636\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProductLineOperationFormPlugin_04", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), oldValue));
        }
    }

    private void productLineOnlyCheck(BeforeDoOperationEventArgs args) {
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        long createorgId = createorg.getLong("id");
        DynamicObject productLine = (DynamicObject)this.getModel().getValue("product_line");
        if (productLine == null) {
            return;
        }
        Long productLineId = productLine.getLong("id");
        ArrayList<String> stutas = new ArrayList<String>(2);
        stutas.add("B");
        stutas.add("C");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fmm_productline_opera", (Long)createorgId);
        QFilter statusFilter = new QFilter("status", "in", stutas);
        QFilter productLineIdFilter = new QFilter("product_line", "=", (Object)productLineId);
        if (QueryServiceHelper.exists((String)"fmm_productline_opera", (QFilter[])new QFilter[]{orgFilter, statusFilter, productLineIdFilter})) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u201c\u751f\u4ea7\u7ebf\u201d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductLineOperationFormPlugin_05", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]));
            args.setCancel(true);
        }
    }

    private void numOnlyCheck(BeforeDoOperationEventArgs args) {
        DynamicObject[] load;
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        long createorgId = createorg.getLong("id");
        String newNum = (String)this.getModel().getValue("number");
        ArrayList<String> stutas = new ArrayList<String>(2);
        stutas.add("B");
        stutas.add("C");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fmm_productline_opera", (Long)createorgId);
        QFilter statusFilter = new QFilter("status", "in", stutas);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"fmm_productline_opera", (String)"number", (QFilter[])new QFilter[]{orgFilter.and(statusFilter)})) {
            String number = dynamicObject.getString("number");
            if (!number.equals(newNum)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0b\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductLineOperationFormPlugin_01", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), number));
            args.setCancel(true);
            break;
        }
    }

    private void setMilestoneFromStepNum(ChangeData[] changeSet) {
        int seq = changeSet[0].getDataEntity().getInt("seq") - 1;
        DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
        DynamicObject selectRowDynamic = (DynamicObject)proseqEntryentity.get(seq);
        DynamicObject stepSequenceNum = selectRowDynamic.getDynamicObject("step_sequence_num");
        if (stepSequenceNum != null) {
            Boolean ismilestoneprocess = stepSequenceNum.getBoolean("ismilestoneprocess");
            this.getModel().setValue("milestone", (Object)ismilestoneprocess, seq);
        } else {
            this.getModel().setValue("milestone", (Object)false, seq);
        }
    }

    private void chenkEntitySeqOnlyOne(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
        Integer newValue = (Integer)changeSet[0].getNewValue();
        if (newValue == 0) {
            return;
        }
        int rowIndex = changeSet[0].getRowIndex() + 1;
        ArrayList<Integer> seqs = new ArrayList<Integer>();
        for (DynamicObject dynamicObject : proseqEntryentity) {
            int sequenceSeq = dynamicObject.getInt("step_sequence_seq");
            int seq = dynamicObject.getInt("seq");
            if (seq == rowIndex) continue;
            seqs.add(sequenceSeq);
        }
        if (seqs.contains(newValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f/\u9636\u6bb5\u5e8f\u53f7\u201d\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductLineOperationFormPlugin_02", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("parent_sequence_new".equals(key)) {
            this.openParentOperation();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("parentLine".equals(actionId)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            EntryGrid entryentity = (EntryGrid)this.getControl("proseq_entryentity");
            int[] selectRows = entryentity.getSelectRows();
            this.getModel().setValue("parent_sequence_new", (Object)returnData, selectRows[0]);
        }
    }

    private void newEntryPlusTen(RowDataEntity[] rowDataEntities) {
        for (RowDataEntity rowData : rowDataEntities) {
            int rowIndex = rowData.getRowIndex();
            DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
            ArrayList seqs = new ArrayList();
            proseqEntryentity.forEach(dynamicObject -> {
                long stepSequenceSeq = dynamicObject.getLong("step_sequence_seq");
                seqs.add(stepSequenceSeq);
            });
            Optional<Long> max = seqs.stream().max(Comparator.comparing(Long::longValue));
            Long maxValue = max.get();
            Integer stepSequenceSeq = (Integer)this.getModel().getValue("step_sequence_seq", rowIndex);
            if (stepSequenceSeq != 0) continue;
            this.getModel().setValue("step_sequence_seq", (Object)(maxValue + 10L), rowIndex);
        }
    }

    private void openParentOperation() {
        EntryGrid proseqEntryentity1 = (EntryGrid)this.getControl("proseq_entryentity");
        int[] selectRows = proseqEntryentity1.getSelectRows();
        int i = selectRows[0];
        DynamicObjectCollection proseqEntryentity = this.getModel().getEntryEntity("proseq_entryentity");
        DynamicObject selectDynamic = (DynamicObject)proseqEntryentity.get(i);
        boolean stepBoolean = selectDynamic.getBoolean("step");
        if (stepBoolean) {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            proseqEntryentity.forEach(dynamicObject -> {
                boolean step = dynamicObject.getBoolean("step");
                if (!step) {
                    dynamicObjectCollection.add(dynamicObject);
                }
            });
            HashMap<String, DynamicObjectCollection> customParams = new HashMap<String, DynamicObjectCollection>();
            customParams.put("entity", dynamicObjectCollection);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("fmm_parent_productline");
            formShowParameter.setCustomParams(customParams);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "parentLine"));
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(openStyle);
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        this.newEntryPlusTen(rowDataEntities);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if ("step_sequence_num".equals(name)) {
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
            long createorgId = createorg.getLong("id");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workprocedure", (Long)createorgId));
            e.setCustomQFilters(qFilters);
        } else if ("product_line".equals(name)) {
            this.setF7Filter(e);
        }
    }

    private void setF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        String title = ResManager.loadKDString((String)"\u751f\u4ea7\u7ebf\u5b9a\u4e49", (String)"ProductLineDefFormPlugin_01", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(title);
        e.setFormShowParameter((FormShowParameter)formShowParameter);
    }
}

