/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.common.constants.MFTBOMConst;

public class BomImportPlugIn
extends AbstractBillPlugIn {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_NAME = "name";
    private static final String KEY_STATUS = "status";
    private static final String KEY_MATERIALID = "materialid";
    private static final String KEY_REPBOM = "repbom";
    private static final String KEY_REPACENO = "replaceno";
    private static final String KEY_CONFIGCODE = "configuredcode";
    private static final String KEY_WBS = "wbs";
    private static final String KEY_ENTRYMATERIALID = "entrymaterialid";
    private static final String KEY_ENTRYISJUMPLEVEL = "entryisjumplevel";
    private static final String KEY_ENTRYQTYTYPE = "entryqtytype";
    private static final String KEY_ENTRYMATERIALATTR = "entrymaterialattr";
    private static final String KEY_ENTRYREPLACEPLAN = "entryreplaceplan";
    private static final String KEY_ENTRYVALIDDATE = "entryvaliddate";
    private static final String KEY_ENTRYINVALIDDATE = "entryinvaliddate";
    private static final String KEY_COPENTRYVALIDDATE = "copentryvaliddate";
    private static final String KEY_COPENTRYINVALIDDATE = "copentryinvaliddate";
    private Map<Integer, String> errorMap = new HashMap<Integer, String>(10);

    public void initImportData(InitImportDataEventArgs e) {
        List datalist = e.getSourceDataList();
        this.preSearchImportData(datalist);
        int size = datalist.size();
        HashSet<String> existSet = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            Object nameObj;
            Object numObj;
            Map map = (Map)datalist.get(i);
            JSONObject orgJson = (JSONObject)JSON.toJSON(map.get(KEY_CREATEORG));
            JSONObject typeJson = (JSONObject)JSON.toJSON(map.get("type"));
            JSONObject matJson = (JSONObject)JSON.toJSON(map.get(KEY_MATERIALID));
            JSONObject verJson = (JSONObject)JSON.toJSON(map.get("version"));
            JSONObject repNumJson = (JSONObject)JSON.toJSON(map.get(KEY_REPACENO));
            JSONObject configCodeJson = (JSONObject)JSON.toJSON(map.get(KEY_CONFIGCODE));
            Map auxpMap = (Map)map.get("auxproperty");
            JSONObject verRuleJson = (JSONObject)JSON.toJSON(map.get("bomversionrule"));
            JSONObject wbs = (JSONObject)JSON.toJSON(map.get(KEY_WBS));
            if (orgJson == null || typeJson == null || matJson == null) {
                return;
            }
            String typeNum = typeJson.getString(KEY_NUMBER);
            String matNum = matJson.getString(KEY_NUMBER);
            String unique = typeNum + "-" + matNum;
            String auxpStr = this.dealWithAuxp(auxpMap);
            unique = unique + "-" + auxpStr;
            if (repNumJson == null) {
                unique = unique + "-0";
            } else {
                String repNum = repNumJson.getString(KEY_NUMBER);
                unique = unique + "-" + repNum;
            }
            if (configCodeJson == null) {
                unique = unique + "-0";
            } else {
                String codeNum = configCodeJson.getString(KEY_NUMBER);
                unique = unique + "-" + codeNum;
            }
            if (verJson == null) {
                unique = unique + "-0";
            } else {
                numObj = verJson.get((Object)KEY_NUMBER);
                nameObj = verJson.get((Object)KEY_NAME);
                if (numObj != null) {
                    unique = unique + "-" + numObj;
                } else if (numObj == null && verRuleJson != null && nameObj != null) {
                    Object ruleNumObj = verRuleJson.get((Object)KEY_NUMBER);
                    unique = unique + "-" + ruleNumObj + "-" + nameObj;
                } else {
                    unique = unique + "-0";
                }
            }
            if (wbs == null) {
                unique = unique + "-0";
            } else {
                numObj = wbs.get((Object)KEY_NUMBER);
                nameObj = wbs.get((Object)KEY_NAME);
                unique = numObj != null ? unique + "-" + numObj : (numObj == null && nameObj != null ? unique + "-" + nameObj : unique + "-0");
            }
            if (existSet.contains(unique)) {
                int rowNum = (Integer)map.get("rowNum");
                this.errorMap.put(rowNum, ResManager.loadKDString((String)"\u5b58\u5728\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3001\u201cBOM\u7c7b\u578b\u201d\u3001\u201c\u7248\u672c\u53f7\u201d\u3001\u201c\u66ff\u4ee3\u53f7\u201d\u3001\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3001\u201c\u914d\u7f6e\u53f7\u201d\u3001\u201cWBS\u201d\u76f8\u540c\u7684BOM\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"BomImportPlugIn_33", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                continue;
            }
            existSet.add(unique);
            this.dealWithBomVer(null, map);
        }
    }

    private void preSearchImportData(List<Map<String, Object>> datalist) {
        if (datalist == null) {
            return;
        }
        HashSet<String> matInfoSet = new HashSet<String>(128);
        HashSet<String> typeInfoSet = new HashSet<String>(16);
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        int size = datalist.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = datalist.get(i);
            JSONObject matJson = (JSONObject)JSON.toJSON((Object)map.get(KEY_MATERIALID));
            JSONObject typeJson = (JSONObject)JSON.toJSON((Object)map.get("type"));
            JSONObject orgJson = (JSONObject)JSON.toJSON((Object)map.get(KEY_CREATEORG));
            if (matJson != null) {
                matInfoSet.add(matJson.getString(KEY_NUMBER));
            }
            if (typeJson != null) {
                typeInfoSet.add(typeJson.getString(KEY_NUMBER));
            }
            if (orgJson != null) {
                orgNumberSet.add(orgJson.getString(KEY_NUMBER));
            }
            Set<String> entryMatSet = this.getChildMatInfo(map, "entry", KEY_ENTRYMATERIALID);
            Set<String> copEntryMatSet = this.getChildMatInfo(map, "copentry", "copentrymaterialid");
            matInfoSet.addAll(entryMatSet);
            matInfoSet.addAll(copEntryMatSet);
        }
        this.searchData(matInfoSet, typeInfoSet, orgNumberSet);
    }

    private Set<String> getChildMatInfo(Map<String, Object> map, String entryName, String fieldName) {
        HashSet<String> entryMatInfoSet = new HashSet<String>(100);
        JSONArray entryJsonArray = (JSONArray)JSON.toJSON((Object)map.get(entryName));
        if (entryJsonArray == null) {
            return entryMatInfoSet;
        }
        int size = entryJsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject entryJson = (JSONObject)entryJsonArray.get(i);
            JSONObject entryMatJson = (JSONObject)entryJson.get((Object)fieldName);
            if (entryMatJson == null) continue;
            entryMatInfoSet.add(entryMatJson.getString(KEY_NUMBER));
        }
        return entryMatInfoSet;
    }

    private void searchData(Set<String> matInfoSet, Set<String> typeInfoSet, Set<String> orgNumberSet) {
        String uniqueKey;
        HashSet<Long> materialIdSet = new HashSet<Long>(matInfoSet.size());
        String matField = "id,number,createorg,baseunit.number unitNum,configproperties";
        QFilter numQfilter = new QFilter(KEY_NUMBER, "in", matInfoSet);
        QFilter status = new QFilter(KEY_STATUS, "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection matObjCol = QueryServiceHelper.query((String)"bd_material", (String)matField, (QFilter[])new QFilter[]{numQfilter, status, enable});
        int size = matObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject matObj = (DynamicObject)matObjCol.get(i);
            String matNum = matObj.getString(KEY_NUMBER);
            MFTBOMConst.matMap.put(matNum, matObj);
            materialIdSet.add(matObj.getLong("id"));
        }
        matField = "id,number,createorg.number orgNum,masterid.number matNum,materialattr";
        numQfilter = new QFilter("masterid", "in", materialIdSet);
        status = new QFilter(KEY_STATUS, "=", (Object)"C");
        enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection matInfoObjCol = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)matField, (QFilter[])new QFilter[]{numQfilter, status, enable});
        size = matInfoObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject matInfoObj = (DynamicObject)matInfoObjCol.get(i);
            String matNum = matInfoObj.getString("matNum");
            String createOrgNum = matInfoObj.getString("orgNum");
            uniqueKey = createOrgNum + "-" + matNum;
            MFTBOMConst.matInfoMap.put(uniqueKey, matInfoObj);
        }
        numQfilter = new QFilter("material", "in", materialIdSet);
        numQfilter.and(new QFilter("type", "=", (Object)"A"));
        numQfilter.and(new QFilter("enable", "=", (Object)"1"));
        numQfilter.and(new QFilter(KEY_STATUS, "=", (Object)"C"));
        DynamicObjectCollection bomVerObjCol = QueryServiceHelper.query((String)"bd_bomversion_new", (String)"id,number,name,bomversionrule.number verRuleNum,material.id matId, material.number matNum", (QFilter[])new QFilter[]{numQfilter, status, enable});
        size = bomVerObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bomVerObj = (DynamicObject)bomVerObjCol.get(i);
            String matNum = bomVerObj.getString("matNum");
            String verRuleNum = bomVerObj.getString("verRuleNum");
            String name = bomVerObj.getString(KEY_NAME);
            String uniqueKey2 = matNum + "-" + verRuleNum + "-" + name;
            MFTBOMConst.bomVerMap.put(uniqueKey2, bomVerObj);
        }
        numQfilter = new QFilter(KEY_MATERIALID, "in", materialIdSet);
        DynamicObjectCollection bomObjCol = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id,number,status", (QFilter[])new QFilter[]{numQfilter, status, enable});
        size = bomObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bomObj = (DynamicObject)bomObjCol.get(i);
            uniqueKey = bomObj.getString(KEY_NUMBER);
            MFTBOMConst.bomMap.put(uniqueKey, bomObj);
        }
        numQfilter = new QFilter(KEY_NUMBER, "in", typeInfoSet);
        DynamicObjectCollection bomTypeObjCol = QueryServiceHelper.query((String)"mpdm_bomtype", (String)"id,number,isinsloc,configtype,purpose", (QFilter[])new QFilter[]{numQfilter, status, enable});
        size = bomTypeObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bomTypeObj = (DynamicObject)bomTypeObjCol.get(i);
            String uniqueKey3 = bomTypeObj.getString(KEY_NUMBER);
            MFTBOMConst.bomTypeMap.put(uniqueKey3, bomTypeObj);
        }
        QFilter orgNumQfilter = new QFilter(KEY_NUMBER, "in", orgNumberSet);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{orgNumQfilter, status, enable});
        size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(i);
            long orgId = orgObj.getLong("id");
            String orgNum = orgObj.getString(KEY_NUMBER);
            QFilter materialPlanQfilter = new QFilter("masterid", "in", materialIdSet);
            QFilter orgQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)orgId);
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)"mpdm_materialplan", (String)"id,masterid.number mnum,wastagerate", (QFilter[])new QFilter[]{materialPlanQfilter, orgQfilter});
            if (planColl == null || planColl.isEmpty()) continue;
            int size2 = planColl.size();
            for (int j = 0; j < size2; ++j) {
                MFTBOMConst.matPlanInfoNumMap.put(orgNum + "_" + ((DynamicObject)planColl.get(j)).getString("mnum"), planColl.get(j));
            }
        }
    }

    public String dealWithAuxp(Map<String, Object> auxpMap) {
        String auxpStr = "";
        if (auxpMap == null) {
            return "0";
        }
        for (Map.Entry<String, Object> entry : auxpMap.entrySet()) {
            String keyStr = entry.getKey();
            String value = "";
            value = entry.getValue() instanceof HashMap ? String.valueOf(((HashMap)entry.getValue()).get(KEY_NUMBER)) : (String)entry.getValue();
            String auxpTmp = keyStr + value;
            if ("".equals(auxpStr)) {
                auxpStr = auxpTmp;
                continue;
            }
            auxpStr = auxpStr + auxpTmp;
        }
        return auxpStr;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        int rowNum;
        String errorMsg;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        if (sourceData.get("rowNum") != null && (errorMsg = this.errorMap.get(rowNum = ((Integer)sourceData.get("rowNum")).intValue())) != null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errorMsg);
            e.setFireAfterImportData(false);
        }
        String status = String.valueOf(sourceData.get(KEY_STATUS));
        if (sourceData.get(KEY_STATUS) != null && !"A".equals(status)) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"BomImportPlugIn_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
        }
        this.validate(e, sourceData);
        this.dealWithBomVer(e, sourceData);
    }

    private void dealWithBomVer(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        JSONArray copEntryJsonArray;
        JSONObject matJson = (JSONObject)JSON.toJSON((Object)sourceData.get(KEY_MATERIALID));
        JSONObject verJson = (JSONObject)JSON.toJSON((Object)sourceData.get("version"));
        JSONObject orgJson = (JSONObject)JSON.toJSON((Object)sourceData.get(KEY_CREATEORG));
        JSONObject verRuleJson = (JSONObject)JSON.toJSON((Object)sourceData.get("bomversionrule"));
        this.convertBomVersion(e, matJson, verJson, verRuleJson, "1");
        JSONArray entryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get("entry"));
        if (entryJsonArray != null) {
            int size = entryJsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject entryJson = (JSONObject)entryJsonArray.get(i);
                JSONObject entryMatJson = (JSONObject)entryJson.get((Object)KEY_ENTRYMATERIALID);
                JSONObject entryVerJson = (JSONObject)entryJson.get((Object)"entryversion");
                this.convertBomVersion(e, entryMatJson, entryVerJson, verRuleJson, "2");
                this.setEntryScrapRate(orgJson, entryJson, entryMatJson);
            }
        }
        if ((copEntryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get("copentry"))) != null) {
            int size = copEntryJsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject copEntryJson = (JSONObject)copEntryJsonArray.get(i);
                JSONObject copEntryMatJson = (JSONObject)copEntryJson.get((Object)"copentrymaterialid");
                JSONObject copEntryVerJson = (JSONObject)copEntryJson.get((Object)"copentryversion");
                this.convertBomVersion(e, copEntryMatJson, copEntryVerJson, verRuleJson, "3");
            }
        }
    }

    public void convertBomVersion(BeforeImportDataEventArgs e, JSONObject matJson, JSONObject verJson, JSONObject verRuleJson, String type) {
        Map verMap = MFTBOMConst.bomVerMap;
        if (verJson == null || matJson == null) {
            return;
        }
        Object verNameObj = verJson.get((Object)KEY_NAME);
        Object verNum = verJson.get((Object)KEY_NUMBER);
        if (verNameObj != null && verNum == null) {
            String verName = String.valueOf(verNameObj);
            String verRuleNum = verRuleJson == null ? "" : verRuleJson.getString(KEY_NUMBER);
            String matNum = matJson.getString(KEY_NUMBER);
            String uniqueKey = matNum + "-" + verRuleNum + "-" + (verName == null ? "" : verName);
            DynamicObject bomVer = (DynamicObject)verMap.get(uniqueKey);
            if (e != null) {
                if (verRuleJson == null) {
                    e.setCancel(true);
                    String strinfo = String.format(ResManager.loadKDString((String)"BOM\u7248\u672c\u89c4\u5219\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6309BOM\u7248\u672c\u540d\u79f0\u5bfc\u5165\u3002", (String)"BomImportPlugIn_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                    e.setFireAfterImportData(false);
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)verRuleNum)) {
                    e.setCancel(true);
                    String strinfo = String.format(ResManager.loadKDString((String)"BOM\u7248\u672c\u89c4\u5219\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6309BOM\u7248\u672c\u540d\u79f0\u5bfc\u5165\u3002", (String)"BomImportPlugIn_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                    e.setFireAfterImportData(false);
                    return;
                }
                StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BomImportPlugIn_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                if ("1".equals(type)) {
                    msg.append(ResManager.loadKDString((String)"\"\u4ea7\u54c1\u7f16\u7801+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\"", (String)"BomImportPlugIn_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                } else if ("2".equals(type)) {
                    msg.append(ResManager.loadKDString((String)"\"\u7ec4\u4ef6\u7f16\u7801+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\"", (String)"BomImportPlugIn_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                } else {
                    msg.append(ResManager.loadKDString((String)"\"\u8054\u526f\u4ea7\u54c1+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\"", (String)"BomImportPlugIn_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                }
                if (bomVer == null) {
                    e.setCancel(true);
                    msg.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7248\u672c\u53f7\u3002", (String)"BomImportPlugIn_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), msg.toString());
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            verJson.put("id", (Object)(bomVer == null ? 0L : bomVer.getLong("id")));
            verJson.put("importprop", (Object)"id");
        } else if (verNameObj == null && verNum == null) {
            verJson.put("id", (Object)0L);
            verJson.put("importprop", (Object)"id");
        }
    }

    private void setEntryScrapRate(JSONObject orgJson, JSONObject entryJson, JSONObject entryMatJson) {
        Object materialPlan;
        if (orgJson == null || entryMatJson == null) {
            return;
        }
        Map matMap = MFTBOMConst.matMap;
        String orgNum = orgJson.getString(KEY_NUMBER);
        String entryMatNum = entryMatJson.getString(KEY_NUMBER);
        if (orgNum == null || "".equals(orgNum) || entryMatNum == null || "".equals(entryMatNum)) {
            return;
        }
        if (entryJson.get((Object)"entryscraprate") == null && (materialPlan = MFTBOMConst.matPlanInfoNumMap.get(orgNum + "_" + entryMatNum)) instanceof DynamicObject) {
            entryJson.put("entryscraprate", (Object)((DynamicObject)materialPlan).getBigDecimal("wastagerate"));
        }
    }

    public void validate(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        Map matMap = MFTBOMConst.matMap;
        this.headValidate(e, sourceData, matMap);
        JSONArray entryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get("entry"));
        boolean entryRet = this.entryValidate(e, entryJsonArray, matMap, sourceData);
        if (!entryRet) {
            return;
        }
        JSONArray copEntryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get("copentry"));
        boolean copRet = this.copValidate(e, copEntryJsonArray, matMap);
        if (!copRet) {
            return;
        }
    }

    public boolean headValidate(BeforeImportDataEventArgs e, Map<String, Object> sourceData, Map<String, Object> matMap) {
        JSONArray copEntryJsonArray;
        Map bomMap = MFTBOMConst.bomMap;
        boolean flag = true;
        JSONObject typeObj = (JSONObject)JSON.toJSON((Object)sourceData.get("type"));
        if (typeObj == null) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199bom\u7c7b\u578b\u3002", (String)"BomImportPlugIn_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            flag = false;
            return flag;
        }
        JSONObject material = (JSONObject)JSON.toJSON((Object)sourceData.get(KEY_MATERIALID));
        if (material == null) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ea7\u54c1\u7f16\u7801\u3002", (String)"BomImportPlugIn_41", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            flag = false;
            return flag;
        }
        JSONObject repBomJson = (JSONObject)JSON.toJSON((Object)sourceData.get(KEY_REPBOM));
        JSONObject repNoJson = (JSONObject)JSON.toJSON((Object)sourceData.get(KEY_REPACENO));
        boolean iscoproduct = false;
        if (sourceData.get("iscoproduct") != null) {
            iscoproduct = (Boolean)sourceData.get("iscoproduct");
        }
        if ((copEntryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get("copentry"))) == null) {
            return true;
        }
        return flag;
    }

    public boolean entryValidate(BeforeImportDataEventArgs e, JSONArray entryJsonArray, Map<String, Object> matMap, Map<String, Object> sourceData) {
        boolean flag = true;
        if (entryJsonArray == null) {
            return flag;
        }
        JSONObject typeObj = (JSONObject)JSON.toJSON((Object)sourceData.get("type"));
        if (typeObj == null) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199bom\u7c7b\u578b\u3002", (String)"BomImportPlugIn_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            flag = false;
            return flag;
        }
        DynamicObject typeInfo = (DynamicObject)MFTBOMConst.bomTypeMap.get(typeObj.getString(KEY_NUMBER));
        int size = entryJsonArray.size();
        for (int i = 0; i < size; ++i) {
            String strinfo;
            String strinfo2;
            Date endDate;
            Date starDate;
            JSONObject entryunitJson;
            String entryMatUnitNum;
            JSONArray setupentryArray;
            Object entryreplaceplan;
            String entrymaterialattr;
            String entryqtytype;
            String entryisjumplevel;
            JSONObject entryJson;
            block20: {
                String entryMatNum;
                DynamicObject entryMatObj;
                String strinfo3;
                String entryType;
                entryJson = (JSONObject)entryJsonArray.get(i);
                Object rowNumObj = sourceData.get("rowNum");
                Object entryRowNumObj = entryJson.get((Object)"rowNum");
                int rowNum = 0;
                int entryRowNum = 0;
                if (rowNumObj != null) {
                    rowNum = (Integer)rowNumObj;
                }
                if (entryRowNumObj != null) {
                    entryRowNum = (Integer)entryRowNumObj;
                }
                entryisjumplevel = String.valueOf(entryJson.get((Object)KEY_ENTRYISJUMPLEVEL));
                entryqtytype = String.valueOf(entryJson.get((Object)KEY_ENTRYQTYTYPE));
                entrymaterialattr = String.valueOf(entryJson.get((Object)KEY_ENTRYMATERIALATTR));
                entryreplaceplan = entryJson.get((Object)KEY_ENTRYREPLACEPLAN);
                setupentryArray = (JSONArray)entryJson.get((Object)"setupentry");
                JSONObject entryMatJson = (JSONObject)entryJson.get((Object)KEY_ENTRYMATERIALID);
                JSONObject featuretype = (JSONObject)entryJson.get((Object)"featuretype");
                String string = entryType = entryJson.get((Object)"entrytype") == null ? "" : entryJson.getString("entrytype");
                if (entryType == null || "".equals(entryType)) {
                    e.setCancel(true);
                    strinfo3 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u4ef6\u7c7b\u578b\u3002", (String)"BomImportPlugIn_29", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(i + 1), Integer.valueOf(0), strinfo3);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
                if ("A".equals(entryType)) {
                    if (entryMatJson == null) {
                        e.setCancel(true);
                        strinfo3 = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u5e93\u5b58\u65f6\uff0c\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BomImportPlugIn_35", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                        e.addCancelMessage(Integer.valueOf(i + 1), Integer.valueOf(0), strinfo3);
                        e.setFireAfterImportData(false);
                        flag = false;
                        break;
                    }
                } else if (featuretype == null) {
                    e.setCancel(true);
                    strinfo3 = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u9009\u9879\u7c7b\u65f6\uff0c\u7279\u5f81\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BomImportPlugIn_36", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(i + 1), Integer.valueOf(0), strinfo3);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
                if (entryMatJson == null || entryMatJson.getString(KEY_NUMBER) == null || (entryMatObj = (DynamicObject)matMap.get(entryMatNum = entryMatJson.getString(KEY_NUMBER))) == null) continue;
                entryMatUnitNum = entryMatObj.getString("unitNum");
                entryunitJson = (JSONObject)entryJson.get((Object)"entryunit");
                String starDateStr = entryJson.getString(KEY_ENTRYVALIDDATE);
                String endDateStr = entryJson.getString(KEY_ENTRYINVALIDDATE);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                starDate = null;
                endDate = null;
                try {
                    if (starDateStr == null || endDateStr == null) break block20;
                    starDate = simpleDateFormat.parse(starDateStr);
                    endDate = simpleDateFormat.parse(endDateStr);
                }
                catch (ParseException ex) {
                    e.setCancel(true);
                    strinfo2 = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"BomImportPlugIn_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(entryRowNum - rowNum), strinfo2);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
            }
            if (starDate != null && starDate.after(endDate)) {
                e.setCancel(true);
                strinfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u5e94\u5c0f\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"BomImportPlugIn_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if ("C".equals(entryqtytype) && "true".equals(entryisjumplevel)) {
                e.setCancel(true);
                strinfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e3a\u8df3\u5c42\u4ef6\uff0c\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u201c\u9636\u68af\u201d\u3002", (String)"BomImportPlugIn_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if (entryreplaceplan != null && "true".equals(entryisjumplevel)) {
                e.setCancel(true);
                strinfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e3a\u8df3\u5c42\u4ef6\uff0c\u4e0d\u80fd\u5b58\u5728\u66ff\u4ee3\u65b9\u6848\u3002", (String)"BomImportPlugIn_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if ("C".equals(entryqtytype) && "10020".equals(entrymaterialattr)) {
                e.setCancel(true);
                strinfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u201c\u7269\u6599\u5c5e\u6027\u201d\u4e3a\u201c\u865a\u62df\u201d\uff0c\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u201c\u9636\u68af\u201d\u3002", (String)"BomImportPlugIn_18", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if (setupentryArray != null && setupentryArray.size() > 0 && "10020".equals(entrymaterialattr)) {
                e.setCancel(true);
                strinfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u201c\u7269\u6599\u5c5e\u6027\u201d\u4e3a\u201c\u865a\u62df\u201d\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4f4d\u7f6e\u4fe1\u606f\u3002", (String)"BomImportPlugIn_19", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if (entryunitJson != null) {
                String entryUnitNum = entryunitJson.getString(KEY_NUMBER);
                if (!(StringUtils.isEmpty((CharSequence)entryMatUnitNum) || StringUtils.isEmpty((CharSequence)entryUnitNum) || entryMatUnitNum.equals(entryUnitNum))) {
                    e.setCancel(true);
                    strinfo2 = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u8ba1\u91cf\u5355\u4f4d\u548c\u7ec4\u4ef6\u7f16\u7801\u5bf9\u5e94\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e0d\u5339\u914d\u3002", (String)"BomImportPlugIn_20", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo2);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
            }
            String entryownertype = entryJson.getString("entryownertype");
            String entryissuemode = entryJson.getString("entryissuemode");
            JSONArray qtyEntryJsonArray = (JSONArray)entryJson.get((Object)"qtyentry");
            if (!this.qtyValidate(e, qtyEntryJsonArray, entryJson)) {
                flag = false;
            }
            if (this.setupValidate(e, sourceData, setupentryArray)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean copValidate(BeforeImportDataEventArgs e, JSONArray copEntryJsonArray, Map<String, Object> matMap) {
        Map sourceData = e.getSourceData();
        boolean flag = true;
        if (copEntryJsonArray == null) {
            return flag;
        }
        int size = copEntryJsonArray.size();
        for (int i = 0; i < size; ++i) {
            Date endDate;
            Date starDate;
            block13: {
                String strinfo;
                JSONObject copEntryJson = (JSONObject)copEntryJsonArray.get(i);
                JSONObject copEntryMatJson = (JSONObject)copEntryJson.get((Object)"copentrymaterialid");
                if (copEntryMatJson == null) {
                    e.setCancel(true);
                    strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8054\u526f\u4ea7\u54c1\u7f16\u7801\u3002", (String)"BomImportPlugIn_22", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
                if (copEntryMatJson.getString(KEY_NUMBER) == null) {
                    e.setCancel(true);
                    strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8054\u526f\u4ea7\u54c1\u7f16\u7801\u3002", (String)"BomImportPlugIn_22", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
                String copEntryMatNum = copEntryMatJson.getString(KEY_NUMBER);
                DynamicObject copEntryMatObj = (DynamicObject)matMap.get(copEntryMatNum);
                if (copEntryMatObj == null) {
                    e.setCancel(true);
                    String strinfo2 = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u7269\u6599\u201c%s\u201d\u3002", (String)"BomImportPlugIn_30", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), copEntryMatNum);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo2);
                    e.setFireAfterImportData(false);
                    flag = false;
                    break;
                }
                String copEntryMatUnitNum = copEntryMatObj.getString("unitNum");
                JSONObject copEntryunitJson = (JSONObject)copEntryJson.get((Object)"copentryunit");
                JSONObject createOrg = (JSONObject)JSON.toJSON(sourceData.get(KEY_CREATEORG));
                String createOrgNum = createOrg.getString(KEY_NUMBER);
                String matInfoUnique = createOrgNum + "-" + copEntryMatNum;
                if (copEntryunitJson != null) {
                    String entryUnitNum = copEntryunitJson.getString(KEY_NUMBER);
                    if (!(StringUtils.isEmpty((CharSequence)copEntryMatUnitNum) || StringUtils.isEmpty((CharSequence)entryUnitNum) || copEntryMatUnitNum.equals(entryUnitNum))) {
                        e.setCancel(true);
                        String strinfo3 = String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u8ba1\u91cf\u5355\u4f4d\u548c\u8054\u526f\u4ea7\u54c1\u5bf9\u5e94\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e0d\u5339\u914d\u3002", (String)"BomImportPlugIn_24", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo3);
                        e.setFireAfterImportData(false);
                        flag = false;
                        break;
                    }
                }
                String copStarDateStr = copEntryJson.getString(KEY_COPENTRYVALIDDATE);
                String copEndDateStr = copEntryJson.getString(KEY_COPENTRYINVALIDDATE);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                starDate = null;
                endDate = null;
                try {
                    if (copStarDateStr != null && copEndDateStr != null) {
                        starDate = simpleDateFormat.parse(copStarDateStr);
                        endDate = simpleDateFormat.parse(copEndDateStr);
                    } else {
                        if (copStarDateStr == null) {
                            e.setCancel(true);
                            String strinfo4 = String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%s\u884c\u201c\u751f\u6548\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BomImportPlugIn_31", (String)"mmc-fmm-formplugin", (Object[])new Object[]{i + 1}), new Object[0]);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo4);
                            e.setFireAfterImportData(false);
                            flag = false;
                            break;
                        }
                        if (copEndDateStr == null) {
                            e.setCancel(true);
                            String strinfo5 = String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\u201c\u5931\u6548\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BomImportPlugIn_37", (String)"mmc-fmm-formplugin", (Object[])new Object[]{i + 1}), new Object[0]);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo5);
                            e.setFireAfterImportData(false);
                            flag = false;
                        }
                    }
                    break block13;
                }
                catch (ParseException ex) {
                    e.setCancel(true);
                    String strinfo6 = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"BomImportPlugIn_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo6);
                    e.setFireAfterImportData(false);
                    flag = false;
                }
                break;
            }
            if (starDate == null || starDate.compareTo(endDate) < 0) continue;
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"BomImportPlugIn_25", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            flag = false;
            break;
        }
        return flag;
    }

    public boolean qtyValidate(BeforeImportDataEventArgs e, JSONArray qtyEntryJsonArray, JSONObject entryJsonObj) {
        boolean flag = true;
        if (qtyEntryJsonArray == null || qtyEntryJsonArray.isEmpty()) {
            return flag;
        }
        String entryQtyType = entryJsonObj.getString(KEY_ENTRYQTYTYPE);
        if (!"C".equals(entryQtyType)) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u7528\u91cf\u7c7b\u578b\u4e3a\"\u9636\u68af\"\u624d\u80fd\u5bfc\u5165\u9636\u68af\u7528\u91cf\u3002", (String)"BomImportPlugIn_38", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            return false;
        }
        int size = qtyEntryJsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject qtyEntryJson = (JSONObject)qtyEntryJsonArray.get(i);
            int entryRowNum = (Integer)qtyEntryJson.get((Object)"rowNum");
            BigDecimal batchStart = qtyEntryJson.getBigDecimal("qtyentrybatchstartqty");
            BigDecimal batchEnd = qtyEntryJson.getBigDecimal("qtyentrybatchendqty");
            if (batchStart == null || batchEnd == null) {
                e.setCancel(true);
                String strinfo = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5f00\u59cb/\u6279\u91cf\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BomImportPlugIn_39", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            if (batchStart.compareTo(batchEnd) >= 0) {
                e.setCancel(true);
                String strinfo = String.format(ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u6279\u91cf\u5f00\u59cb\u5e94\u5c0f\u4e8e\u6279\u91cf\u7ed3\u675f\u3002", (String)"BomImportPlugIn_26", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
                break;
            }
            for (int j = i + 1; j < size; ++j) {
                JSONObject qtyEntryTmp = (JSONObject)JSON.toJSON((Object)qtyEntryJsonArray.get(j));
                BigDecimal batchStartTmp = qtyEntryTmp.getBigDecimal("qtyentrybatchstartqty");
                BigDecimal batchEndTmp = qtyEntryTmp.getBigDecimal("qtyentrybatchendqty");
                if (batchStart.compareTo(batchEndTmp) >= 0 || batchEnd.compareTo(batchStartTmp) <= 0) continue;
                e.setCancel(true);
                String strinfo = String.format(ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u6279\u91cf\u6570\u636e\u91cd\u53e0\u3002", (String)"BomImportPlugIn_40", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                e.setFireAfterImportData(false);
                flag = false;
            }
        }
        return flag;
    }

    public boolean setupValidate(BeforeImportDataEventArgs e, Map<String, Object> sourceData, JSONArray setupArray) {
        boolean flag = true;
        if (setupArray == null) {
            return flag;
        }
        Map bomTypeMap = MFTBOMConst.bomTypeMap;
        JSONObject typeObj = (JSONObject)JSON.toJSON((Object)sourceData.get("type"));
        String bomTypeNum = typeObj.getString(KEY_NUMBER);
        if (bomTypeMap.isEmpty() || bomTypeNum == null) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5BOM\u7c7b\u578b\u586b\u5199\u662f\u5426\u6b63\u786e\u3002", (String)"BomImportPlugIn_27", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            return false;
        }
        DynamicObject bomTypeObj = (DynamicObject)bomTypeMap.get(bomTypeNum);
        if (bomTypeObj == null) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5BOM\u7c7b\u578b\u586b\u5199\u662f\u5426\u6b63\u786e\u3002", (String)"BomImportPlugIn_27", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            return false;
        }
        String isinsloc = bomTypeObj.getString("isinsloc");
        if ("false".equals(isinsloc) && !setupArray.isEmpty()) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e0d\u652f\u6301\u5b89\u88c5\u4f4d\u7f6e\uff0c\u4e0d\u80fd\u5bfc\u5165\u5b89\u88c5\u4f4d\u7f6e\u4fe1\u606f\u3002", (String)"BomImportPlugIn_28", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
            return false;
        }
        return flag;
    }
}

