/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bd.mpdm.common.utils.ECNLocalCacheUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.business.bom.BomReplaceUtils;
import kd.mmc.fmm.business.bom.MFTBomEditbusiness;
import kd.mmc.fmm.common.enums.ECOBomModeEnum;
import kd.mmc.fmm.common.util.EcoCommonHelper;
import kd.mmc.fmm.common.util.MMCUtils;

public class ECOBOMEdit
extends AbstractBillPlugIn
implements TabSelectListener,
BasedataEditListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(ECOBOMEdit.class);
    public static final String PROP_ENABLE = "enable";
    public static final String PROP_ENTRY = "entry";
    public static final String PROP_COPENTRY = "copentry";
    public static final String PROP_ENTRYINVALIDDATE = "entryinvaliddate";
    public static final String PROP_ENTRYMATERIAL = "entrymaterial";
    public static final String PROP_ENTRYMATERIALID = "entrymaterialid";
    public static final String PROP_ENTRYSEQ = "entryseq";
    public static final String PROP_ENTRYSUPPLYMODE = "entrysupplymode";
    public static final String PROP_ENTRYSUPPLYORG = "entrysupplyorg";
    public static final String PROP_ENTRYSUPPLYTYPE = "entrysupplytype";
    public static final String PROP_ENTRYTIMEUNIT = "entrytimeunit";
    public static final String PROP_ENTRYTYPE = "entrytype";
    public static final String PROP_ENTRYUNIT = "entryunit";
    public static final String PROP_ENTRYVALIDDATE = "entryvaliddate";
    public static final String PROP_MATERIAL = "material";
    public static final String BOM_ENTRY_PLAN = "entryreplaceplan";
    public static final String BOM_ENTRY_PLANMM = "entryisreplaceplanmm";
    public static final String BOM_ENTRY_ISREPLACE = "entryisreplace";
    public static final String BOM_ENTRY_REPLACEGROUP = "entryreplacegroup";
    public static final String PRO_FPARENTID = "processseq";
    public static final String PRO_OPERATION = "operation";
    public static final String PRO_OPERATIONNO = "operationno";
    public static final String PRO_WORKCENTER = "workcenter";
    public static final String PRO_NUMBER = "number";
    public static final String PRO_ENTRYPROCESSSEQCTRL = "entryprocessseq_ctrl";
    public static final String PRO_BOMMATERIALUNIT = "bommaterialunit";
    public static final String PRO_ENTRYNUMBER = "entrynumber";
    public static final String PROP_ENTRYBOMENTRYID = "entrybomentryid";
    public static final String PROP_ENTRYMODE = "entrymode";
    public static final String PROP_COPENTRYMODE = "copentrymode";
    public static final String PROP_ESTIMATESTATUS = "estimatestatus";
    public static final String TBI_ENTRYNEW = "acptbi_entry_new_fmm";
    public static final String TBI_ENTRYNEWDELETE = "acptbi_entry_delete_fmm";
    public static final String TBI_ENTRYNEWDISABLE = "acptbi_entry_newdisable";
    public static final String TBI_ENTRYNEWEDIT = "acptbi_entry_newedit";
    public static final String TBI_COPENTRYNEW = "acptbi_copentry_new";
    public static final String TBI_COPENTRYNEWDELETE = "acptbi_copentry_delete";
    public static final String TBI_COPENTRYNEWDISABLE = "disable_copentry";
    public static final String TBI_COPENTRYNEWEDIT = "edit_copentry";
    public static final String TB_ENTRY = "acptb_entry";
    public static final String TB_COPENTRY = "acptb_copentry";
    public static final String REPLACE_DEL = "btn_delreplace";
    public static final String PROP_PENTRYVALIDDATE = "pentryvaliddate";
    public static final String KEY_BASEUNIT = "baseunit";
    public static final String PROP_ENTRYMODE_EC = "entrymode_ec";
    public static final String PROP_ENTRYMODE_Q = "entrymode_qty";
    public static final String PROP_ENTRYMODE_S = "entrymode_set";
    public static final String CACHE_ECOBOMSTR = "cache_ecobomstring";
    public static final String KEY_SERIALIZECACHETYPE = "SerializeCacheType";
    public static final String KEY_ISDISABLEGROUPNO = "isDisableGroupno";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        if (event == null) {
            return;
        }
        Tab tab = (Tab)this.getControl("tab_entry");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        this.addItemClickListeners(new String[]{TB_ENTRY});
        this.addItemClickListeners(new String[]{TB_COPENTRY});
    }

    public void tabSelected(TabSelectEvent event) {
        if (event == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        String tabPageKey = event.getTabKey();
        if (MMCUtils.isEmptyString((String)tabPageKey)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(PROP_ENTRY);
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        DynamicObject entryDO = dm.getEntryRowEntity(PROP_ENTRY, entryRowIndex);
        if ((tabPageKey.equalsIgnoreCase("tabpage_entrycontrol") || tabPageKey.equalsIgnoreCase("tabpage_qtyentry") || tabPageKey.equalsIgnoreCase("tabpage_setupentry") || tabPageKey.equalsIgnoreCase("tabpage_chararule") || tabPageKey.equalsIgnoreCase("workstationtab")) && entryDO != null) {
            String entrymode = entryDO.getString(PROP_ENTRYMODE);
            dm.setValue(PROP_ENTRYMODE_EC, (Object)entrymode);
            dm.setValue(PROP_ENTRYMODE_Q, (Object)entrymode);
            dm.setValue(PROP_ENTRYMODE_S, (Object)entrymode);
            if ("B".equals(entrymode) || "D".equals(entrymode) || "E".equals(entrymode)) {
                fv.setEnable(Boolean.FALSE, new String[]{"qtyentry", "setupentry", "acpp_entrycontrol", "acptbi_qtyentry_new", "acptbi_qtyentry_delete", "acptbi_qtyentry_insert", "acptbi_setupentry_new", "acptbi_setupentry_delete", "acptbi_setupentry_insert", "subentryentity", "workstationentry", "acptbi_chararule_new1", "acptbi_chararule_delete1", "acptbi_chararule_new", "acptbi_chararule_delete"});
            } else {
                fv.setEnable(Boolean.TRUE, new String[]{"qtyentry", "setupentry", "acpp_entrycontrol", "acptbi_qtyentry_new", "acptbi_qtyentry_delete", "acptbi_qtyentry_insert", "acptbi_setupentry_new", "acptbi_setupentry_delete", "acptbi_setupentry_insert", "subentryentity", "workstationentry", "acptbi_chararule_new1", "acptbi_chararule_delete1", "acptbi_chararule_new", "acptbi_chararule_delete"});
            }
            fv.updateView(PROP_ENTRYMODE_EC);
            fv.updateView(PROP_ENTRYMODE_Q);
            fv.updateView(PROP_ENTRYMODE_S);
        }
    }

    public AbstractGrid.GridState getEntryGridState(String entryEntity) {
        EntryGrid entryEG = (EntryGrid)this.getControl(entryEntity);
        return entryEG == null ? null : entryEG.getEntryState();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        String itemKey = evt.getItemKey();
        if (MMCUtils.isEmptyString((String)itemKey)) {
            return;
        }
        if (itemKey.equalsIgnoreCase(TBI_ENTRYNEWEDIT) || itemKey.equalsIgnoreCase(TBI_ENTRYNEWDISABLE) || itemKey.equalsIgnoreCase(TBI_COPENTRYNEWEDIT) || itemKey.equalsIgnoreCase(TBI_COPENTRYNEWDISABLE)) {
            ListShowParameter lsp;
            List<QFilter> qFilterList = this.genQFilterList(dm, itemKey);
            String entitykey = "pdm_mftbomentry";
            if (itemKey.equalsIgnoreCase(TBI_COPENTRYNEWEDIT) || itemKey.equalsIgnoreCase(TBI_COPENTRYNEWDISABLE)) {
                entitykey = "pdm_mftbomcopentry";
            }
            if ((lsp = ShowFormHelper.createShowListForm((String)entitykey, (boolean)true)) != null) {
                CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, itemKey);
                lsp.setCloseCallBack(ccb);
                ListFilterParameter lfp = lsp.getListFilterParameter() == null ? new ListFilterParameter() : lsp.getListFilterParameter();
                lfp.setOrderBy(PROP_ENTRYSEQ);
                if (!MMCUtils.isEmptyList(qFilterList)) {
                    lfp.setQFilters(qFilterList);
                    lsp.setListFilterParameter(lfp);
                }
                lsp.setHasRight(true);
                fv.showForm((FormShowParameter)lsp);
            }
        } else if (itemKey.equalsIgnoreCase(TBI_ENTRYNEWDELETE)) {
            String materialKeys;
            Set replaceSet;
            Set mmSet;
            String repKeys;
            DynamicObject entryreplaceplan;
            String entryid;
            int k;
            AbstractGrid.GridState entryGS = this.getEntryGridState(PROP_ENTRY);
            if (entryGS == null) {
                return;
            }
            int[] entryRowIndexes = entryGS.getSelectedRows();
            if (entryRowIndexes.length <= 0) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7ec4\u4ef6\u5206\u5f55\u6570\u636e\u3002", (String)"ECOBOMEdit_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Integer> dealRowIndexes = new HashSet<Integer>(entryRowIndexes.length);
            Integer size = dm.getEntryRowCount(PROP_ENTRY);
            ArrayList<String> entryidList = new ArrayList<String>(entryRowIndexes.length);
            HashSet<String> repSet = new HashSet<String>(16);
            HashSet<String> delrepSet = new HashSet<String>(16);
            HashMap<String, HashSet<String>> delTypeMap = new HashMap<String, HashSet<String>>(16);
            for (int i = 0; i < entryRowIndexes.length; ++i) {
                int index = entryRowIndexes[i];
                DynamicObject rowentity = dm.getEntryRowEntity(PROP_ENTRY, index);
                if (rowentity == null) continue;
                String entryid2 = rowentity.getString(PROP_ENTRYBOMENTRYID);
                if (StringUtils.isNotEmpty((CharSequence)entryid2) && !"0".equals(entryid2)) {
                    entryidList.add(entryid2);
                }
                dealRowIndexes.add(index);
                String seq = rowentity.getString("seq");
                if (this.isReplace(rowentity) && this.isAddMode(rowentity)) {
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u662f\u66ff\u4ee3\u4ef6\uff0c\u8bf7\u901a\u8fc7\u201c\u66ff\u4ee3\u5220\u9664\u201d\u5b9e\u65bd\u5220\u9664\u3002", (String)"ECOBOMEdit_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), seq));
                    return;
                }
                if (this.isReplace(rowentity) && this.isDisableMode(rowentity)) {
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u662f\u66ff\u4ee3\u4ef6\uff0c\u8bf7\u901a\u8fc7\u9009\u4e2d\u53d8\u66f4\u540e\u7684\u4e3b\u6599\u884c\u540e\u8fdb\u884c\u201c\u5220\u9664\u884c\u201d\u5b9e\u65bd\u5220\u9664\u3002", (String)"ECOBOMEdit_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), seq));
                    return;
                }
                DynamicObject entryreplaceplan2 = (DynamicObject)rowentity.get(BOM_ENTRY_PLAN);
                if (entryreplaceplan2 == null) continue;
                String repKeys2 = this.getEntryRepKeys(rowentity);
                repSet.add(repKeys2);
                delrepSet.add(repKeys2);
                if (!this.isEditOrDisable(rowentity)) continue;
                String isEntryReplace = rowentity.getString(BOM_ENTRY_ISREPLACE);
                HashSet<String> delTypeSet = (HashSet<String>)delTypeMap.get(isEntryReplace);
                if (delTypeSet == null) {
                    delTypeSet = new HashSet<String>(16);
                }
                delTypeSet.add(repKeys2 + "_" + entryid2);
                delTypeMap.put(isEntryReplace, delTypeSet);
            }
            for (k = 0; k < size; ++k) {
                DynamicObject rentity = dm.getEntryRowEntity(PROP_ENTRY, k);
                if (rentity == null) continue;
                entryid = rentity.getString(PROP_ENTRYBOMENTRYID);
                if (entryidList.contains(entryid)) {
                    dealRowIndexes.add(k);
                }
                if ((entryreplaceplan = (DynamicObject)rentity.get(BOM_ENTRY_PLAN)) == null) continue;
                repKeys = this.getEntryRepKeys(rentity);
                if (dealRowIndexes.contains(k)) {
                    delrepSet.add(repKeys);
                }
                if (!repSet.contains(repKeys)) continue;
                mmSet = (Set)delTypeMap.get("false");
                replaceSet = (Set)delTypeMap.get("true");
                if (this.isReplace(rentity)) continue;
                if (this.isDisableMode(rentity)) {
                    dealRowIndexes.add(k);
                    continue;
                }
                materialKeys = repKeys + "_" + entryid;
                if (this.isEditOrDisable(rentity) && (mmSet != null && !mmSet.contains(materialKeys) || replaceSet != null && !replaceSet.contains(materialKeys))) continue;
                rentity.set(BOM_ENTRY_PLAN, null);
                rentity.set(BOM_ENTRY_PLANMM, null);
                rentity.set(BOM_ENTRY_REPLACEGROUP, (Object)"");
            }
            if (!delrepSet.isEmpty()) {
                for (k = 0; k < size; ++k) {
                    DynamicObject rentity = dm.getEntryRowEntity(PROP_ENTRY, k);
                    if (rentity == null) continue;
                    entryid = rentity.getString(PROP_ENTRYBOMENTRYID);
                    if (!entryidList.contains(entryid) && !this.isReplace(rentity)) {
                        DynamicObject beforeEntry;
                        if (this.isAfterChangeMode(rentity) && (beforeEntry = this.getBeforeEntry(rentity)) != null) {
                            rentity.set(BOM_ENTRY_PLAN, beforeEntry.get(BOM_ENTRY_PLAN));
                            rentity.set(BOM_ENTRY_PLANMM, beforeEntry.get(BOM_ENTRY_PLANMM));
                            rentity.set(BOM_ENTRY_REPLACEGROUP, beforeEntry.get(BOM_ENTRY_REPLACEGROUP));
                            continue;
                        }
                        if (this.isBeforeChangeMode(rentity)) continue;
                    }
                    if ((entryreplaceplan = (DynamicObject)rentity.get(BOM_ENTRY_PLAN)) == null || !delrepSet.contains(repKeys = this.getEntryRepKeys(rentity))) continue;
                    mmSet = (Set)delTypeMap.get("false");
                    replaceSet = (Set)delTypeMap.get("true");
                    if (this.isEditOrDisable(rentity)) {
                        materialKeys = repKeys + "_" + entryid;
                        if (this.isReplace(rentity)) {
                            if (mmSet != null && mmSet.contains(materialKeys)) {
                                dealRowIndexes.add(k);
                            } else if (replaceSet != null && !replaceSet.contains(materialKeys)) {
                                continue;
                            }
                        } else if (mmSet != null && !mmSet.contains(materialKeys)) continue;
                    }
                    dealRowIndexes.add(k);
                }
            }
            int[] d = dealRowIndexes.stream().mapToInt(Integer::intValue).toArray();
            dm.deleteEntryRows(PROP_ENTRY, d);
            DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
            this.setEntryFiledEnable(ecoType);
        } else if (itemKey.equalsIgnoreCase(TBI_COPENTRYNEWDELETE)) {
            AbstractGrid.GridState entryGS = this.getEntryGridState(PROP_COPENTRY);
            if (entryGS == null) {
                return;
            }
            int[] entryRowIndexes = entryGS.getSelectedRows();
            if (entryRowIndexes.length <= 0) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u3002", (String)"ECOBOMEdit_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Integer> dealRowIndexes = new HashSet<Integer>(entryRowIndexes.length);
            Integer size = dm.getEntryRowCount(PROP_COPENTRY);
            ArrayList<String> entryidList = new ArrayList<String>(entryRowIndexes.length);
            for (int i = 0; i < entryRowIndexes.length; ++i) {
                int index = entryRowIndexes[i];
                DynamicObject rowentity = dm.getEntryRowEntity(PROP_COPENTRY, index);
                if (rowentity == null) continue;
                String entryid = rowentity.getString("oldcopentryid");
                if (StringUtils.isNotEmpty((CharSequence)entryid) && !"0".equals(entryid)) {
                    entryidList.add(entryid);
                }
                dealRowIndexes.add(index);
            }
            for (int k = 0; k < size; ++k) {
                String entryid;
                DynamicObject rentity = dm.getEntryRowEntity(PROP_COPENTRY, k);
                if (rentity == null || !entryidList.contains(entryid = rentity.getString("oldcopentryid"))) continue;
                dealRowIndexes.add(k);
            }
            int[] d = dealRowIndexes.stream().mapToInt(Integer::intValue).toArray();
            dm.deleteEntryRows(PROP_COPENTRY, d);
            DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
            this.setCopEntryFiledEnable(ecoType);
            this.isCopProduct(this.getModel());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        DynamicObject ecoType;
        super.afterDoOperation(event);
        if (event == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        String opKey = event.getOperateKey();
        if (MMCUtils.isEmptyString((String)opKey)) {
            return;
        }
        Tab entryTab = (Tab)this.getControl("tab_entry");
        String tabPageKey = entryTab == null ? null : entryTab.getCurrentTab();
        EntryGrid entryGrid = (EntryGrid)this.getControl(PROP_ENTRY);
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        DynamicObject entryDO = dm.getEntryRowEntity(PROP_ENTRY, entryRowIndex);
        if (("tabpage_entrycontrol".equalsIgnoreCase(tabPageKey) || "tabpage_qtyentry".equalsIgnoreCase(tabPageKey) || "tabpage_setupentry".equalsIgnoreCase(tabPageKey) || "tabpage_chararule".equalsIgnoreCase(tabPageKey) || "workstationtab".equalsIgnoreCase(tabPageKey)) && entryRowIndex >= 0 && (opKey.equalsIgnoreCase("nextentry") || opKey.equalsIgnoreCase("preventry")) && entryDO != null) {
            String entrymode = entryDO.getString(PROP_ENTRYMODE);
            dm.setValue(PROP_ENTRYMODE_EC, (Object)entrymode);
            dm.setValue(PROP_ENTRYMODE_Q, (Object)entrymode);
            dm.setValue(PROP_ENTRYMODE_S, (Object)entrymode);
            if ("B".equals(entrymode) || "D".equals(entrymode) || "E".equals(entrymode)) {
                fv.setEnable(Boolean.FALSE, new String[]{"qtyentry", "setupentry", "acpp_entrycontrol", "acptbi_qtyentry_new", "acptbi_qtyentry_delete", "acptbi_qtyentry_insert", "acptbi_setupentry_new", "acptbi_setupentry_delete", "acptbi_setupentry_insert", "subentryentity", "workstationentry", "acptbi_chararule_new1", "acptbi_chararule_delete1", "acptbi_chararule_new", "acptbi_chararule_delete"});
            } else {
                fv.setEnable(Boolean.TRUE, new String[]{"qtyentry", "setupentry", "acpp_entrycontrol", "acptbi_qtyentry_new", "acptbi_qtyentry_delete", "acptbi_qtyentry_insert", "acptbi_setupentry_new", "acptbi_setupentry_delete", "acptbi_setupentry_insert", "subentryentity", "workstationentry", "acptbi_chararule_new1", "acptbi_chararule_delete1", "acptbi_chararule_new", "acptbi_chararule_delete"});
            }
            fv.updateView(PROP_ENTRYMODE_EC);
            fv.updateView(PROP_ENTRYMODE_Q);
            fv.updateView(PROP_ENTRYMODE_S);
        }
        if ("newentry".equals(opKey)) {
            ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
            this.setEntryFiledEnable(ecoType);
        }
        if ("newcopentry".equals(opKey)) {
            ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
            this.setCopEntryFiledEnable(ecoType);
        }
        if (REPLACE_DEL.equals(opKey) && entryDO != null && this.isAfterChangeMode(entryDO)) {
            DynamicObject replacePlan = entryDO.getDynamicObject(BOM_ENTRY_PLAN);
            String replaceGroup = entryDO.getString(BOM_ENTRY_REPLACEGROUP);
            String bomid = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"bomid");
            if (replacePlan != null && bomid != null && !"0".equals(bomid) && !"".equals(bomid)) {
                Map replaceMap = BomReplaceUtils.queryReplaceEntry((Long)Long.parseLong(bomid), (Long)replacePlan.getLong("id"), (String)replaceGroup);
                Set<Long> editBomEntryIdSet = this.getRepMaterial(replaceMap, "false");
                Set<Long> disableBomEntryIdSet = this.getRepMaterial(replaceMap, "true");
                this.genEntryData(editBomEntryIdSet, ECOBomModeEnum.EDIT.getValue(), PROP_ENTRY);
                this.genEntryData(disableBomEntryIdSet, ECOBomModeEnum.DISABLE.getValue(), PROP_ENTRY);
                this.clearMMReplacePlan(entryDO);
            }
        }
    }

    private void clearMMReplacePlan(DynamicObject refEntry) {
        String repKeys = this.getEntryRepKeys(refEntry);
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        int size = dm.getEntryRowCount(PROP_ENTRY);
        for (int entryRowIndex = 0; entryRowIndex < size; ++entryRowIndex) {
            DynamicObject entry = dm.getEntryRowEntity(PROP_ENTRY, entryRowIndex);
            if (entry.getDynamicObject(BOM_ENTRY_PLAN) == null || !this.isAfterChangeMode(entry) || !repKeys.equals(this.getEntryRepKeys(entry))) continue;
            entry.set(BOM_ENTRY_PLAN, null);
            entry.set(BOM_ENTRY_PLANMM, null);
            entry.set(BOM_ENTRY_REPLACEGROUP, (Object)"");
            fv.updateView(BOM_ENTRY_PLAN, entryRowIndex);
            fv.updateView(BOM_ENTRY_PLANMM, entryRowIndex);
            fv.updateView(BOM_ENTRY_REPLACEGROUP, entryRowIndex);
        }
    }

    private Set<Long> getRepMaterial(Map<String, Set<Long>> replaceMap, String isReplace) {
        Set<Long> bomEntryIdSet = replaceMap.get(isReplace);
        if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) {
            return Collections.emptySet();
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return Collections.emptySet();
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return Collections.emptySet();
        }
        int size = dm.getEntryRowCount(PROP_ENTRY);
        for (int entryRowIndex = 0; entryRowIndex < size; ++entryRowIndex) {
            long entrybomentryid = (Long)dm.getValue(PROP_ENTRYBOMENTRYID, entryRowIndex);
            if (entrybomentryid == 0L) continue;
            bomEntryIdSet.remove(entrybomentryid);
        }
        return bomEntryIdSet;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event == null) {
            return;
        }
        String actID = event.getActionId();
        Object retDataObj = event.getReturnData();
        if (MMCUtils.isEmptyString((String)actID) || retDataObj == null) {
            return;
        }
        ListSelectedRowCollection returnLSRC = retDataObj instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)retDataObj : null;
        int returnLSRCSize = returnLSRC == null || returnLSRC.isEmpty() ? 0 : returnLSRC.size();
        if (TBI_ENTRYNEWEDIT.equalsIgnoreCase(actID) || TBI_ENTRYNEWDISABLE.equalsIgnoreCase(actID) || TBI_COPENTRYNEWEDIT.equalsIgnoreCase(actID) || TBI_COPENTRYNEWDISABLE.equalsIgnoreCase(actID)) {
            String entryEntity;
            if (returnLSRCSize <= 0) {
                return;
            }
            HashSet<Long> returnMFTInfoPKSet = new HashSet<Long>(returnLSRCSize);
            for (int index = 0; index < returnLSRCSize; ++index) {
                ListSelectedRow returnLSR = returnLSRC.get(index);
                if (returnLSR == null) continue;
                Long returnPK = (Long)returnLSR.getPrimaryKeyValue();
                returnMFTInfoPKSet.add(returnPK);
            }
            String entryMode = "C";
            if (TBI_ENTRYNEWDISABLE.equalsIgnoreCase(actID) || TBI_COPENTRYNEWDISABLE.equalsIgnoreCase(actID)) {
                entryMode = "E";
            }
            String string = entryEntity = TBI_ENTRYNEWEDIT.equalsIgnoreCase(actID) || TBI_ENTRYNEWDISABLE.equalsIgnoreCase(actID) ? PROP_ENTRY : PROP_COPENTRY;
            if (TBI_ENTRYNEWDISABLE.equalsIgnoreCase(actID)) {
                this.initReplacePkSet(returnMFTInfoPKSet);
            }
            this.genEntryData(returnMFTInfoPKSet, entryMode, entryEntity);
        }
    }

    public void initReplacePkSet(Set<Long> returnMFTInfoPKSet) {
        HashSet<String> replaceGroupNoSet = new HashSet<String>(16);
        QFilter qfilter = new QFilter("entryid", "in", returnMFTInfoPKSet);
        String entity = "pdm_mftbomentry";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entity, (String)"bomid,entryreplacegroup", (QFilter[])new QFilter[]{qfilter});
        Long bomId = 0L;
        for (DynamicObject bomentry : coll) {
            String replaceGroupNo = bomentry.getString(BOM_ENTRY_REPLACEGROUP);
            if (kd.bos.util.StringUtils.isEmpty((String)replaceGroupNo)) continue;
            bomId = bomentry.getLong("bomid");
            replaceGroupNoSet.add(replaceGroupNo);
        }
        if (replaceGroupNoSet.isEmpty()) {
            return;
        }
        qfilter = new QFilter("bomid", "=", (Object)bomId);
        qfilter.and(new QFilter(BOM_ENTRY_REPLACEGROUP, "in", replaceGroupNoSet));
        coll = QueryServiceHelper.query((String)entity, (String)"entryid", (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject bomentry : coll) {
            returnMFTInfoPKSet.add(bomentry.getLong("entryid"));
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (MMCUtils.isEmptyString((String)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) continue;
            this.propertyChanged(propertyName, changeData);
        }
    }

    protected void propertyChanged(String propertyName, Object propertyValue) {
        String propertyValueStr;
        if (MMCUtils.isEmptyString((String)propertyName)) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            return;
        }
        IFormView parentfv = fv.getParentView();
        if (parentfv == null) {
            return;
        }
        IDataModel parentdm = parentfv.getModel();
        if (parentdm == null) {
            return;
        }
        EntryGrid parentEntryEG = (EntryGrid)parentfv.getControl("pentry");
        AbstractGrid.GridState parententryGS = parentEntryEG == null ? null : parentEntryEG.getEntryState();
        int parententryRowIndex = parententryGS == null ? -1 : parententryGS.getFocusRow();
        DynamicObjectCollection pentrys = parentdm.getEntryEntity("pentry");
        if (parententryRowIndex < 0 && !pentrys.isEmpty()) {
            parententryRowIndex = 0;
        }
        DynamicObject ecoType = null;
        DynamicObject pentryRowEntity = parentdm.getEntryRowEntity("pentry", parententryRowIndex);
        if (pentryRowEntity != null) {
            ecoType = pentryRowEntity.getDynamicObject("ecotype");
        }
        ChangeData propertyValueCD = propertyValue instanceof ChangeData ? (ChangeData)propertyValue : null;
        int rowIndex = propertyValueCD != null ? propertyValueCD.getRowIndex() : -1;
        Object propertyValueObj = propertyValueCD == null ? propertyValue : propertyValueCD.getNewValue();
        String string = propertyValueStr = propertyValueObj == null ? null : propertyValueObj.toString();
        if (propertyName.equalsIgnoreCase(PROP_ENTRYMODE)) {
            if (rowIndex < 0) {
                return;
            }
            if (ECOBomModeEnum.NEW.getValue().equalsIgnoreCase(propertyValueStr) || ECOBomModeEnum.EDIT.getValue().equalsIgnoreCase(propertyValueStr)) {
                fv.setEnable(Boolean.TRUE, rowIndex, new String[]{PROP_ENTRYUNIT, "entryversion", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entryfixscrap", "entryscraprate", PROP_ENTRYVALIDDATE, PROP_ENTRYINVALIDDATE, "entryauxproperty", "entryremark", PROP_ENTRYMATERIAL});
            } else if (ECOBomModeEnum.BCHANGE.getValue().equalsIgnoreCase(propertyValueStr) || ECOBomModeEnum.DISABLE.getValue().equalsIgnoreCase(propertyValueStr) || ECOBomModeEnum.DELETE.getValue().equalsIgnoreCase(propertyValueStr)) {
                fv.setEnable(Boolean.FALSE, rowIndex, new String[]{PROP_ENTRYUNIT, "entryversion", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entryfixscrap", "entryscraprate", PROP_ENTRYVALIDDATE, PROP_ENTRYINVALIDDATE, "entryauxproperty", "entryremark", PROP_ENTRYMATERIAL, "entryconfiguredcode"});
            }
            fv.setEnable(Boolean.FALSE, rowIndex, new String[]{"refkey", "groupkey"});
            if (ECOBomModeEnum.BCHANGE.getValue().equalsIgnoreCase(propertyValueStr) || ECOBomModeEnum.DISABLE.getValue().equalsIgnoreCase(propertyValueStr)) {
                if (this.isEcoTypeEditMode(ecoType, "refkeytype")) {
                    fv.setEnable(Boolean.TRUE, rowIndex, new String[]{"refkey"});
                }
                if (this.isEcoTypeEditMode(ecoType, "groupkeytype")) {
                    fv.setEnable(Boolean.TRUE, rowIndex, new String[]{"groupkey"});
                }
            }
        } else if (propertyName.equalsIgnoreCase(PROP_ENTRYMATERIAL) && propertyValueObj != null) {
            String entryMode = (String)dm.getValue(PROP_ENTRYMODE, rowIndex);
            if (!ECOBomModeEnum.EDIT.getValue().equalsIgnoreCase(entryMode)) {
                Long pBomEntryPK = ORM.create().genLongId("pdm_ecobom.entry");
                dm.setValue(PROP_ENTRYBOMENTRYID, (Object)pBomEntryPK, rowIndex);
            }
        } else if (propertyName.equalsIgnoreCase("entryqtynumerator")) {
            BigDecimal ret;
            if (propertyValueObj instanceof BigDecimal && BigDecimal.ZERO.compareTo(ret = (BigDecimal)propertyValueObj) == 0) {
                dm.setValue("entryqtynumerator", (Object)BigDecimal.ONE, rowIndex);
            }
        } else if (propertyName.equalsIgnoreCase("entryqtydenominator")) {
            BigDecimal ret;
            if (propertyValueObj instanceof BigDecimal && BigDecimal.ZERO.compareTo(ret = (BigDecimal)propertyValueObj) == 0) {
                dm.setValue("entryqtydenominator", (Object)BigDecimal.ONE, rowIndex);
            }
        } else if (propertyName.equalsIgnoreCase("entryrefno")) {
            this.updateChangeBeforeValue(rowIndex, propertyName);
        } else if (propertyName.equalsIgnoreCase("entrygroupno")) {
            this.updateChangeBeforeValue(rowIndex, propertyName);
        } else if ("acttime".equalsIgnoreCase(propertyName) || "copacttime".equalsIgnoreCase(propertyName)) {
            String entryEntity = this.getEntryByActtimeField(propertyName);
            String entryModeField = this.getEntryModeField(entryEntity);
            String entryValidDateField = this.getEntryValidDateField(entryEntity);
            String oldEntryField = this.getOldEntryIdField(entryEntity);
            String acttimeFiled = this.getActtimeField(entryEntity);
            String entrymode = (String)dm.getValue(entryModeField, rowIndex);
            List<String> values = Arrays.asList("B", "E");
            if (!values.contains(entrymode)) {
                dm.beginInit();
                dm.setValue(entryValidDateField, propertyValueObj, rowIndex);
                dm.endInit();
                this.getView().updateView(entryValidDateField, rowIndex);
            }
            if ("C".equalsIgnoreCase(entrymode)) {
                long entrybomentryid = (Long)dm.getValue(oldEntryField, rowIndex);
                DynamicObjectCollection entryColl = dm.getEntryEntity(entryEntity);
                Optional<DynamicObject> optional = entryColl.stream().filter(f -> "B".equals(f.getString(entryModeField)) && entrybomentryid == f.getLong(oldEntryField)).findFirst();
                if (optional.isPresent()) {
                    DynamicObject dynamicObject = optional.get();
                    dynamicObject.set(acttimeFiled, propertyValueObj);
                    this.getView().updateView(acttimeFiled, rowIndex - 1);
                }
            } else if (!this.isCopEntry(entryEntity)) {
                String replaceGroupNo = (String)dm.getValue(BOM_ENTRY_REPLACEGROUP, rowIndex);
                if (kd.bos.util.StringUtils.isEmpty((String)replaceGroupNo)) {
                    return;
                }
                DynamicObjectCollection entryColl = dm.getEntryEntity(entryEntity);
                for (int i = 0; i < entryColl.size(); ++i) {
                    String replaceGroupNo2;
                    DynamicObject dynamicObject = (DynamicObject)entryColl.get(i);
                    if (i == rowIndex || (replaceGroupNo2 = dynamicObject.getString(BOM_ENTRY_REPLACEGROUP)) == null || !replaceGroupNo2.equals(replaceGroupNo)) continue;
                    dynamicObject.set(acttimeFiled, propertyValueObj);
                    this.getView().updateView(acttimeFiled, i);
                }
            }
        } else if (propertyName.equalsIgnoreCase(PROP_ENTRYTYPE)) {
            DynamicObject typeObj = (DynamicObject)dm.getValue("type");
            if (typeObj == null) {
                return;
            }
            String purpose = typeObj.getString("purpose");
            DynamicObject entryObj = dm.getEntryRowEntity(PROP_ENTRY, rowIndex);
            MFTBomEditbusiness.setEntryFieldInput((DynamicObject)entryObj, (String)purpose, (IFormView)fv, (IDataModel)dm, (boolean)true, (int)rowIndex);
        }
    }

    public void beforeBindData(EventObject evt) {
        int entryRowIndex;
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            return;
        }
        IFormView parentfv = fv.getParentView();
        if (parentfv == null) {
            return;
        }
        IDataModel parentdm = parentfv.getModel();
        if (parentdm == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)parentfv.getControl("pentry");
        IDataModel pdm = parentfv.getModel();
        IPageCache parentpc = parentfv.getPageCache();
        String lindex = parentfv.getPageCache().get("lastindex");
        DynamicObject bomType = null;
        this.getSerialiationCacheType(parentpc);
        this.getIsDisableGroupNo(parentpc);
        if (StringUtils.isNotBlank((CharSequence)lindex)) {
            String contrVersion;
            int lastIndex = Integer.parseInt(lindex);
            bomType = (DynamicObject)pdm.getValue("bomtype", lastIndex);
            String string = contrVersion = pdm.getValue("entryversioncontrol", lastIndex) == null ? null : pdm.getValue("entryversioncontrol", lastIndex).toString();
            if (null != contrVersion && "D".equals(contrVersion)) {
                dm.beginInit();
                dm.setValue("type", (Object)bomType);
                Object org = pdm.getValue("org");
                dm.setValue("createorg", org);
                dm.endInit();
                fv.setVisible(Boolean.valueOf(false), new String[]{TBI_ENTRYNEWEDIT});
                fv.setVisible(Boolean.valueOf(false), new String[]{TBI_ENTRYNEWDISABLE});
                fv.setEnable(Boolean.valueOf(true), new String[]{TBI_ENTRYNEW});
                fv.setEnable(Boolean.valueOf(true), new String[]{"acptbi_entry_insert_fmm"});
                fv.setEnable(Boolean.valueOf(true), new String[]{TBI_ENTRYNEWDELETE});
                fv.setVisible(Boolean.valueOf(false), new String[]{TBI_COPENTRYNEWEDIT});
                fv.setVisible(Boolean.valueOf(false), new String[]{TBI_COPENTRYNEWDISABLE});
                fv.setEnable(Boolean.valueOf(true), new String[]{TBI_COPENTRYNEW});
                fv.setEnable(Boolean.valueOf(true), new String[]{"acptbi_copentry_insert"});
                fv.setEnable(Boolean.valueOf(true), new String[]{TBI_COPENTRYNEWDELETE});
            }
            if (null != contrVersion && !"D".equals(contrVersion)) {
                fv.setEnable(Boolean.valueOf(false), new String[]{"configuredcode"});
                fv.setVisible(Boolean.valueOf(false), new String[]{"yieldrate"});
                fv.setVisible(Boolean.valueOf(false), new String[]{"group"});
                fv.setVisible(Boolean.valueOf(true), new String[]{TBI_ENTRYNEWEDIT});
                fv.setVisible(Boolean.valueOf(true), new String[]{TBI_ENTRYNEWDISABLE});
                fv.setVisible(Boolean.valueOf(true), new String[]{TBI_COPENTRYNEWEDIT});
                fv.setVisible(Boolean.valueOf(true), new String[]{TBI_COPENTRYNEWDISABLE});
            }
        } else {
            fv.setEnable(Boolean.valueOf(false), new String[]{"configuredcode"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"yieldrate"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"group"});
        }
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (entryRowIndex >= 0) {
            String fmmeco;
            DynamicObject pDo;
            String ecobomid;
            String contrVersion;
            dm.setValue("productno", (Object)String.valueOf(entryRowIndex + 1));
            bomType = (DynamicObject)parentfv.getModel().getValue("bomtype", entryRowIndex);
            String string = contrVersion = pdm.getValue("entryversioncontrol", entryRowIndex) == null ? null : pdm.getValue("entryversioncontrol", entryRowIndex).toString();
            if (null != contrVersion && "D".equals(contrVersion) && StringUtils.isNotBlank((CharSequence)(ecobomid = (pDo = parentfv.getModel().getEntryRowEntity("pentry", entryRowIndex)).getString("ecobomid"))) && !this.isSameEcoBom(fmmeco = parentfv.getPageCache().get(ecobomid))) {
                this.setEcoBomCacheString(fmmeco);
                this.setYieldrate(fmmeco, dm);
            }
        }
        this.setBomType(parentfv, fv, bomType);
        fv.setVisible(Boolean.valueOf(false), new String[]{PROP_ENTRYMATERIALID});
        fv.setVisible(Boolean.valueOf(false), new String[]{"entrymatidmodel"});
        fv.setVisible(Boolean.valueOf(false), new String[]{"entrymatidname"});
        fv.setVisible(Boolean.valueOf(false), new String[]{"featuretype"});
    }

    private String getEcoBomCacheString() {
        return this.getPageCache().get(CACHE_ECOBOMSTR);
    }

    private void setEcoBomCacheString(String ecoBomStr) {
        this.getPageCache().put(CACHE_ECOBOMSTR, ecoBomStr);
    }

    private boolean isSameEcoBom(String ecoBomStr) {
        String cacheStr = this.getEcoBomCacheString();
        if (ecoBomStr == null && cacheStr == null) {
            return true;
        }
        if (ecoBomStr == null || cacheStr == null) {
            return false;
        }
        return ecoBomStr.equals(cacheStr);
    }

    private void setBomType(IFormView parentFv, IFormView fv, DynamicObject bomType) {
        if (bomType == null) {
            return;
        }
        fv.getModel().beginInit();
        fv.getModel().setValue("type", (Object)bomType);
        fv.getModel().endInit();
        this.getView().updateView("type");
    }

    private void setYieldrate(String fmmeco, IDataModel dm) {
        DynamicObject fmmEcobom;
        if (StringUtils.isNotBlank((CharSequence)fmmeco) && (fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)fmmeco, (String)this.getSerialiationCacheType(null))) != null) {
            dm.beginInit();
            if (fmmEcobom.getBigDecimal("yieldrate").compareTo(new BigDecimal("0")) == 0) {
                dm.setValue("yieldrate", (Object)1);
            } else {
                dm.setValue("yieldrate", fmmEcobom.get("yieldrate"));
            }
            dm.setValue("version", fmmEcobom.get("version"));
            dm.setValue("group", fmmEcobom.get("group"));
            dm.setValue("materialid", fmmEcobom.get("materialid"));
            dm.setValue(PROP_MATERIAL, fmmEcobom.get(PROP_MATERIAL));
            dm.setValue("configuredcode", fmmEcobom.get("configuredcode"));
            dm.setValue("ctrlstrategy", fmmEcobom.get("ctrlstrategy"));
            dm.setValue("wbs", fmmEcobom.get("wbs"));
            dm.endInit();
        }
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache parentpc;
        super.afterCreateNewData(e);
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            return;
        }
        IPageCache iPageCache = parentpc = fv.getParentView() == null ? null : (IPageCache)fv.getParentView().getService(IPageCache.class);
        if (parentpc == null) {
            return;
        }
        try {
            String ecobomid = parentpc.get("mmc_pdm_selectbomid");
            String bomjson = parentpc.get(ecobomid);
            if (StringUtils.isNotEmpty((CharSequence)bomjson) && !this.isSameEcoBom(bomjson)) {
                this.setEcoBomCacheString(bomjson);
                DynamicObject ecobomObj = ECNLocalCacheUtils.deSerializeFromBase64((String)bomjson, (String)this.getSerialiationCacheType(parentpc));
                DynamicObjectCollection entrys = null;
                DynamicObjectCollection copentrys = null;
                if (ecobomObj != null) {
                    dm.beginInit();
                    dm.setValue("id", (Object)ecobomObj.getLong("id"));
                    dm.setValue(PRO_NUMBER, ecobomObj.get(PRO_NUMBER));
                    dm.setValue(PROP_MATERIAL, ecobomObj.get(PROP_MATERIAL));
                    dm.setValue("materialid", ecobomObj.get("materialid"));
                    dm.setValue("createorg", ecobomObj.get("createorg"));
                    dm.setValue("type", ecobomObj.get("type"));
                    dm.setValue("version", ecobomObj.get("version"));
                    dm.setValue("status", ecobomObj.get("status"));
                    dm.setValue("bomid", ecobomObj.get("bomid"));
                    dm.setValue(PROP_PENTRYVALIDDATE, ecobomObj.get(PROP_PENTRYVALIDDATE));
                    dm.setValue("qtybaseunit", ecobomObj.get("qtybaseunit"));
                    dm.setValue("productno", ecobomObj.get("productno"));
                    dm.setValue("configuredcode", ecobomObj.get("configuredcode"));
                    dm.setValue("optioncontrol", ecobomObj.get("optioncontrol"));
                    dm.setValue("ctrlstrategy", ecobomObj.get("ctrlstrategy"));
                    dm.setValue("iscoproduct", ecobomObj.get("iscoproduct"));
                    dm.setValue("wbs", ecobomObj.get("wbs"));
                    dm.endInit();
                    entrys = ecobomObj.getDynamicObjectCollection(PROP_ENTRY);
                    copentrys = ecobomObj.getDynamicObjectCollection(PROP_COPENTRY);
                    String bomid = ecobomObj.getString("bomid");
                    if (StringUtils.isNotEmpty((CharSequence)bomid) && !StringUtils.equals((CharSequence)"0", (CharSequence)bomid)) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"wbs"});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"wbs"});
                    }
                }
                if (entrys != null) {
                    dm.setValue(PROP_ENTRY, entrys);
                    for (DynamicObject obj : entrys) {
                        String idType = obj.getString(PROP_ENTRYMODE);
                        int seq = obj.getInt("seq");
                        if (!"B".equals(idType) && !"E".equals(idType)) continue;
                        this.getView().setEnable(Boolean.valueOf(false), seq - 1, new String[]{"entryconfiguredcode"});
                    }
                }
                if (copentrys != null) {
                    dm.setValue(PROP_COPENTRY, copentrys);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
            this.closeShowLoading();
            throw e1;
        }
    }

    private void closeShowLoading() {
        IFormView formView = this.getView().getParentView();
        if (null != formView && formView.getEntityId().equals("pdm_bom_eco")) {
            formView.hideLoading();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
        this.setFiledEnable(ecoType);
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(PROP_ENTRY);
        DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
        for (DynamicObject dynamicObject : entryColl) {
            IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)"hasbom");
            if (property == null) continue;
            dynamicObject.getDataEntityState().setBizChanged(property.getOrdinal(), false);
        }
        if (this.isDisableGroupNo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrygroupno", "groupkey"});
        }
    }

    private boolean isDisableGroupNo() {
        String value = this.getIsDisableGroupNo(null);
        return "true".equalsIgnoreCase(value);
    }

    private void setFiledEnable(DynamicObject ecoType) {
        this.setEntryFiledEnable(ecoType);
        this.setCopEntryFiledEnable(ecoType);
    }

    private boolean isAdjustActTime(DynamicObject ecoType) {
        return ecoType == null ? Boolean.FALSE : ecoType.getBoolean("adjustacttime") && "A".equals(ecoType.getString("adjusttype"));
    }

    private void setCopEntryFiledEnable(DynamicObject ecoType) {
        if (ecoType != null) {
            boolean isAdjustActtime = this.isAdjustActTime(ecoType);
            int rowCount = this.getModel().getEntryRowCount(PROP_COPENTRY);
            IFormView view = this.getView();
            for (int i = 0; i < rowCount; ++i) {
                view.setEnable(Boolean.valueOf(isAdjustActtime), i, new String[]{"copacttime"});
                view.setEnable(Boolean.valueOf(this.isLockAux(i, "copentrymaterialid")), i, new String[]{"copentryauxproperty"});
            }
        }
    }

    private void setEntryFiledEnable(DynamicObject ecoType) {
        if (ecoType != null) {
            boolean isAdjustActtime = this.isAdjustActTime(ecoType);
            boolean refkeytypeEdit = this.isEcoTypeEditMode(ecoType, "refkeytype");
            boolean groupkeytypeEdit = this.isEcoTypeEditMode(ecoType, "groupkeytype");
            boolean refkeytypeUnCompute = this.isEcoTypeUnComputeMode(ecoType, "refkeytype");
            boolean groupkeytypeUnCompute = this.isEcoTypeUnComputeMode(ecoType, "groupkeytype");
            int rowCount = this.getModel().getEntryRowCount(PROP_ENTRY);
            IFormView view = this.getView();
            for (int i = 0; i < rowCount; ++i) {
                view.setEnable(Boolean.valueOf(isAdjustActtime), i, new String[]{"acttime"});
                String entryMode = this.getModel().getValue(PROP_ENTRYMODE, i).toString();
                if (ECOBomModeEnum.DISABLE.getValue().equalsIgnoreCase(entryMode)) {
                    view.setEnable(Boolean.valueOf(refkeytypeEdit), i, new String[]{"refkey"});
                    view.setEnable(Boolean.valueOf(groupkeytypeEdit), i, new String[]{"groupkey"});
                } else {
                    view.setEnable(Boolean.FALSE, i, new String[]{"refkey"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"groupkey"});
                }
                boolean isLock = this.isLockEntryRefNo(ecoType, i);
                if (refkeytypeUnCompute) {
                    view.setEnable(Boolean.FALSE, i, new String[]{"entryrefno"});
                } else {
                    view.setEnable(Boolean.valueOf(!isLock), i, new String[]{"entryrefno"});
                }
                if (groupkeytypeUnCompute) {
                    view.setEnable(Boolean.FALSE, i, new String[]{"entrygroupno"});
                } else {
                    view.setEnable(Boolean.valueOf(!isLock), i, new String[]{"entrygroupno"});
                }
                view.setEnable(Boolean.valueOf(this.isLockAux(i, PROP_ENTRYMATERIALID)), i, new String[]{"entryauxproperty"});
            }
        }
    }

    private boolean isLockAux(int rowIndex, String field) {
        String entryModeField;
        String string = entryModeField = PROP_ENTRYMATERIALID.equalsIgnoreCase(field) ? PROP_ENTRYMODE : PROP_COPENTRYMODE;
        if (this.getModel().getValue(entryModeField, rowIndex) == null) {
            return false;
        }
        String entryMode = this.getModel().getValue(entryModeField, rowIndex).toString();
        if (!"A".equals(entryMode) && !"C".equals(entryMode)) {
            return false;
        }
        DynamicObject material = (DynamicObject)this.getModel().getValue(field, rowIndex);
        if (material == null) {
            return false;
        }
        return material.getBoolean("isuseauxpty");
    }

    private boolean isLockEntryRefNo(DynamicObject ecoType, int rowIndex) {
        String entryMode = this.getModel().getValue(PROP_ENTRYMODE, rowIndex).toString();
        String estimateStatus = this.getModel().getValue(PROP_ESTIMATESTATUS, rowIndex).toString();
        return !"A".equals(estimateStatus) || !"A".equals(entryMode) && !"C".equals(entryMode) && !"E".equals(entryMode);
    }

    private boolean isEcoTypeEditMode(DynamicObject ecoType, String fieldType) {
        if (ecoType == null) {
            return false;
        }
        String value = ecoType.getString(fieldType);
        return "C".equals(value);
    }

    private boolean isEcoTypeUnComputeMode(DynamicObject ecoType, String fieldType) {
        if (ecoType == null) {
            return false;
        }
        String value = ecoType.getString(fieldType);
        return "D".equals(value);
    }

    public void afterBindingData(AfterBindingDataEvent e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp prop = e.getEntryProp();
        String key = prop.getName();
        if (PROP_ENTRY.equals(key) || PROP_COPENTRY.equals(key)) {
            String acttimeField;
            DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
            Date pentryvaliddate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            String string = acttimeField = PROP_ENTRY.equals(key) ? "acttime" : "copacttime";
            if (pentryvaliddate != null) {
                for (RowDataEntity rowData : rowDataEntities) {
                    int row = rowData.getRowIndex();
                    this.getModel().setValue(acttimeField, (Object)pentryvaliddate, row);
                }
            }
            if (PROP_ENTRY.equals(key)) {
                this.setEntryFiledEnable(ecoType);
            } else {
                this.setCopEntryFiledEnable(ecoType);
            }
        }
    }

    private Object getPentryPropertyValue(String propertyName) {
        IFormView parentfv = this.getView().getParentView();
        if (parentfv == null) {
            return null;
        }
        IDataModel parentdm = parentfv.getModel();
        if (parentdm == null) {
            return null;
        }
        EntryGrid parentEntryEG = (EntryGrid)parentfv.getControl("pentry");
        if (parentEntryEG == null) {
            return null;
        }
        int parententryRowIndex = parentEntryEG.getEntryState().getFocusRow();
        DynamicObjectCollection pentrys = parentdm.getEntryEntity("pentry");
        if (parententryRowIndex < 0 && !pentrys.isEmpty()) {
            parententryRowIndex = 0;
        }
        return parentdm.getValue(propertyName, parententryRowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    private String getSerialiationCacheType(IPageCache parentpage) {
        IPageCache pc = this.getPageCache();
        if (parentpage != null) {
            String cacheType = parentpage.get(KEY_SERIALIZECACHETYPE);
            pc.put(KEY_SERIALIZECACHETYPE, cacheType);
            return cacheType;
        }
        return pc.get(KEY_SERIALIZECACHETYPE);
    }

    private String getIsDisableGroupNo(IPageCache parentpage) {
        IPageCache pc = this.getPageCache();
        if (parentpage != null) {
            String cacheType = parentpage.get(KEY_ISDISABLEGROUPNO);
            pc.put(KEY_ISDISABLEGROUPNO, cacheType);
            return cacheType;
        }
        return pc.get(KEY_ISDISABLEGROUPNO);
    }

    private void updateChangeBeforeValue(int currentRowIndex, String fieldName) {
        if (this.isDisableGroupNo()) {
            return;
        }
        String entryMode = (String)this.getModel().getValue(PROP_ENTRYMODE, currentRowIndex);
        if (!"C".equals(entryMode)) {
            return;
        }
        Long bomentryId = (Long)this.getModel().getValue(PROP_ENTRYBOMENTRYID, currentRowIndex);
        int rowCount = this.getModel().getEntryRowCount(PROP_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            Long bomentryId2;
            String entryMode2;
            if (i == currentRowIndex || !"B".equals(entryMode2 = (String)this.getModel().getValue(PROP_ENTRYMODE, i)) || !(bomentryId2 = (Long)this.getModel().getValue(PROP_ENTRYBOMENTRYID, i)).equals(bomentryId)) continue;
            this.getModel().setValue(fieldName, this.getModel().getValue(fieldName, currentRowIndex), i);
            break;
        }
    }

    private boolean isReplace(DynamicObject entryObj) {
        String entryisreplace = entryObj.getString(BOM_ENTRY_ISREPLACE);
        return "true".equalsIgnoreCase(entryisreplace);
    }

    private boolean isAddMode(DynamicObject entryObj) {
        String entryMode = entryObj.getString(PROP_ENTRYMODE);
        return "A".equalsIgnoreCase(entryMode);
    }

    private boolean isDisableMode(DynamicObject entryObj) {
        String entryMode = entryObj.getString(PROP_ENTRYMODE);
        return "E".equalsIgnoreCase(entryMode);
    }

    private boolean isAfterChangeMode(DynamicObject entryObj) {
        String entryMode = entryObj.getString(PROP_ENTRYMODE);
        return "C".equalsIgnoreCase(entryMode);
    }

    private boolean isBeforeChangeMode(DynamicObject entryObj) {
        String entryMode = entryObj.getString(PROP_ENTRYMODE);
        return "B".equalsIgnoreCase(entryMode);
    }

    private String getEntryRepKeys(DynamicObject entryObj) {
        DynamicObject entryreplaceplan = (DynamicObject)entryObj.get(BOM_ENTRY_PLAN);
        if (entryreplaceplan == null) {
            return "";
        }
        String replaceGroupNo = entryObj.getString(BOM_ENTRY_REPLACEGROUP);
        return entryreplaceplan.getPkValue() + "_" + (kd.bos.util.StringUtils.isEmpty((String)replaceGroupNo) ? "" : replaceGroupNo);
    }

    private DynamicObject getBeforeEntry(DynamicObject afterEntry) {
        if (this.isAfterChangeMode(afterEntry)) {
            Long bomentryId = afterEntry.getLong(PROP_ENTRYBOMENTRYID);
            int rowCount = this.getModel().getEntryRowCount(PROP_ENTRY);
            for (int i = 0; i < rowCount; ++i) {
                Long bomentryId2;
                DynamicObject entryDO = this.getModel().getEntryRowEntity(PROP_ENTRY, i);
                if (!this.isBeforeChangeMode(entryDO) || !(bomentryId2 = Long.valueOf(entryDO.getLong(PROP_ENTRYBOMENTRYID))).equals(bomentryId)) continue;
                return entryDO;
            }
        }
        return null;
    }

    private boolean isEditOrDisable(DynamicObject rowentity) {
        return this.isBeforeChangeMode(rowentity) || this.isAfterChangeMode(rowentity) || this.isDisableMode(rowentity);
    }

    private Long getBomId() {
        return Long.parseLong((String)this.getModel().getValue("bomid"));
    }

    private List<QFilter> genQFilterList(IDataModel dm, String keyItem) {
        Date validDate;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        String bomid = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"bomid");
        qFilterList.add(new QFilter("bomid", "=", (Object)Long.parseLong(bomid)));
        String entryEntity = PROP_ENTRY;
        String oldEntryId = PROP_ENTRYBOMENTRYID;
        String entryinvaliddate = PROP_ENTRYINVALIDDATE;
        if (keyItem.equalsIgnoreCase(TBI_COPENTRYNEWEDIT) || keyItem.equalsIgnoreCase(TBI_COPENTRYNEWDISABLE)) {
            entryEntity = PROP_COPENTRY;
            oldEntryId = "oldcopentryid";
            entryinvaliddate = "copentryinvaliddate";
        }
        boolean isEntrydisplay = TBI_ENTRYNEWDISABLE.equalsIgnoreCase(keyItem);
        DynamicObjectCollection entryDOC = dm.getEntryEntity(entryEntity);
        int entryDOCSize = entryDOC.size();
        HashSet<Long> ignoreMFTInfoPKSet = new HashSet<Long>(16);
        HashSet<String> existReplaceGroupNoSet = new HashSet<String>(16);
        for (int index = 0; index < entryDOCSize; ++index) {
            DynamicObject entryDO = (DynamicObject)entryDOC.get(index);
            Long entryBOMEntryPK = entryDO.getLong(oldEntryId);
            if (entryBOMEntryPK == null || entryBOMEntryPK.equals(0L)) continue;
            ignoreMFTInfoPKSet.add(entryBOMEntryPK);
            if (!isEntrydisplay) continue;
            DynamicObject entryreplaceplan = (DynamicObject)entryDO.get(BOM_ENTRY_PLAN);
            String replaceGroupNo = entryDO.getString(BOM_ENTRY_REPLACEGROUP);
            if (entryreplaceplan == null || kd.bos.util.StringUtils.isEmpty((String)replaceGroupNo)) continue;
            existReplaceGroupNoSet.add(replaceGroupNo);
        }
        if (!MMCUtils.isEmptySet(ignoreMFTInfoPKSet)) {
            qFilterList.add(new QFilter("id", "not in", ignoreMFTInfoPKSet));
        }
        if ((validDate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE)) != null) {
            qFilterList.add(new QFilter(entryinvaliddate, ">=", (Object)validDate));
        }
        if (isEntrydisplay) {
            qFilterList.add(new QFilter(BOM_ENTRY_ISREPLACE, "=", (Object)false));
            if (!MMCUtils.isEmptySet(existReplaceGroupNoSet)) {
                qFilterList.add(new QFilter(BOM_ENTRY_REPLACEGROUP, "not in", existReplaceGroupNoSet));
            }
        }
        return qFilterList;
    }

    private Set<String> getNotUpdateEntryFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        return fieldSet;
    }

    public String getEntryModeField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? PROP_COPENTRYMODE : PROP_ENTRYMODE;
    }

    public String getActtimeField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? "copacttime" : "acttime";
    }

    public boolean isCopEntry(String subEntryNumber) {
        return PROP_COPENTRY.equals(subEntryNumber);
    }

    public String getEntryValidDateField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? "copentryvaliddate" : PROP_ENTRYVALIDDATE;
    }

    public String getOldEntryIdField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? "oldcopentryid" : PROP_ENTRYBOMENTRYID;
    }

    public String getNewEntryIdField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? "newcopentryid" : "bomentry";
    }

    public String getEstimateStatusField(String subEntryNumber) {
        return this.isCopEntry(subEntryNumber) ? "copestimatestatus" : PROP_ESTIMATESTATUS;
    }

    public void genEntryData(Set<Long> entryIdSet, String entryMode, String entryEntity) {
        AbstractFormDataModel afdm;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        AbstractFormDataModel abstractFormDataModel = afdm = dm instanceof AbstractFormDataModel ? (AbstractFormDataModel)dm : null;
        if (afdm == null) {
            return;
        }
        AbstractGrid.GridState entryGS = this.getEntryGridState(entryEntity);
        if (entryGS == null) {
            return;
        }
        Long bomId = this.getBomId();
        DynamicObject pEntryBomDO = BusinessDataServiceHelper.loadSingle((Object)bomId, (String)"pdm_mftbom");
        DynamicObjectCollection entryColl = pEntryBomDO.getDynamicObjectCollection(entryEntity);
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        Set<String> unIncludeFieldSet = this.getNotUpdateEntryFieldSet();
        DynamicObjectCollection ecoEntryColl = this.getModel().getEntryEntity(entryEntity);
        Date pentryvaliddate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE);
        String acttimeField = this.getActtimeField(entryEntity);
        String oldEntryIdField = this.getOldEntryIdField(entryEntity);
        String newEntryIdField = this.getNewEntryIdField(entryEntity);
        String entryModeField = this.getEntryModeField(entryEntity);
        String estimateStatusField = this.getEstimateStatusField(entryEntity);
        String validDateField = this.getEntryValidDateField(entryEntity);
        boolean isCopentry = this.isCopEntry(entryEntity);
        Date transtartdate = new Date();
        for (DynamicObject entry : entryColl) {
            Long entryId = (Long)entry.getPkValue();
            if (!entryIdSet.contains(entryId)) continue;
            DynamicObject newEcoEntry = ecoEntryColl.addNew();
            EcoCommonHelper.putAllProperties((DynamicObject)entry, (DynamicObject)newEcoEntry, unIncludeFieldSet);
            newEcoEntry.set(entryModeField, (Object)entryMode);
            newEcoEntry.set(oldEntryIdField, (Object)entryId);
            newEcoEntry.set(newEntryIdField, (Object)entryId);
            newEcoEntry.set(acttimeField, (Object)pentryvaliddate);
            newEcoEntry.set(estimateStatusField, (Object)"A");
            if (!isCopentry) {
                newEcoEntry.set("transtartdate", (Object)transtartdate);
            }
            if (!"C".equals(entryMode)) continue;
            newEcoEntry.set(entryModeField, (Object)"B");
            newEcoEntry = ecoEntryColl.addNew();
            EcoCommonHelper.putAllProperties((DynamicObject)entry, (DynamicObject)newEcoEntry, unIncludeFieldSet);
            newEcoEntry.set(entryModeField, (Object)entryMode);
            newEcoEntry.set(oldEntryIdField, (Object)entryId);
            newEcoEntry.set(newEntryIdField, (Object)0L);
            newEcoEntry.set(acttimeField, (Object)pentryvaliddate);
            newEcoEntry.set(estimateStatusField, (Object)"A");
            newEcoEntry.set(validDateField, (Object)pentryvaliddate);
        }
        dm.updateEntryCache(ecoEntryColl);
        fv.updateView(entryEntity);
        DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype");
        if (isCopentry) {
            this.setCopEntryFiledEnable(ecoType);
        } else {
            this.setEntryFiledEnable(ecoType);
        }
    }

    private String getEntryByActtimeField(String fieldNumber) {
        return "acttime".equalsIgnoreCase(fieldNumber) ? PROP_ENTRY : PROP_COPENTRY;
    }

    private String getEntryByEntryModeField(String fieldNumber) {
        return PROP_ENTRYMODE.equalsIgnoreCase(fieldNumber) ? PROP_ENTRY : PROP_COPENTRY;
    }

    private void isCopProduct(IDataModel dm) {
        String bomid;
        boolean isProduct = false;
        DynamicObjectCollection copEntryCol = dm.getEntryEntity(PROP_COPENTRY);
        if (!copEntryCol.isEmpty()) {
            for (int i = 0; i < copEntryCol.size(); ++i) {
                DynamicObject copEntryObj = (DynamicObject)copEntryCol.get(i);
                DynamicObject copEntryMaterial = copEntryObj.getDynamicObject("copentrymaterial");
                if (copEntryMaterial == null) continue;
                isProduct = true;
                break;
            }
        }
        if (!isProduct && (bomid = (String)dm.getValue("bomid")) != null && !"".equals(bomid)) {
            isProduct = this.isBomProductJoin(bomid);
        }
        dm.setValue("iscoproduct", (Object)isProduct);
    }

    private boolean isBomProductJoin(String bomId) {
        DynamicObject bom = QueryServiceHelper.queryOne((String)"pdm_mftbom", (String)"iscoproduct", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bomId))});
        if (bom != null) {
            return bom.getBoolean("iscoproduct");
        }
        return false;
    }
}

