/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.bdctrl.CommonObject;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.impl.asyncexecutor.schedule.CleanMultiLangDirtyDataTask;

public class MFTBOMEditExtends
extends AbstractFormPlugin {
    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        BillView billView = (BillView)e.getSource();
        Long bomId = (Long)billView.getFormShowParameter().getCustomParam("allNodeId");
        if (bomId != null) {
            try (DataMutex mutex = MutexFactory.createDataMutex();){
                mutex.release(String.valueOf(bomId), "pdm_mftbom", "modify");
            }
            catch (IOException ioException) {
                CleanMultiLangDirtyDataTask.log.error((Throwable)ioException);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String dynamicObject = (String)this.getView().getFormShowParameter().getCustomParam("dynamicObject");
        if (!"dynamicObjectNull".equals(dynamicObject)) {
            Long bomId = (Long)this.getView().getFormShowParameter().getCustomParam("allNodeId");
            MutexHelper.require((String)"pdm_mftbom", (Object)String.valueOf(bomId), (String)"modify", (StringBuilder)new StringBuilder());
        }
    }

    public void block() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("number");
        strings.add("type");
        strings.add("group");
        strings.add("createorg");
        strings.add("status");
        strings.add("enable");
        strings.add("ctrlstrategy");
        strings.add("datasource");
        strings.add("material");
        strings.add("yieldrate");
        strings.add("materialid");
        this.blockField(strings);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String pageId = this.getView().getPageId();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentView.getPageCache().put("childPageId", pageId);
        }
        if (this.getView().getFormShowParameter().getCustomParam("nowNodeParentId") != null) {
            String isMainProduct = (String)this.getView().getFormShowParameter().getCustomParam("isMainProduct");
            if ("false".equals(isMainProduct)) {
                this.block();
                return;
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"material"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"materialid"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"version"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxproperty"});
        }
    }

    public void blockField(ArrayList arrayList) {
        for (Object element : arrayList) {
            String temp_element = String.valueOf(element);
            this.getModel().setValue(temp_element, null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{temp_element});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dynamicObject = (String)this.getView().getFormShowParameter().getCustomParam("dynamicObject");
        if ("dynamicObjectNull".equals(dynamicObject)) {
            Long bomId;
            List<CommonObject> list = this.getControlStrategeByViewId(this.getBaseDateViewID("pdm_mftbom").getId());
            String nowStratege = "";
            if (list.isEmpty()) {
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)"defaultctrlstrategy", (QFilter[])new QFilter[]{new QFilter("basedataid", "=", (Object)"pdm_mftbom")});
                if (col != null && col.size() == 1) {
                    DynamicObject dObject = (DynamicObject)col.get(0);
                    nowStratege = dObject.getString("defaultctrlstrategy");
                }
            } else {
                for (CommonObject commonObject : list) {
                    if (!commonObject.getId().equals(this.getView().getFormShowParameter().getCustomParam("newCreateOrg"))) continue;
                    nowStratege = commonObject.getName();
                }
                nowStratege = nowStratege.isEmpty() ? "" : nowStratege;
            }
            String nowNodeParentId = (String)this.getView().getFormShowParameter().getCustomParam("nowNodeParentId");
            if (nowNodeParentId.contains("_")) {
                String[] s = nowNodeParentId.split("_");
                bomId = Long.parseLong(s[0]);
            } else {
                bomId = Long.parseLong(nowNodeParentId);
            }
            int seq = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam("seq"));
            QFilter qFilter = new QFilter("id", "=", (Object)bomId).and("entry.seq", "=", (Object)seq);
            DynamicObject defaultBomDate = QueryServiceHelper.queryOne((String)"pdm_mftbom", (String)"type,entry.entryversion,entry.entryauxproperty,entry.entrymaterial", (QFilter[])qFilter.toArray());
            if (defaultBomDate != null) {
                this.getModel().setValue("createorg", this.getView().getFormShowParameter().getCustomParam("newCreateOrg"));
                this.getModel().setValue("type", defaultBomDate.get("type"));
                this.getModel().setValue("ctrlstrategy", (Object)(nowStratege.isEmpty() ? "" : nowStratege));
                this.getModel().setValue("material", defaultBomDate.get("entry.entrymaterial"));
                this.getModel().setValue("version", defaultBomDate.get("entry.entryversion"));
                this.getModel().setValue("auxproperty", defaultBomDate.get("entry.entryauxproperty"));
            }
        }
    }

    private List<CommonObject> getControlStrategeByViewId(String bdbaseviewId) {
        String sql = "select  a.fcuid ,l.FCtrlStrategy ,l.FENTRYID from  T_BD_CtrlStrategyDetail l ,t_bd_ctrlstrategy a where a.fid=l.fid and a.fcuid=l.FCREATEORGID and  a.FBASEDATAVIEWID=?";
        Object[] filters = new String[]{bdbaseviewId};
        List returnList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<CommonObject>>(){

            public List<CommonObject> handle(ResultSet rs) throws SQLException {
                ArrayList<CommonObject> strategeList = new ArrayList<CommonObject>(16);
                while (rs.next()) {
                    CommonObject cObject = new CommonObject();
                    cObject.setId(rs.getString("fcuid"));
                    cObject.setName(rs.getString("FCtrlStrategy"));
                    cObject.putObject("fentryId", (Object)rs.getString("FENTRYID"));
                    strategeList.add(cObject);
                }
                return strategeList;
            }
        });
        return returnList;
    }

    private CommonObject getBaseDateViewID(String dataNumber) {
        String sql = "select a.fid,a.FCTRLVIEW from t_bd_basedataview a  where a.FBASEDATAID=? ";
        Object[] filters = new String[]{dataNumber};
        CommonObject commonObject = (CommonObject)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<CommonObject>(){

            public CommonObject handle(ResultSet rs) throws SQLException {
                CommonObject cObject = null;
                if (rs.next()) {
                    cObject = new CommonObject();
                    cObject.setId(rs.getString("fid"));
                    cObject.setName(rs.getString("FCTRLVIEW"));
                }
                return cObject;
            }
        });
        return commonObject;
    }
}

