/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.bdctrl.CommonObject;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.fmm.common.util.MMCUtils;

public class MFTBOMList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(MFTBOMList.class);
    private static final String BOM_NUMBER = "pdm_mftbom";
    private static final String KEY_ENTRY = "BOM";
    private static final String KEY_BOMENTRY = "entry";
    private static final String PDM_BATCHMFTBOMLOG = "pdm_batchmftbomlog";
    private static final String PDM_LOG_DETAIL_ENTRY_BOMID = "logdetailentry.bomid";
    public static final String TBI_BATCHASSIGN = "tblbatchassign";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbltreeassign"});
        this.addItemClickListeners(new String[]{"tblbatchsave"});
        this.addItemClickListeners(new String[]{"tblcalc"});
        this.addItemClickListeners(new String[]{"tblnew"});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (StringUtils.isNotBlank((CharSequence)field) && (field.contains("entryoutorg") || field.contains("entrysupplyorg"))) {
            List qFilters = args.getQfilters();
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            QFilter qFilter = new QFilter("fisinventory", "=", (Object)Boolean.TRUE);
            qFilters.clear();
            qFilters.add(qFilterStatus);
            qFilters.add(qFilter);
            args.setQfilters(qFilters);
        }
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
        if (event == null) {
            return;
        }
        String itemKey = event.getItemKey();
        if (MMCUtils.isEmptyString((String)itemKey)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"tbltreeassign", (CharSequence)itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MFTBOMList_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection selectedRowCollection = selectedRows.getBillListSelectedRowCollection();
            if (selectedRowCollection.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u6811\u5f62\u7ef4\u62a4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MFTBOMList_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pdm_treebom");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("bomId", selectedRowCollection.getPrimaryKeyValues()[0]);
            this.getView().showForm(formShowParameter);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"tblbatchsave", (CharSequence)itemKey) && !StringUtils.equalsIgnoreCase((CharSequence)"tblcalc", (CharSequence)itemKey)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"costbomlog", (CharSequence)itemKey)) {
                HashSet<String> set = new HashSet<String>();
                set.add(BOM_NUMBER);
                set.add("pdm_eco");
                QFilter filter = new QFilter("moduler", "in", set);
                ListShowParameter showParams = ShowFormHelper.createShowListForm((String)"pdm_costbomsynclog", (boolean)false, (int)0, (boolean)false);
                ListFilterParameter params = showParams.getListFilterParameter();
                params.setFilter(filter);
                showParams.setListFilterParameter(params);
                this.getView().showForm((FormShowParameter)showParams);
            } else if (StringUtils.equals((CharSequence)"syncMat", (CharSequence)itemKey)) {
                ExecutorService exec = ThreadPools.newCachedExecutorService((String)("bomPool_foward_" + UUID.randomUUID()));
                try {
                    this.syncMatId(exec);
                    this.syncEntryMatId(exec);
                }
                catch (Exception e) {
                    logger.info(e.toString());
                    throw e;
                }
                finally {
                    try {
                        exec.shutdown();
                        exec.awaitTermination(5L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        logger.info(e.toString());
                    }
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"MFTBOMList_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void syncMatId(ExecutorService exec) {
        QFilter filter = new QFilter("materialid", "=", (Object)0L);
        DynamicObject[] dyObj = BusinessDataServiceHelper.load((String)BOM_NUMBER, (String)"id,material,materialid", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(100);
        for (int i = 0; i < dyObj.length; ++i) {
            DynamicObject bom = dyObj[i];
            DynamicObject matInfo = bom.getDynamicObject("material");
            if (matInfo != null) {
                DynamicObject matObj = matInfo.getDynamicObject("masterid");
                bom.set("materialid", (Object)matObj);
            }
            list.add(bom);
            if (list.size() % 3000 != 0) continue;
            FutureTask<List<Map<String, Object>>> ft = new FutureTask<List<Map<String, Object>>>(new MateralSync(list.toArray(new DynamicObject[0])));
            exec.submit(ft);
            list.clear();
        }
        if (!list.isEmpty()) {
            FutureTask<List<Map<String, Object>>> ft = new FutureTask<List<Map<String, Object>>>(new MateralSync(list.toArray(new DynamicObject[0])));
            exec.submit(ft);
        }
    }

    public void syncEntryMatId(ExecutorService exec) {
        QFilter filter = new QFilter("entry.entrymaterialid", "=", (Object)0L);
        DynamicObject[] dyObj = BusinessDataServiceHelper.load((String)BOM_NUMBER, (String)"id,entrymaterial,entrymaterialid", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(100);
        for (int i = 0; i < dyObj.length; ++i) {
            DynamicObject bom = dyObj[i];
            DynamicObjectCollection entryCol = bom.getDynamicObjectCollection(KEY_BOMENTRY);
            for (DynamicObject entryObj : entryCol) {
                DynamicObject entryMatObj = entryObj.getDynamicObject("entrymaterialid");
                DynamicObject entryMatInfo = entryObj.getDynamicObject("entrymaterial");
                if (entryMatObj != null || entryMatInfo == null) continue;
                entryMatObj = entryMatInfo.getDynamicObject("masterid");
                entryObj.set("entrymaterialid", (Object)entryMatObj);
            }
            list.add(bom);
            if (list.size() % 3000 != 0) continue;
            FutureTask<List<Map<String, Object>>> ft = new FutureTask<List<Map<String, Object>>>(new MateralSync(list.toArray(new DynamicObject[0])));
            exec.submit(ft);
            list.clear();
        }
        if (!list.isEmpty()) {
            FutureTask<List<Map<String, Object>>> ft = new FutureTask<List<Map<String, Object>>>(new MateralSync(list.toArray(new DynamicObject[0])));
            exec.submit(ft);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn orgFilter = args.getFilterColumn("useorg.id");
        if (orgFilter.getDefaultValues().size() != 0) {
            this.getPageCache().put("businessOrg", orgFilter.getDefaultValues().get(0).toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("tblbomassign")) {
            RequestContext request = RequestContext.get();
            ControlFilters filters = ((IListView)this.getView()).getControlFilters();
            String appid = this.getAppId(BOM_NUMBER);
            long org = filters.getFilter("useorg.id").size() == 0 ? Long.parseLong(this.getPageCache().get("businessOrg")) : Long.parseLong(filters.getFilter("useorg.id").get(0).toString());
            boolean flag = false;
            if (this.getBaseDateViewID(BOM_NUMBER) == null) {
                flag = true;
            } else {
                List<CommonObject> list = this.getControlStrategeByViewId(this.getBaseDateViewID(BOM_NUMBER).getId());
                if (list != null && !list.isEmpty()) {
                    for (CommonObject commonObject : list) {
                        if (!String.valueOf(org).equals(commonObject.getId())) continue;
                        flag = true;
                    }
                } else {
                    flag = true;
                }
            }
            if (!flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u63a7\u5236\u89c4\u5219\u5904\u6dfb\u52a0\u4e3a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MFTBOMList_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int hasNew = PermissionServiceHelper.checkPermission((long)request.getCurrUserId(), (String)"DIM_ORG", (long)org, (String)appid, (String)BOM_NUMBER, (String)"47156aff000000ac");
            int hasModify = PermissionServiceHelper.checkPermission((long)request.getCurrUserId(), (String)"DIM_ORG", (long)org, (String)appid, (String)BOM_NUMBER, (String)"4715a0df000000ac");
            int hasView = PermissionServiceHelper.checkPermission((long)request.getCurrUserId(), (String)"DIM_ORG", (long)org, (String)appid, (String)BOM_NUMBER, (String)"47150e89000000ac");
            if (hasView == 1 && hasNew != 1 && hasModify != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0BOM\u7684\u65b0\u589e\u548c\u4fee\u6539\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6253\u5f00\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (hasNew != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0BOM\u7684\u65b0\u589e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6253\u5f00\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (hasModify != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0BOM\u7684\u4fee\u6539\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6253\u5f00\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_5", (String)"", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.getPageCache().put("hasNew", String.valueOf(hasNew));
                this.getPageCache().put("hasModify", String.valueOf(hasModify));
            }
        }
    }

    private List<CommonObject> getControlStrategeByViewId(String bdbaseviewId) {
        String sql = "select  a.fcuid ,l.FCtrlStrategy ,l.FENTRYID from  T_BD_CtrlStrategyDetail l ,t_bd_ctrlstrategy a where a.fid=l.fid and a.fcuid=l.FCREATEORGID and  a.FBASEDATAVIEWID=?";
        Object[] filters = new String[]{bdbaseviewId};
        List returnList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<CommonObject>>(){

            public List<CommonObject> handle(ResultSet rs) throws SQLException {
                ArrayList<CommonObject> strategeList = new ArrayList<CommonObject>(16);
                while (rs.next()) {
                    CommonObject cObject = new CommonObject();
                    cObject.setId(rs.getString("fcuid"));
                    cObject.setName(rs.getString("FCtrlStrategy"));
                    cObject.putObject("fentryId", (Object)rs.getString("FENTRYID"));
                    strategeList.add(cObject);
                }
                return strategeList;
            }
        });
        return returnList;
    }

    private CommonObject getBaseDateViewID(String dataNumber) {
        String sql = "select a.fid,a.FCTRLVIEW from t_bd_basedataview a  where a.FBASEDATAID=? ";
        Object[] filters = new String[]{dataNumber};
        CommonObject commonObject = (CommonObject)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<CommonObject>(){

            public CommonObject handle(ResultSet rs) throws SQLException {
                CommonObject cObject = null;
                if (rs.next()) {
                    cObject = new CommonObject();
                    cObject.setId(rs.getString("fid"));
                    cObject.setName(rs.getString("FCTRLVIEW"));
                }
                return cObject;
            }
        });
        return commonObject;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("tblbomassign")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MFTBOMList_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection selectedRowCollection = selectedRows.getBillListSelectedRowCollection();
            if (selectedRowCollection.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u6811\u5f62\u7ef4\u62a4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MFTBOMList_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            ControlFilters filters = ((IListView)this.getView()).getControlFilters();
            ListSelectedRow entitydate = selectedRowCollection.get(0);
            DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)entitydate.getPrimaryKeyValue(), (String)BOM_NUMBER);
            String purpose = bom.getDynamicObject("type").getString("purpose");
            if ("B".equals(purpose)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6eBOM\u6682\u4e0d\u652f\u6301\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("C".equals(purpose)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u5355BOM\u6682\u4e0d\u652f\u6301\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pdm_bom_tree");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String org = filters.getFilter("useorg.id").size() == 0 ? this.getPageCache().get("businessOrg") : filters.getFilter("useorg.id").get(0).toString();
            if (entitydate.getMainOrgId() != Long.parseLong(org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662fBOM\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u6811\u5f62\u7ef4\u62a4\u3002", (String)"MFTBOMList_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            formShowParameter.setCustomParam("businessOrgId", (Object)org);
            formShowParameter.setCustomParam("hasNew", (Object)this.getPageCache().get("hasNew"));
            formShowParameter.setCustomParam("hasModify", (Object)this.getPageCache().get("hasModify"));
            formShowParameter.setCustomParam("bomId", selectedRowCollection.getPrimaryKeyValues()[0]);
            this.getView().showForm(formShowParameter);
            return;
        }
        if (args.getOperateKey().equals("batchbomlog")) {
            this.buildBatchBomLogPage(args);
        }
    }

    private void buildBatchBomLogPage(AfterDoOperationEventArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> batchBomLogs = new HashSet<Long>(16);
        if (selectedRows.isEmpty()) {
            this.showBatchBomLog(batchBomLogs);
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DataSet batchBomLogDataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)PDM_BATCHMFTBOMLOG, (String)"id", (QFilter[])new QFilter[]{new QFilter(PDM_LOG_DETAIL_ENTRY_BOMID, "in", (Object)primaryKeyValues)}, (String)"id");
        if (batchBomLogDataSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684BOM\u6ca1\u6709\u8fdb\u884c\u53d8\u66f4\u3002", (String)"MFTBOMList_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        while (batchBomLogDataSet.hasNext()) {
            Row row = batchBomLogDataSet.next();
            Long logPk = row.getLong("id");
            batchBomLogs.add(logPk);
        }
        this.showBatchBomLog(batchBomLogs);
    }

    private void showBatchBomLog(Set<Long> batchBomLogs) {
        ListShowParameter showParameter = new ListShowParameter();
        HashMap<String, Set<Long>> params = new HashMap<String, Set<Long>>(1);
        params.put("batchbomlogs", batchBomLogs);
        showParameter.setCustomParams(params);
        showParameter.setBillFormId(PDM_BATCHMFTBOMLOG);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getAppId(String entityNumber) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tbl_clearcache"});
    }

    static class MateralSync
    implements Callable<List<Map<String, Object>>> {
        private DynamicObject[] dyObjArray;

        public MateralSync(DynamicObject[] dyObjArray) {
            this.dyObjArray = dyObjArray;
        }

        @Override
        public List<Map<String, Object>> call() throws Exception {
            SaveServiceHelper.update((DynamicObject[])this.dyObjArray);
            return null;
        }
    }
}

