/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.fmm.common.enums.MaterialAttrEnum;

public class MFTBOMTreeListPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener,
FilterContainerInitListener,
AfterSearchClickListener,
HyperLinkClickListener,
ListRowClickListener,
AfterBindDataListener {
    private static final int MAX_LEVEL = 50;
    private static final String KEY_ENTITY = "billlistap";
    private static final String KEY_ENTRY = "billlistapentry";
    private static final String KEY_TREEVIEW = "treeview";
    private static final String KEY_BAR = "toolbarap";
    private static final String KEY_EDIT = "btnedit";
    private static final String KEY_OPEN = "btnopen";
    private static final String KEY_COLLAPSE = "btncollapse";
    private static final String KEY_ID = "id";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_MATERIAL_NUMBER = "masterid.number";
    private static final String KEY_MATERIAL_ATTR = "materialattr";
    private static final String KEY_VERSION = "version";
    private static final String KEY_AUXPRO = "auxproperty";
    private static final String KEY_CONFIGCODE = "configuredcode";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_REPLACENO = "replaceno";
    private static final String KEY_TYPE = "type";
    private static final String KEY_BOMENTRY = "entry";
    private static final String KEY_ENTYRMATERIAL = "entrymaterial";
    private static final String KEY_ENTYRVERSION = "entryversion";
    private static final String KEY_ENTRYAUXPRO = "entryauxproperty";
    private static final String KEY_ENTRYCONFIGCODE = "entryconfiguredcode";
    private static final String KEY_SEARCH = "searchap";
    private static final String ISCONTAINLOWER = "iscontainlower";
    private static final String BOM_NUMBER = "pdm_mftbom";
    private static final String CONTROL_FORMID = "pdm_treebomcontrol";
    private static final String FILTERCONTAINERID = "filtercontainerap";
    private static final String CACHEKEY_INITFILTER = "init_filter";
    private static final String CACHEKEY_CONTROL = "control";
    private static final String CACHEKEY_ROOT = "root";
    private static final String CACHEKEY_NODEQFILTER = "nodefilter";
    private static final String CACHEKEY_QUERYQFILTER = "queryfilter";
    private static final String CACHEKEY_OLDSEARCHETEXT = "old_searchtext";
    private static final String CACHEKEY_SEARCHINDEX = "search_index";
    private static final String CACHEKEY_SEARCHNODES = "search_nodes";
    private int count = 0;

    public void initialize() {
        super.initialize();
        IPageCache pageCache = this.getPageCache();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        filterContainer.setBillFormId(BOM_NUMBER);
        String filterInit = pageCache.get(CACHEKEY_INITFILTER);
        if (filterInit == null) {
            pageCache.put(CACHEKEY_INITFILTER, "true");
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
            filterContainer.addAfterBindDataListener((AfterBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        this.addClickListeners(new String[]{KEY_EDIT, KEY_OPEN, KEY_COLLAPSE});
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{KEY_BAR});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)ISCONTAINLOWER, (CharSequence)name)) {
            boolean isContainAll = (Boolean)newValue;
            if (isContainAll) {
                this.showAll();
            } else {
                this.showSingle();
            }
        }
    }

    private void showSingle() {
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeView.TreeState treeState = treeView.getTreeState();
        String focusNodeId = treeState.getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeId)) {
            return;
        }
        Long realId = this.getRealId(focusNodeId);
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        billList.clearSelection();
        List filters = billList.getFilterParameter().getQFilters();
        filters.add(new QFilter(KEY_ID, "=", (Object)realId));
        this.cacheQFilters(filters, CACHEKEY_NODEQFILTER);
        List<QFilter> cacheQFilters = this.getCacheQFilters(CACHEKEY_QUERYQFILTER);
        filters.addAll(cacheQFilters);
        billList.refresh();
        this.clearEntryData();
    }

    private void showAll() {
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeView.TreeState treeState = treeView.getTreeState();
        String focusNodeId = treeState.getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeId)) {
            return;
        }
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        TreeNode currNode = root.getTreeNode(focusNodeId, 50);
        Set<Long> allNodeId = this.getAllNodeId(currNode);
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        billList.clearSelection();
        List filters = billList.getFilterParameter().getQFilters();
        filters.add(new QFilter(KEY_ID, "in", allNodeId));
        this.cacheQFilters(filters, CACHEKEY_NODEQFILTER);
        List<QFilter> cacheQFilters = this.getCacheQFilters(CACHEKEY_QUERYQFILTER);
        filters.addAll(cacheQFilters);
        billList.refresh();
        this.clearEntryData();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bomId = formShowParameter.getCustomParam("bomId");
        if (bomId == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.setMulti(false);
        DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)bomId, (String)BOM_NUMBER, (String)this.getSelectFields());
        if (bom == null) {
            return;
        }
        DynamicObject material = bom.getDynamicObject(KEY_MATERIAL);
        if (material == null) {
            return;
        }
        String rootNodeName = this.getNodeName(material);
        TreeNode rootNode = new TreeNode("", bomId.toString(), rootNodeName);
        List<TreeNode> childListNode = this.loadChildNode(bom, rootNode.getId(), "");
        if (childListNode != null) {
            rootNode.setChildren(childListNode);
        }
        rootNode.setIsOpened(true);
        treeView.setRootVisible(true);
        treeView.addNode(rootNode);
        this.setRoot(rootNode);
    }

    private List<TreeNode> loadChildNode(DynamicObject bom, String parentId, String bomIdStr) {
        TreeNode childNode;
        Set nodeSet;
        ArrayList<TreeNode> childNodes = null;
        if (bom == null) {
            return childNodes;
        }
        DynamicObject material = bom.getDynamicObject(KEY_MATERIAL);
        if (material == null) {
            return childNodes;
        }
        if (bomIdStr != null && this.isRepeatBom(bom, bomIdStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"BOM\u5728\u201c%s\u201d\u5904\u51fa\u73b0\u6b7b\u5faa\u73af\u3002", (String)"MFTBOMTreeListPlugin_23", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), bom.getString("number")));
            return childNodes;
        }
        bomIdStr = bomIdStr + bom.getPkValue().toString();
        DynamicObjectCollection entryColls = bom.getDynamicObjectCollection(KEY_BOMENTRY);
        if (entryColls.isEmpty()) {
            return childNodes;
        }
        Object createOrgId = bom.getDynamicObject(KEY_CREATEORG).getPkValue();
        Object typeId = bom.getDynamicObject(KEY_TYPE).getPkValue();
        DynamicObject replaceNo = bom.getDynamicObject(KEY_REPLACENO);
        Object replaceId = replaceNo == null ? Long.valueOf(0L) : replaceNo.getPkValue();
        QFilter filter1 = new QFilter(KEY_CREATEORG, "=", createOrgId);
        QFilter filter2 = new QFilter(KEY_REPLACENO, "=", replaceId);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)replaceId.toString())) {
            filter2.or(new QFilter(KEY_REPLACENO, "=", (Object)0L));
        }
        QFilter filter3 = new QFilter(KEY_TYPE, "=", typeId);
        HashSet<Object> materialSet = new HashSet<Object>(entryColls.size());
        HashSet<Object> versionSet = new HashSet<Object>(entryColls.size());
        HashSet<Object> auxpSet = new HashSet<Object>(entryColls.size());
        HashSet<Object> configCodeSet = new HashSet<Object>(entryColls.size());
        HashMap dataMap = new HashMap();
        for (DynamicObject entryObj : entryColls) {
            DynamicObject entryMaterial = entryObj.getDynamicObject(KEY_ENTYRMATERIAL);
            materialSet.add(entryMaterial.getPkValue());
            DynamicObject entryVersion = entryObj.getDynamicObject(KEY_ENTYRVERSION);
            Object entryVersionId = entryVersion == null ? Long.valueOf(0L) : entryVersion.getPkValue();
            versionSet.add(entryVersionId);
            DynamicObject entryAuxpro = entryObj.getDynamicObject(KEY_ENTRYAUXPRO);
            Object entryAuxproId = entryAuxpro == null ? Long.valueOf(0L) : entryAuxpro.getPkValue();
            auxpSet.add(entryAuxproId);
            DynamicObject entryConfigcode = entryObj.getDynamicObject(KEY_ENTRYCONFIGCODE);
            Object configcodeId = entryConfigcode == null ? Long.valueOf(0L) : entryConfigcode.getPkValue();
            configCodeSet.add(configcodeId);
            String key = String.valueOf(entryMaterial.getPkValue()) + entryVersionId + entryAuxproId + configcodeId;
            nodeSet = (HashSet<TreeNode>)dataMap.get(key);
            if (nodeSet == null) {
                nodeSet = new HashSet<TreeNode>();
            }
            String childNodeName = this.getNodeName(entryMaterial);
            childNode = new TreeNode(parentId, entryMaterial.getString(KEY_ID) + "_" + this.count++, childNodeName);
            nodeSet.add(childNode);
            dataMap.put(key, nodeSet);
            if (childNodes == null) {
                childNodes = new ArrayList<TreeNode>();
            }
            childNodes.add(childNode);
        }
        QFilter filter4 = new QFilter(KEY_MATERIAL, "in", materialSet);
        QFilter filter5 = new QFilter(KEY_VERSION, "in", versionSet);
        QFilter filter6 = new QFilter(KEY_AUXPRO, "in", auxpSet);
        QFilter filter7 = new QFilter(KEY_CONFIGCODE, "in", configCodeSet);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3, filter4, filter5, filter6, filter7};
        DynamicObject[] nextBoms = BusinessDataServiceHelper.load((String)BOM_NUMBER, (String)this.getSelectFields(), (QFilter[])filters);
        if (nextBoms.length == 0) {
            return childNodes;
        }
        for (DynamicObject nextBom : nextBoms) {
            Iterator iterator;
            DynamicObject nextMaterial = nextBom.getDynamicObject(KEY_MATERIAL);
            DynamicObject nextVersion = nextBom.getDynamicObject(KEY_VERSION);
            DynamicObject entryAuxpro = nextBom.getDynamicObject(KEY_AUXPRO);
            DynamicObject configcode = nextBom.getDynamicObject(KEY_CONFIGCODE);
            Object versionId = nextVersion == null ? Long.valueOf(0L) : nextVersion.getPkValue();
            Object auxproId = entryAuxpro == null ? Long.valueOf(0L) : entryAuxpro.getPkValue();
            Object configcodeId = configcode == null ? Long.valueOf(0L) : configcode.getPkValue();
            String key = String.valueOf(nextMaterial.getPkValue()) + versionId + auxproId + configcodeId;
            if (!dataMap.containsKey(key) || !(iterator = (nodeSet = (Set)dataMap.get(key)).iterator()).hasNext()) continue;
            childNode = (TreeNode)iterator.next();
            iterator.remove();
            dataMap.put(key, nodeSet);
            if (childNodes != null) {
                childNodes.remove(childNode);
            }
            childNode.setId(nextBom.getString(KEY_ID) + "_" + this.count++);
            childNode.setChildren(this.loadChildNode(nextBom, childNode.getId(), bomIdStr));
            if (childNodes == null) continue;
            childNodes.add(childNode);
        }
        return childNodes;
    }

    private boolean isRepeatBom(DynamicObject bom, String longnumber) {
        boolean retFlag = false;
        String lastBomId = bom.getPkValue().toString();
        int lastEntryIndex = longnumber.lastIndexOf(lastBomId);
        if (longnumber.indexOf(lastBomId) < lastEntryIndex) {
            retFlag = true;
        }
        return retFlag;
    }

    private String getNodeName(DynamicObject material) {
        StringBuilder nodeName = new StringBuilder();
        String mapStr = this.getPageCache().get(CACHEKEY_CONTROL);
        if (StringUtils.isBlank((CharSequence)mapStr)) {
            nodeName.append(material.getString(KEY_MATERIAL_NUMBER));
        } else {
            Map controlMap = (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
            int index = 0;
            for (Map.Entry entry : controlMap.entrySet()) {
                String key = (String)entry.getKey();
                Boolean isVisible = (Boolean)entry.getValue();
                if (!isVisible.booleanValue()) continue;
                Object value = material.get(key);
                if (StringUtils.equals((CharSequence)KEY_MATERIAL_ATTR, (CharSequence)key)) {
                    value = MaterialAttrEnum.getName((String)value.toString());
                }
                if (index++ == 0) {
                    nodeName.append(value);
                    continue;
                }
                nodeName.append('[').append(value).append(']');
            }
        }
        return nodeName.toString();
    }

    private String getSelectFields() {
        return "version, material, material.masterid.number, materail.masterid.name, createorg, type, replaceno,auxproperty,configuredcode, entry, entry.entrymaterial, entry.entryversion,entry.entryauxproperty,entry.entryconfiguredcode ";
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object allNodeId;
        String currNodeId = evt.getNodeId().toString();
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        TreeNode currNode = root.getTreeNode(currNodeId, 50);
        boolean iscontainAll = (Boolean)this.getModel().getValue(ISCONTAINLOWER);
        if (iscontainAll) {
            allNodeId = this.getAllNodeIdAndExpand(currNode);
        } else {
            if (currNode != null && currNode.getChildren() != null) {
                TreeView treeView = (TreeView)evt.getSource();
                treeView.expand(currNodeId);
            }
            allNodeId = this.getRealId(currNodeId);
        }
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        billList.clearSelection();
        List filters = billList.getFilterParameter().getQFilters();
        filters.add(new QFilter(KEY_ID, "in", allNodeId));
        this.cacheQFilters(filters, CACHEKEY_NODEQFILTER);
        List<QFilter> cacheFilters = this.getCacheQFilters(CACHEKEY_QUERYQFILTER);
        filters.addAll(cacheFilters);
        billList.refresh();
        this.clearEntryData();
    }

    private void cacheQFilters(List<QFilter> filters, String cacheKey) {
        String[] strArr = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            strArr[i] = filters.get(i).toSerializedString();
        }
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)strArr));
    }

    private List<QFilter> getCacheQFilters(String cacheKey) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(15);
        String str = this.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)str)) {
            return filters;
        }
        List strList = (List)SerializationUtils.fromJsonString((String)str, List.class);
        for (String filterStr : strList) {
            filters.add(QFilter.fromSerializedString((String)filterStr));
        }
        return filters;
    }

    private Set<Long> getAllNodeIdAndExpand(TreeNode root) {
        HashSet<Long> idSet = new HashSet<Long>();
        if (root == null) {
            return idSet;
        }
        idSet.add(this.getRealId(root.getId()));
        List children = root.getChildren();
        if (children == null) {
            return idSet;
        }
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.expand(root.getId());
        for (TreeNode treeNode : children) {
            String nodeId = treeNode.getId();
            idSet.add(this.getRealId(nodeId));
            if (treeNode.getChildren() == null) continue;
            idSet.addAll(this.getAllNodeIdAndExpand(treeNode));
        }
        return idSet;
    }

    private Set<Long> getAllNodeId(TreeNode currNode) {
        HashSet<Long> idSet = new HashSet<Long>();
        if (currNode == null) {
            return idSet;
        }
        idSet.add(this.getRealId(currNode.getId()));
        List children = currNode.getChildren();
        if (children == null) {
            return idSet;
        }
        for (TreeNode treeNode : children) {
            String nodeId = treeNode.getId();
            idSet.add(this.getRealId(nodeId));
            if (treeNode.getChildren() == null) continue;
            idSet.addAll(this.getAllNodeId(treeNode));
        }
        return idSet;
    }

    private Long getRealId(String nodeId) {
        Long realId;
        if (nodeId.indexOf(95) != -1) {
            String[] split = StringUtils.split((String)nodeId, (String)"_");
            realId = Long.parseLong(split[0]);
        } else {
            realId = Long.parseLong(nodeId);
        }
        return realId;
    }

    private void setRoot(TreeNode treeNode) {
        String str = SerializationUtils.toJsonString((Object)treeNode);
        this.getPageCache().put(CACHEKEY_ROOT, str);
    }

    private TreeNode getRoot() {
        String str = this.getPageCache().get(CACHEKEY_ROOT);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Vector) {
            Vector vector = (Vector)source;
            switch (vector.getKey()) {
                case "btnedit": {
                    this.openControlBill();
                    break;
                }
                case "btnopen": {
                    this.openTree();
                    break;
                }
                case "btncollapse": {
                    this.collapseTree();
                    break;
                }
            }
        }
    }

    private void openTree() {
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeView.TreeState treeState = treeView.getTreeState();
        String focusNodeId = treeState.getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeId)) {
            TreeNode root = this.getRoot();
            focusNodeId = root == null ? null : root.getId();
        }
        treeView.expand(focusNodeId);
    }

    private void collapseTree() {
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeView.TreeState treeState = treeView.getTreeState();
        String focusNodeId = treeState.getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeId)) {
            TreeNode root = this.getRoot();
            focusNodeId = root == null ? null : root.getId();
        }
        treeView.collapse(focusNodeId);
    }

    private void openControlBill() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(CONTROL_FORMID);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_EDIT));
        String mapStr = this.getPageCache().get(CACHEKEY_CONTROL);
        formShowParameter.setCustomParam(CACHEKEY_CONTROL, (Object)mapStr);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)KEY_EDIT, (CharSequence)actionId) && (returnData = event.getReturnData()) instanceof Map) {
            Map returnMap = (Map)returnData;
            String mapStr = SerializationUtils.toJsonString((Object)returnMap);
            this.getPageCache().put(CACHEKEY_CONTROL, mapStr);
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            treeView.deleteAllNodes();
            this.initTree();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.clearEntryData();
    }

    public void afterBindData(AfterBindDataEvent afterBindDataEvent) {
        PageCache pageCache = (PageCache)this.getView().getParentView().getService(IPageCache.class);
        if (pageCache != null) {
            this.getPageCache().put("createOrg", pageCache.get("createOrg"));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bomId = formShowParameter.getCustomParam("bomId");
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        List needFilters = billList.getClientQueryFilterParameter().getQFilters();
        FilterContainer filterContainer = (FilterContainer)afterBindDataEvent.getSource();
        List filters = filterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        if (bomId != null) {
            filters.add(new QFilter(KEY_ID, "=", bomId));
        }
        needFilters.addAll(filters);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList entryList = (BillList)this.getControl(KEY_ENTRY);
        ListSelectedRowCollection selectedRowColls = evt.getListSelectedRowCollection();
        if (!selectedRowColls.isEmpty()) {
            QFilter filter = new QFilter(KEY_ID, "=", selectedRowColls.getPrimaryKeyValues()[0]);
            entryList.setFilterParameter(new FilterParameter(filter, null));
            entryList.refresh();
        } else {
            this.clearEntryData();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)"number", (CharSequence)fieldName)) {
            BillList billList = (BillList)event.getSource();
            ListSelectedRow currSelectRow = billList.getCurrentSelectedRowInfo();
            this.openBomBill(currSelectRow.getPrimaryKeyValue(), OperationStatus.EDIT, null);
        }
    }

    public void click(SearchClickEvent searchClickEvent) {
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        billList.clearSelection();
        List needFilters = billList.getQueryFilterParameter().getQFilters();
        List fastQFilters = searchClickEvent.getFastQFilters();
        needFilters.addAll(fastQFilters);
        List searchFilters = searchClickEvent.getFilterParameter().getQFilters();
        needFilters.addAll(searchFilters);
        this.cacheQFilters(needFilters, CACHEKEY_QUERYQFILTER);
        List<QFilter> cacheQFilters = this.getCacheQFilters(CACHEKEY_NODEQFILTER);
        needFilters.addAll(cacheQFilters);
        billList.refresh();
        this.clearEntryData();
    }

    private void clearEntryData() {
        BillList entryList = (BillList)this.getControl(KEY_ENTRY);
        entryList.clearSelection();
        entryList.clearData();
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        FilterColumn useOrgFilter = filterContainerInitEvent.getFilterColumn("useorg.id");
        filterContainerInitEvent.getCommonFilterColumns().remove(useOrgFilter);
    }

    private Long getDefaultOrgId(List<ComboItem> comboItems) {
        ArrayList<Long> mainOrgIds = new ArrayList<Long>();
        for (ComboItem comboItem : comboItems) {
            if (StringUtils.isBlank((CharSequence)comboItem.getValue())) continue;
            Long orgId = Long.parseLong(comboItem.getValue());
            mainOrgIds.add(orgId);
        }
        return PermissionFilterUtil.getDefaultMainOrgId(mainOrgIds);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblnew": {
                this.openNew();
                break;
            }
            case "tblcopy": {
                this.copy();
                break;
            }
            case "tbldel": {
                this.operate("delete");
                break;
            }
            case "tblsubmit": {
                this.operate("submit");
                break;
            }
            case "tblunsubmit": {
                this.operate("unsubmit");
                break;
            }
            case "tblaudit": {
                this.operate("audit");
                break;
            }
            case "tblunaudit": {
                this.operate("unaudit");
                break;
            }
            case "tbldisable": {
                this.operate("disable");
                break;
            }
            case "tblenable": {
                this.operate("enable");
                break;
            }
            case "tblrefresh": {
                this.refresh();
                break;
            }
        }
    }

    private void openNew() {
        BillList billList = (BillList)this.getControl(KEY_ENTRY);
        ListSelectedRow currSelRowInfo = billList.getCurrentSelectedRowInfo();
        HashMap<String, String> customMap = null;
        if (currSelRowInfo != null) {
            DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)currSelRowInfo.getPrimaryKeyValue(), (String)BOM_NUMBER);
            DynamicObjectCollection entryColls = bom.getDynamicObjectCollection(KEY_BOMENTRY);
            for (DynamicObject entryObj : entryColls) {
                String entryId = entryObj.getString(0);
                if (!StringUtils.equals((CharSequence)entryId, (CharSequence)currSelRowInfo.getEntryPrimaryKeyValue().toString())) continue;
                customMap = new HashMap<String, String>(1);
                DynamicObjectType dt = entryColls.getDynamicObjectType();
                String serialize = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{entryObj}, (DynamicObjectType)dt);
                customMap.put("entryObj", serialize);
                break;
            }
        }
        this.openBomBill(null, OperationStatus.ADDNEW, customMap);
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        List<QFilter> cacheQFilters1 = this.getCacheQFilters(CACHEKEY_NODEQFILTER);
        List<QFilter> cacheQFilters2 = this.getCacheQFilters(CACHEKEY_QUERYQFILTER);
        List needFilters = billList.getQueryFilterParameter().getQFilters();
        needFilters.addAll(cacheQFilters1);
        needFilters.addAll(cacheQFilters2);
        billList.refresh();
    }

    private void operate(String operateKey) {
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> bomIds = new ArrayList<Long>();
        Object[] obj = selectedRows.getPrimaryKeyValues();
        if (obj != null && obj.length > 0) {
            for (int k = 0; k < obj.length; ++k) {
                String str = String.valueOf(obj[k]);
                bomIds.add(Long.valueOf(str));
            }
        }
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MFTBOMTreeListPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)operateKey, (String)BOM_NUMBER, (Object[])selectedRows.getPrimaryKeyValues(), null);
        if (executeOperate.isSuccess()) {
            switch (operateKey) {
                case "delete": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "submit": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "unsubmit": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "audit": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "unaudit": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "disable": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_18", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "enable": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"MFTBOMTreeListPlugin_19", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
            List<QFilter> cacheFilters = this.getCacheQFilters(CACHEKEY_QUERYQFILTER);
            List<QFilter> cacheFilter1 = this.getCacheQFilters(CACHEKEY_NODEQFILTER);
            List newFilters = billList.getQueryFilterParameter().getQFilters();
            newFilters.addAll(cacheFilters);
            newFilters.addAll(cacheFilter1);
            if (bomIds.size() > 0) {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                QFilter idsFilter = new QFilter(KEY_ID, "in", bomIds);
                filterList.add(idsFilter);
                newFilters.addAll(filterList);
            }
            billList.refresh();
        } else {
            this.getView().showOperationResult(executeOperate);
        }
    }

    private void copy() {
        BillList billList = (BillList)this.getControl(KEY_ENTITY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MFTBOMTreeListPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8fdb\u884c\u6279\u91cfBOM\u66ff\u4ee3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MFTBOMTreeListPlugin_20", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>(1);
        customParam.put("iscopy", Boolean.TRUE);
        this.openBomBill(selectedRows.getPrimaryKeyValues()[0], OperationStatus.ADDNEW, customParam);
    }

    private void openBomBill(Object pkId, OperationStatus operationStatus, Map<String, Object> customParam) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(BOM_NUMBER);
        billShowParameter.setPkId(pkId);
        if (customParam != null) {
            billShowParameter.getCustomParams().putAll(customParam);
        }
        billShowParameter.setStatus(operationStatus);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String text = evt.getText();
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        TreeNode resultNode = root.getTreeNodeByText(text, 50);
        if (resultNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"MFTBOMTreeListPlugin_21", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String oldSearchText = pageCache.get(CACHEKEY_OLDSEARCHETEXT);
        if (StringUtils.isNotBlank((CharSequence)oldSearchText) && StringUtils.equals((CharSequence)text, (CharSequence)oldSearchText)) {
            String cacheNodes = pageCache.get(CACHEKEY_SEARCHNODES);
            treeNodes = SerializationUtils.fromJsonStringToList((String)cacheNodes, TreeNode.class);
        } else {
            pageCache.put(CACHEKEY_OLDSEARCHETEXT, text);
            pageCache.put(CACHEKEY_SEARCHINDEX, String.valueOf(0));
            treeNodes = root.getTreeNodeListByText(new LinkedList(), text, 50);
            pageCache.put(CACHEKEY_SEARCHNODES, SerializationUtils.toJsonString((Object)treeNodes));
        }
        if (treeNodes.isEmpty()) {
            pageCache.put(CACHEKEY_OLDSEARCHETEXT, text);
            pageCache.put(CACHEKEY_SEARCHINDEX, String.valueOf(0));
            treeNodes = root.getTreeNodeListByText(new LinkedList(), text, 50);
            pageCache.put(CACHEKEY_SEARCHNODES, SerializationUtils.toJsonString((Object)treeNodes));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"MFTBOMTreeListPlugin_21", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            int searchIndex = Integer.parseInt(pageCache.get(CACHEKEY_SEARCHINDEX));
            if (searchIndex < treeNodes.size()) {
                treeView.showNode(((TreeNode)treeNodes.get(searchIndex)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(searchIndex));
                pageCache.put(CACHEKEY_SEARCHINDEX, String.valueOf(++searchIndex));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"MFTBOMTreeListPlugin_22", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                pageCache.put(CACHEKEY_SEARCHINDEX, String.valueOf(0));
            }
        }
    }
}

