/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.mftbom;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ManuVersionImportPlugIn
extends AbstractBillPlugIn {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_NAME = "name";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        String number = (String)sourceData.get(KEY_NUMBER);
        JSONObject org = (JSONObject)sourceData.get(KEY_CREATEORG);
        if (StringUtils.isNotEmpty((CharSequence)number) && org != null) {
            String orgnumber = org.getString(KEY_NUMBER);
            String orgname = org.getString(KEY_NAME);
            if (StringUtils.isNotEmpty((CharSequence)orgnumber)) {
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
                qFilterList.add(new QFilter("status", "=", (Object)"C").or(new QFilter("status", "=", (Object)"B")));
                qFilterList.add(new QFilter(KEY_NUMBER, "=", (Object)number));
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
                qFilterList.add(new QFilter("createorg.number", "=", (Object)orgnumber));
                JSONObject materialObj = (JSONObject)sourceData.get("material");
                if (materialObj == null) {
                    e.setCancel(true);
                    String strinfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"ManuVersionImportPlugIn_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                    e.setCancelMessage(strinfo);
                    e.setFireAfterImportData(false);
                    return;
                }
                String materialNumber = materialObj.getString(KEY_NUMBER);
                qFilterList.add(new QFilter("material.masterid.number", "=", (Object)materialNumber));
                JSONObject bomObj = (JSONObject)sourceData.get("bom");
                if (bomObj == null) {
                    e.setCancel(true);
                    String strinfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201cBOM\u7f16\u7801\u201d\u3002", (String)"ManuVersionImportPlugIn_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                    e.setCancelMessage(strinfo);
                    e.setFireAfterImportData(false);
                    return;
                }
                String bomNumber = bomObj.getString(KEY_NUMBER);
                qFilterList.add(new QFilter("bom.number", "=", (Object)bomNumber));
                String checkStr = this.addCheckQFilter(qFilterList, sourceData);
                if (!StringUtils.isEmpty((CharSequence)checkStr)) {
                    e.setCancel(true);
                    e.setCancelMessage(checkStr);
                    e.setFireAfterImportData(false);
                    return;
                }
                boolean isexist = QueryServiceHelper.exists((String)"pdm_manuversion", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
                if (isexist) {
                    e.setCancel(true);
                    String filedMsg = this.getFiledMsg(sourceData);
                    String filedValueMsg = this.getFiledValueMsg(sourceData);
                    String strinfo = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u540c\u4e00\u7269\u6599\u7f16\u7801\u540c\u4e00BOM\u7f16\u7801\u540c\u4e00%1$s\u5b58\u5728\u76f8\u540c\u7684\u751f\u4ea7\u7248\u672c\u7f16\u7801\u201c\u751f\u4ea7\u7ec4\u7ec7\uff1a%2$s\uff1b\u751f\u4ea7\u7248\u672c\u7f16\u7801\uff1a%3$s\uff1b\u7269\u6599\u7f16\u7801\uff1a%4$s\uff1bBOM\u7f16\u7801\uff1a%5%s\uff1b%6$s\u201d\u3002", (String)"ManuVersionImportPlugIn_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), filedMsg, orgname, number, materialNumber, bomNumber, filedValueMsg);
                    e.setCancelMessage(strinfo);
                    e.setFireAfterImportData(false);
                }
            }
        }
    }

    private String addCheckQFilter(List<QFilter> qFilterList, Map<String, Object> sourceData) {
        StringBuilder resltStr = new StringBuilder();
        if (sourceData == null) {
            return resltStr.toString();
        }
        Object isRepeatObj = sourceData.get("isrepeat");
        Object workcenterObj = sourceData.get("workcenter");
        Object processrouteObj = sourceData.get("processroute");
        if (!(isRepeatObj instanceof Boolean)) {
            return resltStr.toString();
        }
        boolean aBoolean = Boolean.parseBoolean(isRepeatObj == null ? "false" : isRepeatObj.toString());
        if (aBoolean) {
            if (workcenterObj == null) {
                String strinfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801\u201d\u3002", (String)"ManuVersionImportPlugIn_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                return strinfo;
            }
            JSONObject workcenterJson = (JSONObject)workcenterObj;
            String workCenterNumber = workcenterJson.getString(KEY_NUMBER);
            qFilterList.add(new QFilter("workcenter.number", "=", (Object)workCenterNumber));
        } else {
            if (processrouteObj == null) {
                String strinfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201d\u3002", (String)"ManuVersionImportPlugIn_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                return strinfo;
            }
            JSONObject processrouteJson = (JSONObject)processrouteObj;
            String processrouteNumber = processrouteJson.getString(KEY_NUMBER);
            qFilterList.add(new QFilter("processroute.number", "=", (Object)processrouteNumber));
        }
        return resltStr.toString();
    }

    private String getFiledMsg(Map<String, Object> sourceData) {
        StringBuilder resltStr = new StringBuilder();
        if (sourceData == null) {
            return resltStr.toString();
        }
        Object isRepeatObj = sourceData.get("isrepeat");
        boolean aBoolean = Boolean.parseBoolean(isRepeatObj == null ? "false" : isRepeatObj.toString());
        if (aBoolean) {
            String strinfo = ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801", (String)"ManuVersionImportPlugIn_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
            return strinfo;
        }
        String strinfo = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801", (String)"ManuVersionImportPlugIn_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        return strinfo;
    }

    private String getFiledValueMsg(Map<String, Object> sourceData) {
        StringBuilder resltStr = new StringBuilder();
        if (sourceData == null) {
            return resltStr.toString();
        }
        Object isRepeatObj = sourceData.get("isrepeat");
        Object workcenterObj = sourceData.get("workcenter");
        Object processrouteObj = sourceData.get("processroute");
        boolean aBoolean = Boolean.parseBoolean(isRepeatObj.toString());
        if (aBoolean) {
            String workCenterNumber = "";
            if (workcenterObj != null) {
                JSONObject workcenterJson = (JSONObject)workcenterObj;
                workCenterNumber = workcenterJson.getString(KEY_NUMBER);
            }
            resltStr.append(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801\uff1a%1$s\u3002", (String)"ManuVersionImportPlugIn_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), workCenterNumber));
        } else {
            String processrouteNumber = "";
            if (processrouteObj != null) {
                JSONObject processrouteJson = (JSONObject)processrouteObj;
                processrouteNumber = processrouteJson.getString(KEY_NUMBER);
            }
            resltStr.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801\uff1a%1$s\u3002", (String)"ManuVersionImportPlugIn_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), processrouteNumber));
        }
        return resltStr.toString();
    }
}

