/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.overhaul;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OverhaulSchemeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MATERIAL = "materiel";
    private static final String CUSTOMERS = "customers";
    private static final String MRTYPE = "mrtype";
    private static final String ENTRY_WORKCARD = "entryworkcard";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entryWorkCard = (BasedataEdit)this.getView().getControl(ENTRY_WORKCARD);
        if (entryWorkCard != null) {
            entryWorkCard.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (proName) {
            case "customers": 
            case "mrtype": 
            case "materiel": {
                this.dealChange();
            }
        }
    }

    private void dealChange() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> wordCardSet = new HashSet<Long>(16);
        if (null != entryentity && entryentity.size() > 0) {
            List<QFilter> entryWorkCardQFilter = this.getEntryWorkCardQFilter();
            DynamicObjectCollection workcards = QueryServiceHelper.query((String)"mpdm_mrocardroute", (String)"id", (QFilter[])entryWorkCardQFilter.toArray(new QFilter[entryWorkCardQFilter.size()]));
            if (null != workcards && workcards.size() > 0) {
                for (DynamicObject workCard : workcards) {
                    long id = workCard.getLong("id");
                    wordCardSet.add(id);
                }
            }
            for (int i = 0; i < entryentity.size(); ++i) {
                long workCardId;
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                DynamicObject workCardInfo = entry.getDynamicObject(ENTRY_WORKCARD);
                if (null == workCardInfo || wordCardSet.contains(workCardId = workCardInfo.getLong("id"))) continue;
                this.getModel().setValue(ENTRY_WORKCARD, null, i);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (filedKey) {
            case "entryworkcard": {
                List<QFilter> qFilterList = this.getEntryWorkCardQFilter();
                qFilters.addAll(qFilterList);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object mrtype;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("newentry".equals(operateKey) && null == (mrtype = this.getModel().getValue(MRTYPE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b\u201d\u3002", (String)"OverhaulSchemeEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public List<QFilter> getEntryWorkCardQFilter() {
        Object mrtype;
        Object customers;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        IDataModel model = this.getModel();
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        Object material = model.getValue(MATERIAL);
        if (material instanceof DynamicObject) {
            DynamicObject materialDO = (DynamicObject)material;
            long materialPK = materialDO.getLong("id");
            QFilter materialFilter = new QFilter("material.id", "=", (Object)0L);
            materialFilter.or(new QFilter("material.id", "=", (Object)materialPK));
            qFilterList.add(materialFilter);
        }
        if ((customers = model.getValue(CUSTOMERS)) instanceof DynamicObjectCollection) {
            DynamicObjectCollection customerDOC = (DynamicObjectCollection)customers;
            ArrayList<Long> customerPKList = new ArrayList<Long>(2);
            QFilter customerFilter = new QFilter("customer.id", "=", (Object)0L);
            for (DynamicObject baseDataCustomer : customerDOC) {
                DynamicObject customerDO = baseDataCustomer.getDynamicObject("fbasedataid");
                if (customerDO == null) continue;
                long customerPK = customerDO.getLong("id");
                customerPKList.add(customerPK);
            }
            if (customerPKList.size() > 0) {
                customerFilter.or(new QFilter("customer.id", "in", customerPKList));
                qFilterList.add(customerFilter);
            }
        }
        if (null != (mrtype = model.getValue(MRTYPE)) && mrtype instanceof DynamicObject) {
            DynamicObject mrtypeDO = (DynamicObject)mrtype;
            QFilter mrtypeQfilter = new QFilter("materialtype", "=", (Object)0L);
            try {
                List ids = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getChilds", (Object[])new Object[]{mrtypeDO.getLong("id")});
                if (null != ids && ids.size() > 0) {
                    mrtypeQfilter.or(new QFilter("materialtype", "in", (Object)ids));
                }
            }
            catch (Exception exception) {
                throw new KDBizException(new ErrorCode("MrTypeConfigModelService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u67e5\u8be2L1\u4e0b\u7ea7\u6240\u6709\u5c42\u7ea7\u4e3aL1_MPD\u7684\u68c0\u4fee\u578b\u53f7\u5931\u8d25:%1$s", (String)"OverhaulSchemeEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), exception.getMessage() != null ? exception.getMessage() : exception.toString())), new Object[]{exception});
            }
            qFilterList.add(mrtypeQfilter);
        }
        qFilterList.add(new QFilter("processtype", "!=", (Object)"C"));
        return qFilterList;
    }

    public QFilter getEntryCustomersQFilter() {
        QFilter resultQFilter = null;
        IDataModel model = this.getModel();
        Object customers = model.getValue(CUSTOMERS);
        if (customers instanceof DynamicObjectCollection) {
            DynamicObjectCollection customerDOC = (DynamicObjectCollection)customers;
            ArrayList<Long> customerPKList = new ArrayList<Long>(2);
            for (DynamicObject baseDataCustomer : customerDOC) {
                DynamicObject customerDO = baseDataCustomer.getDynamicObject("fbasedataid");
                if (customerDO == null) continue;
                long customerPK = customerDO.getLong("id");
                customerPKList.add(customerPK);
            }
            if (customerPKList.size() > 0) {
                resultQFilter = new QFilter("id", "in", customerPKList);
            }
        }
        return resultQFilter;
    }
}

