/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.personnel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PersionSchedulAuth
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"responsible", (CharSequence)key)) {
            this.responsibleChange(e);
        }
    }

    private void responsibleChange(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("ischange", (Object)Boolean.TRUE, index);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void initData() {
        DynamicObject[] workGroups = this.queryAllWorkGroupPersion();
        if (workGroups == null || workGroups.length == 0) {
            return;
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"id", "workgroup", "personmsg", "responsible"});
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.deleteEntryData("entryentity");
        int count = 0;
        for (DynamicObject workGroup : workGroups) {
            Object pk = workGroup.getPkValue();
            DynamicObjectCollection personmsgentry = workGroup.getDynamicObjectCollection("personmsgentry");
            for (DynamicObject dynamicObject : personmsgentry) {
                Object entryPk = dynamicObject.getPkValue();
                Object personmsg = dynamicObject.get("personmsg_id");
                DynamicObjectCollection responsible = dynamicObject.getDynamicObjectCollection("responsible");
                tableValueSetter.addRow(new Object[]{entryPk, pk, personmsg, responsible});
                ++count;
            }
        }
        if (count > 0) {
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("entryentity", tableValueSetter);
            dataModel.endInit();
            this.getView().updateView("entryentity");
        }
        this.getModel().setDataChanged(false);
    }

    private DynamicObject[] queryAllWorkGroupPersion() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"fmm_workgroup", (String)"id,personmsgentry.id,personmsgentry.personmsg,personmsgentry.responsible", (QFilter[])filter.toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            this.saveData();
        } else if (StringUtils.equals((CharSequence)"refresh", (CharSequence)key)) {
            this.initData();
        }
    }

    public void saveData() {
        DynamicObject[] workGroups;
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        HashSet<Object> changeWorkGroup = new HashSet<Object>(entryentity.size());
        HashMap<Object, Integer> changePersonPool = new HashMap<Object, Integer>(entryentity.size());
        for (DynamicObject obj : entryentity) {
            boolean isChange = obj.getBoolean("ischange");
            if (!isChange) continue;
            int seq = obj.getInt("seq") - 1;
            changeWorkGroup.add(obj.get("workgroup_id"));
            changePersonPool.put(obj.get("id"), seq);
        }
        if (changePersonPool.isEmpty()) {
            return;
        }
        for (DynamicObject obj : workGroups = this.queryWorkGroupByPk(changeWorkGroup)) {
            DynamicObjectCollection personmsgentry = obj.getDynamicObjectCollection("personmsgentry");
            for (DynamicObject personmsg : personmsgentry) {
                Object entryPk = personmsg.getPkValue();
                Integer index = (Integer)changePersonPool.get(entryPk);
                if (index == null) continue;
                DynamicObjectCollection newResponsibles = (DynamicObjectCollection)this.getModel().getValue("responsible", index.intValue());
                DynamicObjectCollection responsibles = personmsg.getDynamicObjectCollection("responsible");
                responsibles.clear();
                for (DynamicObject newResponsible : newResponsibles) {
                    responsibles.addNew().set("fbasedataid_id", newResponsible.get("fbasedataid_id"));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])workGroups);
    }

    public DynamicObject[] queryWorkGroupByPk(Set<Object> changeWorkGroup) {
        QFilter qFilter = new QFilter("id", "in", changeWorkGroup);
        return BusinessDataServiceHelper.load((String)"fmm_workgroup", (String)"id,personmsgentry.id,personmsgentry.responsible", (QFilter[])qFilter.toArray());
    }
}

