/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.common.util.RouteOldVsersionInitUtils;
import kd.mmc.fmm.formplugin.processroute.RouteVersionInitFormPlugin;

public class ProcessRouteVersionInitListPlugin
extends RouteVersionInitFormPlugin {
    private static final String OP_INIT = "versioninit";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_INIT.equals(operateKey)) {
            Long bizOrgId = this.getBizOrgId();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pdm_routeversionorgsel");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "versioninit_selectorg"));
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("bizorgid", bizOrgId == null ? "0" : String.valueOf(bizOrgId));
            fsp.setCustomParams(params);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("versioninit_selectorg".equals(actionId) && (data = (Map)event.getReturnData()) != null) {
            String isAllOrg = (String)data.get("isallorg");
            String selectOrgids = (String)data.get("selectorgids");
            if (isAllOrg != null && !"".equals(isAllOrg) && selectOrgids != null) {
                Set orgIdSet = RouteOldVsersionInitUtils.getOrgIdSet((String)isAllOrg, (String)selectOrgids);
                if (orgIdSet == null || orgIdSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u7ec4\u7ec7\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ProcessRouteVersionInitListPlugin_01", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> newOrgIdSet = new HashSet<Long>(16);
                String checkMsg = this.checkData(orgIdSet, newOrgIdSet, actionId);
                if (newOrgIdSet.isEmpty()) {
                    if (!StringUtils.isEmpty((String)checkMsg)) {
                        this.getView().showTipNotification(checkMsg);
                        return;
                    }
                } else {
                    if (!StringUtils.isEmpty((String)checkMsg)) {
                        this.getPageCache().put("newOrgIdSet", ((Object)newOrgIdSet).toString());
                        ConfirmCallBackListener listener = new ConfirmCallBackListener("sureorgdatas", (IFormPlugin)this);
                        String msg = String.format(ResManager.loadKDString((String)"%1$s \u7ee7\u7eed\u5bf9\u5176\u4ed6\u7ec4\u7ec7\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u5417\uff1f", (String)"ProcessRouteVersionInitListPlugin_04", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), checkMsg);
                        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                        return;
                    }
                    this.openVersionRuleF7(((Object)newOrgIdSet).toString());
                }
            }
        }
        if ("pdm_routeversionsel".equals(actionId) && (data = (Map)event.getReturnData()) != null) {
            String ruleid = (String)data.get("ruleid");
            String orgids = (String)data.get("orgids");
            this.dealInitData(RouteOldVsersionInitUtils.ParseStringToLongSet((String)orgids), ruleid, OP_INIT);
        }
    }

    public void openVersionRuleF7(String orgIds) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pdm_routeversionsel");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pdm_routeversionsel"));
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("orgids", orgIds);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("sureorgdatas".equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            String newOrgIdSet = this.getPageCache().get("newOrgIdSet");
            this.openVersionRuleF7(newOrgIdSet);
        }
    }

    public String checkData(Set<Long> orgIdSet, Set<Long> newOrgIdSet, String opKey) {
        String orgNames;
        StringBuilder checkMsg = new StringBuilder();
        Set orgIdSetA = RouteOldVsersionInitUtils.getEndInitStatusOrgId(orgIdSet);
        Set orgIdSetB = RouteOldVsersionInitUtils.getIsRunningStatusOrgId(orgIdSet);
        if (!orgIdSetA.isEmpty()) {
            orgNames = RouteOldVsersionInitUtils.getOrgNames((Set)orgIdSetA);
            checkMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\u3002", (String)"ProcessRouteVersionInitListPlugin_02", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), orgNames));
        }
        if (!orgIdSetB.isEmpty()) {
            orgNames = RouteOldVsersionInitUtils.getOrgNames((Set)orgIdSetB);
            checkMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u5728\u6267\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ProcessRouteVersionInitListPlugin_03", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), orgNames));
        }
        for (Long id : orgIdSet) {
            if (orgIdSetA.contains(id) || orgIdSetB.contains(id)) continue;
            newOrgIdSet.add(id);
        }
        return checkMsg.toString();
    }

    public void dealInitData(Set<Long> orgIdSet, String ruleid, String opKey) {
        this.createJobAndLock(orgIdSet, ruleid, opKey);
    }

    private Long getBizOrgId() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String createOrg = pageCache.get("createOrg");
        return Long.parseLong(createOrg);
    }
}

