/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.route.RouteOldVersionInitBusiness;
import kd.mmc.fmm.common.util.RouteOldVsersionInitUtils;

public class RouteDefVersionSelectFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
    }

    public Set<Long> getOrgIdSet() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String orgIds = (String)parameterParams.get("orgids");
        this.getView().getPageCache().put("orgids", orgIds);
        return RouteOldVsersionInitUtils.ParseStringToLongSet((String)orgIds);
    }

    public void initData() {
        this.getModel().setValue("defrulenumber", (Object)RouteOldVsersionInitUtils.getDefRuleNumber());
        this.getModel().setValue("defrulename", (Object)RouteOldVsersionInitUtils.getDefRuleName());
        this.getView().updateView("defrulenumber");
        this.getView().updateView("defrulename");
        RouteOldVersionInitBusiness imp = new RouteOldVersionInitBusiness();
        DynamicObject newRule = imp.getRtVersionRule(Long.valueOf(0L), false, null);
        DynamicObjectCollection newRuleColl = newRule.getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject newRuleEntry : newRuleColl) {
            DynamicObject entry = coll.addNew();
            entry.set("entryversionname", (Object)newRuleEntry.getString("version"));
            entry.set("entryseq", (Object)newRuleEntry.getInt("seq"));
        }
        this.getModel().updateEntryCache(coll);
        this.getView().updateView(ENTRYENTITY);
    }

    public Set<Integer> getSeq(DynamicObject rule) {
        HashSet<Integer> ruleSeqSet = new HashSet<Integer>(64);
        if (rule != null) {
            DynamicObject[] ruleAs = BusinessDataServiceHelper.load((String)rule.getDynamicObjectType().getName(), (String)"id,number,name,entryentity,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("id", "=", rule.getPkValue())});
            DynamicObjectCollection ruleColl = ruleAs[0].getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject rullEntry : ruleColl) {
                ruleSeqSet.add(rullEntry.getInt("seq"));
            }
        } else {
            DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject rullEntry : coll) {
                ruleSeqSet.add(rullEntry.getInt("entryseq"));
            }
        }
        return ruleSeqSet;
    }

    public String checkRouteData(Set<Long> orgIdSet, Set<Integer> ruleEntrySeqSet) {
        StringBuilder sb = new StringBuilder();
        QFilter qf = new QFilter("createorg", "in", orgIdSet);
        qf.and(new QFilter("version", ">", (Object)0L));
        qf.and(new QFilter("version.orderseq", "not in", ruleEntrySeqSet));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_route", (String)"number,version.name versionname,version.orderseq orderseq", (QFilter[])new QFilter[]{qf});
        for (DynamicObject route : coll) {
            sb.append(route.getString("number")).append(" ").append(route.getString("versionname")).append(" ").append(route.get("orderseq")).append(" ");
        }
        return sb.toString();
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            Set<Integer> seqs;
            String chkMsg;
            String ruleNumber;
            boolean isExistversionrule = (Boolean)this.getModel().getValue("isexistversionrule");
            DynamicObject rule = (DynamicObject)this.getModel().getValue("selversionrule");
            if (isExistversionrule && rule == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5f55\u5165\u3002", (String)"RouteDefVersionSelectFormPlugin_01", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Set<Long> orgIdSet = this.getOrgIdSet();
            String string = ruleNumber = isExistversionrule ? rule.getString("number") : RouteOldVsersionInitUtils.getDefRuleNumber();
            if (isExistversionrule && !StringUtils.isEmpty((String)(chkMsg = this.checkRouteData(orgIdSet, seqs = this.getSeq((DynamicObject)(isExistversionrule ? rule : null)))))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5de5\u827a\u8def\u7ebf\u53f7\u7684\u65e7\u7248\u672c\u5bf9\u5e94\u7684\u987a\u5e8f\u53f7\u4e0d\u5b58\u5728\u4e8e\u7248\u672c\u89c4\u5219\u201c%1$s\u201d\u7684\u5206\u5f55\u4e2d\uff1a%2$s", (String)"RouteDefVersionSelectFormPlugin_02", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), ruleNumber, chkMsg));
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("surerule", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u6309\u7248\u672c\u89c4\u5219\u201c%1$s\u201d\u6267\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u5417\uff1f", (String)"RouteDefVersionSelectFormPlugin_03", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), ruleNumber), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("surerule".equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            HashMap<String, String> params = new HashMap<String, String>(16);
            boolean isExistversionrule = (Boolean)this.getModel().getValue("isexistversionrule");
            DynamicObject rule = (DynamicObject)this.getModel().getValue("selversionrule");
            params.put("ruleid", isExistversionrule ? String.valueOf(rule.getPkValue()) : "0");
            params.put("orgids", this.getView().getPageCache().get("orgids"));
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }
}

