/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.constants.RouteConst;
import kd.mmc.fmm.common.util.MMCUtils;

public class RouteImportPlugIn
extends AbstractBillPlugIn {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_NAME = "name";
    private static final String KEY_UNIT = "unit";

    public void initImportData(InitImportDataEventArgs e) {
        List datalist = e.getSourceDataList();
        this.preSearchImportData(datalist);
        super.initImportData(e);
        int size = datalist.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)datalist.get(i);
            this.dealWithRouteVer(null, map);
        }
    }

    private void preSearchImportData(List<Map<String, Object>> datalist) {
        if (datalist == null) {
            return;
        }
        HashSet<String> matInfoSet = new HashSet<String>(64);
        HashSet<String> matGroupInfoSet = new HashSet<String>(32);
        int size = datalist.size();
        for (int i = 0; i < size; ++i) {
            JSONObject matGroupJson;
            Map<String, Object> map = datalist.get(i);
            JSONObject matJson = map.containsKey("material") ? (JSONObject)JSON.toJSON((Object)map.get("material")) : null;
            JSONObject jSONObject = matGroupJson = map.containsKey("materialgroup") ? (JSONObject)JSON.toJSON((Object)map.get("materialgroup")) : null;
            if (matJson != null) {
                matInfoSet.add(matJson.getString(KEY_NUMBER));
            }
            if (matGroupJson == null) continue;
            matGroupInfoSet.add(matGroupJson.getString(KEY_NUMBER));
        }
        this.searchRouteVersionData(matInfoSet, matGroupInfoSet);
    }

    private void searchRouteVersionData(Set<String> matInfoSet, Set<String> matGroupInfoSet) {
        Set<Long> materialIdSet = this.getIdByNumbers(matInfoSet, "bd_material");
        Set<Long> materialGroupIdSet = this.getIdByNumbers(matGroupInfoSet, "bd_materialcontrolgroup");
        if (!materialIdSet.isEmpty()) {
            this.queryRouteVersionData(materialIdSet, "A");
        }
        if (!materialGroupIdSet.isEmpty()) {
            this.queryRouteVersionData(materialIdSet, "B");
        }
        this.queryRouteVersionData(null, "C");
    }

    private void queryRouteVersionData(Set<Long> idSet, String type) {
        QFilter numQfilter = new QFilter("type", "=", (Object)"B");
        if ("A".equals(type)) {
            numQfilter.and(new QFilter("material", "in", idSet));
            numQfilter.and(new QFilter("materialgroup", "=", (Object)0L));
        } else if ("B".equals(type)) {
            numQfilter.and(new QFilter("materialgroup", "in", idSet));
            numQfilter.and(new QFilter("material", "=", (Object)0L));
        } else {
            numQfilter.and(new QFilter("materialgroup", "=", (Object)0L));
            numQfilter.and(new QFilter("material", "=", (Object)0L));
        }
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection bomVerObjCol = QueryServiceHelper.query((String)"bd_bomversion_new", (String)"id,number,name,bomversionrule.number verRuleNum,material.id matId, material.number matNum,materialgroup.number matGroupNum", (QFilter[])new QFilter[]{numQfilter, status, enable});
        int size = bomVerObjCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bomVerObj = (DynamicObject)bomVerObjCol.get(i);
            String matNum = "A".equals(type) ? bomVerObj.getString("matNum") : ("B".equals(type) ? bomVerObj.getString("matGroupNum") : "");
            String verRuleNum = bomVerObj.getString("verRuleNum");
            String name = bomVerObj.getString(KEY_NAME);
            String uniqueKey = matNum + "-" + verRuleNum + "-" + name;
            RouteConst.routeVerMap.put(uniqueKey, bomVerObj);
        }
    }

    private Set<Long> getIdByNumbers(Set<String> matInfoSet, String entityNumber) {
        HashSet<Long> materialGroupIdSet = new HashSet<Long>(32);
        if (!matInfoSet.isEmpty()) {
            String matField = "id";
            QFilter numQfilter = new QFilter(KEY_NUMBER, "in", matInfoSet);
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection matGroupObjCol = QueryServiceHelper.query((String)entityNumber, (String)matField, (QFilter[])new QFilter[]{numQfilter, status, enable});
            int size = matGroupObjCol.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject matObj = (DynamicObject)matGroupObjCol.get(i);
                materialGroupIdSet.add(matObj.getLong("id"));
            }
        }
        return materialGroupIdSet;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String opDescError;
        boolean mainProReplace;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        String number = (String)sourceData.get(KEY_NUMBER);
        JSONObject org = (JSONObject)JSON.toJSON(sourceData.get(KEY_CREATEORG));
        if (StringUtils.isNotEmpty((CharSequence)number) && org != null) {
            String orgnumber = org.getString(KEY_NUMBER);
            String orgname = org.getString(KEY_NAME);
            if (StringUtils.isNotEmpty((CharSequence)orgnumber) && StringUtils.isNotEmpty((CharSequence)orgname)) {
                List existEcnCreatorOrgList;
                List existCreatorOrgList = (List)RouteConst.existRoute.get(number);
                if (existCreatorOrgList != null && existCreatorOrgList.contains(orgnumber)) {
                    e.setCancel(true);
                    String strinfo = String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u5b58\u5728\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%2$s\u201d\u3002", (String)"RouteImportPlugIn_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), orgname, number);
                    e.setCancelMessage(strinfo);
                    e.setFireAfterImportData(false);
                }
                if ((existEcnCreatorOrgList = (List)RouteConst.existEcnRoute.get(number)) != null && existEcnCreatorOrgList.contains(orgnumber)) {
                    e.setCancel(true);
                    String strinfo = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%2$s\u201d\u7684\u5de5\u7a0b\u53d8\u66f4\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RouteImportPlugIn_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), orgname, number);
                    e.setCancelMessage(strinfo);
                    e.setFireAfterImportData(false);
                }
            }
        }
        if (mainProReplace = this.checkMainProReplace(sourceData)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4e3b\u5de5\u827a\u8def\u7ebf\u4e0d\u5141\u8bb8\u5f55\u5165\u66ff\u4ee3\u53f7\u3002", (String)"RouteImportPlugIn_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
        }
        JSONObject unitSQLJSON = this.handleBaseUnit(sourceData);
        Object unit = sourceData.get(KEY_UNIT);
        if (unit instanceof JSONObject) {
            unitSQLJSON = (JSONObject)JSON.toJSON(unit);
        }
        Object processentryObj = sourceData.get("processentry");
        JSONArray processJsonArray = new JSONArray();
        if (processentryObj instanceof JSONArray) {
            processJsonArray = (JSONArray)processentryObj;
        }
        Map option = e.getOption();
        Object importTypeObj = option.get("importtype");
        String importTypeStr = "";
        if (importTypeObj instanceof String) {
            importTypeStr = importTypeObj.toString();
        }
        if (!StringUtils.isEmpty((CharSequence)(opDescError = this.autoWriteOpDesc(processJsonArray, unitSQLJSON, importTypeStr)))) {
            e.setCancel(true);
            e.setCancelMessage(opDescError);
            e.setFireAfterImportData(false);
        }
        Object processListObj = sourceData.get("entryentity");
        this.handleProcess(sourceData);
        String manyProcessMsg = this.checkManyProcess(processListObj);
        if (!StringUtils.isEmpty((CharSequence)manyProcessMsg)) {
            e.setCancel(true);
            e.setCancelMessage(manyProcessMsg);
            e.setFireAfterImportData(false);
        }
        this.dealWithRouteVer(e, sourceData);
    }

    public boolean checkMainProReplace(Map<String, Object> sourceData) {
        boolean resultFlag = false;
        if (sourceData == null) {
            return resultFlag;
        }
        boolean routeReplaceFlag = sourceData.containsKey("routereplace");
        if (!routeReplaceFlag) {
            return resultFlag;
        }
        Object isMainProcess = sourceData.get("ismainprocess");
        boolean isMainPro = isMainProcess instanceof Boolean ? (Boolean)isMainProcess : false;
        JSONObject routeReplaceJObj = (JSONObject)JSON.toJSON((Object)sourceData.get("routereplace"));
        boolean numberFlag = routeReplaceJObj.containsKey((Object)KEY_NUMBER);
        String number = routeReplaceJObj.getString(KEY_NUMBER);
        boolean nameFlag = routeReplaceJObj.containsKey((Object)KEY_NAME);
        String name = routeReplaceJObj.getString(KEY_NAME);
        if (isMainPro && numberFlag && StringUtils.isNotEmpty((CharSequence)number)) {
            resultFlag = true;
        } else if (isMainPro && !numberFlag && nameFlag && StringUtils.isNotEmpty((CharSequence)name)) {
            resultFlag = true;
        }
        return resultFlag;
    }

    public JSONObject handleBaseUnit(Map<String, Object> sourceData) {
        JSONObject unitSQLJSON = new JSONObject();
        if (sourceData == null) {
            return unitSQLJSON;
        }
        Object processTypeObj = sourceData.get("processtype");
        if (processTypeObj instanceof String && "A".equals(processTypeObj.toString())) {
            Object unitValue;
            JSONObject materialObj = (JSONObject)JSON.toJSON((Object)sourceData.get("material"));
            Set materialColSet = (Set)RouteConst.columnMap.get("material");
            String materialCol = "";
            if (materialColSet != null && materialObj != null) {
                if (materialColSet.contains(KEY_NUMBER)) {
                    materialCol = materialObj.getString(KEY_NUMBER);
                } else if (materialColSet.contains(KEY_NAME)) {
                    materialCol = materialObj.getString(KEY_NAME);
                }
            }
            if ((unitValue = RouteConst.materialUnitMap.get(materialCol)) instanceof DynamicObject) {
                DynamicObject unitDO = (DynamicObject)unitValue;
                unitSQLJSON.put(KEY_NUMBER, (Object)unitDO.getString(KEY_NUMBER));
                unitSQLJSON.put(KEY_NAME, (Object)unitDO.getString(KEY_NAME));
                this.autoWriteHeadUnitData(sourceData, unitSQLJSON, KEY_UNIT);
            }
        }
        return unitSQLJSON;
    }

    public void autoWriteHeadUnitData(Map<String, Object> sourceData, JSONObject unitJSON, String coluName) {
        if (sourceData == null || unitJSON == null) {
            return;
        }
        Object baseUnit = sourceData.get(coluName);
        if (unitJSON != null) {
            if (baseUnit instanceof JSONObject) {
                JSONObject headUnitJsonObj = (JSONObject)JSON.toJSON((Object)baseUnit);
                boolean inputTypeF = headUnitJsonObj.containsKey((Object)KEY_NUMBER);
                String number = headUnitJsonObj.getString(KEY_NUMBER);
                if (inputTypeF && StringUtils.isEmpty((CharSequence)number)) {
                    headUnitJsonObj.put(KEY_NUMBER, (Object)unitJSON.getString(KEY_NUMBER));
                }
            } else {
                Set unitCols = (Set)RouteConst.columnMap.get(coluName);
                JSONObject unitJson = new JSONObject();
                if (unitCols != null && !unitCols.isEmpty()) {
                    for (String colName : unitCols) {
                        unitJson.put(colName, (Object)unitJSON.getString(colName));
                    }
                } else {
                    unitJson = unitJSON;
                }
                sourceData.put(coluName, unitJson);
            }
        }
    }

    public String autoWriteOpDesc(JSONArray processJsonArray, JSONObject unitSQLJSON, String importTypeStr) {
        StringBuilder resultStr = new StringBuilder();
        if (processJsonArray == null) {
            return resultStr.toString();
        }
        processJsonArray.stream().forEach(rowObj -> {
            if (rowObj instanceof JSONObject) {
                JSONObject processRow = (JSONObject)JSON.toJSON((Object)rowObj);
                boolean opDescKFlag = processRow.containsKey((Object)"operationdesc");
                Object opDescObj = processRow.get((Object)"operationdesc");
                Object operationObj = processRow.get((Object)"operation");
                if (!(operationObj != null || opDescKFlag && opDescObj != null)) {
                    resultStr.append(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5de5\u5e8f\u8bf4\u660e\u201d\u6216\u201c\u5de5\u5e8f\u7f16\u7801\u201d\u3002", (String)"RouteImportPlugIn_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                }
                if (operationObj instanceof JSONObject && (!opDescKFlag || opDescObj == null)) {
                    JSONObject operationJObj = (JSONObject)JSON.toJSON((Object)operationObj);
                    String operationNumber = operationJObj.getString(KEY_NUMBER);
                    Object value = RouteConst.operatDescMap.get(operationNumber);
                    processRow.put("operationdesc", value);
                }
                this.autoWriteUnitData(processRow, unitSQLJSON, "headunit");
                if ("new".equals(importTypeStr)) {
                    this.autoWriteUnitData(processRow, unitSQLJSON, "operationunit");
                }
                Object workCenterObj = processRow.get((Object)"workcenter");
                String key = "";
                if (workCenterObj instanceof JSONObject) {
                    JSONObject workerJson = (JSONObject)JSON.toJSON((Object)workCenterObj);
                    boolean numberColFlag = workerJson.containsKey((Object)KEY_NUMBER);
                    key = numberColFlag ? workerJson.getString(KEY_NUMBER) : workerJson.getString(KEY_NAME);
                }
                Object activeObj = RouteConst.operatActiveMap.get(key);
                Object activeDOC = null;
                DynamicObject proStrategy = null;
                if (activeObj instanceof Map) {
                    Map activeMap = (Map)activeObj;
                    Object proStrategyObj = activeMap.get("processstrategy");
                    if (proStrategyObj instanceof DynamicObject) {
                        proStrategy = (DynamicObject)proStrategyObj;
                    }
                    activeDOC = activeMap.get("processactivetable");
                }
                this.autoWriteProStrategy(processRow, proStrategy, "workcenter", "oprctrlstrategy");
                boolean machTypeFlag = processRow.containsKey((Object)"machiningtype");
                Object machTypeObj = processRow.get((Object)"machiningtype");
                Object opCtrlObj = processRow.get((Object)"oprctrlstrategy");
                if (opCtrlObj instanceof JSONObject && (!machTypeFlag || machTypeObj == null)) {
                    JSONObject opCtrlJsonObj = (JSONObject)JSON.toJSON((Object)opCtrlObj);
                    Set opCtStrategySet = (Set)RouteConst.columnMap.get("oprctrlstrategy");
                    String opStKey = KEY_NUMBER;
                    if (!opCtStrategySet.contains(KEY_NUMBER) && opCtStrategySet.contains(KEY_NAME)) {
                        opStKey = KEY_NAME;
                    }
                    String opCtrlNumber = opCtrlJsonObj.getString(opStKey);
                    Object machTypeValue = RouteConst.machTypeMap.get(opCtrlNumber);
                    processRow.put("machiningtype", machTypeValue);
                }
                this.autoWriteActiveData(processRow, activeDOC, "actentryentity");
            }
        });
        return resultStr.toString();
    }

    public void autoWriteProStrategy(JSONObject processRow, DynamicObject autoDO, String fromColName, String colName) {
        if (processRow == null || StringUtils.isEmpty((CharSequence)colName)) {
            return;
        }
        Object colNameObj = processRow.get((Object)colName);
        JSONObject colValueJObj = colNameObj instanceof JSONObject ? (JSONObject)JSON.toJSON((Object)colNameObj) : new JSONObject();
        boolean numberFlag = colValueJObj.containsKey((Object)KEY_NUMBER);
        String numberValue = colValueJObj.getString(KEY_NUMBER);
        boolean nameFlag = colValueJObj.containsKey((Object)KEY_NAME);
        String nameValue = colValueJObj.getString(KEY_NAME);
        String number = MMCUtils.getDynamicObjectStringData((DynamicObject)autoDO, (String)KEY_NUMBER);
        String name = MMCUtils.getDynamicObjectStringData((DynamicObject)autoDO, (String)KEY_NAME);
        if (numberFlag && StringUtils.isEmpty((CharSequence)numberValue)) {
            colValueJObj.put(KEY_NUMBER, (Object)number);
        } else if (nameFlag && StringUtils.isEmpty((CharSequence)nameValue)) {
            colValueJObj.put(KEY_NAME, (Object)name);
        } else if (!numberFlag && !nameFlag || StringUtils.isEmpty((CharSequence)numberValue) && StringUtils.isEmpty((CharSequence)nameValue)) {
            colValueJObj.put(KEY_NUMBER, (Object)number);
            colValueJObj.put(KEY_NAME, (Object)name);
            processRow.put(colName, (Object)colValueJObj);
        }
    }

    public void autoWriteActiveData(JSONObject processRow, Object entryDOC, String entryName) {
        if (processRow == null || StringUtils.isEmpty((CharSequence)entryName)) {
            return;
        }
        if (!(entryDOC instanceof DynamicObjectCollection)) {
            return;
        }
        DynamicObjectCollection entryDOCL = (DynamicObjectCollection)entryDOC;
        Object entryObj = processRow.get((Object)entryName);
        JSONArray entryJsonArray = entryObj instanceof JSONArray ? (JSONArray)entryObj : new JSONArray();
        if (entryJsonArray.isEmpty()) {
            for (DynamicObject entryDO : entryDOCL) {
                JSONObject entryDOJSON = new JSONObject();
                JSONObject processNumberJOBJ = this.getDOTranJSON(entryDO, "processnumber");
                entryDOJSON.put("activity", (Object)processNumberJOBJ);
                DynamicObject proNumber = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"processnumber");
                String proStage = MMCUtils.getDynamicObjectStringData((DynamicObject)proNumber, (String)"processstage");
                if (StringUtils.isNotEmpty((CharSequence)proStage)) {
                    entryDOJSON.put("activtyprocessstage", (Object)proStage);
                }
                Object baseQry = entryDO.get("processqty");
                entryDOJSON.put("baseqty", baseQry);
                JSONObject activeformulaJOBJ = this.getDOTranJSON(entryDO, "activeformula");
                entryDOJSON.put("standardformula", (Object)activeformulaJOBJ);
                JSONObject reportformulaJOBJ = this.getDOTranJSON(entryDO, "reportformula");
                entryDOJSON.put("standardformula1", (Object)reportformulaJOBJ);
                entryJsonArray.add((Object)entryDOJSON);
            }
            processRow.put(entryName, (Object)entryJsonArray);
        }
        entryJsonArray.stream().forEach(entryRowObj -> {
            JSONObject entryRowJson;
            boolean flag;
            if (entryRowObj instanceof JSONObject && (flag = this.checkAutoEntry(entryRowJson = (JSONObject)JSON.toJSON((Object)entryRowObj), "activity", "standardformula", "standardformula1"))) {
                for (DynamicObject entryDO : entryDOCL) {
                    DynamicObject proNumber;
                    String proStage;
                    Object activtyProStage;
                    Object baseqty;
                    JSONObject processNumberJOBJ = this.getDOTranJSON(entryDO, "processnumber");
                    JSONObject activeJson = this.setActiveFieldValue(entryRowJson, processNumberJOBJ, "activity");
                    if (!activeJson.isEmpty()) {
                        entryRowJson.put("activity", (Object)activeJson);
                    }
                    JSONObject standardJson = this.setActiveFieldValue(entryRowJson, processNumberJOBJ, "standardformula");
                    if (!activeJson.isEmpty()) {
                        entryRowJson.put("standardformula", (Object)standardJson);
                    }
                    JSONObject standard1Json = this.setActiveFieldValue(entryRowJson, processNumberJOBJ, "standardformula1");
                    if (!activeJson.isEmpty()) {
                        entryRowJson.put("standardformula1", (Object)standard1Json);
                    }
                    if ((baseqty = entryRowJson.get((Object)"baseqty")) == null) {
                        Object baseQry = entryDO.get("processqty");
                        entryRowJson.put("baseqty", baseQry);
                    }
                    if ((activtyProStage = entryRowJson.get((Object)"activtyprocessstage")) != null || !StringUtils.isNotEmpty((CharSequence)(proStage = MMCUtils.getDynamicObjectStringData((DynamicObject)(proNumber = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"processnumber")), (String)"processstage")))) continue;
                    entryRowJson.put("activtyprocessstage", (Object)proStage);
                }
            }
        });
    }

    public JSONObject setActiveFieldValue(JSONObject entryRowJson, JSONObject valueJOBJ, String fieldName) {
        JSONObject resultJson = new JSONObject();
        if (entryRowJson == null || valueJOBJ == null || StringUtils.isEmpty((CharSequence)fieldName)) {
            return resultJson;
        }
        Object excelFileObj = entryRowJson.get((Object)fieldName);
        if (excelFileObj == null) {
            return valueJOBJ;
        }
        if (excelFileObj instanceof JSONObject) {
            JSONObject excelFieldJson = (JSONObject)JSON.toJSON((Object)excelFileObj);
            if (excelFieldJson.containsKey((Object)KEY_NUMBER) && StringUtils.isEmpty((CharSequence)excelFieldJson.getString(KEY_NUMBER))) {
                resultJson.put(KEY_NUMBER, (Object)excelFieldJson.getString(KEY_NUMBER));
            } else if (excelFieldJson.containsKey((Object)KEY_NAME) && StringUtils.isEmpty((CharSequence)excelFieldJson.getString(KEY_NAME))) {
                resultJson.put(KEY_NAME, (Object)excelFieldJson.getString(KEY_NAME));
            }
        }
        return resultJson;
    }

    public JSONObject getDOTranJSON(DynamicObject entryDO, String fieldName) {
        JSONObject resultJson = new JSONObject();
        if (entryDO == null) {
            return resultJson;
        }
        DynamicObject reportformulaDO = entryDO.getDynamicObject(fieldName);
        if (reportformulaDO != null) {
            resultJson.put(KEY_NUMBER, reportformulaDO.get(KEY_NUMBER));
            resultJson.put(KEY_NAME, reportformulaDO.get(KEY_NAME));
        }
        return resultJson;
    }

    public boolean checkAutoEntry(JSONObject entryRowObj, String ... entryFields) {
        boolean flag = false;
        if (entryRowObj == null || entryFields == null || entryFields.length == 0) {
            return flag;
        }
        for (int i = 0; i < entryFields.length; ++i) {
            Object valueObj = entryRowObj.get((Object)entryFields[i]);
            if (valueObj == null) {
                return true;
            }
            if (!(valueObj instanceof JSONObject)) continue;
            JSONObject valueJO = (JSONObject)JSON.toJSON((Object)valueObj);
            boolean numberFlag = valueJO.containsKey((Object)KEY_NUMBER);
            Object number = valueJO.get((Object)KEY_NUMBER);
            Object name = valueJO.get((Object)KEY_NAME);
            if (numberFlag && (number == null || StringUtils.isEmpty((CharSequence)String.valueOf(number)))) {
                flag = true;
                continue;
            }
            if (!numberFlag && (name == null || StringUtils.isEmpty((CharSequence)String.valueOf(name)))) {
                flag = true;
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    public void autoWriteUnitData(JSONObject processRow, JSONObject unit, String columnName) {
        if (processRow == null || unit == null || StringUtils.isEmpty((CharSequence)columnName)) {
            return;
        }
        Object headUnitObj = processRow.get((Object)columnName);
        if (headUnitObj instanceof JSONObject) {
            JSONObject headUnitJsonObj = (JSONObject)JSON.toJSON((Object)headUnitObj);
            boolean inputTypeF = headUnitJsonObj.containsKey((Object)KEY_NUMBER);
            String number = headUnitJsonObj.getString(KEY_NUMBER);
            if (inputTypeF && StringUtils.isEmpty((CharSequence)number)) {
                headUnitJsonObj.put(KEY_NUMBER, (Object)unit.getString(KEY_NUMBER));
            }
        } else {
            Set unitCols = (Set)RouteConst.columnMap.get(columnName);
            JSONObject unitJson = new JSONObject();
            if (unitCols != null && !unitCols.isEmpty()) {
                for (String colName : unitCols) {
                    unitJson.put(colName, (Object)unit.getString(colName));
                }
            } else {
                unitJson = unit;
            }
            processRow.put(columnName, (Object)unitJson);
        }
    }

    public String checkManyProcess(Object processListObj) {
        StringBuilder message = new StringBuilder();
        boolean flag = processListObj instanceof JSONArray;
        if (!flag) {
            return message.toString();
        }
        ((JSONArray)processListObj).stream().forEach(proRow -> {
            boolean noMainProFlag;
            boolean referenceFlag;
            boolean mainProFlag;
            JSONObject proRowJsonObj = (JSONObject)JSON.toJSON((Object)proRow);
            Object proSeqObj = proRowJsonObj.get((Object)"processseq");
            Object proTypeObj = proRowJsonObj.get((Object)"processseqtype");
            Object referenceObj = proRowJsonObj.get((Object)"reference");
            Object relationObj = proRowJsonObj.get((Object)"relation");
            Object outputObj = proRowJsonObj.get((Object)"output");
            Object inputObj = proRowJsonObj.get((Object)"input");
            boolean bl = mainProFlag = proSeqObj instanceof String && "1".equals(String.valueOf(proSeqObj));
            if (mainProFlag && (referenceObj != null || relationObj != null || outputObj != null || inputObj != null)) {
                message.append(String.format(ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217\u201c\u53c2\u7167\u5e8f\u5217\u201d\u3001\u201c\u5e76\u884c\u5173\u7cfb\u201d\u3001\u201c\u8f6c\u5165\u5de5\u5e8f\u201d\u3001\u201c\u8f6c\u51fa\u5de5\u5e8f\u201d\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RouteImportPlugIn_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            boolean proTypeFlag = proTypeObj instanceof String && StringUtils.equals((CharSequence)"C", (CharSequence)String.valueOf(proTypeObj));
            boolean bl2 = referenceFlag = referenceObj instanceof String && StringUtils.equals((CharSequence)"1", (CharSequence)String.valueOf(referenceObj));
            if (proTypeFlag && !referenceFlag) {
                message.append(String.format(ResManager.loadKDString((String)"\u201c\u5e8f\u5217\u7c7b\u578b\u201d\u4e3a\u66ff\u4ee3\u5e8f\u5217\uff0c\u5176\u201c\u53c2\u7167\u5e8f\u5217\u201d\u5fc5\u987b\u662f\u4e3b\u5e8f\u5217\u201c1\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RouteImportPlugIn_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            boolean bl3 = noMainProFlag = proSeqObj instanceof String && !"1".equals(String.valueOf(proSeqObj));
            if (noMainProFlag && proTypeObj == null) {
                String proSeqStr = proSeqObj instanceof String ? String.valueOf(proSeqObj) : "";
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%s\u201d\uff0c\u5e8f\u5217\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RouteImportPlugIn_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), proSeqStr));
            }
            String optionFormat = "^[1-9][0-9]{0,3}$";
            boolean outFormat = Pattern.matches(optionFormat, String.valueOf(outputObj));
            if (outputObj != null && !outFormat) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u8f6c\u51fa\u5de5\u5e8f\u201c%2$s\u201d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"RouteImportPlugIn_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), String.valueOf(proSeqObj), String.valueOf(outputObj)));
            }
            boolean inFormat = Pattern.matches(optionFormat, String.valueOf(inputObj));
            if (inputObj != null && !inFormat) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u8f6c\u5165\u5de5\u5e8f\u201c%2$s\u201d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"RouteImportPlugIn_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), String.valueOf(proSeqObj), String.valueOf(inputObj)));
            }
            String proFormat = "^\\d+$";
            boolean proFormatFlag = Pattern.matches(proFormat, String.valueOf(proSeqObj));
            if (proSeqObj != null && !proFormatFlag) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u7684\u5e8f\u5217\u53f7\u201c%s\u201d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570\u3002", (String)"RouteImportPlugIn_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), String.valueOf(proSeqObj)));
            }
        });
        return message.toString();
    }

    public void handleProcess(Map<String, Object> sourceData) {
        Object processListObj = sourceData.get("entryentity");
        if (!(processListObj instanceof JSONArray)) {
            return;
        }
        JSONArray proListArray = (JSONArray)processListObj;
        JSONArray lastProListArray = new JSONArray();
        for (int i = 0; i < proListArray.size(); ++i) {
            Object rowObj = proListArray.get(i);
            if (!(rowObj instanceof JSONObject)) continue;
            JSONObject rowJsonObj = (JSONObject)JSON.toJSON((Object)rowObj);
            if (lastProListArray.size() == 0) {
                lastProListArray.add((Object)rowJsonObj);
                continue;
            }
            if (this.checkPreRow(lastProListArray, rowJsonObj)) continue;
            lastProListArray.add((Object)rowJsonObj);
        }
        sourceData.put("entryentity", lastProListArray);
    }

    public boolean checkPreRow(JSONArray lastProListArray, JSONObject rowObj) {
        boolean resultFlag = false;
        if (rowObj == null || lastProListArray == null) {
            return resultFlag;
        }
        Object lastRowObj = lastProListArray.get(lastProListArray.size() - 1);
        if (lastRowObj instanceof JSONObject) {
            JSONObject lastRowJsonObj = (JSONObject)JSON.toJSON((Object)lastRowObj);
            Map rowMap = (Map)JSONObject.parseObject((String)rowObj.toString(), Map.class);
            boolean nullFlag = true;
            for (Map.Entry entry : rowMap.entrySet()) {
                Object lastValue;
                String key = (String)entry.getKey();
                if (StringUtils.equals((CharSequence)"rowNum", (CharSequence)key)) continue;
                Object currentValue = entry.getValue();
                if (StringUtils.isNotBlank(currentValue) && nullFlag) {
                    nullFlag = false;
                }
                if (!this.compareData(currentValue, lastValue = lastRowJsonObj.get((Object)key))) {
                    return false;
                }
                resultFlag = true;
            }
            if (nullFlag || resultFlag) {
                return true;
            }
        } else {
            return resultFlag;
        }
        return resultFlag;
    }

    public boolean compareData(Object currentValue, Object lastValue) {
        Class<?> lastClass;
        if (currentValue == null && lastValue == null) {
            return true;
        }
        if (currentValue == null && lastValue != null) {
            return false;
        }
        if (currentValue != null && lastValue == null) {
            return false;
        }
        Class<?> currClass = currentValue.getClass();
        if (currClass == (lastClass = lastValue.getClass())) {
            HashSet<Object> set = new HashSet<Object>(2);
            set.add(currentValue);
            set.add(lastValue);
            return set.size() <= 1;
        }
        return false;
    }

    private void dealWithRouteVer(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        JSONObject matJson = sourceData.containsKey("material") ? (JSONObject)JSON.toJSON((Object)sourceData.get("material")) : null;
        JSONObject matGroupJson = sourceData.containsKey("materialgroup") ? (JSONObject)JSON.toJSON((Object)sourceData.get("materialgroup")) : null;
        JSONObject verJson = sourceData.containsKey("routeversion") ? (JSONObject)JSON.toJSON((Object)sourceData.get("routeversion")) : null;
        JSONObject verRuleJson = sourceData.containsKey("routeversionrule") ? (JSONObject)JSON.toJSON((Object)sourceData.get("routeversionrule")) : null;
        this.convertRouteVersion(e, matJson, matGroupJson, verJson, verRuleJson);
    }

    private String getMatKeys(JSONObject matJson, JSONObject matGroupJson) {
        return matJson == null ? (matGroupJson == null ? "" : matGroupJson.getString(KEY_NUMBER)) : matJson.getString(KEY_NUMBER);
    }

    public void convertRouteVersion(BeforeImportDataEventArgs e, JSONObject matJson, JSONObject matGroupJson, JSONObject verJson, JSONObject verRuleJson) {
        Map verMap = RouteConst.routeVerMap;
        if (verJson == null) {
            return;
        }
        Object verNameObj = verJson.get((Object)KEY_NAME);
        Object verNum = verJson.get((Object)KEY_NUMBER);
        if (verNameObj != null && verNum == null) {
            String verName = String.valueOf(verNameObj);
            String verRuleNum = verRuleJson == null ? "" : verRuleJson.getString(KEY_NUMBER);
            String matNum = this.getMatKeys(matJson, matGroupJson);
            String uniqueKey = matNum + "-" + verRuleNum + "-" + (verName == null ? "" : verName);
            DynamicObject bomVer = (DynamicObject)verMap.get(uniqueKey);
            if (e != null) {
                if (verRuleJson == null || StringUtils.isEmpty((CharSequence)verRuleNum)) {
                    e.setCancel(true);
                    String strinfo = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7248\u672c\u89c4\u5219\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6309\u5de5\u827a\u8def\u7ebf\u7248\u672c\u540d\u79f0\u5bfc\u5165\u3002", (String)"RouteImportPlugIn_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), new Object[0]);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
                    e.setFireAfterImportData(false);
                    return;
                }
                StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"RouteImportPlugIn_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                if (matJson != null) {
                    msg.append(ResManager.loadKDString((String)"\u201c\u7269\u6599+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\u201d", (String)"RouteImportPlugIn_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                } else if (matGroupJson != null) {
                    msg.append(ResManager.loadKDString((String)"\u201c\u7269\u6599\u63a7\u5236\u7ec4+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\u201d", (String)"RouteImportPlugIn_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                } else {
                    msg.append(ResManager.loadKDString((String)"\u201c\u901a\u7528+\u7248\u672c\u53f7+\u7248\u672c\u89c4\u5219\u201d", (String)"RouteImportPlugIn_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                }
                if (bomVer == null) {
                    e.setCancel(true);
                    msg.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7248\u672c\u53f7\u3002", (String)"RouteImportPlugIn_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), msg.toString());
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            verJson.put("id", (Object)(bomVer == null ? 0L : bomVer.getLong("id")));
            verJson.put("importprop", (Object)"id");
        } else if (verNameObj == null && verNum == null) {
            verJson.put("id", (Object)0L);
            verJson.put("importprop", (Object)"id");
        }
    }
}

