/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RouteMulOrgSelectFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeDatas = e.getChangeSet();
        IDataEntityProperty dataEntityProperty = e.getProperty();
        String propertyName = dataEntityProperty.getName();
        ChangeData changeData = changeDatas[0];
        Object newDate = changeData.getNewValue();
        if (propertyName.equalsIgnoreCase("allorg") && ((Boolean)newDate).booleanValue()) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String bizOrgId = (String)parameterParams.get("bizorgid");
        if (StringUtils.isNotEmpty((CharSequence)bizOrgId)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
            DynamicObject entry = coll.addNew();
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(bizOrgId), (String)"bos_org");
            entry.set("entryorg", (Object)org);
            this.getModel().updateEntryCache(coll);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public String getSelectOrgIds() {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : coll) {
            DynamicObject org = entry.getDynamicObject("entryorg");
            if (org == null) continue;
            sb.append(org.getPkValue()).append(";");
        }
        return sb.toString();
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, String> params = new HashMap<String, String>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            boolean isAllOrg = (Boolean)this.getModel().getValue("allorg");
            String selectOrgIds = this.getSelectOrgIds();
            if (!isAllOrg && kd.bos.util.StringUtils.isEmpty((String)selectOrgIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u6570\u636e\uff0c\u8bf7\u5148\u5f55\u5165\u3002", (String)"RouteMulOrgSelectFormPlugin_01", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            params.put("isallorg", isAllOrg ? "true" : "false");
            params.put("selectorgids", selectOrgIds);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }
}

